/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.FileExtension;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderTempCompressedFilePatternTest {
    private static final String CONFIG = "log4j-rolling-gz-tmp-compress.xml";
    private static final String DIR = "target/rolling2";
    private static final String DIR_TMP = "target/rolling-tmp";
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-gz-tmp-compress.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rolling2", "target/rolling-tmp");
    private Logger logger;

    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((!SystemUtils.IS_OS_MAC_OSX ? 1 : 0) != 0);
        this.logger = loggerContextRule.getLogger(RollingAppenderTempCompressedFilePatternTest.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppender() throws Exception {
        File dirTmp = new File(DIR_TMP);
        dirTmp.mkdirs();
        try (WatchService watcher = FileSystems.getDefault().newWatchService();){
            WatchKey key = dirTmp.toPath().register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
            ArrayList<String> messages = new ArrayList<String>();
            for (int i = 0; i < 500; ++i) {
                String message = "This is test message number " + i;
                messages.add(message);
                this.logger.debug(message);
                if (i % 100 != 0) continue;
                Thread.sleep(500L);
            }
            if (!loggerContextRule.getLoggerContext().stop(30L, TimeUnit.SECONDS)) {
                System.err.println("Could not stop cleanly " + loggerContextRule + " for " + this);
            }
            File dir = new File(DIR);
            Assert.assertTrue((String)"Directory not created", (boolean)dir.exists());
            File[] files = dir.listFiles();
            Assert.assertNotNull((Object)files);
            int gzippedFiles = 0;
            for (File file : files) {
                String[] lines;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileInputStream in = null;
                FileExtension ext = FileExtension.lookupForFile((String)file.getName());
                try (FileInputStream fis = new FileInputStream(file);){
                    if (ext != null) {
                        ++gzippedFiles;
                        try {
                            in = new CompressorStreamFactory().createCompressorInputStream(ext.name().toLowerCase(), (InputStream)fis);
                        }
                        catch (CompressorException ce) {
                            ce.printStackTrace();
                            Assert.fail((String)("Error creating intput stream from " + file.toString() + ": " + ce.getMessage()));
                        }
                    } else {
                        in = new FileInputStream(file);
                    }
                    Assert.assertNotNull((String)("No input stream for " + file.getName()), (Object)in);
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)baos);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Assert.fail((String)("Unable to decompress " + file.getAbsolutePath()));
                    }
                }
                catch (Throwable throwable) {
                    Closer.close(in);
                    throw throwable;
                }
                Closer.close((AutoCloseable)in);
                String text = new String(baos.toByteArray(), Charset.defaultCharset());
                for (String line : lines = text.split("[\\r\\n]+")) {
                    messages.remove(line);
                }
            }
            Assert.assertTrue((String)("Log messages lost : " + messages.size()), (boolean)messages.isEmpty());
            Assert.assertTrue((String)("Files not rolled : " + files.length), (files.length > 2 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Files gzipped not rolled : " + gzippedFiles), (gzippedFiles > 0 ? 1 : 0) != 0);
            int temporaryFilesCreated = 0;
            key = watcher.take();
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                if (!filename.toString().endsWith(".tmp")) continue;
                ++temporaryFilesCreated;
            }
            Assert.assertTrue((String)"No temporary file created during compression", (temporaryFilesCreated > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Temporarys file created not equals to compressed files " + temporaryFilesCreated + "/" + gzippedFiles), (gzippedFiles == temporaryFilesCreated ? 1 : 0) != 0);
        }
    }
}

