/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.FileExtension;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RollingAppenderSizeTest {
    @Rule
    public RuleChain chain;
    private static final String DIR = "target/rolling1";
    private final String fileExtension;
    private Logger logger;
    private final boolean createOnDemand;
    private final LoggerContextRule loggerContextRule;

    @Parameterized.Parameters(name="{0} \u2192 {1} (createOnDemand = {2})")
    public static Collection<Object[]> data() {
        return Arrays.asList({"log4j-rolling-gz-lazy.xml", ".gz", true}, {"log4j-rolling-gz.xml", ".gz", false}, {"log4j-rolling-zip-lazy.xml", ".zip", true}, {"log4j-rolling-zip.xml", ".zip", false}, {"log4j-rolling-bzip2-lazy.xml", ".bz2", true}, {"log4j-rolling-bzip2.xml", ".bz2", false}, {"log4j-rolling-deflate-lazy.xml", ".deflate", true}, {"log4j-rolling-deflate.xml", ".deflate", false}, {"log4j-rolling-pack200-lazy.xml", ".pack200", true}, {"log4j-rolling-pack200.xml", ".pack200", false}, {"log4j-rolling-xz-lazy.xml", ".xz", true}, {"log4j-rolling-xz.xml", ".xz", false});
    }

    public RollingAppenderSizeTest(String configFile, String fileExtension, boolean createOnDemand) {
        this.fileExtension = fileExtension;
        this.createOnDemand = createOnDemand;
        this.loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule(configFile);
        this.chain = this.loggerContextRule.withCleanFoldersRule(DIR);
    }

    @Before
    public void setUp() throws Exception {
        this.logger = this.loggerContextRule.getLogger(RollingAppenderSizeTest.class.getName());
    }

    @Test
    public void testIsCreateOnDemand() {
        RollingFileAppender rfAppender = this.loggerContextRule.getRequiredAppender("RollingFile", RollingFileAppender.class);
        RollingFileManager manager = (RollingFileManager)rfAppender.getManager();
        Assert.assertNotNull((Object)manager);
        Assert.assertEquals((Object)this.createOnDemand, (Object)manager.isCreateOnDemand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppender() throws Exception {
        Path path = Paths.get(DIR, "rollingtest.log");
        if (Files.exists(path, new LinkOption[0]) && this.createOnDemand) {
            Assert.fail((String)String.format("Unexpected file: %s (%s bytes)", path, Files.getAttribute(path, "size", new LinkOption[0])));
        }
        for (int i = 0; i < 500; ++i) {
            this.logger.debug("This is test message number " + i);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (dir.exists() && dir.listFiles().length > 0 ? 1 : 0) != 0);
        File[] files = dir.listFiles();
        Assert.assertNotNull((Object)files);
        Assert.assertThat((Object)files, (Matcher)Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)this.fileExtension))))));
        FileExtension ext = FileExtension.lookup((String)this.fileExtension);
        if (ext == null || FileExtension.ZIP == ext || FileExtension.PACK200 == ext) {
            return;
        }
        if (!this.loggerContextRule.getLoggerContext().stop(30L, TimeUnit.SECONDS)) {
            System.err.println("Could not stop cleanly " + this.loggerContextRule + " for " + this);
        }
        for (File file : files) {
            if (!file.getName().endsWith(this.fileExtension)) continue;
            CompressorInputStream in = null;
            try (FileInputStream fis = new FileInputStream(file);){
                String[] lines;
                try {
                    in = new CompressorStreamFactory().createCompressorInputStream(ext.name().toLowerCase(), (InputStream)fis);
                }
                catch (CompressorException ce) {
                    ce.printStackTrace();
                    Assert.fail((String)("Error creating intput stream from " + file.toString() + ": " + ce.getMessage()));
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Assert.assertNotNull((String)("No input stream for " + file.getName()), (Object)in);
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)baos);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Assert.fail((String)("Unable to decompress " + file.getAbsolutePath()));
                }
                String text = new String(baos.toByteArray(), Charset.defaultCharset());
                for (String line : lines = text.split("[\\r\\n]+")) {
                    Assert.assertTrue((boolean)line.contains("DEBUG o.a.l.l.c.a.r.RollingAppenderSizeTest [main] This is test message number"));
                }
            }
            catch (Throwable throwable) {
                Closer.close(in);
                throw throwable;
            }
            Closer.close((AutoCloseable)in);
        }
    }
}

