/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.net.URI;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderDirectWriteWithReconfigureTest {
    private static final String CONFIG = "log4j-rolling-direct-reconfigure.xml";
    private static final String DIR = "target/rolling-direct-reconfigure";
    private static final int MAX_TRIES = 10;
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-direct-reconfigure.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rolling-direct-reconfigure");
    private Logger logger;

    @Before
    public void setUp() throws Exception {
        this.logger = loggerContextRule.getLogger(RollingAppenderDirectWriteWithReconfigureTest.class.getName());
    }

    @Test
    public void testRollingFileAppenderWithReconfigure() throws Exception {
        this.logger.debug("Before reconfigure");
        LoggerContext context = loggerContextRule.getLoggerContext();
        Configuration config = context.getConfiguration();
        context.setConfigLocation(new URI(CONFIG));
        context.reconfigure();
        this.logger.debug("Force a rollover");
        File dir = new File(DIR);
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(200L);
            if (config != context.getConfiguration()) break;
        }
        Assert.assertTrue((String)"Directory not created", (dir.exists() && dir.listFiles().length > 0 ? 1 : 0) != 0);
        File[] files = dir.listFiles();
        Assert.assertNotNull((Object)files);
        Assert.assertThat((Object)dir.listFiles().length, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
    }
}

