/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CronTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.util.CronExpression;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderCronTest {
    private static final String CONFIG = "log4j-rolling-cron.xml";
    private static final String DIR = "target/rolling-cron";
    private static final String FILE = "target/rolling-cron/rollingtest.log";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-cron.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-cron");

    @Test
    public void testAppender() throws Exception {
        Logger logger = this.loggerContextRule.getLogger();
        File file = new File(FILE);
        Assert.assertTrue((String)"Log file does not exist", (boolean)file.exists());
        logger.debug("This is test message number 1");
        Thread.sleep(2500L);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (dir.exists() && dir.listFiles().length > 0 ? 1 : 0) != 0);
        int MAX_TRIES = 20;
        Matcher hasGzippedFile = Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".gz")))));
        boolean succeeded = false;
        for (int i = 0; i < 20; ++i) {
            File[] files = dir.listFiles();
            if (hasGzippedFile.matches((Object)files)) {
                succeeded = true;
                break;
            }
            logger.debug("Sleeping #" + i);
            Thread.sleep(100L);
        }
        if (!succeeded) {
            File[] files;
            for (File dirFile : files = dir.listFiles()) {
                logger.error("Found file: " + dirFile.getPath());
            }
            Assert.fail((String)"No compressed files found");
        }
        Path src = FileSystems.getDefault().getPath("target/test-classes/log4j-rolling-cron2.xml", new String[0]);
        try (FileOutputStream os = new FileOutputStream("target/test-classes/log4j-rolling-cron.xml");){
            Files.copy(src, os);
        }
        Thread.sleep(5000L);
        for (int i = 0; i < 20; ++i) {
            logger.debug("Adding new event {}", (Object)i);
        }
        Thread.sleep(1000L);
        RollingFileAppender app = (RollingFileAppender)this.loggerContextRule.getLoggerContext().getConfiguration().getAppender("RollingFile");
        TriggeringPolicy policy = ((RollingFileManager)app.getManager()).getTriggeringPolicy();
        Assert.assertNotNull((String)"No triggering policy", (Object)policy);
        Assert.assertTrue((String)"Incorrect policy type", (boolean)(policy instanceof CronTriggeringPolicy));
        CronExpression expression = ((CronTriggeringPolicy)policy).getCronExpression();
        Assert.assertTrue((String)"Incorrect triggering policy", (boolean)expression.getCronExpression().equals("* * * ? * *"));
    }
}

