/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.OnStartupTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.apache.logging.log4j.junit.CleanFolders;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class OnStartupTriggeringPolicyTest {
    private static final String TARGET_FOLDER = "target/rollOnStartup";
    private static final String TARGET_FILE = "target/rollOnStartup/testfile";
    private static final String TARGET_PATTERN = "target/rollOnStartup/test1-%d{MM-dd-yyyy}-%i.log";
    private static final String ROLLED_FILE_PREFIX = "target/rollOnStartup/test1-";
    private static final String ROLLED_FILE_SUFFIX = "-1.log";
    private static final String TEST_DATA = "Hello world!";
    private static final FastDateFormat formatter = FastDateFormat.getInstance((String)"MM-dd-yyyy");
    @Rule
    public CleanFolders rule = new CleanFolders("target/rollOnStartup");

    @Test
    public void testPolicy() throws Exception {
        long copied;
        DefaultConfiguration configuration = new DefaultConfiguration();
        Path target = Paths.get(TARGET_FILE, new String[0]);
        Assert.assertFalse((boolean)Files.exists(target, new LinkOption[0]));
        target.toFile().getParentFile().mkdirs();
        long timeStamp = System.currentTimeMillis() - 86400000L;
        String expectedDate = formatter.format(timeStamp);
        String rolledFileName = ROLLED_FILE_PREFIX + expectedDate + ROLLED_FILE_SUFFIX;
        Path rolled = Paths.get(rolledFileName, new String[0]);
        try (ByteArrayInputStream is = new ByteArrayInputStream(TEST_DATA.getBytes("UTF-8"));){
            copied = Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
        }
        long size = Files.size(target);
        Assert.assertTrue((size > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)copied, (long)size);
        FileTime fileTime = FileTime.fromMillis(timeStamp);
        BasicFileAttributeView attrs = Files.getFileAttributeView(target, BasicFileAttributeView.class, new LinkOption[0]);
        attrs.setTimes(fileTime, fileTime, fileTime);
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%msg").withConfiguration((Configuration)configuration).build();
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.createStrategy(null, null, null, (String)"0", null, (boolean)true, (Configuration)configuration);
        OnStartupTriggeringPolicy policy = OnStartupTriggeringPolicy.createPolicy((long)1L);
        try (RollingFileManager manager = RollingFileManager.getFileManager((String)TARGET_FILE, (String)TARGET_PATTERN, (boolean)true, (boolean)false, (TriggeringPolicy)policy, (RolloverStrategy)strategy, null, (Layout)layout, (int)8192, (boolean)true, (boolean)false, null, null, null, (Configuration)configuration);){
            manager.initialize();
            String files = Arrays.toString(new File(TARGET_FOLDER).listFiles());
            Assert.assertTrue((String)(target.toString() + ", files = " + files), (boolean)Files.exists(target, new LinkOption[0]));
            Assert.assertEquals((String)target.toString(), (long)0L, (long)Files.size(target));
            Assert.assertTrue((String)("Missing: " + rolled.toString() + ", files on disk = " + files), (boolean)Files.exists(rolled, new LinkOption[0]));
            Assert.assertEquals((String)rolled.toString(), (long)size, (long)Files.size(rolled));
        }
    }
}

