/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.selector.CoreContextSelectors;
import org.apache.logging.log4j.junit.CleanFiles;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Layouts.Xml.class})
public class XmlCompleteFileAppenderTest {
    private final File logFile = new File("target", "XmlCompleteFileAppenderTest.log");
    private final LoggerContextRule loggerContextRule;
    private final CleanFiles cleanFiles;
    @Rule
    public RuleChain ruleChain;

    public XmlCompleteFileAppenderTest(Class<ContextSelector> contextSelector) {
        this.loggerContextRule = new LoggerContextRule("XmlCompleteFileAppenderTest.xml", contextSelector);
        this.cleanFiles = new CleanFiles(this.logFile);
        this.ruleChain = RuleChain.outerRule((TestRule)this.cleanFiles).around((TestRule)this.loggerContextRule);
    }

    @Parameterized.Parameters(name="{0}")
    public static Class<?>[] getParameters() {
        return CoreContextSelectors.CLASSES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAtEndOfBatch() throws Exception {
        String line5;
        String line4;
        String line3;
        String line2;
        String line1;
        Logger logger = this.loggerContextRule.getLogger("com.foo.Bar");
        String logMsg = "Message flushed with immediate flush=false";
        logger.info("Message flushed with immediate flush=false");
        CoreLoggerContexts.stopLoggerContext(false, this.logFile);
        try (BufferedReader reader = new BufferedReader(new FileReader(this.logFile));){
            line1 = reader.readLine();
            line2 = reader.readLine();
            reader.readLine();
            line3 = reader.readLine();
            line4 = reader.readLine();
            line5 = reader.readLine();
        }
        finally {
            this.logFile.delete();
        }
        Assert.assertNotNull((String)"line1", (Object)line1);
        String msg1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Assert.assertTrue((String)("line1 incorrect: [" + line1 + "], does not contain: [" + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + ']'), (boolean)line1.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        Assert.assertNotNull((String)"line2", (Object)line2);
        String msg2 = "<Events xmlns=\"http://logging.apache.org/log4j/2.0/events\">";
        Assert.assertTrue((String)("line2 incorrect: [" + line2 + "], does not contain: [" + "<Events xmlns=\"http://logging.apache.org/log4j/2.0/events\">" + ']'), (boolean)line2.equals("<Events xmlns=\"http://logging.apache.org/log4j/2.0/events\">"));
        Assert.assertNotNull((String)"line3", (Object)line3);
        String msg3 = "<Event ";
        Assert.assertTrue((String)("line3 incorrect: [" + line3 + "], does not contain: [" + "<Event " + ']'), (boolean)line3.contains("<Event "));
        Assert.assertNotNull((String)"line4", (Object)line4);
        String msg4 = "<Instant epochSecond=";
        Assert.assertTrue((String)("line4 incorrect: [" + line4 + "], does not contain: [" + "<Instant epochSecond=" + ']'), (boolean)line4.contains("<Instant epochSecond="));
        Assert.assertNotNull((String)"line5", (Object)line5);
        String msg5 = "Message flushed with immediate flush=false";
        Assert.assertTrue((String)("line5 incorrect: [" + line5 + "], does not contain: [" + "Message flushed with immediate flush=false" + ']'), (boolean)line5.contains("Message flushed with immediate flush=false"));
        String location = "testFlushAtEndOfBatch";
        Assert.assertTrue((String)"no location", (!line1.contains("testFlushAtEndOfBatch") ? 1 : 0) != 0);
    }

    @Test
    public void testChildElementsAreCorrectlyIndented() throws Exception {
        Logger logger = this.loggerContextRule.getLogger("com.foo.Bar");
        String firstLogMsg = "First Msg tag must be in level 2 after correct indentation";
        logger.info("First Msg tag must be in level 2 after correct indentation");
        String secondLogMsg = "Second Msg tag must also be in level 2 after correct indentation";
        logger.info("Second Msg tag must also be in level 2 after correct indentation");
        CoreLoggerContexts.stopLoggerContext(false, this.logFile);
        int[] indentations = new int[]{0, 0, -1, 2, 4, 4, 2, -1, 2, 4, 4, 2, 0};
        List<String> lines1 = Files.readAllLines(this.logFile.toPath(), Charset.forName("UTF-8"));
        Assert.assertEquals((String)"number of lines", (long)indentations.length, (long)lines1.size());
        for (int i = 0; i < indentations.length; ++i) {
            String line = lines1.get(i);
            if (line.trim().isEmpty()) {
                Assert.assertEquals((long)-1L, (long)indentations[i]);
                continue;
            }
            String padding = "        ".substring(0, indentations[i]);
            Assert.assertTrue((String)("Expected " + indentations[i] + " leading spaces but got: " + line), (boolean)line.startsWith(padding));
        }
    }
}

