/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.junit.CleanFiles;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FileAppenderTest {
    private static final String FILE_NAME = "target/fileAppenderTest.log";
    private static final Path PATH = Paths.get("target/fileAppenderTest.log", new String[0]);
    private static final int THREADS = 2;
    private final boolean createOnDemand;
    private final int threadCount = 2;
    @Rule
    public CleanFiles files = new CleanFiles(PATH);

    @Parameterized.Parameters(name="createOnDemand = {0}")
    public static Boolean[] getParameters() {
        return new Boolean[]{false, true};
    }

    public FileAppenderTest(boolean createOnDemand) {
        this.createOnDemand = createOnDemand;
    }

    @AfterClass
    public static void cleanupClass() {
        Assert.assertTrue((String)"Manager for target/fileAppenderTest.log not removed", (!AbstractManager.hasManager((String)FILE_NAME) ? 1 : 0) != 0);
    }

    @Test
    public void testAppender() throws Exception {
        boolean logEventCount = true;
        FileAppenderTest.writer(false, 1, "test", this.createOnDemand, false);
        this.verifyFile(1);
    }

    @Test
    public void testLazyCreate() throws Exception {
        PatternLayout layout = FileAppenderTest.createPatternLayout();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(FILE_NAME).setName("test")).withImmediateFlush(false)).setIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(1)).setLayout((Layout)layout)).withCreateOnDemand(this.createOnDemand).build();
        Assert.assertEquals((Object)this.createOnDemand, (Object)((FileManager)appender.getManager()).isCreateOnDemand());
        try {
            Assert.assertNotEquals((Object)this.createOnDemand, (Object)Files.exists(PATH, new LinkOption[0]));
            appender.start();
            Assert.assertNotEquals((Object)this.createOnDemand, (Object)Files.exists(PATH, new LinkOption[0]));
        }
        finally {
            appender.stop();
        }
        Assert.assertNotEquals((Object)this.createOnDemand, (Object)Files.exists(PATH, new LinkOption[0]));
    }

    private static PatternLayout createPatternLayout() {
        return PatternLayout.newBuilder().withPattern("%d [%t] %p %c - %m%n").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSmallestBufferSize() throws Exception {
        PatternLayout layout = FileAppenderTest.createPatternLayout();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(FILE_NAME).setName("test")).withImmediateFlush(false)).setIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(1)).setLayout((Layout)layout)).withCreateOnDemand(this.createOnDemand).build();
        try {
            long curLen;
            appender.start();
            File file = new File(FILE_NAME);
            Assert.assertTrue((String)"Appender did not start", (boolean)appender.isStarted());
            Assert.assertNotEquals((Object)this.createOnDemand, (Object)Files.exists(PATH, new LinkOption[0]));
            long prevLen = curLen = file.length();
            Assert.assertTrue((String)("File length: " + curLen), (curLen == 0L ? 1 : 0) != 0);
            for (int i = 0; i < 100; ++i) {
                Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("TestLogger").setLoggerFqcn(FileAppenderTest.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Test")).setThreadName(this.getClass().getSimpleName()).setTimeMillis(System.currentTimeMillis()).build();
                appender.append((LogEvent)event);
                curLen = file.length();
                Assert.assertTrue((String)("File length: " + curLen), (curLen > prevLen ? 1 : 0) != 0);
                Thread.sleep(25L);
                prevLen = curLen;
            }
        }
        finally {
            appender.stop();
        }
        Assert.assertFalse((String)"Appender did not stop", (boolean)appender.isStarted());
    }

    @Test
    public void testLockingAppender() throws Exception {
        boolean logEventCount = true;
        FileAppenderTest.writer(true, 1, "test", this.createOnDemand, false);
        this.verifyFile(1);
    }

    @Test
    public void testMultipleAppenderThreads() throws Exception {
        this.testMultipleLockingAppenderThreads(false, 2);
    }

    private void testMultipleLockingAppenderThreads(boolean lock, int threadCount) throws InterruptedException, Exception {
        ExecutorService threadPool = Executors.newFixedThreadPool(threadCount);
        Exception[] exceptionRef = new Exception[1];
        int logEventCount = 100;
        FileWriterRunnable runnable = new FileWriterRunnable(lock, 100, exceptionRef);
        for (int i = 0; i < threadCount; ++i) {
            threadPool.execute(runnable);
        }
        threadPool.shutdown();
        Assert.assertTrue((String)("The thread pool has not shutdown: " + threadPool), (boolean)threadPool.awaitTermination(10L, TimeUnit.SECONDS));
        if (exceptionRef[0] != null) {
            throw exceptionRef[0];
        }
        this.verifyFile(threadCount * 100);
    }

    @Test
    public void testMultipleLockingAppenders() throws Exception {
        this.testMultipleLockingAppenderThreads(true, 2);
    }

    @Test
    @Ignore
    public void testMultipleVMs() throws Exception {
        int index;
        String classPath = System.getProperty("java.class.path");
        Integer logEventCount = 10;
        int processCount = 3;
        Process[] processes = new Process[3];
        ProcessBuilder[] builders = new ProcessBuilder[3];
        for (index = 0; index < 3; ++index) {
            builders[index] = new ProcessBuilder("java", "-cp", classPath, ProcessTest.class.getName(), "Process " + index, logEventCount.toString(), "true", Boolean.toString(this.createOnDemand));
        }
        for (index = 0; index < 3; ++index) {
            processes[index] = builders[index].start();
        }
        for (index = 0; index < 3; ++index) {
            Process process = processes[index];
            try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            process.destroy();
        }
        this.verifyFile(logEventCount * 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writer(boolean locking, int logEventCount, String name, boolean createOnDemand, boolean concurrent) throws Exception {
        PatternLayout layout = FileAppenderTest.createPatternLayout();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(FILE_NAME).setName("test")).withImmediateFlush(false)).setIgnoreExceptions(false)).withLocking(locking).withBufferedIo(false)).setLayout((Layout)layout)).withCreateOnDemand(createOnDemand).build();
        Assert.assertEquals((Object)createOnDemand, (Object)((FileManager)appender.getManager()).isCreateOnDemand());
        try {
            boolean expectFileCreated;
            appender.start();
            Assert.assertTrue((String)"Appender did not start", (boolean)appender.isStarted());
            boolean exists = Files.exists(PATH, new LinkOption[0]);
            String msg = String.format("concurrent = %s, createOnDemand = %s, file exists = %s", concurrent, createOnDemand, exists);
            boolean bl = expectFileCreated = !createOnDemand;
            if (concurrent && expectFileCreated) {
                Assert.assertTrue((String)msg, (boolean)exists);
            } else if (expectFileCreated) {
                Assert.assertNotEquals((String)msg, (Object)createOnDemand, (Object)exists);
            }
            for (int i = 0; i < logEventCount; ++i) {
                Log4jLogEvent logEvent = Log4jLogEvent.newBuilder().setLoggerName("TestLogger").setLoggerFqcn(FileAppenderTest.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Test")).setThreadName(name).setTimeMillis(System.currentTimeMillis()).build();
                appender.append((LogEvent)logEvent);
                Thread.sleep(25L);
                continue;
            }
        }
        finally {
            appender.stop();
        }
        Assert.assertFalse((String)"Appender did not stop", (boolean)appender.isStarted());
    }

    private void verifyFile(int count) throws Exception {
        String expected = "^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} \\[[^\\]]*\\] INFO TestLogger - Test";
        Pattern pattern = Pattern.compile("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} \\[[^\\]]*\\] INFO TestLogger - Test");
        int lines = 0;
        try (BufferedReader is = new BufferedReader(new InputStreamReader(new FileInputStream(FILE_NAME)));){
            String str = "";
            while (is.ready()) {
                str = is.readLine();
                ++lines;
                Matcher matcher = pattern.matcher(str);
                Assert.assertTrue((String)("Unexpected data: " + str), (boolean)matcher.matches());
            }
        }
        Assert.assertEquals((long)count, (long)lines);
    }

    public static class ProcessTest {
        public static void main(String[] args) {
            if (args.length != 3) {
                System.out.println("Required arguments 'id', 'count' and 'lock' not provided");
                System.exit(-1);
            }
            String id = args[0];
            int count = Integer.parseInt(args[1]);
            if (count <= 0) {
                System.out.println("Invalid count value: " + args[1]);
                System.exit(-1);
            }
            boolean lock = Boolean.parseBoolean(args[2]);
            boolean createOnDemand = Boolean.parseBoolean(args[2]);
            try {
                FileAppenderTest.writer(lock, count, id, createOnDemand, true);
            }
            catch (Exception e) {
                Throwables.rethrow((Throwable)e);
            }
        }
    }

    public class FileWriterRunnable
    implements Runnable {
        private final boolean lock;
        private final int logEventCount;
        private final Exception[] exceptionRef;

        public FileWriterRunnable(boolean lock, int logEventCount, Exception[] exceptionRef) {
            this.lock = lock;
            this.logEventCount = logEventCount;
            this.exceptionRef = exceptionRef;
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            try {
                FileAppenderTest.writer(this.lock, this.logEventCount, thread.getName(), FileAppenderTest.this.createOnDemand, true);
            }
            catch (Exception e) {
                this.exceptionRef[0] = e;
                Throwables.rethrow((Throwable)e);
            }
        }
    }
}

