/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class AsyncAppenderNoLocationTest {
    private ListAppender app;
    @ClassRule
    public static LoggerContextRule init = null;

    @Before
    public void setUp() throws Exception {
        try {
            this.app = (ListAppender)((Object)init.getAppender("List"));
            Assert.assertNotNull((String)"No List appender found", (Object)((Object)this.app));
        }
        catch (Exception ex) {
            System.out.println("init = " + init == null ? "null" : init);
        }
    }

    @After
    public void after() {
        if (this.app != null) {
            this.app.clear();
        }
    }

    @Test
    public void testNoLocation() throws Exception {
        Logger logger = LogManager.getLogger(AsyncAppender.class);
        logger.error("This is a test");
        logger.warn("Hello world!");
        Thread.sleep(100L);
        System.out.println("app = " + (Object)((Object)this.app) == null ? "null" : this.app);
        List<String> list = this.app.getMessages();
        Assert.assertNotNull((String)"No events generated", list);
        Assert.assertEquals((String)("Incorrect number of events. Expected 2, got " + list.size()), (long)list.size(), (long)2L);
        String msg = list.get(0);
        String expected = "?  This is a test";
        Assert.assertEquals((String)("Expected " + expected + ", Actual " + msg), (Object)expected, (Object)msg);
        msg = list.get(1);
        expected = "?  Hello world!";
        Assert.assertEquals((String)("Expected " + expected + ", Actual " + msg), (Object)expected, (Object)msg);
    }

    static {
        try {
            init = new LoggerContextRule("log4j-asynch-no-location.xml");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

