/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class CollectionLoggingTest {
    private static final String CONFIG = "log4j-collectionLogging.xml";
    private ListAppender app;
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-collectionLogging.xml");

    @Before
    public void before() {
        this.app = context.getListAppender("List").clear();
    }

    @Test
    public void testSystemProperties() {
        Logger logger = context.getLogger(CollectionLoggingTest.class.getName());
        logger.error((Object)System.getProperties());
    }

    @Test
    public void testSimpleMap() {
        Logger logger = context.getLogger(CollectionLoggingTest.class.getName());
        logger.error((Object)System.getProperties());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("MyKey1", "MyValue1");
        map.put("MyKey2", "MyValue2");
        logger.error((Message)new StringMapMessage(map));
        logger.error(map);
    }

    @Test
    public void testNetworkInterfaces() throws SocketException {
        Logger logger = context.getLogger(CollectionLoggingTest.class.getName());
        logger.error(NetworkInterface.getNetworkInterfaces());
    }

    @Test
    public void testAvailableCharsets() throws SocketException {
        Logger logger = context.getLogger(CollectionLoggingTest.class.getName());
        logger.error(Charset.availableCharsets());
    }
}

