/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.LevelPatternConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class LevelPatternConverterTest {
    private void testLevelLength(int length, String debug, String warn) {
        SimpleMessage msg = new SimpleMessage("Hello");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        LevelPatternConverter converter = LevelPatternConverter.newInstance(null);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)Level.DEBUG.toString(), (Object)sb.toString());
        String[] opts = new String[]{"length=" + length};
        converter = LevelPatternConverter.newInstance((String[])opts);
        sb.setLength(0);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)debug, (Object)sb.toString());
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.WARN).setMessage((Message)msg).build();
        sb.setLength(0);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)warn, (Object)sb.toString());
    }

    @Test
    public void testLevelLength1() {
        this.testLevelLength(1, "D", "W");
    }

    @Test
    public void testLevelLength10() {
        this.testLevelLength(10, "DEBUG", "WARN");
    }

    @Test
    public void testLevelLength2() {
        this.testLevelLength(2, "DE", "WA");
    }

    @Test
    public void testLevelLength5() {
        this.testLevelLength(5, "DEBUG", "WARN");
    }

    @Test
    public void testLevelLowerCase() {
        SimpleMessage msg = new SimpleMessage("Hello");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        LevelPatternConverter converter = LevelPatternConverter.newInstance(null);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)Level.DEBUG.toString(), (Object)sb.toString());
        String[] opts = new String[]{"lowerCase=true"};
        converter = LevelPatternConverter.newInstance((String[])opts);
        sb.setLength(0);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"debug", (Object)sb.toString());
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.WARN).setMessage((Message)msg).build();
        sb.setLength(0);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"warn", (Object)sb.toString());
    }

    @Test
    public void testLevelMap() {
        SimpleMessage msg = new SimpleMessage("Hello");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        LevelPatternConverter converter = LevelPatternConverter.newInstance(null);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)Level.DEBUG.toString(), (Object)sb.toString());
        String[] opts = new String[]{"WARN=Warning, DEBUG=Debug, ERROR=Error, TRACE=Trace, INFO=Info"};
        converter = LevelPatternConverter.newInstance((String[])opts);
        sb.setLength(0);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"Debug", (Object)sb.toString());
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.WARN).setMessage((Message)msg).build();
        sb.setLength(0);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"Warning", (Object)sb.toString());
    }

    @Test
    public void testLevelMapWithLength() {
        SimpleMessage msg = new SimpleMessage("Hello");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        LevelPatternConverter converter = LevelPatternConverter.newInstance(null);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)Level.DEBUG.toString(), (Object)sb.toString());
        String[] opts = new String[]{"WARN=Warning, length=2"};
        converter = LevelPatternConverter.newInstance((String[])opts);
        sb.setLength(0);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"DE", (Object)sb.toString());
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.WARN).setMessage((Message)msg).build();
        sb.setLength(0);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"Warning", (Object)sb.toString());
    }

    @Test
    public void testLevelMapWithLengthAndLowerCase() {
        SimpleMessage msg = new SimpleMessage("Hello");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        LevelPatternConverter converter = LevelPatternConverter.newInstance(null);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)Level.DEBUG.toString(), (Object)sb.toString());
        String[] opts = new String[]{"WARN=Warning, length=2, lowerCase=true"};
        converter = LevelPatternConverter.newInstance((String[])opts);
        sb.setLength(0);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"de", (Object)sb.toString());
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.WARN).setMessage((Message)msg).build();
        sb.setLength(0);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)"Warning", (Object)sb.toString());
    }
}

