/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.security.KeyStore;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;
import org.apache.logging.log4j.core.net.ssl.TestConstants;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TrustStoreConfigurationTest {
    @Test(expected=StoreConfigurationException.class)
    public void loadEmptyConfigurationDeprecated() throws StoreConfigurationException {
        TrustStoreConfiguration ksc = new TrustStoreConfiguration(null, TestConstants.NULL_PWD, null, null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertTrue((ks == null ? 1 : 0) != 0);
    }

    @Test(expected=StoreConfigurationException.class)
    public void loadEmptyConfiguration() throws StoreConfigurationException {
        TrustStoreConfiguration ksc = new TrustStoreConfiguration(null, (PasswordProvider)new MemoryPasswordProvider(TestConstants.NULL_PWD), null, null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertTrue((ks == null ? 1 : 0) != 0);
    }

    @Test
    public void loadConfigurationDeprecated() throws StoreConfigurationException {
        TrustStoreConfiguration ksc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", TestConstants.TRUSTSTORE_PWD(), null, null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertNotNull((Object)ks);
    }

    @Test
    public void loadConfiguration() throws StoreConfigurationException {
        TrustStoreConfiguration ksc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.TRUSTSTORE_PWD()), null, null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertNotNull((Object)ks);
    }

    @Test
    public void returnTheSameKeyStoreAfterMultipleLoadsDeprecated() throws StoreConfigurationException {
        KeyStore ks2;
        TrustStoreConfiguration ksc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", TestConstants.TRUSTSTORE_PWD(), null, null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertTrue((ks == (ks2 = ksc.getKeyStore()) ? 1 : 0) != 0);
    }

    @Test
    public void returnTheSameKeyStoreAfterMultipleLoads() throws StoreConfigurationException {
        KeyStore ks2;
        TrustStoreConfiguration ksc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.TRUSTSTORE_PWD()), null, null);
        KeyStore ks = ksc.getKeyStore();
        Assert.assertTrue((ks == (ks2 = ksc.getKeyStore()) ? 1 : 0) != 0);
    }

    @Test(expected=StoreConfigurationException.class)
    public void wrongPasswordDeprecated() throws StoreConfigurationException {
        TrustStoreConfiguration ksc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", "wrongPassword!".toCharArray(), null, null);
        ksc.getKeyStore();
        Assert.assertTrue((boolean)false);
    }

    @Test(expected=StoreConfigurationException.class)
    public void wrongPassword() throws StoreConfigurationException {
        TrustStoreConfiguration ksc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", (PasswordProvider)new MemoryPasswordProvider("wrongPassword!".toCharArray()), null, null);
        ksc.getKeyStore();
        Assert.assertTrue((boolean)false);
    }
}

