/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.apache.logging.log4j.junit.ThreadContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class HtmlLayoutTest {
    LoggerContext ctx = LoggerContext.getContext();
    Logger root = this.ctx.getRootLogger();
    static ConfigurationFactory cf = new BasicConfigurationFactory();
    @Rule
    public final ThreadContextRule threadContextRule = new ThreadContextRule();
    private static final String body = "<tr><td bgcolor=\"#993300\" style=\"color:White; font-size : small;\" colspan=\"6\">java.lang.NullPointerException: test";
    private static final String multiLine = "<td title=\"Message\">First line<br />Second line</td>";

    @BeforeClass
    public static void setupClass() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)cf);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
    }

    @AfterClass
    public static void cleanupClass() {
        ConfigurationFactory.removeConfigurationFactory((ConfigurationFactory)cf);
    }

    @Test
    public void testDefaultContentType() {
        HtmlLayout layout = HtmlLayout.createDefaultLayout();
        Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)layout.getContentType());
    }

    @Test
    public void testContentType() {
        HtmlLayout layout = HtmlLayout.newBuilder().withContentType("text/html; charset=UTF-16").build();
        Assert.assertEquals((Object)"text/html; charset=UTF-16", (Object)layout.getContentType());
    }

    @Test
    public void testDefaultCharset() {
        HtmlLayout layout = HtmlLayout.createDefaultLayout();
        Assert.assertEquals((Object)StandardCharsets.UTF_8, (Object)layout.getCharset());
    }

    @Test
    public void testLayoutIncludeLocationNo() throws Exception {
        this.testLayout(false);
    }

    @Test
    public void testLayoutIncludeLocationYes() throws Exception {
        this.testLayout(true);
    }

    private void testLayout(boolean includeLocation) throws Exception {
        String string2;
        Object appender2;
        Map appenders = this.root.getAppenders();
        for (Object appender2 : appenders.values()) {
            this.root.removeAppender((Appender)appender2);
        }
        HtmlLayout layout = HtmlLayout.newBuilder().withLocationInfo(includeLocation).build();
        appender2 = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender2.start();
        this.root.addAppender((Appender)appender2);
        this.root.setLevel(Level.DEBUG);
        this.root.debug("starting mdc pattern test");
        this.root.debug("empty mdc");
        this.root.debug("First line\nSecond line");
        ThreadContext.put((String)"key1", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        this.root.debug("filled mdc");
        ThreadContext.remove((String)"key1");
        ThreadContext.remove((String)"key2");
        this.root.error("finished mdc pattern test", (Throwable)new NullPointerException("test"));
        appender2.stop();
        List<String> list = ((ListAppender)((Object)appender2)).getMessages();
        StringBuilder sb = new StringBuilder();
        for (String string2 : list) {
            sb.append(string2);
        }
        String html = sb.toString();
        Assert.assertTrue((String)("Incorrect number of lines. Require at least 85 " + list.size()), (list.size() > 85 ? 1 : 0) != 0);
        string2 = list.get(3);
        Assert.assertTrue((String)("Incorrect header: " + string2), (boolean)string2.equals("<meta charset=\"UTF-8\"/>"));
        Assert.assertTrue((String)"Incorrect title", (boolean)list.get(4).equals("<title>Log4j Log Messages</title>"));
        Assert.assertTrue((String)"Incorrect footer", (boolean)list.get(list.size() - 1).equals("</body></html>"));
        if (includeLocation) {
            Assert.assertTrue((String)"Incorrect multiline", (boolean)list.get(50).equals(multiLine));
            Assert.assertTrue((String)"Missing location", (boolean)html.contains("HtmlLayoutTest.java:"));
            Assert.assertTrue((String)"Incorrect body", (boolean)list.get(71).equals(body));
        } else {
            Assert.assertFalse((String)"Location should not be in the output table", (boolean)html.contains("<td>HtmlLayoutTest.java:"));
        }
        for (Appender app : appenders.values()) {
            this.root.addAppender(app);
        }
    }
}

