/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class PropertyTest {
    private static final String CONFIG = "configPropertyTest.xml";
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("configPropertyTest.xml");

    @Test
    public void testEmptyAttribute() throws Exception {
        Logger logger = LogManager.getLogger();
        logger.info("msg");
        ListAppender app = (ListAppender)context.getRequiredAppender("List");
        Assert.assertNotNull((String)"No ListAppender", (Object)((Object)app));
        List<String> messages = app.getMessages();
        Assert.assertNotNull((String)"No Messages", messages);
        Assert.assertEquals((String)("message count" + messages), (long)1L, (long)messages.size());
        String expect = "1=elementValue,2=,a=,b=,3=attributeValue,4=attributeValue2,5=elementValue3,m=msg";
        Assert.assertEquals((Object)"1=elementValue,2=,a=,b=,3=attributeValue,4=attributeValue2,5=elementValue3,m=msg", (Object)messages.get(0));
        app.clear();
    }

    @Test
    public void testNullValueIsConvertedToEmptyString() {
        Assert.assertEquals((Object)"", (Object)Property.createProperty((String)"name", null).getValue());
    }

    @Test
    public void testIsValueNeedsLookup() {
        Assert.assertTrue((String)"with ${ as value", (boolean)Property.createProperty((String)"", (String)"${").isValueNeedsLookup());
        Assert.assertTrue((String)"with ${ in value", (boolean)Property.createProperty((String)"", (String)"blah${blah").isValueNeedsLookup());
        Assert.assertFalse((String)"empty value", (boolean)Property.createProperty((String)"", (String)"").isValueNeedsLookup());
        Assert.assertFalse((String)"without ${ in value", (boolean)Property.createProperty((String)"", (String)"blahblah").isValueNeedsLookup());
        Assert.assertFalse((String)"without $ in value", (boolean)Property.createProperty((String)"", (String)"blahb{sys:lah").isValueNeedsLookup());
        Assert.assertFalse((String)"without { in value", (boolean)Property.createProperty((String)"", (String)"blahb$sys:lah").isValueNeedsLookup());
    }
}

