/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async.perftest;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.spi.LoggerContext;

public class SimplePerfTest {
    static final int ITERATIONS = 100000;

    public static void main(String[] args) throws Exception {
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        Logger logger = LogManager.getLogger();
        if (!(logger instanceof AsyncLogger)) {
            throw new IllegalStateException();
        }
        SimplePerfTest.workAroundLog4j2_5Bug();
        logger.error("Starting...");
        System.out.println("Starting...");
        Thread.sleep(100L);
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        long testStartNanos = System.nanoTime();
        long[] UPTIMES = new long[1024];
        long[] DURATIONS = new long[1024];
        long startMs = System.currentTimeMillis();
        long end = startMs + TimeUnit.SECONDS.toMillis(10L);
        int warmupCount = 0;
        do {
            SimplePerfTest.runTest(logger, runtimeMXBean, UPTIMES, DURATIONS, warmupCount);
            ++warmupCount;
        } while (System.currentTimeMillis() < end);
        int COUNT = 10;
        for (int i = 0; i < 10; ++i) {
            int count = warmupCount + i;
            SimplePerfTest.runTest(logger, runtimeMXBean, UPTIMES, DURATIONS, count);
        }
        double testDurationNanos = System.nanoTime() - testStartNanos;
        System.out.println("Done. Calculating stats...");
        SimplePerfTest.printReport("Warmup", UPTIMES, DURATIONS, 0, warmupCount);
        SimplePerfTest.printReport("Test", UPTIMES, DURATIONS, warmupCount, 10);
        StringBuilder sb = new StringBuilder(512);
        sb.append("Test took: ").append(testDurationNanos / 1.0E9).append(" sec");
        System.out.println(sb);
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (int i = 0; i < gcBeans.size(); ++i) {
            GarbageCollectorMXBean gcBean = gcBeans.get(i);
            sb.setLength(0);
            sb.append("GC[").append(gcBean.getName()).append("] ");
            sb.append(gcBean.getCollectionCount()).append(" collections, collection time=");
            sb.append(gcBean.getCollectionTime()).append(" millis.");
            System.out.println(sb);
        }
    }

    private static void printReport(String label, long[] UPTIMES, long[] DURATIONS, int offset, int length) {
        StringBuilder sb = new StringBuilder(512);
        long total = 0L;
        for (int i = offset; i < offset + length; ++i) {
            sb.setLength(0);
            long opsPerSec = 100000000000000L / DURATIONS[i];
            total += opsPerSec;
            sb.append(UPTIMES[i]).append(" ");
            sb.append(label).append(": Throughput: ").append(opsPerSec).append(" ops/s");
            System.out.println(sb);
        }
        sb.setLength(0);
        sb.append("Average ").append(label).append(" throughput: ").append(total / (long)length).append(" ops/s");
        System.out.println(sb);
        sb.setLength(0);
        System.out.println(sb.append(label).append(" ran: ").append(length).append(" iterations"));
    }

    private static void runTest(Logger logger, RuntimeMXBean runtimeMXBean, long[] UPTIMES, long[] DURATIONS, int index) {
        UPTIMES[index] = runtimeMXBean.getUptime();
        long startNanos = System.nanoTime();
        SimplePerfTest.loop(logger, 100000);
        long endNanos = System.nanoTime();
        DURATIONS[index] = endNanos - startNanos;
    }

    private static void loop(Logger logger, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            logger.error("simple text message");
        }
    }

    private static void workAroundLog4j2_5Bug() {
        try {
            Method setUseThreadLocals = AsyncLoggerContext.class.getDeclaredMethod("setUseThreadLocals", Boolean.TYPE);
            LoggerContext context = LogManager.getContext((boolean)false);
            setUseThreadLocals.invoke((Object)context, Boolean.TRUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

