/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerThreadContextTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        System.setProperty("log4j.configurationFile", "AsyncLoggerThreadContextTest.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Test
    public void testAsyncLogWritesToLog() throws Exception {
        File file = new File("target", "AsyncLoggerTest.log");
        file.delete();
        ThreadContext.push((String)"stackvalue");
        ThreadContext.put((String)"KEY", (String)"mapvalue");
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        String msg = "Async logger msg";
        log.info("Async logger msg", (Throwable)new InternalError("this is not a real error"));
        CoreLoggerContexts.stopLoggerContext(false, file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        reader.close();
        file.delete();
        Assert.assertNotNull((String)"line1", (Object)line1);
        Assert.assertTrue((String)"line1 correct", (boolean)line1.contains("Async logger msg"));
        Assert.assertTrue((String)"ThreadContext.map", (boolean)line1.contains("mapvalue"));
        Assert.assertTrue((String)"ThreadContext.stack", (boolean)line1.contains("stackvalue"));
    }
}

