/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerConfigTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.configurationFile", "AsyncLoggerConfigTest.xml");
    }

    @Test
    public void testAdditivity() throws Exception {
        File file = new File("target", "AsyncLoggerConfigTest.log");
        Assert.assertTrue((String)"Deleted old file before test", (!file.exists() || file.delete() ? 1 : 0) != 0);
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        String msg = "Additive logging: 2 for the price of 1!";
        log.info("Additive logging: 2 for the price of 1!");
        CoreLoggerContexts.stopLoggerContext(file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        String line2 = reader.readLine();
        reader.close();
        file.delete();
        Assert.assertNotNull((String)"line1", (Object)line1);
        Assert.assertNotNull((String)"line2", (Object)line2);
        Assert.assertTrue((String)"line1 correct", (boolean)line1.contains("Additive logging: 2 for the price of 1!"));
        Assert.assertTrue((String)"line2 correct", (boolean)line2.contains("Additive logging: 2 for the price of 1!"));
        String location = "testAdditivity";
        Assert.assertTrue((String)"location", (line1.contains("testAdditivity") || line2.contains("testAdditivity") ? 1 : 0) != 0);
    }

    @Test
    public void testIncludeLocationDefaultsToFalse() {
        LoggerConfig rootLoggerConfig = AsyncLoggerConfig.RootLogger.createLogger(null, (String)"INFO", null, (AppenderRef[])new AppenderRef[0], null, (Configuration)new DefaultConfiguration(), null);
        Assert.assertFalse((String)"Include location should default to false for async logggers", (boolean)rootLoggerConfig.isIncludeLocation());
        LoggerConfig loggerConfig = AsyncLoggerConfig.createLogger(null, (String)"INFO", (String)"com.foo.Bar", null, (AppenderRef[])new AppenderRef[0], null, (Configuration)new DefaultConfiguration(), null);
        Assert.assertFalse((String)"Include location should default to false for async logggers", (boolean)loggerConfig.isIncludeLocation());
    }
}

