/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderSizeWithTimeTest {
    private static final String CONFIG = "log4j-rolling-size-with-time.xml";
    private static final String DIR = "target/rolling-size-test";
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-size-with-time.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rolling-size-test");
    private Logger logger;

    @Before
    public void setUp() throws Exception {
        this.logger = loggerContextRule.getLogger(RollingAppenderSizeWithTimeTest.class.getName());
    }

    @Test
    public void testAppender() throws Exception {
        ArrayList<String> messages = new ArrayList<String>();
        for (int i = 0; i < 5000; ++i) {
            String message = "This is test message number " + i;
            messages.add(message);
            this.logger.debug(message);
            if (i % 100 != 0) continue;
            Thread.sleep(10L);
        }
        if (!loggerContextRule.getLoggerContext().stop(30L, TimeUnit.SECONDS)) {
            System.err.println("Could not stop cleanly " + loggerContextRule + " for " + this);
        }
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (boolean)dir.exists());
        File[] files = dir.listFiles();
        Assert.assertNotNull((Object)files);
        for (File file : files) {
            String[] lines;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (FileInputStream fis = new FileInputStream(file);){
                try {
                    IOUtils.copy((InputStream)fis, (OutputStream)baos);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Assert.fail((String)("Unable to read " + file.getAbsolutePath()));
                }
            }
            String text = new String(baos.toByteArray(), Charset.defaultCharset());
            for (String line : lines = text.split("[\\r\\n]+")) {
                messages.remove(line);
            }
        }
        Assert.assertTrue((String)("Log messages lost : " + messages.size()), (boolean)messages.isEmpty());
        Assert.assertTrue((String)("Files not rolled : " + files.length), (files.length > 2 ? 1 : 0) != 0);
    }
}

