/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RandomRollingAppenderOnStartupTest {
    private static final String DIR = "target/onStartup";
    private Logger logger;
    @Rule
    public LoggerContextRule loggerContextRule;

    @Parameterized.Parameters(name="{0} \u2192 {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"log4j-test5.xml"}, {"log4j-test5.xml"});
    }

    public RandomRollingAppenderOnStartupTest(String configFile) {
        this.loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule(configFile);
    }

    @Before
    public void setUp() throws Exception {
        this.logger = this.loggerContextRule.getLogger(RandomRollingAppenderOnStartupTest.class.getName());
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        if (Files.exists(Paths.get(DIR, new String[0]), new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(DIR, new String[0]));){
                for (Path path : directoryStream) {
                    Files.delete(path);
                }
                Files.delete(Paths.get(DIR, new String[0]));
            }
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        long size = 0L;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(DIR, new String[0]));){
            for (Path path : directoryStream) {
                if (size == 0L) {
                    size = Files.size(path);
                } else {
                    long fileSize = Files.size(path);
                    Assert.assertTrue((String)("Expected size: " + size + " Size of " + path.getFileName() + ": " + fileSize), (size == fileSize ? 1 : 0) != 0);
                }
                Files.delete(path);
            }
            Files.delete(Paths.get(DIR, new String[0]));
        }
    }

    @Test
    public void testAppender() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.logger.debug("This is test message number " + i);
        }
    }
}

