/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.junit.Assert;
import org.junit.Test;

public class PatternProcessorTest {
    private String format(long time) {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").format(new Date(time));
    }

    @Test
    public void testDontInterpretBackslashAsEscape() {
        PatternProcessor pp = new PatternProcessor("c:\\test\\new/app-%d{HH-mm-ss}.log");
        Calendar cal = Calendar.getInstance();
        cal.set(11, 16);
        cal.set(12, 2);
        cal.set(13, 15);
        StringBuilder buf = new StringBuilder();
        pp.formatFileName(buf, new Object[]{cal.getTime(), 23});
        Assert.assertEquals((Object)"c:\\test\\new/app-16-02-15.log", (Object)buf.toString());
    }

    @Test
    public void testGetNextTimeHourlyReturnsFirstMinuteOfNextHour() {
        PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM-dd-HH}.log.gz");
        Calendar initial = Calendar.getInstance();
        initial.set(2014, 2, 4, 10, 31, 59);
        long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
        Calendar expected = Calendar.getInstance();
        expected.set(2014, 2, 4, 11, 0, 0);
        expected.set(14, 0);
        Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
    }

    @Test
    public void testGetNextTimeHourlyReturnsFirstMinuteOfNextHour2() {
        PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM-dd-HH}.log.gz");
        Calendar initial = Calendar.getInstance();
        initial.set(2014, 2, 4, 23, 31, 59);
        long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
        Calendar expected = Calendar.getInstance();
        expected.set(2014, 2, 5, 0, 0, 0);
        expected.set(14, 0);
        Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
    }

    @Test
    public void testGetNextTimeHourlyReturnsFirstMinuteOfNextYear() {
        PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM-dd-HH}.log.gz");
        Calendar initial = Calendar.getInstance();
        initial.set(2015, 11, 31, 23, 31, 59);
        long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
        Calendar expected = Calendar.getInstance();
        expected.set(2016, 0, 1, 0, 0, 0);
        expected.set(14, 0);
        Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
    }

    @Test
    public void testGetNextTimeMillisecondlyReturnsNextMillisec() {
        PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM-dd-HH-mm-ss.SSS}.log.gz");
        Calendar initial = Calendar.getInstance();
        initial.set(2014, 2, 4, 10, 31, 53);
        initial.set(14, 123);
        Assert.assertEquals((Object)"2014/03/04 10:31:53.123", (Object)this.format(initial.getTimeInMillis()));
        long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
        Calendar expected = Calendar.getInstance();
        expected.set(2014, 2, 4, 10, 31, 53);
        expected.set(14, 124);
        Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
    }

    @Test
    public void testGetNextTimeMinutelyReturnsFirstSecondOfNextMinute() {
        PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM-dd-HH-mm}.log.gz");
        Calendar initial = Calendar.getInstance();
        initial.set(2014, 2, 4, 10, 31, 59);
        initial.set(14, 0);
        Assert.assertEquals((Object)"2014/03/04 10:31:59.000", (Object)this.format(initial.getTimeInMillis()));
        long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
        Calendar expected = Calendar.getInstance();
        expected.set(2014, 2, 4, 10, 32, 0);
        expected.set(14, 0);
        Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
    }

    @Test
    public void testGetNextTimeMonthlyReturnsFirstDayOfNextMonth() {
        PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM}.log.gz");
        Calendar initial = Calendar.getInstance();
        initial.set(2014, 9, 15, 10, 31, 59);
        long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
        Calendar expected = Calendar.getInstance();
        expected.set(2014, 10, 1, 0, 0, 0);
        expected.set(14, 0);
        Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
    }

    @Test
    public void testGetNextTimeMonthlyReturnsFirstDayOfNextMonth2() {
        PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM}.log.gz");
        Calendar initial = Calendar.getInstance();
        initial.set(2014, 0, 31, 10, 31, 59);
        long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
        Calendar expected = Calendar.getInstance();
        expected.set(2014, 1, 1, 0, 0, 0);
        expected.set(14, 0);
        Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
    }

    @Test
    public void testGetNextTimeMonthlyReturnsFirstDayOfNextMonth3() {
        PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM}.log.gz");
        Calendar initial = Calendar.getInstance();
        initial.set(2014, 11, 31, 10, 31, 59);
        long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
        Calendar expected = Calendar.getInstance();
        expected.set(2015, 0, 1, 0, 0, 0);
        expected.set(14, 0);
        Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
    }

    @Test
    public void testGetNextTimeMonthlyReturnsFirstDayOfNextYear() {
        PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM}.log.gz");
        Calendar initial = Calendar.getInstance();
        initial.set(2015, 11, 28, 0, 0, 0);
        long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
        Calendar expected = Calendar.getInstance();
        expected.set(2016, 0, 1, 0, 0, 0);
        expected.set(14, 0);
        Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
    }

    @Test
    public void testGetNextTimeSecondlyReturnsFirstMillisecOfNextSecond() {
        PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM-dd-HH-mm-ss}.log.gz");
        Calendar initial = Calendar.getInstance();
        initial.set(2014, 2, 4, 10, 31, 53);
        initial.set(14, 123);
        Assert.assertEquals((Object)"2014/03/04 10:31:53.123", (Object)this.format(initial.getTimeInMillis()));
        long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
        Calendar expected = Calendar.getInstance();
        expected.set(2014, 2, 4, 10, 31, 54);
        expected.set(14, 0);
        Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNextTimeWeeklyReturnsFirstDayOfNextWeek_FRANCE() {
        Locale old = Locale.getDefault();
        Locale.setDefault(Locale.FRANCE);
        try {
            PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM-W}.log.gz");
            Calendar initial = Calendar.getInstance();
            initial.set(2014, 2, 4, 10, 31, 59);
            long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
            Calendar expected = Calendar.getInstance();
            expected.set(2014, 2, 10, 0, 0, 0);
            expected.set(14, 0);
            Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
        }
        finally {
            Locale.setDefault(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNextTimeWeeklyReturnsFirstDayOfNextWeek_US() {
        Locale old = Locale.getDefault();
        Locale.setDefault(Locale.US);
        try {
            PatternProcessor pp = new PatternProcessor("logs/app-%d{yyyy-MM-W}.log.gz");
            Calendar initial = Calendar.getInstance();
            initial.set(2014, 2, 4, 10, 31, 59);
            long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
            Calendar expected = Calendar.getInstance();
            expected.set(2014, 2, 9, 0, 0, 0);
            expected.set(14, 0);
            Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
        }
        finally {
            Locale.setDefault(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNextTimeWeeklyReturnsFirstWeekInYear_US() {
        Locale old = Locale.getDefault();
        Locale.setDefault(Locale.US);
        try {
            PatternProcessor pp = new PatternProcessor("logs/market_data_msg.log-%d{yyyy-MM-'W'W}");
            Calendar initial = Calendar.getInstance();
            initial.set(2015, 11, 28, 0, 0, 0);
            long actual = pp.getNextTime(initial.getTimeInMillis(), 1, false);
            Calendar expected = Calendar.getInstance();
            expected.set(2016, 0, 3, 0, 0, 0);
            expected.set(14, 0);
            Assert.assertEquals((Object)this.format(expected.getTimeInMillis()), (Object)this.format(actual));
        }
        finally {
            Locale.setDefault(old);
        }
    }
}

