/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.MapRewritePolicy;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.hamcrest.MapMatchers;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.util.StringMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MapRewritePolicyTest {
    private static final StringMap stringMap = ContextDataFactory.createContextData();
    private static Map<String, String> map = new HashMap<String, String>();
    private static KeyValuePair[] rewrite;
    private static LogEvent logEvent0;
    private static LogEvent logEvent1;
    private static LogEvent logEvent2;
    private static LogEvent logEvent3;

    @BeforeClass
    public static void setupClass() {
        stringMap.putValue("test1", (Object)"one");
        stringMap.putValue("test2", (Object)"two");
        map = stringMap.toMap();
        logEvent0 = Log4jLogEvent.newBuilder().setLoggerName("test").setContextData(stringMap).setLoggerFqcn("MapRewritePolicyTest.setupClass()").setLevel(Level.ERROR).setMessage((Message)new SimpleMessage("Test")).setThrown((Throwable)new RuntimeException("test")).setThreadName("none").setSource(new StackTraceElement("MapRewritePolicyTest", "setupClass", "MapRewritePolicyTest", 28)).setTimeMillis(2L).build();
        logEvent1 = ((Log4jLogEvent)logEvent0).asBuilder().setMessage((Message)new StringMapMessage(map)).setSource(new StackTraceElement("MapRewritePolicyTest", "setupClass", "MapRewritePolicyTest", 29)).build();
        MutableThreadContextStack stack = new MutableThreadContextStack(new ArrayList<String>(map.values()));
        logEvent2 = ((Log4jLogEvent)logEvent0).asBuilder().setContextStack((ThreadContext.ContextStack)stack).setMarker(MarkerManager.getMarker((String)"test")).setLevel(Level.TRACE).setMessage((Message)new StructuredDataMessage("test", "Nothing", "test", map)).setTimeMillis(20000000L).setSource(new StackTraceElement("MapRewritePolicyTest", "setupClass", "MapRewritePolicyTest", 30)).build();
        logEvent3 = ((Log4jLogEvent)logEvent0).asBuilder().setContextStack((ThreadContext.ContextStack)stack).setLevel(Level.ALL).setMessage((Message)new StringMapMessage(map)).setTimeMillis(Long.MAX_VALUE).setSource(new StackTraceElement("MapRewritePolicyTest", "setupClass", "MapRewritePolicyTest", 31)).build();
        rewrite = new KeyValuePair[]{new KeyValuePair("test2", "2"), new KeyValuePair("test3", "three")};
    }

    @Test
    public void addTest() {
        MapRewritePolicy addPolicy = MapRewritePolicy.createPolicy((String)"Add", (KeyValuePair[])rewrite);
        LogEvent rewritten = addPolicy.rewrite(logEvent0);
        this.compareLogEvents(logEvent0, rewritten);
        Assert.assertEquals((String)"Simple log message changed", (Object)logEvent0.getMessage(), (Object)rewritten.getMessage());
        rewritten = addPolicy.rewrite(logEvent1);
        this.compareLogEvents(logEvent1, rewritten);
        this.checkAdded(((StringMapMessage)rewritten.getMessage()).getData());
        rewritten = addPolicy.rewrite(logEvent2);
        this.compareLogEvents(logEvent2, rewritten);
        this.checkAdded(((StructuredDataMessage)rewritten.getMessage()).getData());
        rewritten = addPolicy.rewrite(logEvent3);
        this.compareLogEvents(logEvent3, rewritten);
        this.checkAdded(((StringMapMessage)rewritten.getMessage()).getData());
    }

    @Test
    public void updateTest() {
        MapRewritePolicy updatePolicy = MapRewritePolicy.createPolicy((String)"Update", (KeyValuePair[])rewrite);
        LogEvent rewritten = updatePolicy.rewrite(logEvent0);
        this.compareLogEvents(logEvent0, rewritten);
        Assert.assertEquals((String)"Simple log message changed", (Object)logEvent0.getMessage(), (Object)rewritten.getMessage());
        rewritten = updatePolicy.rewrite(logEvent1);
        this.compareLogEvents(logEvent1, rewritten);
        this.checkUpdated(((StringMapMessage)rewritten.getMessage()).getData());
        rewritten = updatePolicy.rewrite(logEvent2);
        this.compareLogEvents(logEvent2, rewritten);
        this.checkUpdated(((StructuredDataMessage)rewritten.getMessage()).getData());
        rewritten = updatePolicy.rewrite(logEvent3);
        this.compareLogEvents(logEvent3, rewritten);
        this.checkUpdated(((StringMapMessage)rewritten.getMessage()).getData());
    }

    @Test
    public void defaultIsAdd() {
        MapRewritePolicy addPolicy = MapRewritePolicy.createPolicy(null, (KeyValuePair[])rewrite);
        LogEvent rewritten = addPolicy.rewrite(logEvent0);
        this.compareLogEvents(logEvent0, rewritten);
        Assert.assertEquals((String)"Simple log message changed", (Object)logEvent0.getMessage(), (Object)rewritten.getMessage());
        rewritten = addPolicy.rewrite(logEvent1);
        this.compareLogEvents(logEvent1, rewritten);
        this.checkAdded(((StringMapMessage)rewritten.getMessage()).getData());
        rewritten = addPolicy.rewrite(logEvent2);
        this.compareLogEvents(logEvent2, rewritten);
        this.checkAdded(((StructuredDataMessage)rewritten.getMessage()).getData());
        rewritten = addPolicy.rewrite(logEvent3);
        this.compareLogEvents(logEvent3, rewritten);
        this.checkAdded(((StringMapMessage)rewritten.getMessage()).getData());
    }

    private void checkAdded(Map<String, String> addedMap) {
        Assert.assertThat((String)"unwanted entry change", addedMap, (Matcher)Matchers.hasEntry((Object)"test1", (Object)"one"));
        Assert.assertThat((String)"existing entry not updated", addedMap, (Matcher)Matchers.hasEntry((Object)"test2", (Object)"2"));
        Assert.assertThat((String)"new entry not added", addedMap, (Matcher)Matchers.hasEntry((Object)"test3", (Object)"three"));
        Assert.assertThat((String)"wrong size", addedMap, MapMatchers.hasSize(3));
    }

    private void checkUpdated(Map<String, String> updatedMap) {
        Assert.assertThat((String)"unwanted entry change", updatedMap, (Matcher)Matchers.hasEntry((Object)"test1", (Object)"one"));
        Assert.assertThat((String)"existing entry not updated", updatedMap, (Matcher)Matchers.hasEntry((Object)"test2", (Object)"2"));
        Assert.assertThat((String)"wrong size", updatedMap, MapMatchers.hasSize(2));
    }

    private void compareLogEvents(LogEvent orig, LogEvent changed) {
        Assert.assertEquals((String)"LoggerName changed", (Object)orig.getLoggerName(), (Object)changed.getLoggerName());
        Assert.assertEquals((String)"Marker changed", (Object)orig.getMarker(), (Object)changed.getMarker());
        Assert.assertEquals((String)"FQCN changed", (Object)orig.getLoggerFqcn(), (Object)changed.getLoggerFqcn());
        Assert.assertEquals((String)"Level changed", (Object)orig.getLevel(), (Object)changed.getLevel());
        Assert.assertArrayEquals((String)"Throwable changed", (Object[])(orig.getThrown() == null ? null : orig.getThrownProxy().getExtendedStackTrace()), changed.getThrown() == null ? null : changed.getThrownProxy().getExtendedStackTrace());
        Assert.assertEquals((String)"ContextMap changed", (Object)orig.getContextMap(), (Object)changed.getContextMap());
        Assert.assertEquals((String)"ContextData changed", (Object)orig.getContextData(), (Object)changed.getContextData());
        Assert.assertEquals((String)"ContextStack changed", (Object)orig.getContextStack(), (Object)changed.getContextStack());
        Assert.assertEquals((String)"ThreadName changed", (Object)orig.getThreadName(), (Object)changed.getThreadName());
        Assert.assertEquals((String)"Source changed", (Object)orig.getSource(), (Object)changed.getSource());
        Assert.assertEquals((String)"Millis changed", (long)orig.getTimeMillis(), (long)changed.getTimeMillis());
    }
}

