/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.Iterator;
import org.apache.logging.dumbster.smtp.SimpleSmtpServer;
import org.apache.logging.dumbster.smtp.SmtpMessage;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.AvailablePortFinder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class SmtpAppenderAsyncTest {
    private static int PORT;
    private SimpleSmtpServer smtpServer;
    @Rule
    public LoggerContextRule ctx = new LoggerContextRule("SmtpAppenderAsyncTest.xml");

    @BeforeClass
    public static void setupClass() {
        PORT = AvailablePortFinder.getNextAvailable();
        System.setProperty("smtp.port", String.valueOf(PORT));
    }

    @Before
    public void setup() {
        this.smtpServer = SimpleSmtpServer.start(PORT);
    }

    @Test
    public void testSync() {
        this.testSmtpAppender(this.ctx.getLogger("sync"));
    }

    @Test
    public void testAsync() {
        this.testSmtpAppender(this.ctx.getLogger("async"));
    }

    private void testSmtpAppender(Logger logger) {
        ThreadContext.put((String)"MDC1", (String)"mdc1");
        logger.error("the message");
        this.ctx.getLoggerContext().stop();
        this.smtpServer.stop();
        Assert.assertEquals((long)1L, (long)this.smtpServer.getReceivedEmailSize());
        Iterator<SmtpMessage> messages = this.smtpServer.getReceivedEmail();
        SmtpMessage email = messages.next();
        Assert.assertEquals((Object)"to@example.com", (Object)email.getHeaderValue("To"));
        Assert.assertEquals((Object)"from@example.com", (Object)email.getHeaderValue("From"));
        Assert.assertEquals((Object)"[mdc1]", (Object)email.getHeaderValue("Subject"));
        String body = email.getBody();
        if (!body.contains("Body:[mdc1]")) {
            Assert.fail((String)body);
        }
    }

    @After
    public void teardown() {
        if (this.smtpServer != null) {
            this.smtpServer.stop();
        }
    }

    @AfterClass
    public static void teardownClass() {
        System.clearProperty("smtp.port");
    }
}

