/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Collection;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.CleanFiles;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RandomAccessFileAppenderTest {
    private final LoggerContextRule init;
    private final CleanFiles files;
    @Rule
    public final RuleChain chain;
    private final File logFile;
    private final boolean locationEnabled;

    @Parameterized.Parameters(name="{0}, locationEnabled={1}, type={2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"RandomAccessFileAppenderTest", false, ".xml"}, {"RandomAccessFileAppenderLocationTest", true, ".xml"}, {"RollingRandomAccessFileAppenderTest", false, ".xml"}, {"RollingRandomAccessFileAppenderLocationTest", true, ".xml"}, {"RollingRandomAccessFileAppenderLocationPropsTest", false, ".properties"});
    }

    public RandomAccessFileAppenderTest(String testName, boolean locationEnabled, String type) {
        this.init = new LoggerContextRule(testName + type);
        this.logFile = new File("target", testName + ".log");
        this.files = new CleanFiles(this.logFile);
        this.locationEnabled = locationEnabled;
        this.chain = RuleChain.outerRule((TestRule)this.files).around((TestRule)this.init);
    }

    @Test
    public void testRandomAccessConfiguration() throws Exception {
        String line;
        Logger logger = this.init.getLogger("com.foo.Bar");
        String message = "This is a test log message brought to you by Slurm.";
        logger.info("This is a test log message brought to you by Slurm.");
        this.init.getLoggerContext().stop();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.logFile));){
            line = reader.readLine();
        }
        Assert.assertNotNull((Object)line);
        Assert.assertThat((Object)line, (Matcher)CoreMatchers.containsString((String)"This is a test log message brought to you by Slurm."));
        Matcher containsLocationInformation = CoreMatchers.containsString((String)"testRandomAccessConfiguration");
        Matcher containsLocationInformationIfEnabled = this.locationEnabled ? containsLocationInformation : CoreMatchers.not((Matcher)containsLocationInformation);
        Assert.assertThat((Object)line, (Matcher)containsLocationInformationIfEnabled);
    }
}

