/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.util.StringBuilders;

public final class TestPatternConverters {
    private TestPatternConverters() {
    }

    @Plugin(name="TestFormatPatternConverter", category="Converter")
    @ConverterKeys(value={"testformat"})
    public static final class TestFormatPatternConverter
    extends LogEventPatternConverter {
        private TestFormatPatternConverter() {
            super("Format", "testformat");
        }

        public static TestFormatPatternConverter newInstance(String[] options) {
            return new TestFormatPatternConverter();
        }

        public void format(LogEvent event, StringBuilder toAppendTo) {
            toAppendTo.append(event.getMessage().getFormat());
        }
    }

    @Plugin(name="TestParametersPatternConverter", category="Converter")
    @ConverterKeys(value={"testparameters"})
    public static final class TestParametersPatternConverter
    extends LogEventPatternConverter {
        private TestParametersPatternConverter() {
            super("Parameters", "testparameters");
        }

        public static TestParametersPatternConverter newInstance(String[] options) {
            return new TestParametersPatternConverter();
        }

        public void format(LogEvent event, StringBuilder toAppendTo) {
            toAppendTo.append('[');
            Object[] parameters = event.getMessage().getParameters();
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    StringBuilders.appendValue((StringBuilder)toAppendTo, (Object)parameters[i]);
                    if (i == parameters.length - 1) continue;
                    toAppendTo.append(',');
                }
            }
            toAppendTo.append(']');
        }
    }
}

