/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.io.File;
import java.net.URI;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LateConfigTest {
    private static final String CONFIG = "target/test-classes/log4j-test1.xml";
    private static LoggerContext context;

    @BeforeClass
    public static void setupClass() {
        context = LoggerContext.getContext((boolean)false);
    }

    @AfterClass
    public static void tearDownClass() {
        Configurator.shutdown((LoggerContext)context);
        StatusLogger.getLogger().reset();
    }

    @Test
    public void testReconfiguration() throws Exception {
        Configuration cfg = context.getConfiguration();
        Assert.assertNotNull((String)"No configuration", (Object)cfg);
        Assert.assertTrue((String)"Not set to default configuration", (boolean)(cfg instanceof DefaultConfiguration));
        File file = new File(CONFIG);
        LoggerContext loggerContext = LoggerContext.getContext(null, (boolean)false, (URI)file.toURI());
        Assert.assertNotNull((String)"No Logger Context", (Object)loggerContext);
        Configuration newConfig = loggerContext.getConfiguration();
        Assert.assertTrue((String)"Configuration not reset", (cfg != newConfig ? 1 : 0) != 0);
        Assert.assertTrue((String)"Reconfiguration failed", (boolean)(newConfig instanceof XmlConfiguration));
        context = LoggerContext.getContext((boolean)false);
        Configuration sameConfig = context.getConfiguration();
        Assert.assertTrue((String)"Configuration should not have been reset", (newConfig == sameConfig ? 1 : 0) != 0);
    }
}

