/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.ExtendedLevels;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class ExtendedLevelTest {
    private static final String CONFIG = "log4j-customLevel.xml";
    private ListAppender list1;
    private ListAppender list2;
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-customLevel.xml");

    @Before
    public void before() {
        this.list1 = context.getListAppender("List1").clear();
        this.list2 = context.getListAppender("List2").clear();
    }

    @Test
    public void testLevelLogging() {
        Logger logger = context.getLogger("org.apache.logging.log4j.test1");
        logger.log(ExtendedLevels.DETAIL, "Detail message");
        logger.log(Level.DEBUG, "Debug message");
        List<LogEvent> events = this.list1.getEvents();
        Assert.assertNotNull((String)"No events", events);
        Assert.assertThat(events, (Matcher)Matchers.hasSize((int)1));
        LogEvent event = events.get(0);
        Assert.assertEquals((String)("Expected level DETAIL, got" + event.getLevel()), (Object)"DETAIL", (Object)event.getLevel().name());
        logger = context.getLogger("org.apache.logging.log4j.test2");
        logger.log(ExtendedLevels.NOTE, "Note message");
        logger.log(Level.INFO, "Info message");
        events = this.list2.getEvents();
        Assert.assertNotNull((String)"No events", events);
        Assert.assertThat(events, (Matcher)Matchers.hasSize((int)1));
        event = events.get(0);
        Assert.assertEquals((String)("Expected level NOTE, got" + event.getLevel()), (Object)"NOTE", (Object)event.getLevel().name());
    }
}

