/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class CustomLevelsWithFiltersTest {
    private static final String CONFIG = "log4j-customLevelsWithFilters.xml";
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-customLevelsWithFilters.xml");
    private Level infom1Level;
    private Level infop1Level;

    @Before
    public void before() {
        this.infom1Level = Level.getLevel((String)"INFOM1");
        this.infop1Level = Level.getLevel((String)"INFOP1");
    }

    @Test
    public void testConfiguration() {
        Configuration configuration = context.getConfiguration();
        Assert.assertNotNull((Object)configuration);
        FileAppender appender = (FileAppender)configuration.getAppender("info");
        Assert.assertNotNull((Object)appender);
        CompositeFilter compFilter = (CompositeFilter)appender.getFilter();
        Assert.assertNotNull((Object)compFilter);
        Filter[] filters = compFilter.getFiltersArray();
        Assert.assertNotNull((Object)filters);
        boolean foundLevel = false;
        for (Filter filter : filters) {
            ThresholdFilter tFilter = (ThresholdFilter)filter;
            if (!this.infom1Level.equals((Object)tFilter.getLevel())) continue;
            foundLevel = true;
            break;
        }
        Assert.assertTrue((String)("Level not found: " + this.infom1Level), (boolean)foundLevel);
    }

    @Test
    public void testCustomLevelInts() {
        Assert.assertEquals((long)399L, (long)this.infom1Level.intLevel());
        Assert.assertEquals((long)401L, (long)this.infop1Level.intLevel());
    }

    @Test
    public void testCustomLevelPresence() {
        Assert.assertNotNull((Object)this.infom1Level);
        Assert.assertNotNull((Object)this.infop1Level);
    }
}

