/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.importer;

import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.logging.log4j.changelog.ChangelogEntry;
import org.apache.logging.log4j.changelog.ChangelogFiles;
import org.apache.logging.log4j.changelog.ChangelogRelease;
import org.apache.logging.log4j.changelog.importer.MavenChanges;
import org.apache.logging.log4j.changelog.importer.MavenChangesImporterArgs;
import org.apache.logging.log4j.changelog.util.StringUtils;

public final class MavenChangesImporter {
    private MavenChangesImporter() {
    }

    public static void performImport(MavenChangesImporterArgs args) {
        MavenChanges mavenChanges = MavenChanges.readFromFile(args.changesXmlFile);
        mavenChanges.releases.forEach(release -> {
            if ("TBD".equals(release.date)) {
                MavenChangesImporter.writeUnreleased(args.changelogDirectory, args.releaseVersionMajor, release);
            } else {
                MavenChangesImporter.writeReleased(args.changelogDirectory, release);
            }
        });
    }

    private static void writeUnreleased(Path changelogDirectory, int releaseVersionMajor, MavenChanges.Release release) {
        Path releaseDirectory = ChangelogFiles.unreleasedDirectory(changelogDirectory, releaseVersionMajor);
        release.actions.forEach(action -> MavenChangesImporter.writeAction(releaseDirectory, action));
    }

    private static void writeReleased(Path changelogDirectory, MavenChanges.Release release) {
        Path releaseDirectory = ChangelogFiles.releaseDirectory(changelogDirectory, release.version);
        Path releaseFile = ChangelogFiles.releaseXmlFile(releaseDirectory);
        ChangelogRelease changelogRelease = new ChangelogRelease(release.version, release.date);
        changelogRelease.writeToXmlFile(releaseFile);
        release.actions.forEach(action -> MavenChangesImporter.writeAction(releaseDirectory, action));
    }

    private static void writeAction(Path releaseDirectory, MavenChanges.Action action) {
        ChangelogEntry changelogEntry = MavenChangesImporter.changelogEntry(action);
        String changelogEntryFilename = MavenChangesImporter.changelogEntryFilename(action);
        Path changelogEntryFile = releaseDirectory.resolve(changelogEntryFilename);
        changelogEntry.writeToXmlFile(changelogEntryFile);
    }

    private static String changelogEntryFilename(MavenChanges.Action action) {
        String sanitizedDescription;
        StringBuilder actionRelativeFileBuilder = new StringBuilder();
        if (action.issue != null) {
            actionRelativeFileBuilder.append(action.issue).append('_');
        }
        String shortenedSanitizedDescription = (sanitizedDescription = action.description.replaceAll("[^A-Za-z0-9]", "_").replaceAll("_+", "_").replaceAll("^[^A-Za-z0-9]*", "").replaceAll("[^A-Za-z0-9]*$", "")).length() > 60 ? sanitizedDescription.substring(0, 60) : sanitizedDescription;
        actionRelativeFileBuilder.append(shortenedSanitizedDescription);
        actionRelativeFileBuilder.append(".xml");
        return actionRelativeFileBuilder.toString();
    }

    private static ChangelogEntry changelogEntry(MavenChanges.Action action) {
        ChangelogEntry.Type type = MavenChangesImporter.changelogType(action.type);
        ArrayList<ChangelogEntry.Issue> issues = new ArrayList<ChangelogEntry.Issue>(1);
        if (action.issue != null) {
            String issueLink = String.format("https://issues.apache.org/jira/browse/%s", action.issue);
            ChangelogEntry.Issue issue = new ChangelogEntry.Issue(action.issue, issueLink);
            issues.add(issue);
        }
        ArrayList<ChangelogEntry.Author> authors = new ArrayList<ChangelogEntry.Author>(2);
        for (String authorId : action.dev.split("\\s*,\\s*")) {
            if (StringUtils.isBlank(authorId)) continue;
            authors.add(new ChangelogEntry.Author(authorId, null));
        }
        if (action.dueTo != null) {
            authors.add(new ChangelogEntry.Author(null, action.dueTo));
        }
        ChangelogEntry.Description description = new ChangelogEntry.Description("asciidoc", action.description);
        return new ChangelogEntry(type, issues, authors, description);
    }

    private static ChangelogEntry.Type changelogType(MavenChanges.Action.Type type) {
        if (MavenChanges.Action.Type.ADD.equals((Object)type)) {
            return ChangelogEntry.Type.ADDED;
        }
        if (MavenChanges.Action.Type.FIX.equals((Object)type)) {
            return ChangelogEntry.Type.FIXED;
        }
        if (MavenChanges.Action.Type.REMOVE.equals((Object)type)) {
            return ChangelogEntry.Type.REMOVED;
        }
        return ChangelogEntry.Type.CHANGED;
    }
}

