/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.rest;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.audit.request.RequestContextMapping;
import org.apache.logging.log4j.audit.request.RequestContextMappings;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RequestContextHeaderInterceptor
implements ClientHttpRequestInterceptor {
    private RequestContextMappings mappings = null;

    public RequestContextHeaderInterceptor(RequestContextMappings mappings) {
        this.mappings = mappings;
    }

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] body, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        Map map = ThreadContext.getImmutableContext();
        HttpHeaders headers = httpRequest.getHeaders();
        for (Map.Entry entry : map.entrySet()) {
            String key;
            RequestContextMapping mapping = this.mappings.getMapping((String)entry.getKey());
            if (mapping == null || mapping.isLocal() || headers.containsKey((Object)(key = this.mappings.getHeaderPrefix() + mapping.getFieldName()))) continue;
            headers.add(key, (String)entry.getValue());
        }
        return clientHttpRequestExecution.execute(httpRequest, body);
    }
}

