/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TStatus;
import org.apache.kyuubi.util.reflect.DynConstructors;

public class KyuubiSQLException
extends SQLException {
    public KyuubiSQLException() {
    }

    public KyuubiSQLException(String reason) {
        super(reason);
    }

    public KyuubiSQLException(Throwable cause) {
        super(cause);
    }

    public KyuubiSQLException(String reason, String sqlState) {
        super(reason, sqlState);
    }

    public KyuubiSQLException(String reason, Throwable cause) {
        super(reason, cause);
    }

    public KyuubiSQLException(String reason, String sqlState, int vendorCode) {
        super(reason, sqlState, vendorCode);
    }

    public KyuubiSQLException(String reason, String sqlState, Throwable cause) {
        super(reason, sqlState, cause);
    }

    public KyuubiSQLException(String reason, String sqlState, int vendorCode, Throwable cause) {
        super(reason, sqlState, vendorCode, cause);
    }

    public KyuubiSQLException(TStatus status) {
        super(status.getErrorMessage(), status.getSqlState(), status.getErrorCode());
        if (status.getInfoMessages() != null) {
            this.initCause(KyuubiSQLException.toCause(status.getInfoMessages()));
        }
    }

    public static List<String> toString(Throwable ex) {
        return KyuubiSQLException.toString(ex, null);
    }

    private static List<String> toString(Throwable cause, StackTraceElement[] parent) {
        StackTraceElement[] trace = cause.getStackTrace();
        int m = trace.length - 1;
        if (parent != null) {
            for (int n = parent.length - 1; m >= 0 && n >= 0 && trace[m].equals(parent[n]); --m, --n) {
            }
        }
        List<String> detail = KyuubiSQLException.enroll(cause, trace, m);
        if ((cause = cause.getCause()) != null) {
            detail.addAll(KyuubiSQLException.toString(cause, trace));
        }
        return detail;
    }

    private static List<String> enroll(Throwable ex, StackTraceElement[] trace, int max) {
        ArrayList<String> details = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append('*').append(ex.getClass().getName()).append(':');
        builder.append(ex.getMessage()).append(':');
        builder.append(trace.length).append(':').append(max);
        details.add(builder.toString());
        for (int i = 0; i <= max; ++i) {
            builder.setLength(0);
            builder.append(trace[i].getClassName()).append(':');
            builder.append(trace[i].getMethodName()).append(':');
            String fileName = trace[i].getFileName();
            builder.append(fileName == null ? "" : fileName).append(':');
            builder.append(trace[i].getLineNumber());
            details.add(builder.toString());
        }
        return details;
    }

    public static Throwable toCause(List<String> details) {
        return KyuubiSQLException.toStackTrace(details, null, 0);
    }

    private static Throwable toStackTrace(List<String> details, StackTraceElement[] parent, int index) {
        int i;
        String detail;
        if (!(detail = details.get(index++)).startsWith("*")) {
            return null;
        }
        int i1 = detail.indexOf(58);
        int i3 = detail.lastIndexOf(58);
        int i2 = detail.substring(0, i3).lastIndexOf(58);
        String exceptionClass = detail.substring(1, i1);
        String exceptionMessage = detail.substring(i1 + 1, i2);
        Throwable ex = KyuubiSQLException.newInstance(exceptionClass, exceptionMessage);
        int length = Integer.parseInt(detail.substring(i2 + 1, i3));
        int unique = Integer.parseInt(detail.substring(i3 + 1));
        StackTraceElement[] trace = new StackTraceElement[length];
        for (i = 0; i <= unique; ++i) {
            detail = details.get(index++);
            int j1 = detail.indexOf(58);
            int j3 = detail.lastIndexOf(58);
            int j2 = detail.substring(0, j3).lastIndexOf(58);
            String className = detail.substring(0, j1);
            String methodName = detail.substring(j1 + 1, j2);
            String fileName = detail.substring(j2 + 1, j3);
            if (fileName.isEmpty()) {
                fileName = null;
            }
            int lineNumber = Integer.parseInt(detail.substring(j3 + 1));
            trace[i] = new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        int common = trace.length - i;
        if (common > 0) {
            System.arraycopy(parent, parent.length - common, trace, trace.length - common, common);
        }
        if (details.size() > index) {
            ex.initCause(KyuubiSQLException.toStackTrace(details, trace, index));
        }
        ex.setStackTrace(trace);
        return ex;
    }

    private static Throwable newInstance(String className, String message) {
        try {
            return (Throwable)DynConstructors.builder().impl(className, new Class[]{String.class}).buildChecked().newInstance(new Object[]{message});
        }
        catch (Exception e) {
            return new RuntimeException(className + ":" + message);
        }
    }
}

