/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.deploy.yarn;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.util.Records;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.deploy.yarn.ApplicationMaster$;
import org.apache.kyuubi.engine.deploy.yarn.EngineYarnModeSubmitter$;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tUh!\u0002\"D\u0003\u0003\u0001\u0006\"B.\u0001\t\u0003a\u0006bB0\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007Y\u0002\u0001\u000b\u0011B1\t\u000f5\u0004!\u0019!C\u0001]\"1a\u000f\u0001Q\u0001\n=Dqa\u001e\u0001C\u0002\u0013\u0005a\u000e\u0003\u0004y\u0001\u0001\u0006Ia\u001c\u0005\bs\u0002\u0011\r\u0011\"\u0001o\u0011\u0019Q\b\u0001)A\u0005_\"91\u0010\u0001b\u0001\n\u0003q\u0007B\u0002?\u0001A\u0003%q\u000eC\u0004~\u0001\t\u0007I\u0011\u0001@\t\u000f\u0005M\u0001\u0001)A\u0005\u007f\"A\u0011Q\u0003\u0001C\u0002\u0013%\u0001\rC\u0004\u0002\u0018\u0001\u0001\u000b\u0011B1\t\u0017\u0005e\u0001\u00011AA\u0002\u0013%\u00111\u0004\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0004C\u0006\u0002>\u0001\u0001\r\u0011!Q!\n\u0005u\u0001bCA$\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013B1\"!\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\\!Y\u0011q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA&\u00111\t\t\u0007\u0001a\u0001\u0002\u0004%\taRA2\u00111\ti\u0007\u0001a\u0001\u0002\u0004%\taRA8\u0011-\t\u0019\b\u0001a\u0001\u0002\u0003\u0006K!!\u001a\t\u0013\u0005U\u0004A1A\u0005\u0002\u0005]\u0004\u0002CAC\u0001\u0001\u0006I!!\u001f\t\u0017\u0005\u001d\u0005\u00011AA\u0002\u0013\u0005\u0011\u0011\u0012\u0005\f\u0003/\u0003\u0001\u0019!a\u0001\n\u0003\tI\nC\u0006\u0002\u001e\u0002\u0001\r\u0011!Q!\n\u0005-\u0005bCAP\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0013C1\"!)\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002$\"Y\u0011q\u0015\u0001A\u0002\u0003\u0005\u000b\u0015BAF\u0011!\tI\u000b\u0001a\u0001\u000e\u0003\u0001\u0007\"CAV\u0001\u0001\u0007i\u0011AAW\u0011\u001d\t\t\f\u0001D\u0001\u0003gCq!!.\u0001\t\u0003\t9\fC\u0004\u0002X\u0002!\t\"!7\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bb\u0002B\u0005\u0001\u0011%!1\u0002\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0005;AqAa\t\u0001\t\u0013\u0011)\u0003\u0003\u0005\u0003<\u0001!\t!\u0013B\u001f\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqA!\u0017\u0001\t\u0013\u0011Y\u0006C\u0004\u0003`\u0001!I!!7\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d!9!q\u000e\u0001\u0005\n\tE\u0004b\u0002B=\u0001\u0011%!1\u0010\u0005\b\u0005\u0017\u0003A\u0011\u0001BG\u0011\u001d\u00119\u000b\u0001C\u0001\u0005S;qA!-D\u0011\u0003\u0011\u0019L\u0002\u0004C\u0007\"\u0005!Q\u0017\u0005\u00077Z\"\tAa.\t\u0013\tefG1A\u0005\u0006\tm\u0006\u0002\u0003Bbm\u0001\u0006iA!0\t\u0013\t\u0015gG1A\u0005\u0006\t\u001d\u0007\u0002\u0003Bhm\u0001\u0006iA!3\t\u0013\tEgG1A\u0005\u0006\tM\u0007\u0002\u0003Bnm\u0001\u0006iA!6\t\u0013\tugG1A\u0005\u0006\t}\u0007\u0002\u0003Btm\u0001\u0006iA!9\t\u0013\t%hG1A\u0005\u0006\t-\b\u0002\u0003Bzm\u0001\u0006iA!<\u0003/\u0015sw-\u001b8f3\u0006\u0014h.T8eKN+(-\\5ui\u0016\u0014(B\u0001#F\u0003\u0011I\u0018M\u001d8\u000b\u0005\u0019;\u0015A\u00023fa2|\u0017P\u0003\u0002I\u0013\u00061QM\\4j]\u0016T!AS&\u0002\r-LX/\u001e2j\u0015\taU*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0006\u0019qN]4\u0004\u0001M\u0019\u0001!U,\u0011\u0005I+V\"A*\u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0003\r\u0005s\u0017PU3g!\tA\u0016,D\u0001J\u0013\tQ\u0016JA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005i\u0006C\u00010\u0001\u001b\u0005\u0019\u0015!F&Z+V\u0013\u0015jX#O\u000f&sUiX*U\u0003\u001eKejR\u000b\u0002CB\u0011!-\u001b\b\u0003G\u001e\u0004\"\u0001Z*\u000e\u0003\u0015T!AZ(\u0002\rq\u0012xn\u001c;?\u0013\tA7+\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u00015T\u0003YY\u0015,V+C\u0013~+ejR%O\u000b~\u001bF+Q$J\u001d\u001e\u0003\u0013!\u0005'P\u0007\u0006c\u0015JW#E?2K%i\u0018#J%V\tq\u000e\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006!A.\u00198h\u0015\u0005!\u0018\u0001\u00026bm\u0006L!A[9\u0002%1{5)\u0011'J5\u0016#u\fT%C?\u0012K%\u000bI\u0001\u0013\u0019>\u001b\u0015\tT%[\u000b\u0012{6i\u0014(G?\u0012K%+A\nM\u001f\u000e\u000bE*\u0013.F\t~\u001buJ\u0014$`\t&\u0013\u0006%A\bI\u0003\u0012{u\nU0D\u001f:3u\fR%S\u0003AA\u0015\tR(P!~\u001buJ\u0014$`\t&\u0013\u0006%\u0001\tL3V+&)S0D\u001f:3uLR%M\u000b\u0006\t2*W+V\u0005&{6i\u0014(G?\u001aKE*\u0012\u0011\u0002-M#\u0016iR%O\u000f~#\u0015JU0Q\u000bJk\u0015jU*J\u001f:+\u0012a \t\u0005\u0003\u0003\ty!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003)\u0001XM]7jgNLwN\u001c\u0006\u0005\u0003\u0013\tY!\u0001\u0002gg*\u0019\u0011QB&\u0002\r!\fGm\\8q\u0013\u0011\t\t\"a\u0001\u0003\u0019\u0019\u001b\b+\u001a:nSN\u001c\u0018n\u001c8\u0002/M#\u0016iR%O\u000f~#\u0015JU0Q\u000bJk\u0015jU*J\u001f:\u0003\u0013!E1qa2L7-\u0019;j_:l\u0015m\u001d;fe\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\u001b\u0006\u001cH/\u001a:!\u0003)I\u0018M\u001d8DY&,g\u000e^\u000b\u0003\u0003;\u0001B!a\b\u0002,5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#A\u0002ba&TA!a\n\u0002*\u000511\r\\5f]RT1\u0001RA\u0006\u0013\u0011\ti#!\t\u0003\u0015e\u000b'O\\\"mS\u0016tG/\u0001\bzCJt7\t\\5f]R|F%Z9\u0015\t\u0005M\u0012\u0011\b\t\u0004%\u0006U\u0012bAA\u001c'\n!QK\\5u\u0011%\tY$EA\u0001\u0002\u0004\ti\"A\u0002yIE\n1\"_1s]\u000ec\u0017.\u001a8uA!\u001a!#!\u0011\u0011\u0007I\u000b\u0019%C\u0002\u0002FM\u0013\u0001B^8mCRLG.Z\u0001\u0006CB\u0004\u0018\nZ\u000b\u0003\u0003\u0017\u0002B!!\u0014\u0002V5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&A\u0004sK\u000e|'\u000fZ:\u000b\t\u0005\r\u0012\u0011F\u0005\u0005\u0003/\nyEA\u0007BaBd\u0017nY1uS>t\u0017\nZ\u0001\nCB\u0004\u0018\nZ0%KF$B!a\r\u0002^!I\u00111\b\u000b\u0002\u0002\u0003\u0007\u00111J\u0001\u0007CB\u0004\u0018\n\u001a\u0011\u0002\u001dM$\u0018mZ5oO\u0012K'\u000fU1uQV\u0011\u0011Q\r\t\u0005\u0003O\nI'\u0004\u0002\u0002\b%!\u00111NA\u0004\u0005\u0011\u0001\u0016\r\u001e5\u0002%M$\u0018mZ5oO\u0012K'\u000fU1uQ~#S-\u001d\u000b\u0005\u0003g\t\t\bC\u0005\u0002<]\t\t\u00111\u0001\u0002f\u0005y1\u000f^1hS:<G)\u001b:QCRD\u0007%\u0001\u0006lsV,(-[\"p]\u001a,\"!!\u001f\u0011\t\u0005m\u0014\u0011Q\u0007\u0003\u0003{R1!a J\u0003\u0019\u0019wN\u001c4jO&!\u00111QA?\u0005)Y\u00150^;cS\u000e{gNZ\u0001\fWf,XOY5D_:4\u0007%\u0001\u0005zCJt7i\u001c8g+\t\tY\t\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\u0011\t\t*a\u0003\u0002\t\r|gNZ\u0005\u0005\u0003+\u000byIA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\rs\u0006\u0014hnQ8oM~#S-\u001d\u000b\u0005\u0003g\tY\nC\u0005\u0002<q\t\t\u00111\u0001\u0002\f\u0006I\u00110\u0019:o\u0007>tg\rI\u0001\u000bQ\u0006$wn\u001c9D_:4\u0017A\u00045bI>|\u0007oQ8oM~#S-\u001d\u000b\u0005\u0003g\t)\u000bC\u0005\u0002<}\t\t\u00111\u0001\u0002\f\u0006Y\u0001.\u00193p_B\u001cuN\u001c4!\u0003))gnZ5oKRK\b/Z\u0001\u000fK:<\u0017N\\3UsB,w\fJ3r)\u0011\t\u0019$a,\t\u0011\u0005m\"%!AA\u0002\u0005\fq\"\u001a8hS:,W*Y5o\u00072\f7o\u001d\u000b\u0002C\u0006yQM\\4j]\u0016,\u0005\u0010\u001e:b\u0015\u0006\u00148\u000f\u0006\u0002\u0002:B1\u00111XAc\u0003\u0017tA!!0\u0002B:\u0019A-a0\n\u0003QK1!a1T\u0003\u001d\u0001\u0018mY6bO\u0016LA!a2\u0002J\n\u00191+Z9\u000b\u0007\u0005\r7\u000b\u0005\u0003\u0002N\u0006MWBAAh\u0015\r\t\tn]\u0001\u0003S>LA!!6\u0002P\n!a)\u001b7f\u0003E\u0019XOY7ji\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0003\u0003g\tAd\u0019:fCR,7i\u001c8uC&tWM\u001d'bk:\u001c\u0007nQ8oi\u0016DH\u000f\u0006\u0002\u0002`B!\u0011QJAq\u0013\u0011\t\u0019/a\u0014\u0003-\r{g\u000e^1j]\u0016\u0014H*Y;oG\"\u001cuN\u001c;fqR\fQ\u0003\u001d:fa\u0006\u0014X\rT8dC2\u0014Vm]8ve\u000e,7\u000f\u0006\u0004\u0002j\u0006}(1\u0001\t\b\u0003W\f)0YA}\u001b\t\tiO\u0003\u0003\u0002p\u0006E\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003g\u001c\u0016AC2pY2,7\r^5p]&!\u0011q_Aw\u0005\u001dA\u0015m\u001d5NCB\u0004B!!\u0014\u0002|&!\u0011Q`A(\u00055aunY1m%\u0016\u001cx.\u001e:dK\"9!\u0011A\u0014A\u0002\u0005\u0015\u0014a\u00023fgR$\u0015N\u001d\u0005\b\u0005\u000b9\u0003\u0019\u0001B\u0004\u0003\r)gN\u001e\t\u0007\u0003W\f)0Y1\u0002\u001d\u0011L7\u000f\u001e:jEV$XMS1sgR1\u00111\u0007B\u0007\u0005#AqAa\u0004)\u0001\u0004\tI/\u0001\bm_\u000e\fGNU3t_V\u00148-Z:\t\u000f\t\u0015\u0001\u00061\u0001\u0003\b\u0005qA-[:ue&\u0014W\u000f^3D_:4GCBA\u001a\u0005/\u0011I\u0002C\u0004\u0003\u0010%\u0002\r!!;\t\u000f\t\u0015\u0011\u00061\u0001\u0003\b\u0005\tB.[:u\t&\u001cH/\u001b8di\u001aKG.Z:\u0015\t\u0005e&q\u0004\u0005\u0007\u0005CQ\u0003\u0019A1\u0002\u000f\u0005\u00148\r[5wK\u0006QA-[:ue&\u0014W\u000f^3\u0015\u0015\u0005M\"q\u0005B\u0016\u0005k\u0011I\u0004C\u0004\u0003*-\u0002\r!!\u001a\u0002\u000fM\u00148\rU1uQ\"9!QF\u0016A\u0002\t=\u0012a\u0002:fgRK\b/\u001a\t\u0005\u0003\u001b\u0012\t$\u0003\u0003\u00034\u0005=#!\u0005'pG\u0006d'+Z:pkJ\u001cW\rV=qK\"1!qG\u0016A\u0002\u0005\f\u0001\u0002Z3ti:\u000bW.\u001a\u0005\b\u0005\u001fY\u0003\u0019AAu\u00039\u0019X\r^;q\u0019\u0006,hn\u00195F]Z$BAa\u0002\u0003@!9\u0011Q\u000f\u0017A\u0002\u0005e\u0014AI2sK\u0006$X-\u00119qY&\u001c\u0017\r^5p]N+(-\\5tg&|gnQ8oi\u0016DH\u000f\u0006\u0004\u0003F\t-#Q\u000b\t\u0005\u0003\u001b\u00129%\u0003\u0003\u0003J\u0005=#\u0001H!qa2L7-\u0019;j_:\u001cVOY7jgNLwN\\\"p]R,\u0007\u0010\u001e\u0005\b\u0005\u001bj\u0003\u0019\u0001B(\u0003\u0019qWm^!qaB!\u0011q\u0004B)\u0013\u0011\u0011\u0019&!\t\u0003+e\u000b'O\\\"mS\u0016tG/\u00119qY&\u001c\u0017\r^5p]\"9!qK\u0017A\u0002\u0005}\u0017\u0001E2p]R\f\u0017N\\3s\u0007>tG/\u001a=u\u0003IiwN\\5u_J\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\u0015\t\u0005M\"Q\f\u0005\b\u0003\u000fr\u0003\u0019AA&\u0003E\u0019G.Z1okB\u001cF/Y4j]\u001e$\u0015N]\u0001\nEVLG\u000e\u001a)bi\"$2!\u0019B3\u0011\u001d\u00119\u0007\ra\u0001\u0005S\n!bY8na>tWM\u001c;t!\u0011\u0011&1N1\n\u0007\t54K\u0001\u0006=e\u0016\u0004X-\u0019;fIz\n\u0011#\u00193e\u00072\f7o\u001d9bi\",e\u000e\u001e:z)\u0019\t\u0019Da\u001d\u0003x!1!QO\u0019A\u0002\u0005\fA\u0001]1uQ\"9!QA\u0019A\u0002\t\u001d\u0011\u0001E2p]\u001a$v\u000e\u0015:pa\u0016\u0014H/[3t)\u0011\u0011iH!#\u0011\t\t}$QQ\u0007\u0003\u0005\u0003S1Aa!t\u0003\u0011)H/\u001b7\n\t\t\u001d%\u0011\u0011\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBAIe\u0001\u0007\u0011\u0011P\u0001\u0019oJLG/\u001a)s_B,'\u000f^5fgR{\u0017I]2iSZ,G\u0003CA\u001a\u0005\u001f\u0013\u0019Ja&\t\u000f\tE5\u00071\u0001\u0003~\u0005)\u0001O]8qg\"1!QS\u001aA\u0002\u0005\fAA\\1nK\"9!\u0011T\u001aA\u0002\tm\u0015aA8viB!!Q\u0014BR\u001b\t\u0011yJ\u0003\u0003\u0003\"\n\u0005\u0015a\u0001>ja&!!Q\u0015BP\u0005=Q\u0016\u000e](viB,Ho\u0015;sK\u0006l\u0017aG<sSR,7i\u001c8gS\u001e,(/\u0019;j_:$v.\u0011:dQ&4X\r\u0006\u0005\u00024\t-&Q\u0016BX\u0011\u001d\t\t\n\u000ea\u0001\u0003\u0017CaA!&5\u0001\u0004\t\u0007b\u0002BMi\u0001\u0007!1T\u0001\u0018\u000b:<\u0017N\\3ZCJtWj\u001c3f'V\u0014W.\u001b;uKJ\u0004\"A\u0018\u001c\u0014\u0005Y\nFC\u0001BZ\u0003\u001dZ\u0015,V+C\u0013~+ejR%O\u000b~#U\t\u0015'P3~K\u0016I\u0015(`\u001b>#Ui\u0018&B%N{6*R-\u0016\u0005\tuvB\u0001B`C\t\u0011\t-A\u0012lsV,(-\u001b\u0018f]\u001eLg.\u001a\u0018eKBdw.\u001f\u0018zCJtg&\\8eK:R\u0017M]:\u0002Q-KV+\u0016\"J?\u0016su)\u0013(F?\u0012+\u0005\u000bT(Z?f\u000b%KT0N\u001f\u0012+uLS!S'~[U)\u0017\u0011\u0002Y-KV+\u0016\"J?\u0016su)\u0013(F?\u0012+\u0005\u000bT(Z?f\u000b%KT0N\u001f\u0012+u\fS%W\u000b~\u001buJ\u0014$`\u0017\u0016KVC\u0001Be\u001f\t\u0011Y-\t\u0002\u0003N\u000693._;vE&tSM\\4j]\u0016tC-\u001a9m_ft\u00130\u0019:o]5|G-\u001a\u0018iSZ,7i\u001c8g\u00035Z\u0015,V+C\u0013~+ejR%O\u000b~#U\t\u0015'P3~K\u0016I\u0015(`\u001b>#Ui\u0018%J-\u0016{6i\u0014(G?.+\u0015\fI\u0001/\u0017f+VKQ%`\u000b:;\u0015JT#`\t\u0016\u0003FjT-`3\u0006\u0013fjX'P\t\u0016{\u0006*\u0011#P\u001fB{6i\u0014(G?.+\u0015,\u0006\u0002\u0003V>\u0011!q[\u0011\u0003\u00053\f\u0011f[=vk\nLg&\u001a8hS:,g\u0006Z3qY>Lh&_1s]:jw\u000eZ3/Q\u0006$wn\u001c9D_:4\u0017aL&Z+V\u0013\u0015jX#O\u000f&sUi\u0018#F!2{\u0015lX-B%:{Vj\u0014#F?\"\u000bEiT(Q?\u000e{eJR0L\u000bf\u0003\u0013\u0001L&Z+V\u0013\u0015jX#O\u000f&sUi\u0018#F!2{\u0015lX-B%:{Vj\u0014#F?f\u000b%KT0D\u001f:3ulS#Z+\t\u0011\to\u0004\u0002\u0003d\u0006\u0012!Q]\u0001(Wf,XOY5/K:<\u0017N\\3/I\u0016\u0004Hn\\=/s\u0006\u0014hNL7pI\u0016t\u00130\u0019:o\u0007>tg-A\u0017L3V+&)S0F\u001d\u001eKe*R0E\u000bBcu*W0Z\u0003Jsu,T(E\u000b~K\u0016I\u0015(`\u0007>seiX&F3\u0002\n\u0001gS-V+\nKu,\u0012(H\u0013:+u\fR#Q\u0019>Kv,W!S\u001d~ku\nR#`\u0003J\u001b\u0005*\u0013,F?N+\u0005+\u0011*B)>\u0013VC\u0001Bw\u001f\t\u0011y/\t\u0002\u0003r\u0006\tA&A\u0019L3V+&)S0F\u001d\u001eKe*R0E\u000bBcu*W0Z\u0003Jsu,T(E\u000b~\u000b%k\u0011%J-\u0016{6+\u0012)B%\u0006#vJ\u0015\u0011")
public abstract class EngineYarnModeSubmitter
implements Logging {
    private final String KYUUBI_ENGINE_STAGING;
    private final String LOCALIZED_LIB_DIR;
    private final String LOCALIZED_CONF_DIR;
    private final String HADOOP_CONF_DIR;
    private final String KYUUBI_CONF_FILE;
    private final FsPermission STAGING_DIR_PERMISSION;
    private final String applicationMaster;
    private volatile YarnClient yarnClient;
    private ApplicationId appId;
    private Path stagingDirPath;
    private final KyuubiConf kyuubiConf;
    private Configuration yarnConf;
    private Configuration hadoopConf;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static String KYUUBI_ENGINE_DEPLOY_YARN_MODE_ARCHIVE_SEPARATOR() {
        return EngineYarnModeSubmitter$.MODULE$.KYUUBI_ENGINE_DEPLOY_YARN_MODE_ARCHIVE_SEPARATOR();
    }

    public static String KYUUBI_ENGINE_DEPLOY_YARN_MODE_YARN_CONF_KEY() {
        return EngineYarnModeSubmitter$.MODULE$.KYUUBI_ENGINE_DEPLOY_YARN_MODE_YARN_CONF_KEY();
    }

    public static String KYUUBI_ENGINE_DEPLOY_YARN_MODE_HADOOP_CONF_KEY() {
        return EngineYarnModeSubmitter$.MODULE$.KYUUBI_ENGINE_DEPLOY_YARN_MODE_HADOOP_CONF_KEY();
    }

    public static String KYUUBI_ENGINE_DEPLOY_YARN_MODE_HIVE_CONF_KEY() {
        return EngineYarnModeSubmitter$.MODULE$.KYUUBI_ENGINE_DEPLOY_YARN_MODE_HIVE_CONF_KEY();
    }

    public static String KYUUBI_ENGINE_DEPLOY_YARN_MODE_JARS_KEY() {
        return EngineYarnModeSubmitter$.MODULE$.KYUUBI_ENGINE_DEPLOY_YARN_MODE_JARS_KEY();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public String KYUUBI_ENGINE_STAGING() {
        return this.KYUUBI_ENGINE_STAGING;
    }

    public String LOCALIZED_LIB_DIR() {
        return this.LOCALIZED_LIB_DIR;
    }

    public String LOCALIZED_CONF_DIR() {
        return this.LOCALIZED_CONF_DIR;
    }

    public String HADOOP_CONF_DIR() {
        return this.HADOOP_CONF_DIR;
    }

    public String KYUUBI_CONF_FILE() {
        return this.KYUUBI_CONF_FILE;
    }

    public FsPermission STAGING_DIR_PERMISSION() {
        return this.STAGING_DIR_PERMISSION;
    }

    private String applicationMaster() {
        return this.applicationMaster;
    }

    private YarnClient yarnClient() {
        return this.yarnClient;
    }

    private void yarnClient_$eq(YarnClient x$1) {
        this.yarnClient = x$1;
    }

    private ApplicationId appId() {
        return this.appId;
    }

    private void appId_$eq(ApplicationId x$1) {
        this.appId = x$1;
    }

    public Path stagingDirPath() {
        return this.stagingDirPath;
    }

    public void stagingDirPath_$eq(Path x$1) {
        this.stagingDirPath = x$1;
    }

    public KyuubiConf kyuubiConf() {
        return this.kyuubiConf;
    }

    public Configuration yarnConf() {
        return this.yarnConf;
    }

    public void yarnConf_$eq(Configuration x$1) {
        this.yarnConf = x$1;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public void hadoopConf_$eq(Configuration x$1) {
        this.hadoopConf = x$1;
    }

    public abstract String engineType();

    public abstract void engineType_$eq(String var1);

    public abstract String engineMainClass();

    public Seq<File> engineExtraJars() {
        return (Seq)Nil$.MODULE$;
    }

    public void submitApplication() {
        this.yarnConf_$eq((Configuration)KyuubiHadoopUtils$.MODULE$.newYarnConfiguration(this.kyuubiConf()));
        this.hadoopConf_$eq(KyuubiHadoopUtils$.MODULE$.newHadoopConf(this.kyuubiConf(), KyuubiHadoopUtils$.MODULE$.newHadoopConf$default$2()));
        try {
            try {
                this.yarnClient_$eq(YarnClient.createYarnClient());
                this.yarnClient().init(this.yarnConf());
                this.yarnClient().start();
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Requesting a new application from cluster with %d NodeManagers")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.yarnClient().getYarnClusterMetrics().getNumNodeManagers())})));
                YarnClientApplication newApp = this.yarnClient().createApplication();
                GetNewApplicationResponse newAppResponse = newApp.getNewApplicationResponse();
                this.appId_$eq(newAppResponse.getApplicationId());
                Path appStagingBaseDir = (Path)((Option)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_DEPLOY_YARN_MODE_STAGING_DIR())).map((Function1 & Serializable & scala.Serializable)x$1 -> new Path(x$1, UserGroupInformation.getCurrentUser().getShortUserName())).getOrElse((Function0 & Serializable & scala.Serializable)() -> FileSystem.get((Configuration)this.hadoopConf()).getHomeDirectory());
                this.stagingDirPath_$eq(new Path(appStagingBaseDir, this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.KYUUBI_ENGINE_STAGING(), this.appId().toString()}))));
                ContainerLaunchContext containerContext = this.createContainerLaunchContext();
                ApplicationSubmissionContext appContext = this.createApplicationSubmissionContext(newApp, containerContext);
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Submitting application ").append(this.appId()).append(" to ResourceManager").toString());
                this.yarnClient().submitApplication(appContext);
                this.monitorApplication(this.appId());
            }
            catch (Throwable e) {
                if (this.stagingDirPath() != null) {
                    this.cleanupStagingDir();
                }
                throw new KyuubiException("Failed to submit application to YARN", e);
            }
        }
        finally {
            if (this.yarnClient() != null) {
                this.yarnClient().stop();
            }
        }
    }

    private ContainerLaunchContext createContainerLaunchContext() {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Setting up container launch context for engine AM");
        HashMap<String, String> env = this.setupLaunchEnv(this.kyuubiConf());
        HashMap<String, LocalResource> localResources = this.prepareLocalResources(this.stagingDirPath(), env);
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        amContainer.setLocalResources((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(localResources).asJava());
        amContainer.setEnvironment((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(env).asJava());
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option javaOptions = (Option)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_DEPLOY_YARN_MODE_JAVA_OPTIONS());
        Object object = javaOptions.isDefined() ? javaOpts.$plus$eq(javaOptions.get()) : BoxedUnit.UNIT;
        Seq am = (Seq)new .colon.colon((Object)this.applicationMaster(), (List)Nil$.MODULE$);
        Seq engineClass = (Seq)new .colon.colon((Object)"--class", (List)new .colon.colon((Object)this.engineMainClass(), (List)Nil$.MODULE$));
        Seq kyuubiConfProperties = (Seq)new .colon.colon((Object)"--properties-file", (List)new .colon.colon((Object)this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), this.LOCALIZED_CONF_DIR(), this.KYUUBI_CONF_FILE()})), (List)Nil$.MODULE$));
        Seq commands = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)new .colon.colon((Object)new StringBuilder(9).append(ApplicationConstants.Environment.JAVA_HOME.$$()).append("/bin/java").toString(), (List)new .colon.colon((Object)"-server", (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)javaOpts, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)am, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)engineClass, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)kyuubiConfProperties, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"1>", (List)new .colon.colon((Object)"<LOG_DIR>/stdout", (List)new .colon.colon((Object)"2>", (List)new .colon.colon((Object)"<LOG_DIR>/stderr", (List)Nil$.MODULE$)))), Seq$.MODULE$.canBuildFrom());
        List printableCommands = ((TraversableOnce)commands.map((Function1 & Serializable & scala.Serializable)s -> {
            if (s == null) {
                return "null";
            }
            return s;
        }, Seq$.MODULE$.canBuildFrom())).toList();
        amContainer.setCommands((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)printableCommands).asJava());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Commands: ").append(printableCommands.mkString(" ")).toString());
        return amContainer;
    }

    private HashMap<String, LocalResource> prepareLocalResources(Path destDir, HashMap<String, String> env) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Preparing resources for engine AM container");
        FileSystem fs = destDir.getFileSystem(this.hadoopConf());
        HashMap localResources = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        FileSystem.mkdirs((FileSystem)fs, (Path)destDir, (FsPermission)new FsPermission(this.STAGING_DIR_PERMISSION()));
        this.distributeJars((HashMap<String, LocalResource>)localResources, env);
        this.distributeConf((HashMap<String, LocalResource>)localResources, env);
        return localResources;
    }

    private void distributeJars(HashMap<String, LocalResource> localResources, HashMap<String, String> env) {
        File jarsArchive = File.createTempFile(this.LOCALIZED_LIB_DIR(), ".zip", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toFile());
        try (ZipOutputStream jarsStream = new ZipOutputStream(new FileOutputStream(jarsArchive));){
            jarsStream.setLevel(0);
            Option<String> jars = this.kyuubiConf().getOption("kyuubi.engine.deploy.yarn.mode.jars");
            ListBuffer putedEntry = new ListBuffer();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)jars.get()).split(","))).foreach((Function1 & Serializable & scala.Serializable)path -> {
                EngineYarnModeSubmitter.$anonfun$distributeJars$1(this, putedEntry, jarsStream, env, path);
                return BoxedUnit.UNIT;
            });
            putedEntry.clear();
        }
        this.distribute(new Path(jarsArchive.getAbsolutePath()), LocalResourceType.ARCHIVE, this.LOCALIZED_LIB_DIR(), localResources);
    }

    private void distributeConf(HashMap<String, LocalResource> localResources, HashMap<String, String> env) {
        File confArchive = File.createTempFile(this.LOCALIZED_CONF_DIR(), ".zip", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toFile());
        try (ZipOutputStream confStream = new ZipOutputStream(new FileOutputStream(confArchive));){
            confStream.setLevel(0);
            ListBuffer putedEntry = new ListBuffer();
            Option<String> hiveConf = this.kyuubiConf().getOption("kyuubi.engine.deploy.yarn.mode.hiveConf");
            this.listDistinctFiles((String)hiveConf.get()).foreach((Function1 & Serializable & scala.Serializable)f -> {
                this.putEntry$1(f, putedEntry, confStream, env);
                return BoxedUnit.UNIT;
            });
            Option<String> hadoopConf = this.kyuubiConf().getOption("kyuubi.engine.deploy.yarn.mode.hadoopConf");
            this.listDistinctFiles((String)hadoopConf.get()).foreach((Function1 & Serializable & scala.Serializable)f -> {
                this.putEntry$1(f, putedEntry, confStream, env);
                return BoxedUnit.UNIT;
            });
            Option<String> yarnConf = this.kyuubiConf().getOption("kyuubi.engine.deploy.yarn.mode.yarnConf");
            this.listDistinctFiles((String)yarnConf.get()).foreach((Function1 & Serializable & scala.Serializable)f -> {
                this.putEntry$1(f, putedEntry, confStream, env);
                return BoxedUnit.UNIT;
            });
            Properties properties = this.confToProperties(this.kyuubiConf());
            this.writePropertiesToArchive(properties, this.KYUUBI_CONF_FILE(), confStream);
        }
        this.distribute(new Path(confArchive.getAbsolutePath()), LocalResourceType.ARCHIVE, this.LOCALIZED_CONF_DIR(), localResources);
    }

    public Seq<File> listDistinctFiles(String archive) {
        LinkedHashSet distinctFiles = new LinkedHashSet();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])archive.split(","))).foreach((Function1 & Serializable & scala.Serializable)path -> {
            EngineYarnModeSubmitter.$anonfun$listDistinctFiles$1(distinctFiles, path);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)distinctFiles.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LinkedHashSet items = (LinkedHashSet)tuple2._2();
                return (File)items.head();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private void distribute(Path srcPath, LocalResourceType resType, String destName, HashMap<String, LocalResource> localResources) {
        FileSystem fs = this.stagingDirPath().getFileSystem(this.hadoopConf());
        Path destPath = new Path(this.stagingDirPath(), srcPath.getName());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Copying ").append(srcPath).append(" to ").append(destPath).toString());
        fs.copyFromLocalFile(srcPath, destPath);
        fs.setPermission(destPath, new FsPermission(this.STAGING_DIR_PERMISSION()));
        FileSystem destFs = FileSystem.get((URI)destPath.toUri(), (Configuration)this.hadoopConf());
        FileStatus destStatus = destFs.getFileStatus(destPath);
        LocalResource destResource = (LocalResource)Records.newRecord(LocalResource.class);
        destResource.setType(resType);
        destResource.setVisibility(LocalResourceVisibility.APPLICATION);
        destResource.setResource(URL.fromPath((Path)destPath));
        destResource.setTimestamp(destStatus.getModificationTime());
        destResource.setSize(destStatus.getLen());
        localResources.update((Object)destName, (Object)destResource);
    }

    public HashMap<String, String> setupLaunchEnv(KyuubiConf kyuubiConf) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Setting up the launch environment for engine AM container");
        HashMap env = new HashMap();
        ((IterableLike)((TraversableLike)kyuubiConf.getAll().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EngineYarnModeSubmitter.$anonfun$setupLaunchEnv$2(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k.substring("kyuubi.engine.yarn.AMEnv".length() + 1), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            EngineYarnModeSubmitter.$anonfun$setupLaunchEnv$4(env, x0$3);
            return BoxedUnit.UNIT;
        });
        this.addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), this.LOCALIZED_CONF_DIR()})), (HashMap<String, String>)env);
        env.put((Object)ApplicationConstants.Environment.HADOOP_CONF_DIR.name(), (Object)this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), this.LOCALIZED_CONF_DIR(), this.HADOOP_CONF_DIR()})));
        this.addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), this.LOCALIZED_CONF_DIR(), this.HADOOP_CONF_DIR()})), (HashMap<String, String>)env);
        env.put((Object)"KYUUBI_ENGINE_YARN_MODE_STAGING_DIR", (Object)this.stagingDirPath().toString());
        return env;
    }

    private ApplicationSubmissionContext createApplicationSubmissionContext(YarnClientApplication newApp, ContainerLaunchContext containerContext) {
        ApplicationSubmissionContext appContext = newApp.getApplicationSubmissionContext();
        appContext.setApplicationName((String)((Option)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_DEPLOY_YARN_MODE_APP_NAME())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Apache Kyuubi ").append(this.engineType()).append(" Engine").toString()));
        appContext.setQueue(this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_DEPLOY_YARN_MODE_QUEUE()));
        appContext.setAMContainerSpec(containerContext);
        ((Option)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_DEPLOY_YARN_MODE_PRIORITY())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)appPriority -> appContext.setPriority(Priority.newInstance((int)appPriority)));
        appContext.setApplicationType(this.engineType().toUpperCase(Locale.ROOT));
        HashSet allTags = new HashSet();
        ((Option)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_DEPLOY_YARN_MODE_TAGS())).foreach((Function1 & Serializable & scala.Serializable)tags -> BoxesRunTime.boxToBoolean((boolean)allTags.addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(tags).asJava())));
        appContext.setApplicationTags(allTags);
        appContext.setMaxAppAttempts(1);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemorySize((long)BoxesRunTime.unboxToInt((Object)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_DEPLOY_YARN_MODE_MEMORY())));
        capability.setVirtualCores(BoxesRunTime.unboxToInt((Object)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_DEPLOY_YARN_MODE_CORES())));
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Created resource capability for AM request: ").append(capability).toString());
        appContext.setResource(capability);
        return appContext;
    }

    private void monitorApplication(ApplicationId appId) {
        block3: {
            YarnApplicationState state;
            block2: {
                ApplicationReport report = this.yarnClient().getApplicationReport(appId);
                state = report.getYarnApplicationState();
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Application report for ").append(appId).append(" (state: ").append(state).append(")").toString());
                YarnApplicationState yarnApplicationState = state;
                YarnApplicationState yarnApplicationState2 = YarnApplicationState.FAILED;
                if (!(yarnApplicationState == null ? yarnApplicationState2 != null : !yarnApplicationState.equals(yarnApplicationState2))) break block2;
                YarnApplicationState yarnApplicationState3 = state;
                YarnApplicationState yarnApplicationState4 = YarnApplicationState.KILLED;
                if (yarnApplicationState3 != null ? !yarnApplicationState3.equals(yarnApplicationState4) : yarnApplicationState4 != null) break block3;
            }
            throw new KyuubiException(new StringBuilder(35).append("Application ").append(appId).append(" finished with status: ").append(state).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private void cleanupStagingDir() {
        try {
            FileSystem fs = this.stagingDirPath().getFileSystem(this.hadoopConf());
            if (fs.delete(this.stagingDirPath(), true)) {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Deleted staging directory ").append(this.stagingDirPath()).toString());
            }
        }
        catch (IOException ioe) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Failed to cleanup staging dir ").append(this.stagingDirPath()).toString(), ioe);
        }
    }

    private String buildPath(Seq<String> components) {
        return components.mkString("/");
    }

    private void addClasspathEntry(String path, HashMap<String, String> env) {
        KyuubiHadoopUtils$.MODULE$.addPathToEnvironment(env, ApplicationConstants.Environment.CLASSPATH.name(), path);
    }

    private Properties confToProperties(KyuubiConf conf) {
        Properties props = new Properties();
        conf.getAll().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.setProperty(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        return props;
    }

    public void writePropertiesToArchive(Properties props, String name, ZipOutputStream out) {
        out.putNextEntry(new ZipEntry(name));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        props.store(writer, "Kyuubi configuration.");
        writer.flush();
        out.closeEntry();
    }

    public void writeConfigurationToArchive(Configuration conf, String name, ZipOutputStream out) {
        out.putNextEntry(new ZipEntry(name));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        conf.writeXml((Writer)writer);
        writer.flush();
        out.closeEntry();
    }

    public static final /* synthetic */ void $anonfun$distributeJars$2(EngineYarnModeSubmitter $this, ListBuffer putedEntry$1, ZipOutputStream jarsStream$1, HashMap env$1, File f) {
        if (!putedEntry$1.contains((Object)f.getName()) && f.isFile() && f.getName().toLowerCase(Locale.ROOT).endsWith(".jar") && f.canRead()) {
            jarsStream$1.putNextEntry(new ZipEntry(f.getName()));
            Files.copy(f.toPath(), jarsStream$1);
            jarsStream$1.closeEntry();
            putedEntry$1.$plus$eq((Object)f.getName());
            $this.addClasspathEntry($this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), $this.LOCALIZED_LIB_DIR(), f.getName()})), (HashMap<String, String>)env$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$distributeJars$1(EngineYarnModeSubmitter $this, ListBuffer putedEntry$1, ZipOutputStream jarsStream$1, HashMap env$1, String path) {
        Seq jars = (Seq)Utils$.MODULE$.listFilesRecursively(new File(path)).$plus$plus($this.engineExtraJars(), Seq$.MODULE$.canBuildFrom());
        jars.foreach((Function1 & Serializable & scala.Serializable)f -> {
            EngineYarnModeSubmitter.$anonfun$distributeJars$2($this, putedEntry$1, jarsStream$1, env$1, f);
            return BoxedUnit.UNIT;
        });
    }

    private final void putEntry$1(File f, ListBuffer putedEntry$2, ZipOutputStream confStream$1, HashMap env$2) {
        if (!putedEntry$2.contains((Object)f.getName()) && f.isFile() && f.canRead()) {
            confStream$1.putNextEntry(new ZipEntry(new StringBuilder(1).append(this.HADOOP_CONF_DIR()).append("/").append(f.getName()).toString()));
            Files.copy(f.toPath(), confStream$1);
            confStream$1.closeEntry();
            putedEntry$2.$plus$eq((Object)f.getName());
            this.addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), this.LOCALIZED_CONF_DIR(), this.HADOOP_CONF_DIR(), f.getName()})), (HashMap<String, String>)env$2);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$listDistinctFiles$1(LinkedHashSet distinctFiles$1, String path) {
        File file = new File(path);
        Seq<File> files = Utils$.MODULE$.listFilesRecursively(file);
        files.foreach((Function1 & Serializable & scala.Serializable)f -> {
            if (f.isFile() && f.canRead()) {
                return distinctFiles$1.$plus$eq(f);
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$setupLaunchEnv$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.startsWith("kyuubi.engine.yarn.AMEnv");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$setupLaunchEnv$4(HashMap env$3, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            KyuubiHadoopUtils$.MODULE$.addPathToEnvironment((HashMap<String, String>)env$3, k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public EngineYarnModeSubmitter() {
        Logging.$init$(this);
        this.KYUUBI_ENGINE_STAGING = ".kyuubiEngineStaging";
        this.LOCALIZED_LIB_DIR = "__kyuubi_engine_libs__";
        this.LOCALIZED_CONF_DIR = "__kyuubi_engine_conf__";
        this.HADOOP_CONF_DIR = "__hadoop_conf__";
        this.KYUUBI_CONF_FILE = "__kyuubi_conf__.properties";
        this.STAGING_DIR_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("700", 8)));
        this.applicationMaster = (String)new StringOps(Predef$.MODULE$.augmentString(ApplicationMaster$.MODULE$.getClass().getName())).dropRight(1);
        this.kyuubiConf = new KyuubiConf(KyuubiConf$.MODULE$.$lessinit$greater$default$1());
    }
}

