/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.util;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.engine.spark.schema.SchemaHelper$;
import org.apache.kyuubi.util.reflect.ReflectUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SparkCatalogUtils$
implements Logging {
    public static SparkCatalogUtils$ MODULE$;
    private final String VIEW;
    private final String TABLE;
    private final String SESSION_CATALOG;
    private final Set<String> sparkTableTypes;
    private final Pattern validIdentPattern;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new SparkCatalogUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private String VIEW() {
        return this.VIEW;
    }

    private String TABLE() {
        return this.TABLE;
    }

    public String SESSION_CATALOG() {
        return this.SESSION_CATALOG;
    }

    public Set<String> sparkTableTypes() {
        return this.sparkTableTypes;
    }

    public Seq<Row> getCatalogs(SparkSession spark) {
        CatalogManager catalogMgr = spark.sessionState().catalogManager();
        Object sessionCatalog = ReflectUtils$.MODULE$.invokeAs(catalogMgr, "v2SessionCatalog", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        CatalogPlugin defaultCatalog = catalogMgr.currentCatalog();
        Seq defaults = (Seq)((TraversableLike)((SeqLike)new .colon.colon(sessionCatalog, (List)new .colon.colon((Object)defaultCatalog, (List)Nil$.MODULE$))).distinct()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)ReflectUtils$.MODULE$.invokeAs(x$1, "name", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), Seq$.MODULE$.canBuildFrom());
        Map catalogs = (Map)ReflectUtils$.MODULE$.getField(catalogMgr, "catalogs");
        Iterable iterable = catalogs.keys();
        return (Seq)((TraversableLike)((SeqLike)defaults.$plus$plus$colon((Traversable)iterable, Seq$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)x$3 -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x$3})), Seq$.MODULE$.canBuildFrom());
    }

    public CatalogPlugin getCatalog(SparkSession spark, String catalogName) {
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        if (StringUtils.isBlank((CharSequence)catalogName)) {
            return catalogManager.currentCatalog();
        }
        return catalogManager.catalog(catalogName);
    }

    public void setCurrentCatalog(SparkSession spark, String catalog) {
        if (spark.sessionState().catalogManager().isCatalogRegistered(catalog)) {
            spark.sessionState().catalogManager().setCurrentCatalog(catalog);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(47).append("Cannot find catalog plugin class for catalog '").append(catalog).append("'").toString());
    }

    public Seq<Row> getSchemas(SparkSession spark, String catalogName, String schemaPattern) {
        String string = catalogName;
        String string2 = this.SESSION_CATALOG();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return (Seq)((TraversableLike)spark.sessionState().catalog().listDatabases(schemaPattern).$plus$plus(this.getGlobalTempViewManager(spark, schemaPattern), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x$4, MODULE$.SESSION_CATALOG()})), Seq$.MODULE$.canBuildFrom());
        }
        CatalogPlugin catalog = this.getCatalog(spark, catalogName);
        return (Seq)this.getSchemasWithPattern(catalog, schemaPattern).map((Function1 & Serializable & scala.Serializable)x$5 -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x$5, catalog.name()})), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> getGlobalTempViewManager(SparkSession spark, String schemaPattern) {
        String database = spark.sharedState().globalTempViewManager().database();
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)database).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.matches(schemaPattern)))).toSeq();
    }

    private String[][] listAllNamespaces(SupportsNamespaces catalog, String[][] namespaces) {
        String[][] children = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespaces)).flatMap((Function1 & Serializable & scala.Serializable)ns -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalog.listNamespaces(ns))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])children)).isEmpty()) {
            return namespaces;
        }
        String[][] stringArray = namespaces;
        return (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listAllNamespaces(catalog, children))).$plus$plus$colon((Traversable)Predef$.MODULE$.wrapRefArray((Object[])stringArray), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
    }

    private String[][] listAllNamespaces(CatalogPlugin catalog) {
        CatalogPlugin catalogPlugin = catalog;
        if (catalogPlugin instanceof CatalogExtension) {
            CatalogExtension catalogExtension = (CatalogExtension)catalogPlugin;
            String[] stringArray = catalogExtension.defaultNamespace();
            return (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogExtension.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))))).$plus$colon((Object)stringArray, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        }
        if (catalogPlugin instanceof SupportsNamespaces) {
            SupportsNamespaces supportsNamespaces = (SupportsNamespaces)catalogPlugin;
            String[][] rootSchema = supportsNamespaces.listNamespaces();
            String[][] allSchemas = this.listAllNamespaces(supportsNamespaces, rootSchema);
            return allSchemas;
        }
        throw new MatchError((Object)catalogPlugin);
    }

    private String[][] listNamespacesWithPattern(CatalogPlugin catalog, String schemaPattern) {
        return (String[][])((TraversableOnce)((List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listAllNamespaces(catalog))).filter((Function1 & Serializable & scala.Serializable)ns -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$listNamespacesWithPattern$1(schemaPattern, ns))))).map((Function1 & Serializable & scala.Serializable)x$9 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$9)).toList(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(List.class))))).toList().distinct()).map((Function1 & Serializable & scala.Serializable)x$10 -> (String[])x$10.toArray(ClassTag$.MODULE$.apply(String.class)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
    }

    private Seq<String> getSchemasWithPattern(CatalogPlugin catalog, String schemaPattern) {
        Pattern p = new StringOps(Predef$.MODULE$.augmentString(schemaPattern)).r().pattern();
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listAllNamespaces(catalog))).flatMap((Function1 & Serializable & scala.Serializable)ns -> {
            String quoted = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ns)).map((Function1 & Serializable & scala.Serializable)part -> MODULE$.quoteIfNeeded((String)part), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
            if (p.matcher(quoted).matches()) {
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)quoted));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct());
    }

    public Seq<Row> getCatalogTablesOrViews(SparkSession spark, String catalogName, String schemaPattern, String tablePattern, Set<String> tableTypes, boolean ignoreTableProperties) {
        CatalogPlugin catalog = this.getCatalog(spark, catalogName);
        String[][] namespaces = this.listNamespacesWithPattern(catalog, schemaPattern);
        CatalogPlugin catalogPlugin = catalog;
        String string = catalogPlugin.name();
        String string2 = this.SESSION_CATALOG();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            SessionCatalog sessionCatalog = spark.sessionState().catalog();
            Seq databases = sessionCatalog.listDatabases(schemaPattern);
            return (Seq)databases.flatMap((Function1 & Serializable & scala.Serializable)db -> {
                Seq identifiers = sessionCatalog.listTables(db, tablePattern, false);
                if (ignoreTableProperties) {
                    return (Seq)identifiers.map((Function1 & Serializable & scala.Serializable)ti -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{catalogName, ti.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "default"), ti.table(), MODULE$.TABLE(), "", null, null, null, null, null})), Seq$.MODULE$.canBuildFrom());
                }
                return (Seq)((TraversableLike)sessionCatalog.getTablesByName(identifiers).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isMatchedTableType$1(tableTypes, t.tableType().name())))).map((Function1 & Serializable & scala.Serializable)t -> {
                    String string = t.tableType().name();
                    String string2 = MODULE$.VIEW();
                    String typ = !(string != null ? !string.equals(string2) : string2 != null) ? MODULE$.VIEW() : MODULE$.TABLE();
                    return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{catalogName, t.database(), t.identifier().table(), typ, t.comment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), null, null, null, null, null}));
                }, Seq$.MODULE$.canBuildFrom());
            }, Seq$.MODULE$.canBuildFrom());
        }
        if (catalogPlugin instanceof TableCatalog) {
            TableCatalog tableCatalog = (TableCatalog)catalogPlugin;
            Pattern tp = new StringOps(Predef$.MODULE$.augmentString(tablePattern)).r().pattern();
            Identifier[] identifiers = (Identifier[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespaces)).flatMap((Function1 & Serializable & scala.Serializable)ns -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableCatalog.listTables(ns))).filter((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getCatalogTablesOrViews$9(tp$1, i))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Identifier.class)));
            return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])identifiers)).map((Function1 & Serializable & scala.Serializable)ident -> {
                String comment = ignoreTableProperties ? "" : tableCatalog.loadTable(ident).properties().getOrDefault("comment", "");
                String schema = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).map((Function1 & Serializable & scala.Serializable)part -> MODULE$.quoteIfNeeded((String)part), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
                String tableName = MODULE$.quoteIfNeeded(ident.name());
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{catalog.name(), schema, tableName, MODULE$.TABLE(), comment, null, null, null, null, null}));
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        return (Seq)Nil$.MODULE$;
    }

    public boolean getCatalogTablesOrViews$default$6() {
        return false;
    }

    private Seq<Row> getColumnsByCatalog(SparkSession spark, String catalogName, String schemaPattern, String tablePattern, Pattern columnPattern) {
        CatalogPlugin catalog = this.getCatalog(spark, catalogName);
        CatalogPlugin catalogPlugin = catalog;
        if (catalogPlugin instanceof TableCatalog) {
            TableCatalog tableCatalog = (TableCatalog)catalogPlugin;
            String[][] namespaces = this.listNamespacesWithPattern(catalog, schemaPattern);
            Pattern tp = new StringOps(Predef$.MODULE$.augmentString(tablePattern)).r().pattern();
            Identifier[] identifiers = (Identifier[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespaces)).flatMap((Function1 & Serializable & scala.Serializable)ns -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableCatalog.listTables(ns))).filter((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getColumnsByCatalog$2(tp$2, i))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Identifier.class)));
            return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])identifiers)).flatMap((Function1 & Serializable & scala.Serializable)ident -> {
                Table table = tableCatalog.loadTable(ident);
                String namespace = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).map((Function1 & Serializable & scala.Serializable)part -> MODULE$.quoteIfNeeded((String)part), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
                String tableName = MODULE$.quoteIfNeeded(ident.name());
                return (Seq)((TraversableLike)((TraversableLike)table.schema().zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getColumnsByCatalog$5(columnPattern, f)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        StructField f = (StructField)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        return MODULE$.toColumnResult(tableCatalog.name(), namespace, tableName, f, i);
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom());
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        String string = catalogPlugin.name();
        String string2 = this.SESSION_CATALOG();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            SessionCatalog catalog2 = spark.sessionState().catalog();
            Seq databases = catalog2.listDatabases(schemaPattern);
            return (Seq)databases.flatMap((Function1 & Serializable & scala.Serializable)db -> {
                Seq identifiers = catalog2.listTables(db, tablePattern, true);
                return (Seq)catalog2.getTablesByName(identifiers).flatMap((Function1 & Serializable & scala.Serializable)t -> (Seq)((TraversableLike)((TraversableLike)t.schema().zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getColumnsByCatalog$9(columnPattern, f)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        StructField f = (StructField)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        return MODULE$.toColumnResult(catalogName, t.database(), t.identifier().table(), f, i);
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            }, Seq$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)catalogPlugin);
    }

    public Seq<Row> getTempViews(SparkSession spark, String catalogName, String schemaPattern, String tablePattern) {
        Seq<TableIdentifier> views = this.getViews(spark, schemaPattern, tablePattern);
        return (Seq)views.map((Function1 & Serializable & scala.Serializable)ident -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{catalogName, ident.database().orNull(Predef$.MODULE$.$conforms()), ident.table(), MODULE$.VIEW(), "", null, null, null, null, null})), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<TableIdentifier> getViews(SparkSession spark, String schemaPattern, String tablePattern) {
        Seq<String> db = this.getGlobalTempViewManager(spark, schemaPattern);
        if (db.nonEmpty()) {
            return spark.sessionState().catalog().listTables((String)db.head(), tablePattern);
        }
        return spark.sessionState().catalog().listLocalTempViews(tablePattern);
    }

    public Seq<Row> getColumns(SparkSession spark, String catalogName, String schemaPattern, String tablePattern, String columnPattern) {
        Pattern cp = new StringOps(Predef$.MODULE$.augmentString(columnPattern)).r().pattern();
        Seq<Row> byCatalog = this.getColumnsByCatalog(spark, catalogName, schemaPattern, tablePattern, cp);
        Seq<Row> byGlobalTmpDB = this.getColumnsByGlobalTempViewManager(spark, schemaPattern, tablePattern, cp);
        Seq<Row> byLocalTmp = this.getColumnsByLocalTempViews(spark, tablePattern, cp);
        return (Seq)((TraversableLike)byCatalog.$plus$plus(byGlobalTmpDB, Seq$.MODULE$.canBuildFrom())).$plus$plus(byLocalTmp, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Row> getColumnsByGlobalTempViewManager(SparkSession spark, String schemaPattern, String tablePattern, Pattern columnPattern) {
        SessionCatalog catalog = spark.sessionState().catalog();
        return (Seq)this.getGlobalTempViewManager(spark, schemaPattern).flatMap((Function1 & Serializable & scala.Serializable)globalTmpDb -> (Seq)((GenericTraversableTemplate)catalog.globalTempViewManager().listViewNames(tablePattern).flatMap((Function1 & Serializable & scala.Serializable)v -> Option$.MODULE$.option2Iterable(catalog.globalTempViewManager().get(v).map((Function1 & Serializable & scala.Serializable)plan -> (Seq)((TraversableLike)((TraversableLike)plan.schema().zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getColumnsByGlobalTempViewManager$4(columnPattern, f)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return MODULE$.toColumnResult(MODULE$.SESSION_CATALOG(), (String)globalTmpDb, (String)v, f, i);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom()))), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Row> getColumnsByLocalTempViews(SparkSession spark, String tablePattern, Pattern columnPattern) {
        SessionCatalog catalog = spark.sessionState().catalog();
        return (Seq)((TraversableLike)catalog.listLocalTempViews(tablePattern).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, catalog.getTempView(v.table()).get()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TableIdentifier v = (TableIdentifier)tuple2._1();
                View plan = (View)tuple2._2();
                return (Seq)((TraversableLike)((TraversableLike)plan.schema().zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SparkCatalogUtils$.$anonfun$getColumnsByLocalTempViews$3(columnPattern, f)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        StructField f = (StructField)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        return MODULE$.toColumnResult(MODULE$.SESSION_CATALOG(), null, v.table(), f, i);
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Row toColumnResult(String catalog, String db, String table, StructField col, int pos) {
        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{catalog, db, table, col.name(), BoxesRunTime.boxToInteger((int)SchemaHelper$.MODULE$.toJavaSQLType(col.dataType())), col.dataType().sql(), SchemaHelper$.MODULE$.getColumnSize(col.dataType()).orNull(Predef$.MODULE$.$conforms()), null, SchemaHelper$.MODULE$.getDecimalDigits(col.dataType()).orNull(Predef$.MODULE$.$conforms()), SchemaHelper$.MODULE$.getNumPrecRadix(col.dataType()).orNull(Predef$.MODULE$.$conforms()), col.nullable() ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0), col.getComment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), null, null, null, null, BoxesRunTime.boxToInteger((int)pos), "YES", null, null, null, null, "NO"}));
    }

    private Pattern validIdentPattern() {
        return this.validIdentPattern;
    }

    public String quoteIfNeeded(String part) {
        if (this.validIdentPattern().matcher(part).matches()) {
            return part;
        }
        return this.quoteIdentifier(part);
    }

    public String quoteIdentifier(String name) {
        return new StringBuilder(2).append("`").append(name.replace("`", "``")).append("`").toString();
    }

    public static final /* synthetic */ boolean $anonfun$listNamespacesWithPattern$1(String schemaPattern$2, String[] ns) {
        String quoted = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ns)).map((Function1 & Serializable & scala.Serializable)part -> MODULE$.quoteIfNeeded((String)part), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
        return new StringOps(Predef$.MODULE$.augmentString(schemaPattern$2)).r().pattern().matcher(quoted).matches();
    }

    private final boolean isMatchedTableType$1(Set tableTypes, String tableType) {
        String typ = tableType.equalsIgnoreCase(this.VIEW()) ? this.VIEW() : this.TABLE();
        return tableTypes.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)typ.equalsIgnoreCase(x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getCatalogTablesOrViews$9(Pattern tp$1, Identifier i) {
        return tp$1.matcher(MODULE$.quoteIfNeeded(i.name())).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByCatalog$2(Pattern tp$2, Identifier i) {
        return tp$2.matcher(MODULE$.quoteIfNeeded(i.name())).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByCatalog$5(Pattern columnPattern$1, Tuple2 f) {
        return columnPattern$1.matcher(((StructField)f._1()).name()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByCatalog$9(Pattern columnPattern$1, Tuple2 f) {
        return columnPattern$1.matcher(((StructField)f._1()).name()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByGlobalTempViewManager$4(Pattern columnPattern$2, Tuple2 f) {
        return columnPattern$2.matcher(((StructField)f._1()).name()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getColumnsByLocalTempViews$3(Pattern columnPattern$3, Tuple2 f) {
        return columnPattern$3.matcher(((StructField)f._1()).name()).matches();
    }

    private SparkCatalogUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.VIEW = "VIEW";
        this.TABLE = "TABLE";
        this.SESSION_CATALOG = "spark_catalog";
        this.sparkTableTypes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.VIEW(), this.TABLE()}));
        this.validIdentPattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*");
    }
}

