/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationManagerInfo;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.EngineRef$;
import org.apache.kyuubi.engine.EngineType$;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.chat.ChatProcessBuilder;
import org.apache.kyuubi.engine.flink.FlinkProcessBuilder;
import org.apache.kyuubi.engine.hive.HiveProcessBuilder;
import org.apache.kyuubi.engine.jdbc.JdbcProcessBuilder;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder;
import org.apache.kyuubi.engine.trino.TrinoProcessBuilder;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.apache.kyuubi.server.KyuubiServer$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tec!B\u00193\u0001QR\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u00115\u0003!\u0011!Q\u0001\n9C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\tA\u0002\u0011\t\u0011)A\u0005\u001d\"A\u0011\r\u0001B\u0001B\u0003%!\r\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003h\u0011\u0015!\b\u0001\"\u0001v\u0011\u001di\bA1A\u0005\nyDaa \u0001!\u0002\u0013q\u0005\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0011!\tY\u0001\u0001Q\u0001\n\u0005\u0015\u0001\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\ty\u0003\u0001Q\u0001\n\u0005E\u0001\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005U\u0002\"CA#\u0001\t\u0007I\u0011BA$\u0011!\ty\u0005\u0001Q\u0001\n\u0005%\u0003\"CA)\u0001\t\u0007I\u0011BA$\u0011!\t\u0019\u0006\u0001Q\u0001\n\u0005%\u0003\u0002CA+\u0001\t\u0007I\u0011\u0002@\t\u000f\u0005]\u0003\u0001)A\u0005\u001d\"I\u0011\u0011\f\u0001C\u0002\u0013%\u00111\f\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002^!A\u0011Q\r\u0001C\u0002\u0013%a\u0010C\u0004\u0002h\u0001\u0001\u000b\u0011\u0002(\t\u0013\u0005%\u0004A1A\u0005\n\u0005-\u0004\u0002CA:\u0001\u0001\u0006I!!\u001c\t\u0017\u0005U\u0004\u00011AA\u0002\u0013%\u0011q\u000f\u0005\f\u0003\u007f\u0002\u0001\u0019!a\u0001\n\u0013\t\t\tC\u0006\u0002\u000e\u0002\u0001\r\u0011!Q!\n\u0005e\u0004\u0002CAH\u0001\u0011\u0005A'!%\t\u0013\u0005M\u0005A1A\u0005\u0002Qr\bbBAK\u0001\u0001\u0006IA\u0014\u0005\n\u0003/\u0003!\u0019!C\u0001iyDq!!'\u0001A\u0003%a\nC\u0005\u00026\u0002\u0011\r\u0011\"\u00015}\"9\u0011q\u0017\u0001!\u0002\u0013q\u0005BCA^\u0001!\u0015\r\u0011\"\u00015}\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBA~\u0001\u0011%\u0011Q \u0005\b\u0005;\u0001A\u0011\u0001B\u0010\u0011%\u0011)\u0003AI\u0001\n\u0003\u00119\u0003C\u0004\u0003>\u0001!\tAa\u0010\t\u000f\t\u001d\u0003\u0001\"\u0001\u0003J\u001dQ!1\n\u001a\u0002\u0002#\u0005AG!\u0014\u0007\u0013E\u0012\u0014\u0011!E\u0001i\t=\u0003B\u0002;/\t\u0003\u0011\t\u0006C\u0005\u0003T9\n\n\u0011\"\u0001\u0003V\tIQI\\4j]\u0016\u0014VM\u001a\u0006\u0003gQ\na!\u001a8hS:,'BA\u001b7\u0003\u0019Y\u00170^;cS*\u0011q\u0007O\u0001\u0007CB\f7\r[3\u000b\u0003e\n1a\u001c:h'\r\u00011(\u0011\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001bU\"\u0001\u001b\n\u0005\u0011#$a\u0002'pO\u001eLgnZ\u0001\u0005G>tgm\u0001\u0001\u0011\u0005![U\"A%\u000b\u0005)#\u0014AB2p]\u001aLw-\u0003\u0002M\u0013\nQ1*_;vE&\u001cuN\u001c4\u0002\tU\u001cXM\u001d\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005EkT\"\u0001*\u000b\u0005M3\u0015A\u0002\u001fs_>$h(\u0003\u0002V{\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)V(A\u0007he>,\b\u000f\u0015:pm&$WM\u001d\t\u00037zk\u0011\u0001\u0018\u0006\u0003;R\na\u0001\u001d7vO&t\u0017BA0]\u000559%o\\;q!J|g/\u001b3fe\u0006YQM\\4j]\u0016\u0014VMZ%e\u00035)gnZ5oK6\u000bg.Y4feB\u00111\rZ\u0007\u0002e%\u0011QM\r\u0002\u0019\u0017f,XOY5BaBd\u0017nY1uS>tW*\u00198bO\u0016\u0014\u0018aF:uCJ$X\u000f\u001d)s_\u000e,7o]*f[\u0006\u0004\bn\u001c:f!\ra\u0004N[\u0005\u0003Sv\u0012aa\u00149uS>t\u0007CA6s\u001b\u0005a'BA7o\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003_B\fA!\u001e;jY*\t\u0011/\u0001\u0003kCZ\f\u0017BA:m\u0005%\u0019V-\\1qQ>\u0014X-\u0001\u0004=S:LGO\u0010\u000b\bm^D\u0018P_>}!\t\u0019\u0007\u0001C\u0003F\u000f\u0001\u0007q\tC\u0003N\u000f\u0001\u0007a\nC\u0003Z\u000f\u0001\u0007!\fC\u0003a\u000f\u0001\u0007a\nC\u0003b\u000f\u0001\u0007!\rC\u0004g\u000fA\u0005\t\u0019A4\u0002\u0017M,'O^3s'B\f7-Z\u000b\u0002\u001d\u0006a1/\u001a:wKJ\u001c\u0006/Y2fA\u00059A/[7f_V$XCAA\u0003!\ra\u0014qA\u0005\u0004\u0003\u0013i$\u0001\u0002'p]\u001e\f\u0001\u0002^5nK>,H\u000fI\u0001\u000bg\"\f'/\u001a'fm\u0016dWCAA\t!\u0011\t\u0019\"!\u000b\u000f\t\u0005U\u0011Q\u0005\b\u0005\u0003/\t\u0019C\u0004\u0003\u0002\u001a\u0005\u0005b\u0002BA\u000e\u0003?q1!UA\u000f\u0013\u0005I\u0014BA\u001c9\u0013\t)d'\u0003\u00024i%\u0019\u0011q\u0005\u001a\u0002\u0015MC\u0017M]3MKZ,G.\u0003\u0003\u0002,\u00055\"AC*iCJ,G*\u001a<fY*\u0019\u0011q\u0005\u001a\u0002\u0017MD\u0017M]3MKZ,G\u000eI\u0001\u000bK:<\u0017N\\3UsB,WCAA\u001b!\u0011\t9$!\u0010\u000f\t\u0005U\u0011\u0011H\u0005\u0004\u0003w\u0011\u0014AC#oO&tW\rV=qK&!\u0011qHA!\u0005))enZ5oKRK\b/\u001a\u0006\u0004\u0003w\u0011\u0014aC3oO&tW\rV=qK\u0002\nQ\u0002]8pYRC'/Z:i_2$WCAA%!\ra\u00141J\u0005\u0004\u0003\u001bj$aA%oi\u0006q\u0001o\\8m)\"\u0014Xm\u001d5pY\u0012\u0004\u0013AD2mS\u0016tG\u000fU8pYNK'0Z\u0001\u0010G2LWM\u001c;Q_>d7+\u001b>fA\u0005q1\r\\5f]R\u0004vn\u001c7OC6,\u0017aD2mS\u0016tG\u000fU8pY:\u000bW.\u001a\u0011\u00023\u0015tw-\u001b8f!>|G.S4o_J,7+\u001e2e_6\f\u0017N\\\u000b\u0003\u0003;\u00022\u0001PA0\u0013\r\t\t'\u0010\u0002\b\u0005>|G.Z1o\u0003i)gnZ5oKB{w\u000e\\%h]>\u0014XmU;cI>l\u0017-\u001b8!\u0003Y)gnZ5oKB{w\u000e\\*fY\u0016\u001cG\u000fU8mS\u000eL\u0018aF3oO&tW\rU8pYN+G.Z2u!>d\u0017nY=!\u0003aaujQ&`)&kUiT+U?N\u0003\u0016IT0G\u0003\u000e#vJU\u000b\u0003\u0003[\u00022\u0001PA8\u0013\r\t\t(\u0010\u0002\u0007\t>,(\r\\3\u000231{5iS0U\u00136+u*\u0016+`'B\u000bej\u0018$B\u0007R{%\u000bI\u0001\bEVLG\u000eZ3s+\t\tI\bE\u0002d\u0003wJ1!! 3\u0005-\u0001&o\\2Ck&dG-\u001a:\u0002\u0017\t,\u0018\u000e\u001c3fe~#S-\u001d\u000b\u0005\u0003\u0007\u000bI\tE\u0002=\u0003\u000bK1!a\">\u0005\u0011)f.\u001b;\t\u0013\u0005-U$!AA\u0002\u0005e\u0014a\u0001=%c\u0005A!-^5mI\u0016\u0014\b%\u0001\bhKR,enZ5oKJ+g-\u00133\u0015\u00039\u000bq!\u00199q+N,'/\u0001\u0005baB,6/\u001a:!\u0003%\u0019XO\u00193p[\u0006Lg.\u0001\u0006tk\n$w.\\1j]\u0002B3aIAO!\u0011\ty*!-\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000b1\"\u00198o_R\fG/[8og*!\u0011qUAU\u0003\u0019\u0019w.\\7p]*!\u00111VAW\u0003\u00199wn\\4mK*\u0011\u0011qV\u0001\u0004G>l\u0017\u0002BAZ\u0003C\u0013\u0011CV5tS\ndWMR8s)\u0016\u001cH/\u001b8h\u0003E!WMZ1vYR,enZ5oK:\u000bW.Z\u0001\u0013I\u00164\u0017-\u001e7u\u000b:<\u0017N\\3OC6,\u0007\u0005K\u0002&\u0003;\u000b1\"\u001a8hS:,7\u000b]1dK\"\u001aa%!(\u0002\u0017Q\u0014\u0018pV5uQ2{7m[\u000b\u0005\u0003\u0007\fY\r\u0006\u0003\u0002F\u0006\u001dH\u0003BAd\u0003;\u0004B!!3\u0002L2\u0001AaBAgO\t\u0007\u0011q\u001a\u0002\u0002)F!\u0011\u0011[Al!\ra\u00141[\u0005\u0004\u0003+l$a\u0002(pi\"Lgn\u001a\t\u0004y\u0005e\u0017bAAn{\t\u0019\u0011I\\=\t\u0011\u0005}w\u0005\"a\u0001\u0003C\f\u0011A\u001a\t\u0006y\u0005\r\u0018qY\u0005\u0004\u0003Kl$\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0005%x\u00051\u0001\u0002l\u0006yA-[:d_Z,'/_\"mS\u0016tG\u000f\u0005\u0003\u0002n\u0006]XBAAx\u0015\u0011\t\t0a=\u0002\r\rd\u0017.\u001a8u\u0015\r\t)\u0010N\u0001\u0003Q\u0006LA!!?\u0002p\nyA)[:d_Z,'/_\"mS\u0016tG/\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003\u007f\u0014)Aa\u0002\u0011\rq\u0012\tATA%\u0013\r\u0011\u0019!\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005%\b\u00061\u0001\u0002l\"9!\u0011\u0002\u0015A\u0002\t-\u0011AD3yiJ\fWI\\4j]\u0016dun\u001a\t\u0005y!\u0014i\u0001\u0005\u0003\u0003\u0010\teQB\u0001B\t\u0015\u0011\u0011\u0019B!\u0006\u0002\u00071|wMC\u0002\u0003\u0018Q\n\u0011b\u001c9fe\u0006$\u0018n\u001c8\n\t\tm!\u0011\u0003\u0002\r\u001fB,'/\u0019;j_:dunZ\u0001\fO\u0016$xJ]\"sK\u0006$X\r\u0006\u0004\u0002\u0000\n\u0005\"1\u0005\u0005\b\u0003SL\u0003\u0019AAv\u0011%\u0011I!\u000bI\u0001\u0002\u0004\u0011Y!A\u000bhKR|%o\u0011:fCR,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t%\"\u0006\u0002B\u0006\u0005WY#A!\f\u0011\t\t=\"\u0011H\u0007\u0003\u0005cQAAa\r\u00036\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005oi\u0014AC1o]>$\u0018\r^5p]&!!1\bB\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000bI\u0016\u0014XmZ5ti\u0016\u0014HCBAB\u0005\u0003\u0012\u0019\u0005C\u0004\u0002j.\u0002\r!a;\t\u000f\t\u00153\u00061\u0001\u0002\u0000\u0006A\u0001n\\:u!>\u0014H/A\u0003dY>\u001cX\r\u0006\u0002\u0002\u0004\u0006IQI\\4j]\u0016\u0014VM\u001a\t\u0003G:\u001a\"AL\u001e\u0015\u0005\t5\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0003X)\u001aqMa\u000b")
public class EngineRef
implements Logging {
    @VisibleForTesting
    private String engineSpace;
    private final KyuubiConf conf;
    private final String engineRefId;
    private final KyuubiApplicationManager engineManager;
    private final Option<Semaphore> startupProcessSemaphore;
    private final String serverSpace;
    private final long timeout;
    private final Enumeration.Value shareLevel;
    private final Enumeration.Value engineType;
    private final int poolThreshold;
    private final int clientPoolSize;
    private final String clientPoolName;
    private final boolean enginePoolIgnoreSubdomain;
    private final String enginePoolSelectPolicy;
    private final double LOCK_TIMEOUT_SPAN_FACTOR;
    private ProcBuilder builder;
    private final String appUser;
    @VisibleForTesting
    private final String subdomain;
    @VisibleForTesting
    private final String defaultEngineName;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Option<Semaphore> $lessinit$greater$default$6() {
        return EngineRef$.MODULE$.$lessinit$greater$default$6();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private String serverSpace() {
        return this.serverSpace;
    }

    private long timeout() {
        return this.timeout;
    }

    private Enumeration.Value shareLevel() {
        return this.shareLevel;
    }

    private Enumeration.Value engineType() {
        return this.engineType;
    }

    private int poolThreshold() {
        return this.poolThreshold;
    }

    private int clientPoolSize() {
        return this.clientPoolSize;
    }

    private String clientPoolName() {
        return this.clientPoolName;
    }

    private boolean enginePoolIgnoreSubdomain() {
        return this.enginePoolIgnoreSubdomain;
    }

    private String enginePoolSelectPolicy() {
        return this.enginePoolSelectPolicy;
    }

    private double LOCK_TIMEOUT_SPAN_FACTOR() {
        return this.LOCK_TIMEOUT_SPAN_FACTOR;
    }

    private ProcBuilder builder() {
        return this.builder;
    }

    private void builder_$eq(ProcBuilder x$1) {
        this.builder = x$1;
    }

    public String getEngineRefId() {
        return this.engineRefId;
    }

    public String appUser() {
        return this.appUser;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public String defaultEngineName() {
        return this.defaultEngineName;
    }

    private String engineSpace$lzycompute() {
        EngineRef engineRef = this;
        synchronized (engineRef) {
            if (!this.bitmap$0) {
                String commonParent = new StringBuilder(3).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).toString();
                Enumeration.Value value = this.shareLevel();
                Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
                Enumeration.Value value3 = value;
                this.engineSpace = !(value2 != null ? !value2.equals(value3) : value3 != null) ? DiscoveryPaths$.MODULE$.makePath(commonParent, this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.engineRefId})) : DiscoveryPaths$.MODULE$.makePath(commonParent, this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
                this.bitmap$0 = true;
            }
        }
        return this.engineSpace;
    }

    public String engineSpace() {
        if (!this.bitmap$0) {
            return this.engineSpace$lzycompute();
        }
        return this.engineSpace;
    }

    private <T> T tryWithLock(DiscoveryClient discoveryClient, Function0<T> f) {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (T)f.apply();
        }
        String lockPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(8).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_lock").toString(), this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
        return (T)discoveryClient.tryWithLock(lockPath, this.timeout() + (long)(this.LOCK_TIMEOUT_SPAN_FACTOR() * (double)this.timeout()), f);
    }

    private Tuple2<String, Object> create(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            tuple2 = (Tuple2)this.tryWithLock(discoveryClient, (Function0 & Serializable & scala.Serializable)() -> {
                boolean waitCompletion;
                boolean destroyProcess;
                Tuple2 tuple2;
                Logging logging;
                Option engineRef = discoveryClient.getServerHost(this.engineSpace());
                if (engineRef.nonEmpty()) {
                    throw new NonLocalReturnControl(object, engineRef.get());
                }
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_NAMESPACE(), (Object)this.engineSpace());
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID(), (Object)$this.engineRefId);
                long started = System.currentTimeMillis();
                $this.conf.set("kyuubi.engine.submit.time", String.valueOf(started));
                Enumeration.Value value = this.engineType();
                Enumeration.Value value2 = EngineType$.MODULE$.SPARK_SQL();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    $this.conf.setIfMissing("spark.app.name", this.defaultEngineName());
                    logging = new SparkProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                } else {
                    Enumeration.Value value4 = EngineType$.MODULE$.FLINK_SQL();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        $this.conf.setIfMissing("flink.app.name", this.defaultEngineName());
                        logging = new FlinkProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                    } else {
                        Enumeration.Value value6 = EngineType$.MODULE$.TRINO();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            logging = new TrinoProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                        } else {
                            Enumeration.Value value8 = EngineType$.MODULE$.HIVE_SQL();
                            Enumeration.Value value9 = value;
                            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                $this.conf.setIfMissing("hive.engine.name", this.defaultEngineName());
                                logging = new HiveProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                            } else {
                                Enumeration.Value value10 = EngineType$.MODULE$.JDBC();
                                Enumeration.Value value11 = value;
                                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                    logging = new JdbcProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                                } else {
                                    Enumeration.Value value12 = EngineType$.MODULE$.CHAT();
                                    Enumeration.Value value13 = value;
                                    if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                        logging = new ChatProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                                    } else {
                                        throw new MatchError((Object)value);
                                    }
                                }
                            }
                        }
                    }
                }
                this.builder_$eq((ProcBuilder)logging);
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.incCount(MetricsConstants$.MODULE$.ENGINE_TOTAL());
                    return BoxedUnit.UNIT;
                });
                boolean acquiredPermit = false;
                try {
                    if (!$this.startupProcessSemaphore.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.tryAcquire(this.timeout(), TimeUnit.MILLISECONDS)))) {
                        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$4 -> {
                            x$4.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                            return BoxedUnit.UNIT;
                        });
                        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(94).append("Timeout(").append(this.timeout()).append(" ms, you can modify ").append(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT().key()).append(" to change it) to").append(" acquires a permit from engine builder semaphore.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                    }
                    acquiredPermit = true;
                    String redactedCmd = this.builder().toString();
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Launching engine:\n").append(redactedCmd).toString());
                    this.builder().validateConf();
                    Process process = this.builder().start();
                    None$ exitValue = None$.MODULE$;
                    ObjectRef lastApplicationInfo = ObjectRef.create((Object)None$.MODULE$);
                    while (engineRef.isEmpty()) {
                        if (exitValue.isEmpty() && process.waitFor(1L, TimeUnit.SECONDS)) {
                            exitValue = new Some((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
                            if (exitValue.contains((Object)BoxesRunTime.boxToInteger((int)0))) {
                                acquiredPermit = false;
                                $this.startupProcessSemaphore.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                                    x$5.release();
                                    return BoxedUnit.UNIT;
                                });
                            } else {
                                Throwable error = this.builder().getError();
                                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                                    EngineRef.$anonfun$create$7(this, error, ms);
                                    return BoxedUnit.UNIT;
                                });
                                throw error;
                            }
                        }
                        if (started + this.timeout() <= System.currentTimeMillis()) {
                            Tuple2<Object, String> killMessage = $this.engineManager.killApplication(this.builder().appMgrInfo(), $this.engineRefId, (Option<String>)new Some((Object)this.appUser()));
                            this.builder().close(true);
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$6 -> {
                                x$6.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                                return BoxedUnit.UNIT;
                            });
                            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(70).append("Timeout(").append(this.timeout()).append(" ms, you can modify ").append(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT().key()).append(" to change it) to").append(" launched ").append(this.engineType()).append(" engine with ").append(redactedCmd).append(". ").append(killMessage).toString(), this.builder().getError(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                        }
                        engineRef = discoveryClient.getEngineByRefId(this.engineSpace(), $this.engineRefId);
                        if (!engineRef.isEmpty()) continue;
                        None$ none$ = exitValue;
                        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                        if (none$ != null ? !none$.equals(some) : some != null) continue;
                        Option$.MODULE$.apply((Object)$this.engineManager).foreach((Function1 & Serializable & scala.Serializable)engineMgr -> {
                            EngineRef.$anonfun$create$9(this, lastApplicationInfo, started, engineMgr);
                            return BoxedUnit.UNIT;
                        });
                    }
                    tuple2 = (Tuple2)engineRef.get();
                }
                catch (Throwable throwable) {
                    boolean waitCompletion2;
                    boolean destroyProcess2;
                    if (acquiredPermit) {
                        $this.startupProcessSemaphore.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                            x$7.release();
                            return BoxedUnit.UNIT;
                        });
                    }
                    boolean bl = destroyProcess2 = !(waitCompletion2 = BoxesRunTime.unboxToBoolean((Object)$this.conf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_STARTUP_WAIT_COMPLETION()))) && this.builder().isClusterMode();
                    if (destroyProcess2) {
                        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Destroy the builder process because waitCompletion is false and the engine is running in cluster mode.");
                    }
                    this.builder().close(destroyProcess2);
                    throw throwable;
                }
                if (acquiredPermit) {
                    $this.startupProcessSemaphore.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                        x$7.release();
                        return BoxedUnit.UNIT;
                    });
                }
                boolean bl = destroyProcess = !(waitCompletion = BoxesRunTime.unboxToBoolean((Object)$this.conf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_STARTUP_WAIT_COMPLETION()))) && this.builder().isClusterMode();
                if (destroyProcess) {
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Destroy the builder process because waitCompletion is false and the engine is running in cluster mode.");
                }
                this.builder().close(destroyProcess);
                return tuple2;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public Tuple2<String, Object> getOrCreate(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        return (Tuple2)discoveryClient.getServerHost(this.engineSpace()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.create(discoveryClient, extraEngineLog));
    }

    public Option<OperationLog> getOrCreate$default$2() {
        return None$.MODULE$;
    }

    public void deregister(DiscoveryClient discoveryClient, Tuple2<String, Object> hostPort) {
        this.tryWithLock(discoveryClient, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq = discoveryClient.getServiceNodesInfo(this.engineSpace(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), true);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                ServiceNodeInfo sn = (ServiceNodeInfo)((SeqLike)some.get()).apply(0);
                Tuple2 tuple2 = new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port()));
                Tuple2 tuple22 = hostPort;
                if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Deleting engine node:").append(sn).toString());
                    discoveryClient.delete(new StringBuilder(1).append(this.engineSpace()).append("/").append(sn.nodeName()).toString(), discoveryClient.delete$default$2());
                    return;
                }
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Engine node:").append(sn).append(" is not matched with host&port[").append(hostPort).append("]").toString());
                return;
            }
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("No engine node found in ").append(this.engineSpace()).toString());
        });
    }

    public void close() {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        if (!(value != null ? !value.equals(value2) : value2 != null) && this.builder() != null) {
            try {
                ApplicationManagerInfo appMgrInfo = this.builder().appMgrInfo();
                this.builder().close(true);
                this.engineManager.killApplication(appMgrInfo, this.engineRefId, (Option<String>)new Some((Object)this.appUser()));
            }
            catch (Exception e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error closing engine builder, engineRefId: ").append($this.engineRefId).toString(), e);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$create$7(EngineRef $this, Throwable error$1, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{error$1.getClass().getSimpleName()}));
    }

    public static final /* synthetic */ void $anonfun$create$11(EngineRef $this, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{"ENGINE_TERMINATE"}));
    }

    public static final /* synthetic */ void $anonfun$create$10(EngineRef $this, ApplicationInfo appInfo) {
        if (ApplicationState$.MODULE$.isTerminated(appInfo.state())) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                EngineRef.$anonfun$create$11($this, ms);
                return BoxedUnit.UNIT;
            });
            throw new KyuubiSQLException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(158).append("\n                     |The engine application has been terminated. Please check the engine log.\n                     |ApplicationInfo: ").append(appInfo.toMap().mkString("(\n", ",\n", "\n)")).append("\n                     |").toString())).stripMargin(), $this.builder().getError());
        }
    }

    public static final /* synthetic */ void $anonfun$create$9(EngineRef $this, ObjectRef lastApplicationInfo$1, long started$1, KyuubiApplicationManager engineMgr) {
        if (((Option)lastApplicationInfo$1.elem).isDefined()) {
            TimeUnit.SECONDS.sleep(1L);
        }
        Option<ApplicationInfo> applicationInfo = engineMgr.getApplicationInfo($this.builder().appMgrInfo(), $this.engineRefId, (Option<String>)new Some((Object)$this.appUser()), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)started$1)));
        applicationInfo.foreach((Function1 & Serializable & scala.Serializable)appInfo -> {
            EngineRef.$anonfun$create$10($this, appInfo);
            return BoxedUnit.UNIT;
        });
        lastApplicationInfo$1.elem = applicationInfo;
    }

    public EngineRef(KyuubiConf conf, String user, GroupProvider groupProvider, String engineRefId, KyuubiApplicationManager engineManager, Option<Semaphore> startupProcessSemaphore) {
        String string;
        String string2;
        this.conf = conf;
        this.engineRefId = engineRefId;
        this.engineManager = engineManager;
        this.startupProcessSemaphore = startupProcessSemaphore;
        Logging.$init$((Logging)this);
        this.serverSpace = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE());
        this.timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.shareLevel = ShareLevel$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
        this.engineType = EngineType$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()));
        this.poolThreshold = BoxesRunTime.unboxToInt((Object)((KyuubiConf)Option$.MODULE$.apply((Object)KyuubiServer$.MODULE$.kyuubiServer()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getConf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1()))).get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE_THRESHOLD()));
        this.clientPoolSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE()));
        this.clientPoolName = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_NAME());
        this.enginePoolIgnoreSubdomain = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_IGNORE_SUBDOMAIN()));
        this.enginePoolSelectPolicy = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SELECT_POLICY());
        this.LOCK_TIMEOUT_SPAN_FACTOR = Utils$.MODULE$.isTesting() ? 0.5 : 0.1;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.SERVER();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string2 = Utils$.MODULE$.currentUser();
        } else {
            Enumeration.Value value4 = ShareLevel$.MODULE$.GROUP();
            Enumeration.Value value5 = value;
            string2 = !(value4 != null ? !value4.equals(value5) : value5 != null) ? groupProvider.primaryGroup(user, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)conf.getAll()).asJava()) : user;
        }
        this.appUser = string2;
        Option option = (Option)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN());
        if (this.clientPoolSize() > 0 && (option.isEmpty() || this.enginePoolIgnoreSubdomain())) {
            int n;
            String string3;
            int poolSize = scala.math.package$.MODULE$.min(this.clientPoolSize(), this.poolThreshold());
            if (poolSize < this.clientPoolSize()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Request engine pool size(").append(this.clientPoolSize()).append(") exceeds, fallback to ").append("system threshold ").append(this.poolThreshold()).toString());
            }
            if ("POLLING".equals(string3 = this.enginePoolSelectPolicy())) {
                String snPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(10).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_seqNum").toString(), this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.clientPoolName()}));
                n = BoxesRunTime.unboxToInt((Object)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(conf, (Function1 & Serializable & scala.Serializable)client -> BoxesRunTime.boxToInteger((int)client.getAndIncrement(snPath, client.getAndIncrement$default$2()))));
            } else if ("RANDOM".equals(string3)) {
                n = Random$.MODULE$.nextInt(poolSize);
            } else {
                throw new MatchError((Object)string3);
            }
            int seqNum = n;
            string = new StringBuilder(1).append(this.clientPoolName()).append("-").append(seqNum % poolSize).toString();
        } else if (option instanceof Some) {
            String _subdomain;
            Some some = (Some)option;
            string = _subdomain = (String)some.value();
        } else {
            string = "default";
        }
        this.subdomain = string;
        String commonNamePrefix = new StringBuilder(9).append("kyuubi_").append(this.shareLevel()).append("_").append(this.engineType()).append("_").append(this.appUser()).toString();
        Enumeration.Value value6 = this.shareLevel();
        Enumeration.Value value7 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value8 = value6;
        this.defaultEngineName = !(value7 != null ? !value7.equals(value8) : value8 != null) ? new StringBuilder(1).append(commonNamePrefix).append("_").append(engineRefId).toString() : new StringBuilder(2).append(commonNamePrefix).append("_").append(this.subdomain()).append("_").append(engineRefId).toString();
    }
}

