/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.KyuubiRestFrontendService$;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.v1.ApiRootResource$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.KyuubiHttpAuthenticationFactory;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.ui.JettyServer;
import org.apache.kyuubi.server.ui.JettyServer$;
import org.apache.kyuubi.server.ui.JettyUtils$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.authentication.AuthMethods$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.KyuubiAuthenticationFactory$;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.util.ThreadUtils$;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0011#\u0001-B\u0001B\r\u0001\u0003\u0006\u0004%\te\r\u0005\to\u0001\u0011\t\u0011)A\u0005i!)\u0001\b\u0001C\u0001s!I1\u0005\u0001a\u0001\u0002\u0004%I!\u0010\u0005\n\t\u0002\u0001\r\u00111A\u0005\n\u0015C\u0011B\u0014\u0001A\u0002\u0003\u0005\u000b\u0015\u0002 \t\u000f=\u0003!\u0019!C\u0005!\"1Q\f\u0001Q\u0001\nECQA\u0018\u0001\u0005\n}Ca\u0001\u001b\u0001\u0005\u0002\u0011J\u0007b\u00029\u0001\u0005\u0004%I!\u001d\u0005\u0007m\u0002\u0001\u000b\u0011\u0002:\t\u0011]\u0004\u0001R1A\u0005\u0002aD!\"!\u0003\u0001\u0011\u000b\u0007I\u0011BA\u0006\u0011)\t\u0019\u0002\u0001EC\u0002\u0013%\u0011Q\u0003\u0005\u000b\u0003;\u0001\u0001R1A\u0005\n\u0005}\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u0019\t\t\u0005\u0001C!q\"9\u00111\t\u0001\u0005\n\u0005\u0015\u0003bBA$\u0001\u0011%\u0011Q\t\u0005\b\u0003\u0013\u0002A\u0011BA#\u0011!\tY\u0005\u0001C\u0001I\u0005\u0015\u0003bBA4\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003S\u0002A\u0011IA#\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!a\u001c\u0001\t\u0003\t\t\bC\u0004\u0002p\u0001!\t!a\u001e\t\r\u0005\r\u0005\u0001\"\u0001y\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fC\u0011\"a%\u0001\u0005\u0004%\t%!&\t\u0011\u0005\r\u0006\u0001)A\u0005\u0003/\u0013\u0011dS=vk\nL'+Z:u\rJ|g\u000e^3oIN+'O^5dK*\u00111\u0005J\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u00152\u0013AB6zkV\u0014\u0017N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0002\"!\f\u0019\u000e\u00039R!a\f\u0013\u0002\u000fM,'O^5dK&\u0011\u0011G\f\u0002\u0018\u0003\n\u001cHO]1di\u001a\u0013xN\u001c;f]\u0012\u001cVM\u001d<jG\u0016\f!b]3sm\u0016\u0014\u0018M\u00197f+\u0005!\u0004CA\u00176\u0013\t1dF\u0001\u0006TKJ4XM]1cY\u0016\f1b]3sm\u0016\u0014\u0018M\u00197fA\u00051A(\u001b8jiz\"\"A\u000f\u001f\u0011\u0005m\u0002Q\"\u0001\u0012\t\u000bI\u001a\u0001\u0019\u0001\u001b\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0012\u0002\u0005UL\u0017BA\"A\u0005-QU\r\u001e;z'\u0016\u0014h/\u001a:\u0002\u0015M,'O^3s?\u0012*\u0017\u000f\u0006\u0002G\u0019B\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n!QK\\5u\u0011\u001diU!!AA\u0002y\n1\u0001\u001f\u00132\u0003\u001d\u0019XM\u001d<fe\u0002\n\u0011\"[:Ti\u0006\u0014H/\u001a3\u0016\u0003E\u0003\"AU.\u000e\u0003MS!\u0001V+\u0002\r\u0005$x.\\5d\u0015\t1v+\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001W-\u0002\tU$\u0018\u000e\u001c\u0006\u00025\u0006!!.\u0019<b\u0013\ta6KA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000bSN\u001cF/\u0019:uK\u0012\u0004\u0013A\u00035bI>|\u0007oQ8oMV\t\u0001\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006!1m\u001c8g\u0015\t)g%\u0001\u0004iC\u0012|w\u000e]\u0005\u0003O\n\u0014QbQ8oM&<WO]1uS>t\u0017AD:fgNLwN\\'b]\u0006<WM]\u000b\u0002UB\u00111N\\\u0007\u0002Y*\u0011Q\u000eJ\u0001\bg\u0016\u001c8/[8o\u0013\tyGN\u0001\u000bLsV,(-[*fgNLwN\\'b]\u0006<WM]\u0001\rE\u0006$8\r[\"iK\u000e\\WM]\u000b\u0002eB\u00111\u000f^\u0007\u0002+&\u0011Q/\u0016\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!\u00042bi\u000eD7\t[3dW\u0016\u0014\b%\u0001\u0003i_N$X#A=\u0011\u0007i\f\u0019A\u0004\u0002|\u007fB\u0011A\u0010S\u0007\u0002{*\u0011aPK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005\u0001*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\t9A\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003A\u0015\u0001\u00029peR,\"!!\u0004\u0011\u0007\u001d\u000by!C\u0002\u0002\u0012!\u00131!\u00138u\u0003=\u0019XmY;sSRLXI\\1cY\u0016$WCAA\f!\r9\u0015\u0011D\u0005\u0004\u00037A%a\u0002\"p_2,\u0017M\\\u0001\u000fC\u0012l\u0017N\\5tiJ\fGo\u001c:t+\t\t\t\u0003\u0005\u0003{\u0003GI\u0018\u0002BA\u0013\u0003\u000f\u00111aU3u\u0003=I7/\u00113nS:L7\u000f\u001e:bi>\u0014H\u0003BA\f\u0003WAa!!\f\u0012\u0001\u0004I\u0018\u0001C;tKJt\u0015-\\3\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0002G\u0003gAaa\u0019\nA\u0002\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mB%\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003\u007f\tID\u0001\u0006LsV,(-[\"p]\u001a\fQbY8o]\u0016\u001cG/[8o+Jd\u0017!D:uCJ$\u0018J\u001c;fe:\fG\u000eF\u0001G\u00031Ign\u001d;bY2<VMY+J\u0003E\u0019H/\u0019:u\u0005\u0006$8\r[\"iK\u000e\\WM]\u0001\u0015e\u0016\u001cwN^3s\u0005\u0006$8\r[*fgNLwN\\:)\u0007]\ty\u0005\u0005\u0003\u0002R\u0005\rTBAA*\u0015\u0011\t)&a\u0016\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0005\u00033\nY&\u0001\u0004d_6lwN\u001c\u0006\u0005\u0003;\ny&\u0001\u0004h_><G.\u001a\u0006\u0003\u0003C\n1aY8n\u0013\u0011\t)'a\u0015\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw-A\u0003ti\u0006\u0014H/\u0001\u0003ti>\u0004\u0018aC4fiJ+\u0017\r\\+tKJ$\u0012!_\u0001\u000fO\u0016$8+Z:tS>tWk]3s)\rI\u00181\u000f\u0005\u0007\u0003kZ\u0002\u0019A=\u0002\u0019!\u001c(\u0007\u0015:pqf,6/\u001a:\u0015\u0007e\fI\bC\u0004\u0002|q\u0001\r!! \u0002\u0017M,7o]5p]\u000e{gN\u001a\t\u0006u\u0006}\u00140_\u0005\u0005\u0003\u0003\u000b9AA\u0002NCB\fAbZ3u\u0013B\fE\r\u001a:fgN\fAbZ3u!J|\u00070_+tKJ$r!_AE\u0003\u0017\u000by\tC\u0004\u0002|y\u0001\r!! \t\r\u00055e\u00041\u0001z\u0003%I\u0007/\u00113ee\u0016\u001c8\u000f\u0003\u0004\u0002\u0012z\u0001\r!_\u0001\te\u0016\fG.V:fe\u0006\u0001B-[:d_Z,'/_*feZL7-Z\u000b\u0003\u0003/\u0003RaRAM\u0003;K1!a'I\u0005\u0019y\u0005\u000f^5p]B\u0019Q&a(\n\u0007\u0005\u0005fFA\u0004TKJ4\u0018nY3\u0002#\u0011L7oY8wKJL8+\u001a:wS\u000e,\u0007\u0005")
public class KyuubiRestFrontendService
extends AbstractFrontendService {
    private String host;
    private int port;
    private boolean securityEnabled;
    private Set<String> administrators;
    private final Serverable serverable;
    private JettyServer server;
    private final AtomicBoolean isStarted;
    private final ScheduledExecutorService batchChecker;
    private final Option<Service> discoveryService;
    private volatile byte bitmap$0;

    public Serverable serverable() {
        return this.serverable;
    }

    private JettyServer server() {
        return this.server;
    }

    private void server_$eq(JettyServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean isStarted() {
        return this.isStarted;
    }

    private Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    public KyuubiSessionManager sessionManager() {
        return (KyuubiSessionManager)this.be().sessionManager();
    }

    private ScheduledExecutorService batchChecker() {
        return this.batchChecker;
    }

    private String host$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.host = (String)((Option)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_HOST())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    if (Utils$.MODULE$.isWindows() || Utils$.MODULE$.isMac()) {
                        this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Kyuubi Server run in Windows or Mac environment, binding ").append(this.getName()).append(" to 0.0.0.0").toString());
                        return "0.0.0.0";
                    }
                    if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_CONNECTION_URL_USE_HOSTNAME()))) {
                        return Utils$.MODULE$.findLocalInetAddress().getCanonicalHostName();
                    }
                    return Utils$.MODULE$.findLocalInetAddress().getHostAddress();
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.host;
    }

    public String host() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.host$lzycompute();
        }
        return this.host;
    }

    private int port$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.port = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_PORT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.port;
    }

    private int port() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.port$lzycompute();
        }
        return this.port;
    }

    private boolean securityEnabled$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Set authTypes = (Set)((SetLike)this.conf().get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).map((Function1 & Serializable & scala.Serializable)s -> AuthTypes$.MODULE$.withName(s), Set$.MODULE$.canBuildFrom());
                Enumeration.Value value = KyuubiAuthenticationFactory$.MODULE$.getValidPasswordAuthMethod(authTypes);
                Enumeration.Value value2 = AuthMethods$.MODULE$.NONE();
                this.securityEnabled = value == null ? value2 != null : !value.equals(value2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.securityEnabled;
    }

    private boolean securityEnabled() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.securityEnabled$lzycompute();
        }
        return this.securityEnabled;
    }

    private Set<String> administrators$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.administrators = (Set)((SetLike)this.conf().get(KyuubiConf$.MODULE$.SERVER_ADMINISTRATORS())).$plus((Object)Utils$.MODULE$.currentUser());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.administrators;
    }

    private Set<String> administrators() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.administrators$lzycompute();
        }
        return this.administrators;
    }

    public boolean isAdministrator(String userName) {
        if (this.securityEnabled()) {
            return this.administrators().contains((Object)userName);
        }
        return true;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.server_$eq(JettyServer$.MODULE$.apply(this.getName(), this.host(), this.port(), BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_MAX_WORKER_THREADS()))));
        super.initialize(conf);
    }

    public String connectionUrl() {
        this.checkInitialized();
        Option option = (Option)this.conf().get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_ADVERTISED_HOST());
        if (option instanceof Some) {
            Some some = (Some)option;
            String advertisedHost = (String)some.value();
            return new StringBuilder(1).append(advertisedHost).append(":").append(this.port()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return this.server().getServerUri();
        }
        throw new MatchError((Object)option);
    }

    private void startInternal() {
        ServletContextHandler contextHandler = ApiRootResource$.MODULE$.getServletHandler(this);
        FilterHolder holder = new FilterHolder((Filter)new AuthenticationFilter(this.conf()));
        contextHandler.addFilter(holder, "/v1/*", EnumSet.allOf(DispatcherType.class));
        KyuubiHttpAuthenticationFactory authenticationFactory = new KyuubiHttpAuthenticationFactory(this.conf());
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)contextHandler));
        ServletContextHandler proxyHandler = ApiRootResource$.MODULE$.getEngineUIProxyHandler(this);
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)proxyHandler));
        this.installWebUI();
    }

    private void installWebUI() {
        this.server().addRedirectHandler("/", "/ui");
        ServletContextHandler servletHandler = JettyUtils$.MODULE$.createStaticHandler("dist", "/ui");
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(404, "/");
        servletHandler.setErrorHandler((ErrorHandler)errorHandler);
        this.server().addHandler((Handler)servletHandler);
    }

    private void startBatchChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_CHECK_INTERVAL()));
        Runnable task = new Runnable(this){
            private final /* synthetic */ KyuubiRestFrontendService $outer;

            public void run() {
                try {
                    this.$outer.sessionManager().getPeerInstanceClosedBatchSessions(this.$outer.connectionUrl()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        $anon$1.$anonfun$run$1(this, batch);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable e) {
                    this.$outer.error((Function0 & Serializable & scala.Serializable)() -> "Error checking batch sessions", e);
                }
            }

            public static final /* synthetic */ void $anonfun$run$3(KyuubiBatchSession x$1) {
                x$1.close();
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, Metadata batch) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    SessionHandle sessionHandle = SessionHandle$.MODULE$.fromUUID(batch.identifier());
                    $this.$outer.sessionManager().getBatchSession(sessionHandle).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anon$1.$anonfun$run$3(x$1);
                        return BoxedUnit.UNIT;
                    });
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata ), $anonfun$run$4(), $anonfun$run$3$adapted(org.apache.kyuubi.session.KyuubiBatchSession ), $anonfun$run$2(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata )}, serializedLambda);
            }
        };
        this.batchChecker().scheduleWithFixedDelay(task, interval, interval, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public void recoverBatchSessions() {
        int recoveryNumThreads = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_RECOVERY_THREADS()));
        ThreadPoolExecutor batchRecoveryExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(recoveryNumThreads, "batch-recovery-executor");
        try {
            Seq<KyuubiBatchSession> batchSessionsToRecover = this.sessionManager().getBatchSessionsToRecover(this.connectionUrl());
            AtomicInteger pendingRecoveryTasksCount = new AtomicInteger(0);
            Seq tasks = (Seq)batchSessionsToRecover.flatMap((Function1 & Serializable & scala.Serializable)batchSession -> {
                Iterable iterable;
                String batchId = batchSession.batchJobSubmissionOp().batchId();
                try {
                    Future<Object> task = batchRecoveryExecutor.submit(() -> {
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sessionManager().openBatchSession(batchSession));
                        return BoxedUnit.UNIT;
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(task), (Object)batchId)));
                }
                catch (Throwable e) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error while submitting batch[").append(batchId).append("] for recovery").toString(), e);
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
            pendingRecoveryTasksCount.addAndGet(tasks.size());
            tasks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KyuubiRestFrontendService.$anonfun$recoverBatchSessions$5(this, pendingRecoveryTasksCount, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)batchRecoveryExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
        }
    }

    public synchronized void start() {
        if (!this.isStarted().get()) {
            try {
                this.server().start();
                this.isStarted().set(true);
                this.startBatchChecker();
                this.startInternal();
                while (true) {
                    String string = this.server().getState();
                    String string2 = "STARTED";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break;
                    this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Waiting for ").append(this.getName()).append("'s HTTP server getting started").toString());
                    Thread.sleep(1000L);
                }
                this.recoverBatchSessions();
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(13).append("Cannot start ").append(this.getName()).toString(), (Throwable)e);
            }
        }
        super.start();
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Exposing REST endpoint at: http://").append(this.server().getServerUri()).toString());
    }

    public synchronized void stop() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.batchChecker(), ThreadUtils$.MODULE$.shutdown$default$2());
        if (this.isStarted().getAndSet(false)) {
            this.server().stop();
        }
        super.stop();
    }

    public String getRealUser() {
        return ServiceUtils$.MODULE$.getShortName((String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserName()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getRealUser$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous"));
    }

    public String getSessionUser(String hs2ProxyUser) {
        Map sessionConf = (Map)Option$.MODULE$.apply((Object)hs2ProxyUser).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getSessionUser$1(x$3))).map((Function1 & Serializable & scala.Serializable)proxyUser -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiAuthenticationFactory$.MODULE$.HS2_PROXY_USER()), proxyUser)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return this.getSessionUser((Map<String, String>)sessionConf);
    }

    public String getSessionUser(Map<String, String> sessionConf) {
        String string;
        String ipAddress = AuthenticationFilter$.MODULE$.getUserIpAddress();
        String realUser = this.getRealUser();
        try {
            string = this.getProxyUser(sessionConf, ipAddress, realUser);
        }
        catch (Throwable t) {
            throw new WebApplicationException(t.getMessage(), Response.Status.METHOD_NOT_ALLOWED);
        }
        return string;
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuthenticationFilter$.MODULE$.getUserIpAddress());
    }

    private String getProxyUser(Map<String, String> sessionConf, String ipAddress, String realUser) {
        if (sessionConf == null) {
            return realUser;
        }
        return (String)sessionConf.get((Object)KyuubiAuthenticationFactory$.MODULE$.HS2_PROXY_USER()).map((Function1 & Serializable & scala.Serializable)proxyUser -> {
            block0: {
                if (this.isAdministrator(realUser)) break block0;
                KyuubiAuthenticationFactory$.MODULE$.verifyProxyAccess(realUser, proxyUser, ipAddress, this.hadoopConf());
            }
            return proxyUser;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> realUser);
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    public static final /* synthetic */ void $anonfun$recoverBatchSessions$5(KyuubiRestFrontendService $this, AtomicInteger pendingRecoveryTasksCount$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Future task = (Future)tuple2._1();
            String batchId = (String)tuple2._2();
            try {
                BoxedUnit boxedUnit;
                try {
                    boxedUnit = (BoxedUnit)task.get();
                }
                catch (Throwable e) {
                    $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error while recovering batch[").append(batchId).append("]").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                int pendingTasks = pendingRecoveryTasksCount$1.decrementAndGet();
                $this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Batch[").append(batchId).append("] recovery task terminated, current pending tasks ").append(pendingTasks).toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getRealUser$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getSessionUser$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public KyuubiRestFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiRestFrontendService");
        this.isStarted = new AtomicBoolean(false);
        this.batchChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("batch-checker", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.discoveryService = None$.MODULE$;
    }
}

