/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BackwardsCompatibilityInterceptor
implements Interceptor {
    public static final String NAME = "BACKWARDS";
    private static final int API_GROUP = 1;
    private static final int API_VERSION = 2;
    private static final int PATH = 3;
    private static final String PATCH = "patch";
    private static final String NAME_REGEX = "[a-z0-9\\-\\.]+";
    private static final Pattern URL_PATTERN = Pattern.compile("[^ ]+/apis/([a-z0-9\\-\\.]+)/([a-z0-9\\-\\.]+)/([a-z0-9\\-\\.]+)[^ ]*");
    private static final Pattern NAMESPACED_URL_PATTERN = Pattern.compile("[^ ]+/apis/([a-z0-9\\-\\.]+)/([a-z0-9\\-\\.]+)/namespaces/[a-z0-9\\-\\.]+/([a-z0-9\\-\\.]+)[^ ]*");
    private static final Map<ResourceKey, ResourceKey> notFoundTransformations = new HashMap<ResourceKey, ResourceKey>();
    private static final Map<ResourceKey, ResourceKey> badRequestTransformations = new HashMap<ResourceKey, ResourceKey>();
    private static final Map<String, ResourceKey> openshiftOAPITransformations = new HashMap<String, ResourceKey>();
    private static final Map<Integer, Map<ResourceKey, ResourceKey>> responseCodeToTransformations = new HashMap<Integer, Map<ResourceKey, ResourceKey>>();

    @Override
    public boolean afterFailure(HttpRequest.Builder builder, HttpResponse<?> response) {
        Object object;
        ResourceKey target = this.findNewTarget(builder, response);
        if (target == null) {
            return false;
        }
        HttpRequest request = response.request();
        if (request.bodyString() != null && !request.method().equalsIgnoreCase(PATCH) && (object = Serialization.unmarshal(request.bodyString())) instanceof HasMetadata) {
            HasMetadata h = (HasMetadata)object;
            h.setApiVersion(target.group + "/" + target.version);
            switch (request.method()) {
                case "POST": {
                    builder.post("application/json", Serialization.asJson(h));
                    break;
                }
                case "PUT": {
                    builder.put("application/json", Serialization.asJson(h));
                    break;
                }
                case "DELETE": {
                    builder.delete("application/json", Serialization.asJson(h));
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public ResourceKey findNewTarget(BasicBuilder basicBuilder, HttpResponse<?> response) {
        HttpRequest request = response.request();
        if (BackwardsCompatibilityInterceptor.isDeprecatedOpenshiftOapiRequest(request)) {
            return BackwardsCompatibilityInterceptor.handleOpenshiftOapiRequests(basicBuilder, request, response);
        }
        if (!response.isSuccessful() && responseCodeToTransformations.keySet().contains(response.code())) {
            String url = request.uri().toString();
            Matcher matcher = BackwardsCompatibilityInterceptor.getMatcher(url);
            ResourceKey key = BackwardsCompatibilityInterceptor.getKey(matcher);
            ResourceKey target = responseCodeToTransformations.get(response.code()).get(key);
            if (target != null) {
                String newUrl = new StringBuilder(url).replace(matcher.start(2), matcher.end(2), target.version).replace(matcher.start(1), matcher.end(1), target.group).toString();
                basicBuilder.uri(URI.create(newUrl));
                return target;
            }
        }
        return null;
    }

    @Override
    public boolean afterFailure(BasicBuilder basicBuilder, HttpResponse<?> response) {
        return this.findNewTarget(basicBuilder, response) != null;
    }

    private static Matcher getMatcher(String url) {
        Matcher m = NAMESPACED_URL_PATTERN.matcher(url);
        if (m.matches()) {
            return m;
        }
        m = URL_PATTERN.matcher(url);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    private static ResourceKey getKey(Matcher m) {
        return m != null ? new ResourceKey(null, m.group(3), m.group(1), m.group(2)) : null;
    }

    private static ResourceKey handleOpenshiftOapiRequests(BasicBuilder builder, HttpRequest request, HttpResponse<?> response) {
        String requestUrl;
        String[] parts;
        String resourcePath;
        ResourceKey target;
        if (!response.isSuccessful() && response.code() == 404 && (target = openshiftOAPITransformations.get(resourcePath = (parts = (requestUrl = request.uri().toString()).split("/"))[parts.length - 1])) != null) {
            requestUrl = requestUrl.replace("/oapi", "/apis/" + target.getGroup());
            builder.uri(URI.create(requestUrl));
            return target;
        }
        return null;
    }

    private static boolean isDeprecatedOpenshiftOapiRequest(HttpRequest request) {
        return request.uri().toString().contains("oapi");
    }

    static {
        notFoundTransformations.put(new ResourceKey("Deployment", "deployments", "apps", "v1"), new ResourceKey("Deployment", "deployments", "extensions", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("StatefulSet", "statefulsets", "apps", "v1"), new ResourceKey("StatefulSet", "statefulsets", "apps", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("DaemonSets", "daemonsets", "apps", "v1"), new ResourceKey("DaemonSet", "daemonsets", "extensions", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("ReplicaSets", "replicasets", "apps", "v1"), new ResourceKey("ReplicaSet", "replicasets", "extensions", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("NetworkPolicy", "networkpolicies", "networking.k8s.io", "v1"), new ResourceKey("NetworkPolicy", "networkpolicies", "extensions", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("StorageClass", "storageclasses", "storage.k8s.io", "v1"), new ResourceKey("StorageClass", "storageclasses", "extensions", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("RoleBinding", "rolebindings", "rbac.authorization.k8s.io", "v1"), new ResourceKey("RoleBinding", "rolebindings", "rbac.authorization.k8s.io", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("Role", "roles", "rbac.authorization.k8s.io", "v1"), new ResourceKey("Role", "roles", "rbac.authorization.k8s.io", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("ClusterRoleBinding", "clusterrolebindings", "rbac.authorization.k8s.io", "v1"), new ResourceKey("ClusterRoleBinding", "clusterrolebindings", "rbac.authorization.k8s.io", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("ClusterRole", "clusterroles", "rbac.authorization.k8s.io", "v1"), new ResourceKey("ClusterRole", "clusterroles", "rbac.authorization.k8s.io", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("CronJob", "cronjobs", "batch", "v1beta1"), new ResourceKey("CronJob", "cronjob", "batch", "v2alpha1"));
        notFoundTransformations.put(new ResourceKey("Template", "template", "", "v1"), new ResourceKey("Template", "template", "template.openshift.io", "v1"));
        badRequestTransformations.put(new ResourceKey("Deployment", "deployments", "apps", "v1beta1"), new ResourceKey("Deployment", "deployments", "extensions", "v1beta1"));
        responseCodeToTransformations.put(400, badRequestTransformations);
        responseCodeToTransformations.put(404, notFoundTransformations);
        openshiftOAPITransformations.put("routes", new ResourceKey("Route", "routes", "route.openshift.io", "v1"));
        openshiftOAPITransformations.put("templates", new ResourceKey("Template", "templates", "template.openshift.io", "v1"));
        openshiftOAPITransformations.put("buildconfigs", new ResourceKey("BuildConfig", "buildconfigs", "build.openshift.io", "v1"));
        openshiftOAPITransformations.put("deploymentconfigs", new ResourceKey("DeploymentConfig", "deploymentconfigs", "apps.openshift.io", "v1"));
        openshiftOAPITransformations.put("imagestreams", new ResourceKey("ImageStream", "imagestreams", "image.openshift.io", "v1"));
        openshiftOAPITransformations.put("imagestreamtags", new ResourceKey("ImageStream", "imagestreamtags", "image.openshift.io", "v1"));
        openshiftOAPITransformations.put("securitycontextconstraints", new ResourceKey("SecurityContextConstraints", "securitycontextconstraints", "security.openshift.io", "v1"));
    }

    private static class ResourceKey {
        private final String kind;
        private final String path;
        private final String group;
        private final String version;

        public ResourceKey(String kind, String path, String group, String version) {
            this.kind = kind;
            this.path = path;
            this.group = group;
            this.version = version;
        }

        public String getKind() {
            return this.kind;
        }

        public String getPath() {
            return this.path;
        }

        public String getGroup() {
            return this.group;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceKey key = (ResourceKey)o;
            return Objects.equals(this.path, key.path) && Objects.equals(this.group, key.group) && Objects.equals(this.version, key.version);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.group, this.version);
        }
    }
}

