/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.operation.log;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TStringColumn;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.operation.log.SeekableBufferedReader;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.util.ThriftUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mx!\u0002\u0013&\u0011\u0003\u0001d!\u0002\u001a&\u0011\u0003\u0019\u0004\"\u0002 \u0002\t\u0003y\u0004b\u0002!\u0002\u0005\u0004%i!\u0011\u0005\b\u0003s\u000b\u0001\u0015!\u0004C\u0011\u001d\tY,\u0001C\u0001\u0003{Cq!a1\u0002\t\u0003\t)\rC\u0004\u0002N\u0006!\t!a\u0014\t\u000f\u0005=\u0017\u0001\"\u0001\u0002R\"9\u0011\u0011]\u0001\u0005\u0002\u0005\rh\u0001\u0002\u001a&\u0001-C\u0001\u0002\u0014\u0006\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006})!\t!\u0016\u0005\t/*A)\u0019!C\u00051\"AqL\u0003EC\u0002\u0013%\u0001\rC\u0004e\u0015\u0001\u0007I\u0011B3\t\u000f%T\u0001\u0019!C\u0005U\"1\u0001O\u0003Q!\n\u0019D\u0001\"\u001e\u0006\t\u0006\u0004%IA\u001e\u0005\n\u007f*A)\u0019!C\u0005\u0003\u0003A\u0011\"!\u0002\u000b\u0001\u0004%I!a\u0002\t\u0013\u0005=!\u00021A\u0005\n\u0005E\u0001\u0002CA\u000b\u0015\u0001\u0006K!!\u0003\t\u0017\u0005]!\u00021AA\u0002\u0013%\u0011\u0011\u0004\u0005\f\u0003CQ\u0001\u0019!a\u0001\n\u0013\t\u0019\u0003C\u0006\u0002()\u0001\r\u0011!Q!\n\u0005m\u0001bBA\u0015\u0015\u0011\u0005\u00111\u0006\u0005\b\u0003_QA\u0011AA\u0019\u0011!\tiE\u0003C\u0001K\u0005=\u0003bBA)\u0015\u0011%\u00111\u000b\u0005\b\u0003cRA\u0011BA:\u0011\u001d\t9J\u0003C\u0001\u00033Cq!a&\u000b\t\u0003\ti\nC\u0004\u0002(*!\t!a\u0014\t\u000f\u0005%&\u0002\"\u0003\u0002,\"9\u0011q\u0017\u0006\u0005\n\u0005=\u0013\u0001D(qKJ\fG/[8o\u0019><'B\u0001\u0014(\u0003\rawn\u001a\u0006\u0003Q%\n\u0011b\u001c9fe\u0006$\u0018n\u001c8\u000b\u0005)Z\u0013AB6zkV\u0014\u0017N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7\u0001\u0001\t\u0003c\u0005i\u0011!\n\u0002\r\u001fB,'/\u0019;j_:dunZ\n\u0004\u0003QR\u0004CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g\r\u0005\u0002<y5\t\u0011&\u0003\u0002>S\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00011\u00035y\u0005+\u0012*B)&{ej\u0018'P\u000fV\t!\tE\u0002D\u0011*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bA\u0001\\1oO*\tq)\u0001\u0003kCZ\f\u0017BA%E\u0005YIe\u000e[3sSR\f'\r\\3UQJ,\u0017\r\u001a'pG\u0006d\u0007CA\u0019\u000b'\tQA'\u0001\u0003qCRD\u0007C\u0001(T\u001b\u0005y%B\u0001)R\u0003\u00111\u0017\u000e\\3\u000b\u0005I3\u0015a\u00018j_&\u0011Ak\u0014\u0002\u0005!\u0006$\b\u000e\u0006\u0002K-\")A\n\u0004a\u0001\u001b\u00061qO]5uKJ,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039\u001a\u000b!![8\n\u0005y[&A\u0004\"vM\u001a,'/\u001a3Xe&$XM]\u0001\u0007e\u0016\fG-\u001a:\u0016\u0003\u0005\u0004\"A\u00172\n\u0005\r\\&A\u0004\"vM\u001a,'/\u001a3SK\u0006$WM]\u0001\fS:LG/[1mSj,G-F\u0001g!\t)t-\u0003\u0002im\t9!i\\8mK\u0006t\u0017aD5oSRL\u0017\r\\5{K\u0012|F%Z9\u0015\u0005-t\u0007CA\u001bm\u0013\tigG\u0001\u0003V]&$\bbB8\u0011\u0003\u0003\u0005\rAZ\u0001\u0004q\u0012\n\u0014\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0003FA\ts!\t)4/\u0003\u0002um\tAao\u001c7bi&dW-\u0001\u0006fqR\u0014\u0018\rU1uQN,\u0012a\u001e\t\u0004qvlU\"A=\u000b\u0005i\\\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003yZ\n!bY8mY\u0016\u001cG/[8o\u0013\tq\u0018P\u0001\u0006MSN$()\u001e4gKJ\fA\"\u001a=ue\u0006\u0014V-\u00193feN,\"!a\u0001\u0011\u0007al\u0018-A\bmCN$8+Z3l%\u0016\fG\rU8t+\t\tI\u0001E\u00026\u0003\u0017I1!!\u00047\u0005\rIe\u000e^\u0001\u0014Y\u0006\u001cHoU3fWJ+\u0017\r\u001a)pg~#S-\u001d\u000b\u0004W\u0006M\u0001\u0002C8\u0016\u0003\u0003\u0005\r!!\u0003\u0002!1\f7\u000f^*fK.\u0014V-\u00193Q_N\u0004\u0013AD:fK.\f'\r\\3SK\u0006$WM]\u000b\u0003\u00037\u00012!MA\u000f\u0013\r\ty\"\n\u0002\u0017'\u0016,7.\u00192mK\n+hMZ3sK\u0012\u0014V-\u00193fe\u0006\u00112/Z3lC\ndWMU3bI\u0016\u0014x\fJ3r)\rY\u0017Q\u0005\u0005\t_b\t\t\u00111\u0001\u0002\u001c\u0005y1/Z3lC\ndWMU3bI\u0016\u0014\b%A\u0006bI\u0012,\u0005\u0010\u001e:b\u0019><GcA6\u0002.!)AJ\u0007a\u0001\u001b\u0006)qO]5uKR\u00191.a\r\t\u000f\u0005U2\u00041\u0001\u00028\u0005\u0019Qn]4\u0011\t\u0005e\u0012q\t\b\u0005\u0003w\t\u0019\u0005E\u0002\u0002>Yj!!a\u0010\u000b\u0007\u0005\u0005s&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000b2\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002J\u0005-#AB*ue&twMC\u0002\u0002FY\n1$\u001b8ji>\u0003XM]1uS>tGj\\4JM:+7-Z:tCJLH#A6\u0002\u0011I,\u0017\r\u001a'pON$\u0002\"!\u0016\u0002h\u0005%\u0014Q\u000e\t\bk\u0005]\u00131LA\u0005\u0013\r\tIF\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\u0005u\u00131MA\u001c\u001b\t\tyFC\u0002\u0002b\u0019\u000bA!\u001e;jY&!\u0011QMA0\u0005%\t%O]1z\u0019&\u001cH\u000fC\u0003`;\u0001\u0007\u0011\rC\u0004\u0002lu\u0001\r!!\u0003\u0002\u00111\f7\u000f\u001e*poNDq!a\u001c\u001e\u0001\u0004\tI!A\u0004nCb\u0014vn^:\u0002\u0011Q|'k\\<TKR$B!!\u001e\u0002\u000eB!\u0011qOAE\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014A\u0002;ie&4GO\u0003\u0003\u0002\u0000\u0005\u0005\u0015a\u0001:qG*!\u00111QAC\u0003\u001d\u0019XM\u001d<jG\u0016T1!a\",\u0003\u0011A\u0017N^3\n\t\u0005-\u0015\u0011\u0010\u0002\b)J{woU3u\u0011\u001d\tyI\ba\u0001\u0003#\u000bA\u0001\\8hgB1\u0011QLAJ\u0003oIA!!&\u0002`\t!A*[:u\u0003\u0011\u0011X-\u00193\u0015\t\u0005U\u00141\u0014\u0005\b\u0003_z\u0002\u0019AA\u0005)\u0019\t)(a(\u0002$\"9\u0011\u0011\u0015\u0011A\u0002\u0005%\u0011\u0001\u00024s_6Dq!!*!\u0001\u0004\tI!\u0001\u0003tSj,\u0017!B2m_N,\u0017!\u0003;ssN\u000bg-\u001a7z)\rY\u0017Q\u0016\u0005\t\u0003_\u0013C\u00111\u0001\u00022\u0006\ta\r\u0005\u00036\u0003g[\u0017bAA[m\tAAHY=oC6,g(A\tdY>\u001cX-\u0012=ue\u0006\u0014V-\u00193feN\fab\u0014)F%\u0006#\u0016j\u0014(`\u0019>;\u0005%\u0001\ftKR\u001cUO\u001d:f]R|\u0005/\u001a:bi&|g\u000eT8h)\rY\u0017q\u0018\u0005\u0007\u0003\u0003,\u0001\u0019\u0001&\u0002\u0019=\u0004XM]1uS>tGj\\4\u0002-\u001d,GoQ;se\u0016tGo\u00149fe\u0006$\u0018n\u001c8M_\u001e,\"!a2\u0011\tU\nIMS\u0005\u0004\u0003\u00174$AB(qi&|g.A\rsK6|g/Z\"veJ,g\u000e^(qKJ\fG/[8o\u0019><\u0017aH2sK\u0006$Xm\u00149fe\u0006$\u0018n\u001c8M_\u001e\u0014vn\u001c;ESJ,7\r^8ssR\u00191.a5\t\u000f\u0005U\u0007\u00021\u0001\u0002X\u000691/Z:tS>t\u0007\u0003BAm\u0003;l!!a7\u000b\u0007\u0005U\u0017&\u0003\u0003\u0002`\u0006m'aB*fgNLwN\\\u0001\u0013GJ,\u0017\r^3Pa\u0016\u0014\u0018\r^5p]2{w\rF\u0003K\u0003K\f9\u000fC\u0004\u0002V&\u0001\r!a6\t\u000f\u0005%\u0018\u00021\u0001\u0002l\u0006Aq\u000e\u001d%b]\u0012dW\r\u0005\u0003\u0002n\u0006=X\"A\u0014\n\u0007\u0005ExEA\bPa\u0016\u0014\u0018\r^5p]\"\u000bg\u000e\u001a7f\u0001")
public class OperationLog {
    private BufferedWriter writer;
    private BufferedReader reader;
    private ListBuffer<Path> extraPaths;
    private ListBuffer<BufferedReader> extraReaders;
    private final Path path;
    private volatile boolean initialized;
    private int lastSeekReadPos;
    private SeekableBufferedReader seekableReader;
    private volatile byte bitmap$0;

    public static OperationLog createOperationLog(Session session, OperationHandle operationHandle) {
        return OperationLog$.MODULE$.createOperationLog(session, operationHandle);
    }

    public static void createOperationLogRootDirectory(Session session) {
        OperationLog$.MODULE$.createOperationLogRootDirectory(session);
    }

    public static void removeCurrentOperationLog() {
        OperationLog$.MODULE$.removeCurrentOperationLog();
    }

    public static Option<OperationLog> getCurrentOperationLog() {
        return OperationLog$.MODULE$.getCurrentOperationLog();
    }

    public static void setCurrentOperationLog(OperationLog operationLog) {
        OperationLog$.MODULE$.setCurrentOperationLog(operationLog);
    }

    public static void error(Function0<Object> function0) {
        OperationLog$.MODULE$.error(function0);
    }

    public static void error(Function0<Object> function0, Throwable throwable) {
        OperationLog$.MODULE$.error(function0, throwable);
    }

    public static void warn(Function0<Object> function0, Throwable throwable) {
        OperationLog$.MODULE$.warn(function0, throwable);
    }

    public static void warn(Function0<Object> function0) {
        OperationLog$.MODULE$.warn(function0);
    }

    public static void info(Function0<Object> function0, Throwable throwable) {
        OperationLog$.MODULE$.info(function0, throwable);
    }

    public static void info(Function0<Object> function0) {
        OperationLog$.MODULE$.info(function0);
    }

    public static void debug(Function0<Object> function0, Throwable throwable) {
        OperationLog$.MODULE$.debug(function0, throwable);
    }

    public static void debug(Function0<Object> function0) {
        OperationLog$.MODULE$.debug(function0);
    }

    private BufferedWriter writer$lzycompute() {
        OperationLog operationLog = this;
        synchronized (operationLog) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.writer = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, new OpenOption[0]);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.writer;
    }

    private BufferedWriter writer() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.writer$lzycompute();
        }
        return this.writer;
    }

    private BufferedReader reader$lzycompute() {
        OperationLog operationLog = this;
        synchronized (operationLog) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.reader = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.reader;
    }

    private BufferedReader reader() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.reader$lzycompute();
        }
        return this.reader;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private ListBuffer<Path> extraPaths$lzycompute() {
        OperationLog operationLog = this;
        synchronized (operationLog) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.extraPaths = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.extraPaths;
    }

    private ListBuffer<Path> extraPaths() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.extraPaths$lzycompute();
        }
        return this.extraPaths;
    }

    private ListBuffer<BufferedReader> extraReaders$lzycompute() {
        OperationLog operationLog = this;
        synchronized (operationLog) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.extraReaders = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.extraReaders;
    }

    private ListBuffer<BufferedReader> extraReaders() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.extraReaders$lzycompute();
        }
        return this.extraReaders;
    }

    private int lastSeekReadPos() {
        return this.lastSeekReadPos;
    }

    private void lastSeekReadPos_$eq(int x$1) {
        this.lastSeekReadPos = x$1;
    }

    private SeekableBufferedReader seekableReader() {
        return this.seekableReader;
    }

    private void seekableReader_$eq(SeekableBufferedReader x$1) {
        this.seekableReader = x$1;
    }

    public synchronized void addExtraLog(Path path) {
        try {
            this.extraReaders().$plus$eq((Object)Files.newBufferedReader(path, StandardCharsets.UTF_8));
            this.extraPaths().$plus$eq((Object)path);
            Option$.MODULE$.apply((Object)this.seekableReader()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            this.seekableReader_$eq(null);
        }
        catch (IOException iOException) {}
    }

    public synchronized void write(String msg) {
        try {
            this.writer().write(msg);
            this.writer().flush();
            this.initOperationLogIfNecessary();
        }
        catch (IOException iOException) {}
    }

    public void initOperationLogIfNecessary() {
        if (!this.initialized()) {
            this.initialized_$eq(true);
            return;
        }
    }

    private Tuple2<ArrayList<String>, Object> readLogs(BufferedReader reader, int lastRows, int maxRows) {
        Tuple2 tuple2;
        ArrayList<String> logs = new ArrayList<String>();
        int i = 0;
        try {
            String line = null;
            do {
                if ((line = reader.readLine()) == null) continue;
                logs.add(line);
                ++i;
            } while ((i < lastRows || maxRows <= 0) && line != null);
            tuple2 = new Tuple2(logs, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        catch (IOException e) {
            Path absPath = this.path.toAbsolutePath();
            Path opHandle = absPath.getFileName();
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(34).append("Operation[").append(opHandle).append("] log file ").append(absPath).append(" is not found").toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return tuple2;
    }

    private TRowSet toRowSet(java.util.List<String> logs) {
        TColumn tColumn = TColumn.stringVal((TStringColumn)new TStringColumn(logs, ByteBuffer.allocate(0)));
        TRowSet tRow = new TRowSet(0L, new ArrayList(logs.size()));
        tRow.addToColumns(tColumn);
        return tRow;
    }

    public synchronized TRowSet read(int maxRows) {
        if (!this.initialized()) {
            return ThriftUtils$.MODULE$.newEmptyRowSet();
        }
        Tuple2<ArrayList<String>, Object> tuple2 = this.readLogs(this.reader(), maxRows, maxRows);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ArrayList logs = (ArrayList)tuple2._1();
        int lines = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)logs, (Object)BoxesRunTime.boxToInteger((int)lines));
        ArrayList logs2 = (ArrayList)tuple22._1();
        int lines2 = tuple22._2$mcI$sp();
        IntRef lastRows = IntRef.create((int)(maxRows - lines2));
        this.extraReaders().withFilter((Function1 & Serializable & scala.Serializable)extraReader -> BoxesRunTime.boxToBoolean((boolean)OperationLog.$anonfun$read$1(lastRows, maxRows, extraReader))).foreach((Function1 & Serializable & scala.Serializable)extraReader -> BoxesRunTime.boxToBoolean((boolean)OperationLog.$anonfun$read$2(this, lastRows, maxRows, logs2, extraReader)));
        return this.toRowSet(logs2);
    }

    public synchronized TRowSet read(int from, int size) {
        if (!this.initialized()) {
            return ThriftUtils$.MODULE$.newEmptyRowSet();
        }
        int pos = from;
        if (pos < 0) {
            pos = this.lastSeekReadPos();
        }
        if (this.seekableReader() == null) {
            this.seekableReader_$eq(new SeekableBufferedReader((Seq<Path>)((Seq)((TraversableLike)new .colon.colon((Object)this.path, (List)Nil$.MODULE$)).$plus$plus(this.extraPaths(), Seq$.MODULE$.canBuildFrom()))));
        } else if (pos < this.lastSeekReadPos()) {
            this.seekableReader().close();
            this.seekableReader_$eq(new SeekableBufferedReader((Seq<Path>)((Seq)((TraversableLike)new .colon.colon((Object)this.path, (List)Nil$.MODULE$)).$plus$plus(this.extraPaths(), Seq$.MODULE$.canBuildFrom()))));
        }
        Iterator<String> it = this.seekableReader().readLine(pos, size);
        java.util.List res = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)it.toList()).asJava();
        this.lastSeekReadPos_$eq(pos + res.size());
        return this.toRowSet(res);
    }

    public synchronized void close() {
        if (!this.initialized()) {
            return;
        }
        this.closeExtraReaders();
        this.trySafely((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.reader().close());
        this.trySafely((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writer().close());
        if (this.seekableReader() != null) {
            this.lastSeekReadPos_$eq(0);
            this.trySafely((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.seekableReader().close());
        }
        this.trySafely((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Files.deleteIfExists($this.path));
    }

    private void trySafely(Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(54).append("Failed to remove corresponding log file of operation: ").append(this.path.toAbsolutePath()).toString(), e);
        }
    }

    private void closeExtraReaders() {
        this.extraReaders().foreach((Function1 & Serializable & scala.Serializable)extraReader -> {
            OperationLog.$anonfun$closeExtraReaders$1(extraReader);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$read$1(IntRef lastRows$1, int maxRows$1, BufferedReader extraReader) {
        return lastRows$1.elem > 0 || maxRows$1 <= 0;
    }

    public static final /* synthetic */ boolean $anonfun$read$2(OperationLog $this, IntRef lastRows$1, int maxRows$1, ArrayList logs$1, BufferedReader extraReader) {
        Tuple2<ArrayList<String>, Object> tuple2 = $this.readLogs(extraReader, lastRows$1.elem, maxRows$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ArrayList extraLogs = (ArrayList)tuple2._1();
        int extraRows = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)extraLogs, (Object)BoxesRunTime.boxToInteger((int)extraRows));
        ArrayList extraLogs2 = (ArrayList)tuple22._1();
        int extraRows2 = tuple22._2$mcI$sp();
        lastRows$1.elem -= extraRows2;
        return logs$1.addAll(extraLogs2);
    }

    public static final /* synthetic */ void $anonfun$closeExtraReaders$1(BufferedReader extraReader) {
        try {
            extraReader.close();
        }
        catch (IOException iOException) {}
    }

    public OperationLog(Path path) {
        this.path = path;
        this.initialized = false;
        this.lastSeekReadPos = 0;
    }
}

