/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.operation.OperationManager;
import org.apache.kyuubi.service.CompositeService;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager$;
import org.apache.kyuubi.session.package$;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\t\rf!\u0002\u001e<\u0003\u0003!\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000be\u0003A\u0011\u0001.\t\u000fy\u0003\u0001\u0019!C\u0005?\"9A\r\u0001a\u0001\n\u0013)\u0007BB6\u0001A\u0003&\u0001\rC\u0004q\u0001\u0001\u0007I\u0011C9\t\u000fU\u0004\u0001\u0019!C\tm\"1\u0001\u0010\u0001Q!\nIDQ!\u001f\u0001\u0005\u0002EDQA\u001f\u0001\u0005\nmDq\u0001 \u0001A\u0002\u0013%Q\u0010C\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0003\u0002\u0006!9\u0011\u0011\u0002\u0001!B\u0013q\bBBA\u0007\u0001\u0011\u0005Q\u0010C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012!A\u00111\u0007\u0001!\u0002\u0013\t\u0019\u0002C\u0005\u00026\u0001\u0011\r\u0011\"\u0003\u00028!A\u0011q\b\u0001!\u0002\u0013\tI\u0004\u0003\u0004\u0002B\u00011\tb\u0018\u0005\f\u0003\u0007\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0005C\u0006\u0002N\u0001\u0001\r\u00111A\u0005\n\u0005=\u0003bCA*\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000fBq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002\b\u00021\t!!#\t\u000f\u0005]\u0005A\"\u0005\u0002\u001a\"9\u00111\u001a\u0001\u0005\u0012\u00055\u0007bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0003G\u0004A\u0011AAs\u0011\u001d\tY\u000f\u0001C\u0005\u0003[Dq!!=\u0001\t\u0003\t\u0019\u0010C\u0004\u0002z\u0002!\t!a?\t\u000f\u0005}\b\u0001\"\u0006\u0003\u0002!9!q\u0001\u0001\u0005\u0002\t%\u0001b\u0002B\t\u0001\u0011\u0005!1\u0003\u0005\b\u0005O\u0001A\u0011\u0001B\u0005\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005\u0013A1Ba\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003.!Y!Q\u0007\u0001A\u0002\u0003\u0007I\u0011\u0002B\u001c\u0011-\u0011Y\u0004\u0001a\u0001\u0002\u0003\u0006KAa\f\t\u0017\tu\u0002\u00011AA\u0002\u0013%!Q\u0006\u0005\f\u0005\u007f\u0001\u0001\u0019!a\u0001\n\u0013\u0011\t\u0005C\u0006\u0003F\u0001\u0001\r\u0011!Q!\n\t=\u0002b\u0003B$\u0001\u0001\u0007\t\u0019!C\u0005\u0005[A1B!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003L!Y!q\n\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\u0018\u0011)\u0011\t\u0006\u0001EC\u0002\u0013%!Q\u0006\u0005\u000b\u0005'\u0002\u0001R1A\u0005\n\t5\u0002B\u0003B+\u0001!\u0015\r\u0011\"\u0003\u0003.!9!q\u000b\u0001\u0005\u0002\te\u0003b\u0002B6\u0001\u0011\u0005!Q\u000e\u0005\b\u0005g\u0002A\u0011\u0001B;\u0011\u001d\u0011Y\b\u0001C\u0001\u0005{BqA!!\u0001\t\u0003\u0012\u0019\t\u0003\u0004\u0003\u0012\u0002!\te\u001f\u0005\u0007\u0005'\u0003A\u0011I>\t\r\tU\u0005\u0001\"\u0003|\u0011!\u00119\n\u0001C\u0001{\te%AD*fgNLwN\\'b]\u0006<WM\u001d\u0006\u0003yu\nqa]3tg&|gN\u0003\u0002?\u007f\u000511._;vE&T!\u0001Q!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0015aA8sO\u000e\u00011C\u0001\u0001F!\t1\u0015*D\u0001H\u0015\tAU(A\u0004tKJ4\u0018nY3\n\u0005);%\u0001E\"p[B|7/\u001b;f'\u0016\u0014h/[2f\u0003\u0011q\u0017-\\3\u0011\u000553fB\u0001(U!\ty%+D\u0001Q\u0015\t\t6)\u0001\u0004=e>|GO\u0010\u0006\u0002'\u0006)1oY1mC&\u0011QKU\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002V%\u00061A(\u001b8jiz\"\"aW/\u0011\u0005q\u0003Q\"A\u001e\t\u000b-\u0013\u0001\u0019\u0001'\u0002\u0011MDW\u000f\u001e3po:,\u0012\u0001\u0019\t\u0003C\nl\u0011AU\u0005\u0003GJ\u0013qAQ8pY\u0016\fg.\u0001\u0007tQV$Hm\\<o?\u0012*\u0017\u000f\u0006\u0002gSB\u0011\u0011mZ\u0005\u0003QJ\u0013A!\u00168ji\"9!\u000eBA\u0001\u0002\u0004\u0001\u0017a\u0001=%c\u0005I1\u000f[;uI><h\u000e\t\u0015\u0003\u000b5\u0004\"!\u00198\n\u0005=\u0014&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002#}{\u0007/\u001a:bi&|g\u000eT8h%>|G/F\u0001s!\r\t7\u000fT\u0005\u0003iJ\u0013aa\u00149uS>t\u0017!F0pa\u0016\u0014\u0018\r^5p]2{wMU8pi~#S-\u001d\u000b\u0003M^DqA[\u0004\u0002\u0002\u0003\u0007!/\u0001\n`_B,'/\u0019;j_:dun\u001a*p_R\u0004\u0013\u0001E8qKJ\fG/[8o\u0019><'k\\8u\u0003]Ig.\u001b;Pa\u0016\u0014\u0018\r^5p]2{wMU8pi\u0012K'\u000fF\u0001g\u0003EyF.\u0019;fgRdunZ8viRKW.Z\u000b\u0002}B\u0011\u0011m`\u0005\u0004\u0003\u0003\u0011&\u0001\u0002'p]\u001e\fQc\u00187bi\u0016\u001cH\u000fT8h_V$H+[7f?\u0012*\u0017\u000fF\u0002g\u0003\u000fAqA\u001b\u0007\u0002\u0002\u0003\u0007a0\u0001\n`Y\u0006$Xm\u001d;M_\u001e|W\u000f\u001e+j[\u0016\u0004\u0003FA\u0007n\u0003Aa\u0017\r^3ti2{wm\\;u)&lW-A\biC:$G.\u001a+p'\u0016\u001c8/[8o+\t\t\u0019\u0002\u0005\u0005\u0002\u0016\u0005\r\u0012qEA\u0017\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011AC2p]\u000e,(O]3oi*!\u0011QDA\u0010\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0005\u0012\u0001\u00026bm\u0006LA!!\n\u0002\u0018\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0007q\u000bI#C\u0002\u0002,m\u0012QbU3tg&|g\u000eS1oI2,\u0007c\u0001/\u00020%\u0019\u0011\u0011G\u001e\u0003\u000fM+7o]5p]\u0006\u0001\u0002.\u00198eY\u0016$vnU3tg&|g\u000eI\u0001\u000fi&lWm\\;u\u0007\",7m[3s+\t\tI\u0004\u0005\u0003\u0002\u0016\u0005m\u0012\u0002BA\u001f\u0003/\u0011\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003=!\u0018.\\3pkR\u001c\u0005.Z2lKJ\u0004\u0013\u0001C5t'\u0016\u0014h/\u001a:\u0002\u0011\u0015DXm\u0019)p_2,\"!a\u0012\u0011\t\u0005U\u0011\u0011J\u0005\u0005\u0003\u0017\n9B\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\u0018\u0001D3yK\u000e\u0004vn\u001c7`I\u0015\fHc\u00014\u0002R!A!.FA\u0001\u0002\u0004\t9%A\u0005fq\u0016\u001c\u0007k\\8mA\u0005I2/\u001e2nSR\u0014\u0015mY6he>,h\u000eZ(qKJ\fG/[8o)\u0011\tI&a\u001e1\t\u0005m\u0013Q\r\t\u0007\u0003+\ti&!\u0019\n\t\u0005}\u0013q\u0003\u0002\u0007\rV$XO]3\u0011\t\u0005\r\u0014Q\r\u0007\u0001\t-\t9gFA\u0001\u0002\u0003\u0015\t!!\u001b\u0003\u0007}#\u0013'\u0005\u0003\u0002l\u0005E\u0004cA1\u0002n%\u0019\u0011q\u000e*\u0003\u000f9{G\u000f[5oOB\u0019\u0011-a\u001d\n\u0007\u0005U$KA\u0002B]fDq!!\u001f\u0018\u0001\u0004\tY(A\u0001s!\u0011\ti(a!\u000e\u0005\u0005}$\u0002BAA\u0003?\tA\u0001\\1oO&!\u0011QQA@\u0005!\u0011VO\u001c8bE2,\u0017\u0001E8qKJ\fG/[8o\u001b\u0006t\u0017mZ3s+\t\tY\t\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\t*P\u0001\n_B,'/\u0019;j_:LA!!&\u0002\u0010\n\u0001r\n]3sCRLwN\\'b]\u0006<WM]\u0001\u000eGJ,\u0017\r^3TKN\u001c\u0018n\u001c8\u0015\u0019\u00055\u00121TA[\u0003s\u000bi,!1\t\u000f\u0005u\u0015\u00041\u0001\u0002 \u0006A\u0001O]8u_\u000e|G\u000e\u0005\u0003\u0002\"\u0006EVBAAR\u0015\u0011\t)+a*\u0002\rQD'/\u001b4u\u0015\u0011\tI+a+\u0002\u0007I\u00048MC\u0002I\u0003[S1!a,@\u0003\u0011A\u0017N^3\n\t\u0005M\u00161\u0015\u0002\u0011)B\u0013x\u000e^8d_24VM]:j_:Da!a.\u001a\u0001\u0004a\u0015\u0001B;tKJDa!a/\u001a\u0001\u0004a\u0015\u0001\u00039bgN<xN\u001d3\t\r\u0005}\u0016\u00041\u0001M\u0003%I\u0007/\u00113ee\u0016\u001c8\u000fC\u0004\u0002Df\u0001\r!!2\u0002\t\r|gN\u001a\t\u0006\u001b\u0006\u001dG\nT\u0005\u0004\u0003\u0013D&aA'ba\u0006\u0019Bn\\4TKN\u001c\u0018n\u001c8D_VtG/\u00138g_R)a-a4\u0002R\"1AH\u0007a\u0001\u0003[Aa!a5\u001b\u0001\u0004a\u0015AB1di&|g.A\u0006pa\u0016t7+Z:tS>tG\u0003DA\u0014\u00033\fY.!8\u0002`\u0006\u0005\bbBAO7\u0001\u0007\u0011q\u0014\u0005\u0007\u0003o[\u0002\u0019\u0001'\t\r\u0005m6\u00041\u0001M\u0011\u0019\tyl\u0007a\u0001\u0019\"9\u00111Y\u000eA\u0002\u0005\u0015\u0017\u0001D2m_N,7+Z:tS>tGc\u00014\u0002h\"9\u0011\u0011\u001e\u000fA\u0002\u0005\u001d\u0012!D:fgNLwN\u001c%b]\u0012dW-\u0001\u000feK2,G/Z(qKJ\fG/[8o\u0019><7+Z:tS>tG)\u001b:\u0015\u0007\u0019\fy\u000fC\u0004\u0002jv\u0001\r!a\n\u0002!\u001d,GoU3tg&|gn\u00149uS>tG\u0003BA{\u0003o\u0004B!Y:\u0002.!9\u0011\u0011\u001e\u0010A\u0002\u0005\u001d\u0012AC4fiN+7o]5p]R!\u0011QFA\u007f\u0011\u001d\tIo\ba\u0001\u0003O\t!b]3u'\u0016\u001c8/[8o)\u00151'1\u0001B\u0003\u0011\u001d\tI\u000f\ta\u0001\u0003OAa\u0001\u0010\u0011A\u0002\u00055\u0012aE4fi>\u0003XM\\*fgNLwN\\\"pk:$XC\u0001B\u0006!\r\t'QB\u0005\u0004\u0005\u001f\u0011&aA%oi\u0006Y\u0011\r\u001c7TKN\u001c\u0018n\u001c8t)\t\u0011)\u0002\u0005\u0004\u0003\u0018\t\u0005\u0012Q\u0006\b\u0005\u00053\u0011iBD\u0002P\u00057I\u0011aU\u0005\u0004\u0005?\u0011\u0016a\u00029bG.\fw-Z\u0005\u0005\u0005G\u0011)C\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011yBU\u0001\u0010O\u0016$X\t_3d!>|GnU5{K\u0006qq-\u001a;BGRLg/Z\"pk:$\u0018!E0d_:4'+Z:ue&\u001cG\u000fT5tiV\u0011!q\u0006\t\u0005\u001b\nEB*C\u0002\u00034a\u00131aU3u\u0003Uy6m\u001c8g%\u0016\u001cHO]5di2K7\u000f^0%KF$2A\u001aB\u001d\u0011!Qg%!AA\u0002\t=\u0012AE0d_:4'+Z:ue&\u001cG\u000fT5ti\u0002\nqbX2p]\u001aLuM\\8sK2K7\u000f^\u0001\u0014?\u000e|gNZ%h]>\u0014X\rT5ti~#S-\u001d\u000b\u0004M\n\r\u0003\u0002\u00036*\u0003\u0003\u0005\rAa\f\u0002!}\u001bwN\u001c4JO:|'/\u001a'jgR\u0004\u0013\u0001F0cCR\u001c\u0007nQ8oM&;gn\u001c:f\u0019&\u001cH/\u0001\r`E\u0006$8\r[\"p]\u001aLuM\\8sK2K7\u000f^0%KF$2A\u001aB'\u0011!QG&!AA\u0002\t=\u0012!F0cCR\u001c\u0007nQ8oM&;gn\u001c:f\u0019&\u001cH\u000fI\u0001\u0017?\u000e|gN\u001a*fgR\u0014\u0018n\u0019;NCR\u001c\u0007\u000eT5ti\u0006!rlY8oM&;gn\u001c:f\u001b\u0006$8\r\u001b'jgR\f\u0011d\u00182bi\u000eD7i\u001c8g\u0013\u001etwN]3NCR\u001c\u0007\u000eT5ti\u0006Ya/\u00197jI\u0006$XmS3z)\u0019\u0011YFa\u0019\u0003hA!\u0011m\u001dB/!\u0015\t'q\f'M\u0013\r\u0011\tG\u0015\u0002\u0007)V\u0004H.\u001a\u001a\t\r\t\u0015\u0014\u00071\u0001M\u0003\rYW-\u001f\u0005\u0007\u0005S\n\u0004\u0019\u0001'\u0002\u000bY\fG.^3\u00021Y\fG.\u001b3bi\u0016\fe\u000e\u001a(pe6\fG.\u001b>f\u0007>tg\r\u0006\u0003\u0002F\n=\u0004b\u0002B9e\u0001\u0007\u0011QY\u0001\u0007G>tg-[4\u0002!Y\fG.\u001b3bi\u0016\u0014\u0015\r^2i\u0017\u0016LHC\u0002B.\u0005o\u0012I\b\u0003\u0004\u0003fM\u0002\r\u0001\u0014\u0005\u0007\u0005S\u001a\u0004\u0019\u0001'\u0002#Y\fG.\u001b3bi\u0016\u0014\u0015\r^2i\u0007>tg\r\u0006\u0003\u0002F\n}\u0004b\u0002B9i\u0001\u0007\u0011QY\u0001\u000bS:LG/[1mSj,Gc\u00014\u0003\u0006\"9\u00111Y\u001bA\u0002\t\u001d\u0005\u0003\u0002BE\u0005\u001bk!Aa#\u000b\u0007\tET(\u0003\u0003\u0003\u0010\n-%AC&zkV\u0014\u0017nQ8oM\u0006)1\u000f^1si\u0006!1\u000f^8q\u0003M\u0019H/\u0019:u)&lWm\\;u\u0007\",7m[3s\u0003]\u0019H/\u0019:u)\u0016\u0014X.\u001b8bi&twm\u00115fG.,'\u000fF\u0002g\u00057CqAa%:\u0001\u0004\u0011i\n\u0005\u0003b\u0005?3\u0017b\u0001BQ%\nIa)\u001e8di&|g\u000e\r")
public abstract class SessionManager
extends CompositeService {
    private Set<String> _confRestrictMatchList;
    private Set<String> _confIgnoreMatchList;
    private Set<String> _batchConfIgnoreMatchList;
    private final String name;
    private volatile boolean org$apache$kyuubi$session$SessionManager$$shutdown;
    private Option<String> _operationLogRoot;
    private volatile long _latestLogoutTime;
    private final ConcurrentHashMap<SessionHandle, Session> org$apache$kyuubi$session$SessionManager$$handleToSession;
    private final ScheduledExecutorService timeoutChecker;
    private ThreadPoolExecutor execPool;
    private Set<String> _confRestrictList;
    private Set<String> _confIgnoreList;
    private Set<String> _batchConfIgnoreList;
    private volatile byte bitmap$0;

    public boolean org$apache$kyuubi$session$SessionManager$$shutdown() {
        return this.org$apache$kyuubi$session$SessionManager$$shutdown;
    }

    private void org$apache$kyuubi$session$SessionManager$$shutdown_$eq(boolean x$1) {
        this.org$apache$kyuubi$session$SessionManager$$shutdown = x$1;
    }

    public Option<String> _operationLogRoot() {
        return this._operationLogRoot;
    }

    public void _operationLogRoot_$eq(Option<String> x$1) {
        this._operationLogRoot = x$1;
    }

    public Option<String> operationLogRoot() {
        return this._operationLogRoot();
    }

    private void initOperationLogRootDir() {
        try {
            String logRoot = this.isServer() ? this.conf().get(KyuubiConf$.MODULE$.SERVER_OPERATION_LOG_DIR_ROOT()) : this.conf().get(KyuubiConf$.MODULE$.ENGINE_OPERATION_LOG_DIR_ROOT());
            Path logPath = Files.createDirectories(Utils$.MODULE$.getAbsolutePathFromWork(logRoot, Utils$.MODULE$.getAbsolutePathFromWork$default$2()), new FileAttribute[0]);
            this._operationLogRoot_$eq((Option<String>)new Some((Object)((Object)logPath).toString()));
        }
        catch (IOException e) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Failed to initialize operation log root directory: ").append(this._operationLogRoot()).toString(), e);
            this._operationLogRoot_$eq((Option<String>)None$.MODULE$);
        }
    }

    private long _latestLogoutTime() {
        return this._latestLogoutTime;
    }

    private void _latestLogoutTime_$eq(long x$1) {
        this._latestLogoutTime = x$1;
    }

    public long latestLogoutTime() {
        return this._latestLogoutTime();
    }

    public ConcurrentHashMap<SessionHandle, Session> org$apache$kyuubi$session$SessionManager$$handleToSession() {
        return this.org$apache$kyuubi$session$SessionManager$$handleToSession;
    }

    private ScheduledExecutorService timeoutChecker() {
        return this.timeoutChecker;
    }

    public abstract boolean isServer();

    private ThreadPoolExecutor execPool() {
        return this.execPool;
    }

    private void execPool_$eq(ThreadPoolExecutor x$1) {
        this.execPool = x$1;
    }

    public Future<?> submitBackgroundOperation(Runnable r) {
        return this.execPool().submit(r);
    }

    public abstract OperationManager operationManager();

    public abstract Session createSession(TProtocolVersion var1, String var2, String var3, String var4, Map<String, String> var5);

    public void logSessionCountInfo(Session session, String action) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append(session.user()).append("'s session with").append(" ").append(session.handle()).append(session.name().map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append("/").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" is ").append(action).append(",").append(" current opening sessions ").append(this.getOpenSessionCount()).toString());
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Opening session for ").append(user).append("@").append(ipAddress).toString());
        Session session = this.createSession(protocol, user, password, ipAddress, conf);
        try {
            SessionHandle handle = session.handle();
            session.open();
            this.setSession(handle, session);
            this.logSessionCountInfo(session, "opened");
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                session.close();
            }
            catch (Throwable t) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error closing session for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            throw KyuubiSQLException$.MODULE$.apply(e);
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        this._latestLogoutTime_$eq(System.currentTimeMillis());
        Session session = this.org$apache$kyuubi$session$SessionManager$$handleToSession().remove(sessionHandle);
        if (session == null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(8).append("Invalid ").append(sessionHandle).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        this.logSessionCountInfo(session, "closed");
        try {
            session.close();
        }
        finally {
            this.deleteOperationLogSessionDir(sessionHandle);
        }
    }

    private void deleteOperationLogSessionDir(SessionHandle sessionHandle) {
        this._operationLogRoot().foreach((Function1 & Serializable & scala.Serializable)logRoot -> {
            Boolean bl;
            Path rootPath = Paths.get(logRoot, sessionHandle.identifier().toString());
            try {
                bl = BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.deleteDirectoryRecursively(rootPath.toFile()));
            }
            catch (IOException e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Failed to delete session operation log directory ").append(((Object)rootPath).toString()).toString(), e);
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
    }

    public Option<Session> getSessionOption(SessionHandle sessionHandle) {
        return Option$.MODULE$.apply((Object)this.org$apache$kyuubi$session$SessionManager$$handleToSession().get(sessionHandle));
    }

    public Session getSession(SessionHandle sessionHandle) {
        return (Session)this.getSessionOption(sessionHandle).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(8).append("Invalid ").append(sessionHandle).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    public final void setSession(SessionHandle sessionHandle, Session session) {
        this.org$apache$kyuubi$session$SessionManager$$handleToSession().put(sessionHandle, session);
    }

    public int getOpenSessionCount() {
        return this.org$apache$kyuubi$session$SessionManager$$handleToSession().size();
    }

    public Iterable<Session> allSessions() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$kyuubi$session$SessionManager$$handleToSession().values()).asScala();
    }

    public int getExecPoolSize() {
        Predef$.MODULE$.assert(this.execPool() != null);
        return this.execPool().getPoolSize();
    }

    public int getActiveCount() {
        Predef$.MODULE$.assert(this.execPool() != null);
        return this.execPool().getActiveCount();
    }

    private Set<String> _confRestrictList() {
        return this._confRestrictList;
    }

    private void _confRestrictList_$eq(Set<String> x$1) {
        this._confRestrictList = x$1;
    }

    private Set<String> _confIgnoreList() {
        return this._confIgnoreList;
    }

    private void _confIgnoreList_$eq(Set<String> x$1) {
        this._confIgnoreList = x$1;
    }

    private Set<String> _batchConfIgnoreList() {
        return this._batchConfIgnoreList;
    }

    private void _batchConfIgnoreList_$eq(Set<String> x$1) {
        this._batchConfIgnoreList = x$1;
    }

    private Set<String> _confRestrictMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._confRestrictMatchList = (Set)((SetLike)this._confRestrictList().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.endsWith(".*")))).map((Function1 & Serializable & scala.Serializable)x$3 -> new StringOps(Predef$.MODULE$.augmentString(x$3)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._confRestrictMatchList;
    }

    private Set<String> _confRestrictMatchList() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this._confRestrictMatchList$lzycompute();
        }
        return this._confRestrictMatchList;
    }

    private Set<String> _confIgnoreMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this._confIgnoreMatchList = (Set)((SetLike)this._confIgnoreList().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.endsWith(".*")))).map((Function1 & Serializable & scala.Serializable)x$5 -> new StringOps(Predef$.MODULE$.augmentString(x$5)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this._confIgnoreMatchList;
    }

    private Set<String> _confIgnoreMatchList() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this._confIgnoreMatchList$lzycompute();
        }
        return this._confIgnoreMatchList;
    }

    private Set<String> _batchConfIgnoreMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this._batchConfIgnoreMatchList = (Set)((SetLike)this._batchConfIgnoreList().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.endsWith(".*")))).map((Function1 & Serializable & scala.Serializable)x$7 -> new StringOps(Predef$.MODULE$.augmentString(x$7)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this._batchConfIgnoreMatchList;
    }

    private Set<String> _batchConfIgnoreMatchList() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this._batchConfIgnoreMatchList$lzycompute();
        }
        return this._batchConfIgnoreMatchList;
    }

    public Option<Tuple2<String, String>> validateKey(String key, String value) {
        String normalizedKey;
        String string;
        if (key.startsWith(package$.MODULE$.SET_PREFIX())) {
            String newKey = key.substring(package$.MODULE$.SET_PREFIX().length());
            if (newKey.startsWith(package$.MODULE$.ENV_PREFIX())) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append(key).append(" is forbidden, env:* variables can not be set.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            string = newKey.startsWith(package$.MODULE$.SYSTEM_PREFIX()) ? newKey.substring(package$.MODULE$.SYSTEM_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.HIVECONF_PREFIX()) ? newKey.substring(package$.MODULE$.HIVECONF_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.HIVEVAR_PREFIX()) ? newKey.substring(package$.MODULE$.HIVEVAR_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.METACONF_PREFIX()) ? newKey.substring(package$.MODULE$.METACONF_PREFIX().length()) : newKey)));
        } else {
            string = normalizedKey = key;
        }
        if (this._confRestrictMatchList().exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)normalizedKey.startsWith(x$8))) || this._confRestrictList().contains((Object)normalizedKey)) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(112).append(normalizedKey).append(" is a restrict key according to the server-side").append(" configuration, please remove it and retry if you want to proceed").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        if (this._confIgnoreMatchList().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)normalizedKey.startsWith(x$9))) || this._confIgnoreList().contains((Object)normalizedKey)) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append(normalizedKey).append(" is a ignored key according to the server-side configuration").toString());
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)normalizedKey, (Object)value));
    }

    public Map<String, String> validateAndNormalizeConf(Map<String, String> config) {
        return (Map)config.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Option$.MODULE$.option2Iterable(this.validateKey(k, v));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Option<Tuple2<String, String>> validateBatchKey(String key, String value) {
        if (this._batchConfIgnoreMatchList().exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)key.startsWith(x$10))) || this._batchConfIgnoreList().contains((Object)key)) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append(key).append(" is a ignored batch key according to the server-side configuration").toString());
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)key, (Object)value));
    }

    public Map<String, String> validateBatchConf(Map<String, String> config) {
        return (Map)config.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Option$.MODULE$.option2Iterable(this.validateBatchKey(k, v));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.addService(this.operationManager());
        this.initOperationLogRootDir();
        int poolSize = this.isServer() ? BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_POOL_SIZE())) : BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_POOL_SIZE()));
        int waitQueueSize = this.isServer() ? BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_WAIT_QUEUE_SIZE())) : BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_WAIT_QUEUE_SIZE()));
        long keepAliveMs = this.isServer() ? BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_KEEPALIVE_TIME())) : BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_KEEPALIVE_TIME()));
        this._confRestrictList_$eq((Set<String>)((TraversableOnce)conf.get(KyuubiConf$.MODULE$.SESSION_CONF_RESTRICT_LIST())).toSet());
        this._confIgnoreList_$eq((Set<String>)((Set)((TraversableOnce)conf.get(KyuubiConf$.MODULE$.SESSION_CONF_IGNORE_LIST())).toSet().$plus((Object)String.valueOf(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED().key()))));
        this._batchConfIgnoreList_$eq((Set<String>)((TraversableOnce)conf.get(KyuubiConf$.MODULE$.BATCH_CONF_IGNORE_LIST())).toSet());
        this.execPool_$eq(ThreadUtils$.MODULE$.newDaemonQueuedThreadPool(poolSize, waitQueueSize, keepAliveMs, new StringBuilder(10).append(this.name).append("-exec-pool").toString()));
        super.initialize(conf);
    }

    @Override
    public synchronized void start() {
        this.startTimeoutChecker();
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.org$apache$kyuubi$session$SessionManager$$shutdown_$eq(true);
        long shutdownTimeout = this.isServer() ? BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.SERVER_EXEC_POOL_SHUTDOWN_TIMEOUT())) : BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_EXEC_POOL_SHUTDOWN_TIMEOUT()));
        ThreadUtils$.MODULE$.shutdown(this.timeoutChecker(), (Duration)Duration$.MODULE$.apply(shutdownTimeout, TimeUnit.MILLISECONDS));
        ThreadUtils$.MODULE$.shutdown(this.execPool(), (Duration)Duration$.MODULE$.apply(shutdownTimeout, TimeUnit.MILLISECONDS));
    }

    private void startTimeoutChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.SESSION_CHECK_INTERVAL()));
        Runnable checkTask = new Runnable(this){
            private final /* synthetic */ SessionManager $outer;

            public void run() {
                long current = System.currentTimeMillis();
                if (!this.$outer.org$apache$kyuubi$session$SessionManager$$shutdown()) {
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.org$apache$kyuubi$session$SessionManager$$handleToSession().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)session -> {
                        $anon$1.$anonfun$run$1(this, current, session);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, long current$1, Session session) {
                if (session.lastAccessTime() + session.sessionIdleTimeoutThreshold() <= current$1 && session.getNoOperationTime() > session.sessionIdleTimeoutThreshold()) {
                    $this.$outer.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Closing session ").append(session.handle().identifier()).append(" that has been idle for more").append(" than ").append(session.sessionIdleTimeoutThreshold()).append(" ms").toString());
                    try {
                        $this.$outer.closeSession(session.handle());
                    }
                    catch (KyuubiSQLException e) {
                        $this.$outer.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Error closing idle session ").append(session.handle()).toString(), e);
                    }
                    return;
                }
                session.closeExpiredOperations();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.session.SessionManager$$anon$1 long org.apache.kyuubi.session.Session ), $anonfun$run$2(org.apache.kyuubi.session.Session ), $anonfun$run$3(org.apache.kyuubi.session.Session )}, serializedLambda);
            }
        };
        this.timeoutChecker().scheduleWithFixedDelay(checkTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    public void startTerminatingChecker(Function0<BoxedUnit> stop) {
        if (!this.isServer()) {
            this._latestLogoutTime_$eq(System.currentTimeMillis());
            long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_CHECK_INTERVAL()));
            long idleTimeout = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_IDLE_TIMEOUT()));
            if (idleTimeout > 0L) {
                Runnable checkTask = new Runnable(this, idleTimeout, stop){
                    private final /* synthetic */ SessionManager $outer;
                    private final long idleTimeout$1;
                    private final Function0 stop$1;

                    public void run() {
                        if (!this.$outer.org$apache$kyuubi$session$SessionManager$$shutdown() && System.currentTimeMillis() - this.$outer.latestLogoutTime() > this.idleTimeout$1 && this.$outer.getOpenSessionCount() <= 0) {
                            this.$outer.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Idled for more than ").append($this.idleTimeout$1).append(" ms, terminating").toString());
                            this.stop$1.apply$mcV$sp();
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.idleTimeout$1 = idleTimeout$1;
                        this.stop$1 = stop$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$4(org.apache.kyuubi.session.SessionManager$$anon$2 )}, serializedLambda);
                    }
                };
                this.timeoutChecker().scheduleWithFixedDelay(checkTask, interval, interval, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    public SessionManager(String name) {
        this.name = name;
        super(name);
        this.org$apache$kyuubi$session$SessionManager$$shutdown = false;
        this._operationLogRoot = None$.MODULE$;
        this._latestLogoutTime = System.currentTimeMillis();
        this.org$apache$kyuubi$session$SessionManager$$handleToSession = new ConcurrentHashMap();
        this.timeoutChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(16).append(name).append("-timeout-checker").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
    }
}

