/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.operation;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationInfo$;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.spark.SparkBatchProcessBuilder;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.BatchJobSubmission$;
import org.apache.kyuubi.operation.KyuubiApplicationOperation;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.session.KyuubiBatchSessionImpl;
import org.apache.kyuubi.session.Session;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMe\u0001\u0002 @\u0001!C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t'\u0002\u0011)\u0019!C\u0001)\"A!\r\u0001B\u0001B\u0003%Q\u000b\u0003\u0005d\u0001\t\u0015\r\u0011\"\u0001U\u0011!!\u0007A!A!\u0002\u0013)\u0006\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011\u0019\u0004!\u0011!Q\u0001\nUC\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\"AQ\u000f\u0001B\u0001B\u0003%a\u000fC\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111\u0006\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u0002.!I\u00111\b\u0001C\u0002\u0013%\u0011Q\b\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002@!I\u0011Q\n\u0001C\u0002\u0013\u0005\u0011\t\u0016\u0005\b\u0003\u001f\u0002\u0001\u0015!\u0003V\u0011%\t\t\u0006\u0001a\u0001\n\u0013\t\u0019\u0006C\u0005\u0002^\u0001\u0001\r\u0011\"\u0003\u0002`!A\u00111\u000e\u0001!B\u0013\t)\u0006C\u0004\u0002v\u0001!\t!a\u0015\t\u0013\u0005]\u0004\u00011A\u0005\n\u0005e\u0004\"CAL\u0001\u0001\u0007I\u0011BAM\u0011!\ti\n\u0001Q!\n\u0005m\u0004bBAP\u0001\u0011\u0005\u0011\u0011\u0010\u0005\n\u0003C\u0003\u0001\u0019!C\u0005\u0003GC\u0011\"a+\u0001\u0001\u0004%I!!,\t\u0011\u0005E\u0006\u0001)Q\u0005\u0003KCq!!.\u0001\t\u0003\t\u0019\u000bC\u0004\u00028\u0002!\t!!\t\t\u0015\u0005e\u0006\u0001#b\u0001\n\u0013\t\u0019\u000b\u0003\u0006\u0002<\u0002\u0011\r\u0011\"\u0001B\u0003{C\u0001\"!2\u0001A\u0003%\u0011q\u0018\u0005\b\u0003C\u0004A\u0011KAr\u0011\u001d\t)\u000f\u0001C\u0005\u0003OD\u0001\"a<\u0001\t\u0003\t\u0015\u0011\u001f\u0005\n\u0003g\u0004!\u0019!C\u0005\u0003GC\u0001\"!>\u0001A\u0003%\u0011Q\u0015\u0005\n\u0003o\u0004!\u0019!C\u0005\u0003GC\u0001\"!?\u0001A\u0003%\u0011Q\u0015\u0005\b\u0003w\u0004A\u0011BA\u007f\u0011\u001d\ty\u0010\u0001C!\u0005\u0003AqA!\u0002\u0001\t\u0013\u00119\u0001C\u0004\u0003 \u0001!\t&!@\t\u000f\t\u0005\u0002\u0001\"\u0015\u0002~\"9!1\u0005\u0001\u0005R\u0005u\bb\u0002B\u0013\u0001\u0011%\u0011Q \u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u0011y\u0003\u0001C\u0005\u0003{DqA!\r\u0001\t\u0003\u0011\u0019\u0004C\u0004\u0003n\u0001!\t%!@\t\u000f\t=\u0004\u0001\"\u0011\u0002~\"9!\u0011\u000f\u0001\u0005B\u0005\u0005\u0002b\u0002B:\u0001\u0011E\u0013\u0011\u0005\u0005\b\u0005k\u0002A\u0011BA\u007f\u000f\u001d\u00119h\u0010E\u0001\u0005s2aAP \t\u0002\tm\u0004bBA\u0005u\u0011\u0005!1\u0011\u0005\b\u0005\u000bSD\u0011\u0001BD\u0011\u001d\u0011iI\u000fC\u0001\u0005\u001f\u0013!CQ1uG\"TuNY*vE6L7o]5p]*\u0011\u0001)Q\u0001\n_B,'/\u0019;j_:T!AQ\"\u0002\r-LX/\u001e2j\u0015\t!U)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\r\u0006\u0019qN]4\u0004\u0001M\u0011\u0001!\u0013\t\u0003\u0015.k\u0011aP\u0005\u0003\u0019~\u0012!dS=vk\nL\u0017\t\u001d9mS\u000e\fG/[8o\u001fB,'/\u0019;j_:\fqa]3tg&|g\u000e\u0005\u0002P#6\t\u0001K\u0003\u0002N\u0003&\u0011!\u000b\u0015\u0002\u0017\u0017f,XOY5CCR\u001c\u0007nU3tg&|g.S7qY\u0006I!-\u0019;dQRK\b/Z\u000b\u0002+B\u0011ak\u0018\b\u0003/v\u0003\"\u0001W.\u000e\u0003eS!AW$\u0002\rq\u0012xn\u001c;?\u0015\u0005a\u0016!B:dC2\f\u0017B\u00010\\\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y[\u0016A\u00032bi\u000eDG+\u001f9fA\u0005I!-\u0019;dQ:\u000bW.Z\u0001\u000bE\u0006$8\r\u001b(b[\u0016\u0004\u0013\u0001\u0003:fg>,(oY3\u0002\u0013\rd\u0017m]:OC6,\u0017!\u00032bi\u000eD7i\u001c8g!\u00111\u0016.V+\n\u0005)\f'aA'ba\u0006I!-\u0019;dQ\u0006\u0013xm\u001d\t\u0004[J,fB\u00018q\u001d\tAv.C\u0001]\u0013\t\t8,A\u0004qC\u000e\\\u0017mZ3\n\u0005M$(aA*fc*\u0011\u0011oW\u0001\u0011e\u0016\u001cwN^3ss6+G/\u00193bi\u0006\u00042a\u001e={\u001b\u0005Y\u0016BA=\\\u0005\u0019y\u0005\u000f^5p]B\u001910!\u0002\u000e\u0003qT!! @\u0002\u0007\u0005\u0004\u0018NC\u0002\u0000\u0003\u0003\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0004\u0003\u0007\t\u0015AB:feZ,'/C\u0002\u0002\bq\u0014\u0001\"T3uC\u0012\fG/Y\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u00055\u0011qBA\t\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011Q\u0004\t\u0003\u0015\u0002AQ!T\u0006A\u00029CQaU\u0006A\u0002UCQaY\u0006A\u0002UCQ!Z\u0006A\u0002UCQAZ\u0006A\u0002UCQaZ\u0006A\u0002!DQa[\u0006A\u00021DQ!^\u0006A\u0002Y\fab\u001d5pk2$'+\u001e8Bgft7-\u0006\u0002\u0002$A\u0019q/!\n\n\u0007\u0005\u001d2LA\u0004C_>dW-\u00198\u0002\u001b}{\u0007/\u001a:bi&|g\u000eT8h+\t\ti\u0003\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019dP\u0001\u0004Y><\u0017\u0002BA\u001c\u0003c\u0011Ab\u00149fe\u0006$\u0018n\u001c8M_\u001e\fabX8qKJ\fG/[8o\u0019><\u0007%\u0001\nbaBd\u0017nY1uS>tW*\u00198bO\u0016\u0014XCAA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#\u0003\u00061QM\\4j]\u0016LA!!\u0013\u0002D\tA2*_;vE&\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0002'\u0005\u0004\b\u000f\\5dCRLwN\\'b]\u0006<WM\u001d\u0011\u0002\u000f\t\fGo\u00195JI\u0006A!-\u0019;dQ&#\u0007%\u0001\t`CB\u0004H.[2bi&|g.\u00138g_V\u0011\u0011Q\u000b\t\u0005ob\f9\u0006\u0005\u0003\u0002B\u0005e\u0013\u0002BA.\u0003\u0007\u0012q\"\u00119qY&\u001c\u0017\r^5p]&sgm\\\u0001\u0015?\u0006\u0004\b\u000f\\5dCRLwN\\%oM>|F%Z9\u0015\t\u0005\u0005\u0014q\r\t\u0004o\u0006\r\u0014bAA37\n!QK\\5u\u0011%\tI\u0007FA\u0001\u0002\u0004\t)&A\u0002yIE\n\u0011cX1qa2L7-\u0019;j_:LeNZ8!Q\r)\u0012q\u000e\t\u0004o\u0006E\u0014bAA:7\nAao\u001c7bi&dW-\u0001\nhKR\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8J]\u001a|\u0017aC6jY2lUm]:bO\u0016,\"!a\u001f\u0011\t\u0005u\u0014\u0011\u0013\b\u0005\u0003\u007f\nyI\u0004\u0003\u0002\u0002\u00065e\u0002BAB\u0003\u0017sA!!\"\u0002\n:\u0019\u0001,a\"\n\u0003\u0019K!\u0001R#\n\u0005\t\u001b\u0015bAA#\u0003&\u0019\u0011/a\u0011\n\t\u0005M\u0015Q\u0013\u0002\r\u0017&dGNU3ta>t7/\u001a\u0006\u0004c\u0006\r\u0013aD6jY2lUm]:bO\u0016|F%Z9\u0015\t\u0005\u0005\u00141\u0014\u0005\n\u0003SB\u0012\u0011!a\u0001\u0003w\nAb[5mY6+7o]1hK\u0002\nabZ3u\u0017&dG.T3tg\u0006<W-A\u0007`CB\u00048\u000b^1siRKW.Z\u000b\u0003\u0003K\u00032a^AT\u0013\r\tIk\u0017\u0002\u0005\u0019>tw-A\t`CB\u00048\u000b^1siRKW.Z0%KF$B!!\u0019\u00020\"I\u0011\u0011\u000e\u000f\u0002\u0002\u0003\u0007\u0011QU\u0001\u000f?\u0006\u0004\bo\u0015;beR$\u0016.\\3!Q\ri\u0012qN\u0001\rCB\u00048\u000b^1siRKW.Z\u0001\u000bCB\u00048\u000b^1si\u0016$\u0017aC0tk\nl\u0017\u000e\u001e+j[\u0016\fqAY;jY\u0012,'/\u0006\u0002\u0002@B!\u0011\u0011IAa\u0013\u0011\t\u0019-a\u0011\u0003\u0017A\u0013xn\u0019\"vS2$WM]\u0001\tEVLG\u000eZ3sA!\u001a!%!3\u0011\t\u0005-\u0017Q\\\u0007\u0003\u0003\u001bTA!a4\u0002R\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\t\u0019.!6\u0002\r\r|W.\\8o\u0015\u0011\t9.!7\u0002\r\u001d|wn\u001a7f\u0015\t\tY.A\u0002d_6LA!a8\u0002N\n\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\u0002-\r,(O]3oi\u0006\u0003\b\u000f\\5dCRLwN\\%oM>$\"!!\u0016\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e)\u0011\tI/a;\u0011\u0007]DX\u000bC\u0004\u0002n\u0012\u0002\r!!\u0016\u0002\u001f\u0005\u0004\b\u000f\\5dCRLwN\\%oM>\fAc[5mY\n\u000bGo\u00195BaBd\u0017nY1uS>tGCAA>\u0003a\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u00138uKJ4\u0018\r\\\u0001\u001aCB\u0004H.[2bi&|gn\u00115fG.Le\u000e^3sm\u0006d\u0007%\u0001\u000fbaBd\u0017nY1uS>t7\u000b^1sm\u0006$\u0018n\u001c8US6,w.\u001e;\u0002;\u0005\u0004\b\u000f\\5dCRLwN\\*uCJ4\u0018\r^5p]RKW.Z8vi\u0002\n1#\u001e9eCR,')\u0019;dQ6+G/\u00193bi\u0006$\"!!\u0019\u0002\u001f\u001d,Go\u00149fe\u0006$\u0018n\u001c8M_\u001e,\"Aa\u0001\u0011\t]D\u0018QF\u0001\u0016g\u0016$8\u000b^1uK&3gj\u001c;DC:\u001cW\r\\3e)\u0011\t\tG!\u0003\t\u000f\t-A\u00061\u0001\u0003\u000e\u0005Aa.Z<Ti\u0006$X\r\u0005\u0003\u0003\u0010\tea\u0002\u0002B\t\u0005+qA!!!\u0003\u0014%\u0011\u0001)Q\u0005\u0004\u0005/y\u0014AD(qKJ\fG/[8o'R\fG/Z\u0005\u0005\u00057\u0011iB\u0001\bPa\u0016\u0014\u0018\r^5p]N#\u0018\r^3\u000b\u0007\t]q(A\u0005cK\u001a|'/\u001a*v]\u0006A\u0011M\u001a;feJ+h.A\u0006sk:Le\u000e^3s]\u0006d\u0017\u0001G:vE6LG/\u00118e\u001b>t\u0017\u000e^8s\u0005\u0006$8\r\u001b&pE\u0006yQn\u001c8ji>\u0014()\u0019;dQ*{'\r\u0006\u0003\u0002b\t-\u0002B\u0002B\u0017c\u0001\u0007Q+A\u0003baBLE-A\u0013va\u0012\fG/Z!qa2L7-\u0019;j_:LeNZ8NKR\fG-\u0019;b\u0013\u001atU-\u001a3fI\u0006)r-\u001a;Pa\u0016\u0014\u0018\r^5p]2{wMU8x'\u0016$H\u0003\u0003B\u001b\u0005\u001b\u0012yF!\u001b\u0011\t\t]\"\u0011J\u0007\u0003\u0005sQAAa\u000f\u0003>\u00051A\u000f\u001b:jMRTAAa\u0010\u0003B\u0005\u0019!\u000f]2\u000b\t\t\r#QI\u0001\bg\u0016\u0014h/[2f\u0015\r\u00119eQ\u0001\u0005Q&4X-\u0003\u0003\u0003L\te\"a\u0002+S_^\u001cV\r\u001e\u0005\b\u0005\u001f\u001a\u0004\u0019\u0001B)\u0003\u0015y'\u000fZ3s!\u0011\u0011\u0019F!\u0017\u000f\t\tE!QK\u0005\u0004\u0005/z\u0014\u0001\u0005$fi\u000eDwJ]5f]R\fG/[8o\u0013\u0011\u0011YF!\u0018\u0003!\u0019+Go\u00195Pe&,g\u000e^1uS>t'b\u0001B,\u007f!9!\u0011M\u001aA\u0002\t\r\u0014\u0001\u00024s_6\u00042a\u001eB3\u0013\r\u00119g\u0017\u0002\u0004\u0013:$\bb\u0002B6g\u0001\u0007!1M\u0001\u0005g&TX-A\u0003dY>\u001cX-\u0001\u0004dC:\u001cW\r\\\u0001\u000bSN$\u0016.\\3e\u001fV$\u0018\u0001D3wK:$XI\\1cY\u0016$\u0017aH2mK\u0006tW\u000f]+qY>\fG-\u001a3SKN|WO]2f\u0013\u001atU-\u001a3fI\u0006\u0011\")\u0019;dQ*{'mU;c[&\u001c8/[8o!\tQ%hE\u0002;\u0005{\u00022a\u001eB@\u0013\r\u0011\ti\u0017\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\te\u0014!E1qa2L7-\u0019;j_:4\u0015-\u001b7fIR!\u00111\u0005BE\u0011\u001d\u0011Y\t\u0010a\u0001\u0003+\n\u0011#\u00199qY&\u001c\u0017\r^5p]N#\u0018\r^;t\u0003U\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8UKJl\u0017N\\1uK\u0012$B!a\t\u0003\u0012\"9!1R\u001fA\u0002\u0005U\u0003")
public class BatchJobSubmission
extends KyuubiApplicationOperation {
    private long _submitTime;
    private final KyuubiBatchSessionImpl session;
    private final String batchType;
    private final String batchName;
    private final String resource;
    private final Option<Metadata> recoveryMetadata;
    private final OperationLog _operationLog;
    private final KyuubiApplicationManager applicationManager;
    private final String batchId;
    private volatile Option<ApplicationInfo> _applicationInfo;
    private Tuple2<Object, String> killMessage;
    private volatile long _appStartTime;
    @VisibleForTesting
    private final ProcBuilder builder;
    private final long applicationCheckInterval;
    private final long applicationStarvationTimeout;
    private volatile boolean bitmap$0;

    public static boolean applicationTerminated(Option<ApplicationInfo> option) {
        return BatchJobSubmission$.MODULE$.applicationTerminated(option);
    }

    public static boolean applicationFailed(Option<ApplicationInfo> option) {
        return BatchJobSubmission$.MODULE$.applicationFailed(option);
    }

    public String batchType() {
        return this.batchType;
    }

    public String batchName() {
        return this.batchName;
    }

    @Override
    public boolean shouldRunAsync() {
        return true;
    }

    private OperationLog _operationLog() {
        return this._operationLog;
    }

    private KyuubiApplicationManager applicationManager() {
        return this.applicationManager;
    }

    public String batchId() {
        return this.batchId;
    }

    private Option<ApplicationInfo> _applicationInfo() {
        return this._applicationInfo;
    }

    private void _applicationInfo_$eq(Option<ApplicationInfo> x$1) {
        this._applicationInfo = x$1;
    }

    public Option<ApplicationInfo> getApplicationInfo() {
        return this._applicationInfo();
    }

    private Tuple2<Object, String> killMessage() {
        return this.killMessage;
    }

    private void killMessage_$eq(Tuple2<Object, String> x$1) {
        this.killMessage = x$1;
    }

    public Tuple2<Object, String> getKillMessage() {
        return this.killMessage();
    }

    private long _appStartTime() {
        return this._appStartTime;
    }

    private void _appStartTime_$eq(long x$1) {
        this._appStartTime = x$1;
    }

    public long appStartTime() {
        return this._appStartTime();
    }

    public boolean appStarted() {
        return this._appStartTime() > 0L;
    }

    private long _submitTime$lzycompute() {
        BatchJobSubmission batchJobSubmission = this;
        synchronized (batchJobSubmission) {
            if (!this.bitmap$0) {
                this._submitTime = this.appStarted() ? this._appStartTime() : System.currentTimeMillis();
                this.bitmap$0 = true;
            }
        }
        return this._submitTime;
    }

    private long _submitTime() {
        if (!this.bitmap$0) {
            return this._submitTime$lzycompute();
        }
        return this._submitTime;
    }

    public ProcBuilder builder() {
        return this.builder;
    }

    @Override
    public Option<ApplicationInfo> currentApplicationInfo() {
        if (OperationState$.MODULE$.isTerminal(this.state()) && this._applicationInfo().nonEmpty()) {
            return this._applicationInfo();
        }
        Option<ApplicationInfo> applicationInfo = this.applicationManager().getApplicationInfo(this.builder().clusterManager(), this.batchId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this._submitTime())));
        this.applicationId(applicationInfo).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            BatchJobSubmission.$anonfun$currentApplicationInfo$1(this, x$3);
            return BoxedUnit.UNIT;
        });
        return applicationInfo;
    }

    private Option<String> applicationId(Option<ApplicationInfo> applicationInfo) {
        return applicationInfo.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)BatchJobSubmission.$anonfun$applicationId$1(x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.id()).orElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
    }

    public Tuple2<Object, String> killBatchApplication() {
        return this.applicationManager().killApplication(this.builder().clusterManager(), this.batchId());
    }

    private long applicationCheckInterval() {
        return this.applicationCheckInterval;
    }

    private long applicationStarvationTimeout() {
        return this.applicationStarvationTimeout;
    }

    private void updateBatchMetadata() {
        long endTime;
        long l = endTime = this.isTerminalState(this.state()) ? this.lastAccessTime() : 0L;
        if (this.isTerminalState(this.state()) && this._applicationInfo().isEmpty()) {
            this._applicationInfo_$eq((Option<ApplicationInfo>)new Some((Object)ApplicationInfo$.MODULE$.NOT_FOUND()));
        }
        this._applicationInfo().foreach((Function1 & Serializable & scala.Serializable)appInfo -> {
            BatchJobSubmission.$anonfun$updateBatchMetadata$1(this, endTime, appInfo);
            return BoxedUnit.UNIT;
        });
    }

    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this._operationLog());
    }

    private void setStateIfNotCanceled(Enumeration.Value newState) {
        this.withLockRequired((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Enumeration.Value value = this.state();
            Enumeration.Value value2 = OperationState$.MODULE$.CANCELED();
            if (value == null ? value2 != null : !value.equals(value2)) {
                this.setState(newState);
                this.applicationId(this._applicationInfo()).foreach((Function1 & Serializable & scala.Serializable)appId -> {
                    BatchJobSubmission.$anonfun$setStateIfNotCanceled$2(this, appId);
                    return BoxedUnit.UNIT;
                });
                Enumeration.Value value3 = newState;
                Enumeration.Value value4 = OperationState$.MODULE$.RUNNING();
                if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                    $this.session.onEngineOpened();
                    return;
                }
                return;
            }
        });
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this._operationLog());
        this.setHasResultSet(true);
        this.setStateIfNotCanceled(OperationState$.MODULE$.PENDING());
    }

    @Override
    public void afterRun() {
        OperationLog$.MODULE$.removeCurrentOperationLog();
    }

    public void runInternal() {
        this.session.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block7: {
                Runnable asyncOperation = () -> {
                    block8: {
                        try {
                            try {
                                if ($this.recoveryMetadata.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.peerInstanceClosed()))) {
                                    this.setState(OperationState$.MODULE$.CANCELED());
                                } else {
                                    $this.recoveryMetadata.map((Function1 & Serializable & scala.Serializable)metadata -> {
                                        BatchJobSubmission.$anonfun$runInternal$4(this, metadata);
                                        return BoxedUnit.UNIT;
                                    }).getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.submitAndMonitorBatchJob());
                                    this.setStateIfNotCanceled(OperationState$.MODULE$.FINISHED());
                                }
                            }
                            catch (Throwable x$8) {
                                PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(this.onError$default$1());
                                if (catchExpr$1.isDefinedAt((Object)x$8)) {
                                    catchExpr$1.apply((Object)x$8);
                                    break block8;
                                }
                                throw x$8;
                            }
                        }
                        finally {
                            this.updateBatchMetadata();
                        }
                    }
                };
                try {
                    try {
                        Future opHandle = $this.session.sessionManager().submitBackgroundOperation(asyncOperation);
                        this.setBackgroundHandle(opHandle);
                    }
                    catch (Throwable x$9) {
                        PartialFunction<Throwable, BoxedUnit> catchExpr$2 = this.onError("submitting batch job submission operation in background, request rejected");
                        if (catchExpr$2.isDefinedAt((Object)x$9)) {
                            catchExpr$2.apply((Object)x$9);
                            break block7;
                        }
                        throw x$9;
                    }
                }
                finally {
                    if (this.isTerminalState(this.state())) {
                        this.updateBatchMetadata();
                    }
                }
            }
        });
    }

    private void submitAndMonitorBatchJob() {
        block15: {
            boolean appStatusFirstUpdated = false;
            long lastStarvationCheckTime = this.createTime();
            try {
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Submitting ").append(this.batchType()).append(" batch[").append(this.batchId()).append("] job:\n").append(this.builder()).toString());
                Process process = this.builder().start();
                while (!BatchJobSubmission$.MODULE$.applicationFailed(this._applicationInfo()) && process.isAlive()) {
                    this.updateApplicationInfoMetadataIfNeeded();
                    if (!appStatusFirstUpdated) {
                        if (this.applicationId(this._applicationInfo()).isDefined()) {
                            this.setStateIfNotCanceled(OperationState$.MODULE$.RUNNING());
                            this.updateBatchMetadata();
                            appStatusFirstUpdated = true;
                        } else {
                            long currentTime = System.currentTimeMillis();
                            if (currentTime - lastStarvationCheckTime > this.applicationStarvationTimeout()) {
                                lastStarvationCheckTime = currentTime;
                                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Batch[").append(this.batchId()).append("] has not started, check the Kyuubi server to ensure").append(" that batch jobs can be submitted.").toString());
                            }
                        }
                    }
                    process.waitFor(this.applicationCheckInterval(), TimeUnit.MILLISECONDS);
                }
                if (BatchJobSubmission$.MODULE$.applicationFailed(this._applicationInfo())) {
                    process.destroyForcibly();
                    throw new KyuubiException(new StringBuilder(18).append("Batch job failed: ").append(this._applicationInfo()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
                process.waitFor();
                if (process.exitValue() != 0) {
                    throw new KyuubiException(new StringBuilder(24).append("Process exit with value ").append(process.exitValue()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
                while (!this.appStarted() && this.applicationId(this._applicationInfo()).isEmpty() && !BatchJobSubmission$.MODULE$.applicationTerminated(this._applicationInfo())) {
                    Thread.sleep(this.applicationCheckInterval());
                    this.updateApplicationInfoMetadataIfNeeded();
                }
                boolean bl = false;
                Option<String> option = null;
                Option<String> option2 = this.applicationId(this._applicationInfo());
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    String appId = (String)some.value();
                    this.monitorBatchJob(appId);
                    break block15;
                }
                if (None$.MODULE$.equals(option2)) {
                    bl = true;
                    option = option2;
                    if (!this.appStarted()) {
                        throw new KyuubiException(new StringBuilder(21).append(this.batchType()).append(" batch[").append(this.batchId()).append("] job failed: ").append(this._applicationInfo()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                    }
                }
                if (bl) {
                    break block15;
                }
                throw new MatchError(option2);
            }
            finally {
                this.builder().close(this.builder().close$default$1());
                this.cleanupUploadedResourceIfNeeded();
            }
        }
    }

    private void monitorBatchJob(String appId) {
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Monitoring submitted ").append(this.batchType()).append(" batch[").append(this.batchId()).append("] job: ").append(appId).toString());
        if (this._applicationInfo().isEmpty()) {
            this._applicationInfo_$eq(this.currentApplicationInfo());
        }
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = OperationState$.MODULE$.PENDING();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.setStateIfNotCanceled(OperationState$.MODULE$.RUNNING());
        }
        if (this._applicationInfo().isEmpty()) {
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("The ").append(this.batchType()).append(" batch[").append(this.batchId()).append("] job: ").append(appId).append(" not found, assume that it has finished.").toString());
            return;
        }
        if (BatchJobSubmission$.MODULE$.applicationFailed(this._applicationInfo())) {
            throw new KyuubiException(new StringBuilder(21).append(this.batchType()).append(" batch[").append(this.batchId()).append("] job failed: ").append(this._applicationInfo()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        this.updateBatchMetadata();
        while (this._applicationInfo().isDefined() && !BatchJobSubmission$.MODULE$.applicationTerminated(this._applicationInfo())) {
            Thread.sleep(this.applicationCheckInterval());
            this.updateApplicationInfoMetadataIfNeeded();
        }
        if (BatchJobSubmission$.MODULE$.applicationFailed(this._applicationInfo())) {
            throw new KyuubiException(new StringBuilder(21).append(this.batchType()).append(" batch[").append(this.batchId()).append("] job failed: ").append(this._applicationInfo()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private void updateApplicationInfoMetadataIfNeeded() {
        Option<ApplicationInfo> newApplicationStatus = this.currentApplicationInfo();
        Option option = newApplicationStatus.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.state());
        Option option2 = this._applicationInfo().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.state());
        if (option == null ? option2 != null : !option.equals(option2)) {
            this._applicationInfo_$eq(newApplicationStatus);
            this.updateBatchMetadata();
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Batch report for ").append(this.batchId()).append(", ").append(this._applicationInfo()).toString());
            return;
        }
    }

    public TRowSet getOperationLogRowSet(Enumeration.Value order, int from, int size) {
        Option<OperationLog> operationLog = this.getOperationLog();
        return (TRowSet)operationLog.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.read(from, size)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(44).append("Batch ID: ").append(this.batchId()).append(", failed to generate operation log").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    @Override
    public void close() {
        Object object = new Object();
        try {
            this.withLockRequired((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (!this.isClosedOrCanceled()) {
                    try {
                        this.getOperationLog().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                            x$13.close();
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (IOException e) {
                        this.error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
                    }
                    MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$14 -> {
                        x$14.decCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.OPERATION_OPEN(), (String[])new String[]{this.opType()}));
                        return BoxedUnit.UNIT;
                    });
                    if (this.isTerminalState(this.state())) {
                        this.killMessage_$eq((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(46).append("batch ").append(this.batchId()).append(" is already terminal so can not kill it.").toString()));
                        this.builder().close(this.builder().close$default$1());
                        this.cleanupUploadedResourceIfNeeded();
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    try {
                        this.killMessage_$eq(this.killBatchApplication());
                        this.builder().close(this.builder().close$default$1());
                        this.cleanupUploadedResourceIfNeeded();
                    }
                    finally {
                        Enumeration.Value value = this.state();
                        Enumeration.Value value2 = OperationState$.MODULE$.INITIALIZED();
                        if (!(value != null ? !value.equals(value2) : value2 != null)) {
                            this.setState(OperationState$.MODULE$.CANCELED());
                            this.updateBatchMetadata();
                        } else if (this.killMessage()._1$mcZ$sp() && !this.isTerminalState(this.state())) {
                            this.setState(OperationState$.MODULE$.CANCELED());
                            this.updateBatchMetadata();
                        } else if (this.killMessage()._1$mcZ$sp()) {
                            this.killMessage_$eq((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(46).append("batch ").append(this.batchId()).append(" is already terminal so can not kill it.").toString()));
                        } else if (!this.isTerminalState(this.state())) {
                            // empty if block
                        }
                    }
                    return;
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    @Override
    public void cancel() {
        throw new IllegalStateException("Use close instead.");
    }

    public boolean isTimedOut() {
        return false;
    }

    @Override
    public boolean eventEnabled() {
        return true;
    }

    private void cleanupUploadedResourceIfNeeded() {
        if (this.session.isResourceUploaded()) {
            try {
                Files.deleteIfExists(Paths.get(this.resource, new String[0]));
            }
            catch (Throwable e) {
                this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error deleting the uploaded resource: ").append($this.resource).toString(), e);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$currentApplicationInfo$1(BatchJobSubmission $this, String x$3) {
        if ($this._appStartTime() <= 0L) {
            $this._appStartTime_$eq(System.currentTimeMillis());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$applicationId$1(ApplicationInfo x$4) {
        return x$4.id() != null;
    }

    public static final /* synthetic */ void $anonfun$updateBatchMetadata$1(BatchJobSubmission $this, long endTime$1, ApplicationInfo appInfo) {
        String x$1 = $this.batchId();
        String x$2 = $this.state().toString();
        long x$3 = $this.appStartTime();
        String x$4 = appInfo.id();
        String x$5 = appInfo.name();
        String x$6 = (String)appInfo.url().orNull(Predef$.MODULE$.$conforms());
        String x$7 = appInfo.state().toString();
        Option<String> x$8 = appInfo.error();
        long x$9 = endTime$1;
        Enumeration.Value x$10 = Metadata$.MODULE$.apply$default$2();
        String x$11 = Metadata$.MODULE$.apply$default$3();
        String x$12 = Metadata$.MODULE$.apply$default$4();
        String x$13 = Metadata$.MODULE$.apply$default$5();
        String x$14 = Metadata$.MODULE$.apply$default$6();
        String x$15 = Metadata$.MODULE$.apply$default$8();
        String x$16 = Metadata$.MODULE$.apply$default$9();
        String x$17 = Metadata$.MODULE$.apply$default$10();
        Map<String, String> x$18 = Metadata$.MODULE$.apply$default$11();
        Seq<String> x$19 = Metadata$.MODULE$.apply$default$12();
        long x$20 = Metadata$.MODULE$.apply$default$13();
        String x$21 = Metadata$.MODULE$.apply$default$14();
        Option<String> x$22 = Metadata$.MODULE$.apply$default$15();
        boolean x$23 = Metadata$.MODULE$.apply$default$23();
        Metadata metadataToUpdate = new Metadata(x$1, x$10, x$11, x$12, x$13, x$14, x$2, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$23);
        $this.session.sessionManager().updateMetadata(metadataToUpdate);
    }

    public static final /* synthetic */ void $anonfun$setStateIfNotCanceled$2(BatchJobSubmission $this, String appId) {
        $this.session.getSessionEvent().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.engineId_$eq(appId);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$runInternal$4(BatchJobSubmission $this, Metadata metadata) {
        String string = metadata.state();
        String string2 = OperationState$.MODULE$.PENDING().toString();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            $this._applicationInfo_$eq($this.currentApplicationInfo());
            Option<String> option = $this.applicationId($this._applicationInfo());
            if (option instanceof Some) {
                Some some = (Some)option;
                String appId = (String)some.value();
                $this.monitorBatchJob(appId);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                $this.submitAndMonitorBatchJob();
                return;
            }
            throw new MatchError(option);
        }
        $this.monitorBatchJob(metadata.engineId());
    }

    public BatchJobSubmission(KyuubiBatchSessionImpl session, String batchType, String batchName, String resource, String className, Map<String, String> batchConf, Seq<String> batchArgs, Option<Metadata> recoveryMetadata) {
        Some some;
        String string;
        Some some2;
        String string2;
        this.session = session;
        this.batchType = batchType;
        this.batchName = batchName;
        this.resource = resource;
        this.recoveryMetadata = recoveryMetadata;
        super((Session)session);
        this._operationLog = OperationLog$.MODULE$.createOperationLog((Session)session, this.getHandle());
        this.applicationManager = session.sessionManager().applicationManager();
        this.batchId = session.handle().identifier().toString();
        this._applicationInfo = None$.MODULE$;
        this.killMessage = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"UNKNOWN");
        this._appStartTime = BoxesRunTime.unboxToLong((Object)recoveryMetadata.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.engineOpenTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Option option = Option$.MODULE$.apply((Object)batchType).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toUpperCase(Locale.ROOT));
        if (!(option instanceof Some && "SPARK".equals(string2 = (String)(some2 = (Some)option).value()) ? true : option instanceof Some && "PYSPARK".equals(string = (String)(some = (Some)option).value()))) {
            throw new UnsupportedOperationException(new StringBuilder(23).append("Batch type ").append(batchType).append(" unsupported").toString());
        }
        this.builder = new SparkBatchProcessBuilder(session.user(), session.sessionConf(), this.batchId(), batchName, (Option<String>)Option$.MODULE$.apply((Object)resource), className, batchConf, batchArgs, this.getOperationLog());
        this.applicationCheckInterval = BoxesRunTime.unboxToLong((Object)session.sessionConf().get(KyuubiConf$.MODULE$.BATCH_APPLICATION_CHECK_INTERVAL()));
        this.applicationStarvationTimeout = BoxesRunTime.unboxToLong((Object)session.sessionConf().get(KyuubiConf$.MODULE$.BATCH_APPLICATION_STARVATION_TIMEOUT()));
    }
}

