/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha.client.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.CreateModable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicInteger;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreMutex;
import org.apache.curator.framework.recipes.nodes.PersistentNode;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryForever;
import org.apache.curator.utils.ZKPaths;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClient$;
import org.apache.kyuubi.ha.client.ServiceDiscovery;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.ha.client.zookeeper.ZookeeperClientProvider$;
import org.apache.kyuubi.ha.client.zookeeper.ZookeeperDiscoveryClient$;
import org.apache.kyuubi.package$;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r=b\u0001B\u001d;\u0001\u001dC\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u00063\u0002!\tA\u0017\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0011\u0019A\u0007\u0001)A\u0005A\"I\u0011\u000e\u0001a\u0001\u0002\u0004%IA\u001b\u0005\ng\u0002\u0001\r\u00111A\u0005\nQD\u0011B\u001f\u0001A\u0002\u0003\u0005\u000b\u0015B6\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0013\t\t\u0001C\u0006\u0002^\u0001\u0001\r\u00111A\u0005\n\u0005}\u0003bCA2\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0007Aq!!\u001a\u0001\t\u0003\n9\u0007C\u0004\u0002j\u0001!\t%a\u001a\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n!I\u0011\u0011\u0011\u0001\u0012\u0002\u0013\u0005\u00111\u0011\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\tY\u000b\u0001C!\u0003[Cq!!.\u0001\t\u0003\n9\fC\u0004\u0002N\u0002!\t%a4\t\u000f\u0005M\u0007\u0001\"\u0011\u0002V\"9\u0011\u0011\u001c\u0001\u0005B\u0005m\u0007\"CAr\u0001E\u0005I\u0011AAB\u0011\u001d\t)\u000f\u0001C!\u0003ODq!a;\u0001\t\u0003\ni\u000fC\u0004\u0003\"\u0001!\tEa\t\t\u000f\tm\u0002\u0001\"\u0011\u0003>!9!Q\t\u0001\u0005B\t\u001d\u0003\"\u0003B1\u0001E\u0005I\u0011\u0001B2\u0011%\u00119\u0007AI\u0001\n\u0003\t\u0019\tC\u0004\u0003j\u0001!\tEa\u001b\t\u0013\tu\u0004!%A\u0005\u0002\t}\u0004\"\u0003BB\u0001E\u0005I\u0011AAB\u0011\u001d\u0011)\t\u0001C!\u0003OBqAa\"\u0001\t\u0003\u0012I\tC\u0004\u0003\u000e\u0002!\tEa$\t\u0013\tm\u0005!%A\u0005\u0002\t}\u0004\"\u0003BO\u0001E\u0005I\u0011AAB\u0011\u001d\u0011y\n\u0001C!\u0005CC\u0011B!4\u0001#\u0003%\t!a!\t\u000f\t=\u0007\u0001\"\u0011\u0003R\"I!\u0011\u001c\u0001\u0012\u0002\u0013\u0005!1\u001c\u0005\t\u0005?\u0004A\u0011\u0001\u001f\u0003b\"9!q\u001d\u0001\u0005\n\t%\b\"\u0003B\u0000\u0001E\u0005I\u0011\u0002B@\u0011%\u0019\t\u0001AI\u0001\n\u0013\t\u0019\tC\u0005\u0004\u0004\u0001\t\n\u0011\"\u0003\u0004\u0006!91\u0011\u0002\u0001\u0005\n\u0005\u001ddABA\u0004\u0001\u0001\tI\u0001\u0003\u0006\u0002&=\u0012)\u0019!C\u0001\u0003OA!\"a\u00100\u0005\u0003\u0005\u000b\u0011BA\u0015\u0011)\t\te\fB\u0001B\u0003%\u00111\t\u0005\u00073>\"\t!!\u0013\t\u000f\u0005=s\u0006\"\u0011\u0002R\u001d911\u0002\u001e\t\u0002\r5aAB\u001d;\u0011\u0003\u0019y\u0001\u0003\u0004Zm\u0011\u00051\u0011\u0004\u0005\u000b\u000771\u0004R1A\u0005\u000e\ru!\u0001\u0007.p_.,W\r]3s\t&\u001c8m\u001c<fef\u001cE.[3oi*\u00111\bP\u0001\nu>|7.Z3qKJT!!\u0010 \u0002\r\rd\u0017.\u001a8u\u0015\ty\u0004)\u0001\u0002iC*\u0011\u0011IQ\u0001\u0007Wf,XOY5\u000b\u0005\r#\u0015AB1qC\u000eDWMC\u0001F\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001J\u0014\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0003V\"\u0001\u001f\n\u0005Ec$a\u0004#jg\u000e|g/\u001a:z\u00072LWM\u001c;\u0002\t\r|gN\u001a\t\u0003)^k\u0011!\u0016\u0006\u0003-\u0002\u000baaY8oM&<\u0017B\u0001-V\u0005)Y\u00150^;cS\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005mk\u0006C\u0001/\u0001\u001b\u0005Q\u0004\"\u0002*\u0003\u0001\u0004\u0019\u0016\u0001\u0003>l\u00072LWM\u001c;\u0016\u0003\u0001\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\u0013\u0019\u0014\u0018-\\3x_J\\'BA3C\u0003\u001d\u0019WO]1u_JL!a\u001a2\u0003!\r+(/\u0019;pe\u001a\u0013\u0018-\\3x_J\\\u0017!\u0003>l\u00072LWM\u001c;!\u0003-\u0019XM\u001d<jG\u0016tu\u000eZ3\u0016\u0003-\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\u000b9|G-Z:\u000b\u0005A\u0014\u0017a\u0002:fG&\u0004Xm]\u0005\u0003e6\u0014a\u0002U3sg&\u001cH/\u001a8u\u001d>$W-A\btKJ4\u0018nY3O_\u0012,w\fJ3r)\t)\b\u0010\u0005\u0002Jm&\u0011qO\u0013\u0002\u0005+:LG\u000fC\u0004z\r\u0005\u0005\t\u0019A6\u0002\u0007a$\u0013'\u0001\u0007tKJ4\u0018nY3O_\u0012,\u0007\u0005\u000b\u0002\byB\u0011\u0011*`\u0005\u0003}*\u0013\u0001B^8mCRLG.Z\u0001\bo\u0006$8\r[3s+\t\t\u0019\u0001E\u0002\u0002\u0006=j\u0011\u0001\u0001\u0002\u0012\t\u0016\u0014VmZ5ti\u0016\u0014x+\u0019;dQ\u0016\u00148#B\u0018\u0002\f\u0005m\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0004\u0003\r=\u0013'.Z2u!\u0011\ti\"!\t\u000e\u0005\u0005}!BA\u001eC\u0013\u0011\t\u0019#a\b\u0003\u000f]\u000bGo\u00195fe\u0006A\u0011N\\:uC:\u001cW-\u0006\u0002\u0002*A!\u00111FA\u001d\u001d\u0011\ti#!\u000e\u0011\u0007\u0005=\"*\u0004\u0002\u00022)\u0019\u00111\u0007$\u0002\rq\u0012xn\u001c;?\u0013\r\t9DS\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0012Q\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]\"*A\u0005j]N$\u0018M\\2fA\u0005\u00012/\u001a:wS\u000e,G)[:d_Z,'/\u001f\t\u0004\u001f\u0006\u0015\u0013bAA$y\t\u00012+\u001a:wS\u000e,G)[:d_Z,'/\u001f\u000b\u0007\u0003\u0007\tY%!\u0014\t\u000f\u0005\u00152\u00071\u0001\u0002*!9\u0011\u0011I\u001aA\u0002\u0005\r\u0013a\u00029s_\u000e,7o\u001d\u000b\u0004k\u0006M\u0003bBA+i\u0001\u0007\u0011qK\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003;\tI&\u0003\u0003\u0002\\\u0005}!\u0001D,bi\u000eDW\rZ#wK:$\u0018aC<bi\u000eDWM]0%KF$2!^A1\u0011!I\u0018\"!AA\u0002\u0005\r\u0011\u0001C<bi\u000eDWM\u001d\u0011\u0002\u0019\r\u0014X-\u0019;f\u00072LWM\u001c;\u0015\u0003U\f1b\u00197pg\u0016\u001cE.[3oi\u000611M]3bi\u0016$\u0002\"!\u000b\u0002p\u0005M\u0014q\u000f\u0005\b\u0003cj\u0001\u0019AA\u0015\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005UT\u00021\u0001\u0002*\u0005!Qn\u001c3f\u0011%\tI(\u0004I\u0001\u0002\u0004\tY(\u0001\u0007de\u0016\fG/\u001a)be\u0016tG\u000fE\u0002J\u0003{J1!a K\u0005\u001d\u0011un\u001c7fC:\f\u0001c\u0019:fCR,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0015%\u0006BA>\u0003\u000f[#!!#\u0011\t\u0005-\u0015QS\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'S\u0015AC1o]>$\u0018\r^5p]&!\u0011qSAG\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\bO\u0016$H)\u0019;b)\u0011\ti*!+\u0011\u000b%\u000by*a)\n\u0007\u0005\u0005&JA\u0003BeJ\f\u0017\u0010E\u0002J\u0003KK1!a*K\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005Et\u00021\u0001\u0002*\u000591/\u001a;ECR\fGCBA>\u0003_\u000b\t\fC\u0004\u0002rA\u0001\r!!\u000b\t\u000f\u0005M\u0006\u00031\u0001\u0002\u001e\u0006!A-\u0019;b\u0003-9W\r^\"iS2$'/\u001a8\u0015\t\u0005e\u00161\u001a\t\u0007\u0003w\u000b)-!\u000b\u000f\t\u0005u\u0016\u0011\u0019\b\u0005\u0003_\ty,C\u0001L\u0013\r\t\u0019MS\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9-!3\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u0007T\u0005bBA9#\u0001\u0007\u0011\u0011F\u0001\u000ba\u0006$\b.\u0012=jgR\u001cH\u0003BA>\u0003#Dq!!\u001d\u0013\u0001\u0004\tI#A\u0007qCRDgj\u001c8Fq&\u001cHo\u001d\u000b\u0005\u0003w\n9\u000eC\u0004\u0002rM\u0001\r!!\u000b\u0002\r\u0011,G.\u001a;f)\u0015)\u0018Q\\Ap\u0011\u001d\t\t\b\u0006a\u0001\u0003SA\u0011\"!9\u0015!\u0003\u0005\r!a\u001f\u0002\u001d\u0011,G.\u001a;f\u0007\"LG\u000e\u001a:f]\u0006\u0001B-\u001a7fi\u0016$C-\u001a4bk2$HEM\u0001\r[>t\u0017\u000e^8s'R\fG/\u001a\u000b\u0004k\u0006%\bbBA!-\u0001\u0007\u00111I\u0001\fiJLx+\u001b;i\u0019>\u001c7.\u0006\u0003\u0002p\u0006]HCBAy\u0005'\u00119\u0002\u0006\u0003\u0002t\n%\u0001\u0003BA{\u0003od\u0001\u0001B\u0004\u0002z^\u0011\r!a?\u0003\u0003Q\u000bB!!@\u0003\u0004A\u0019\u0011*a@\n\u0007\t\u0005!JA\u0004O_RD\u0017N\\4\u0011\u0007%\u0013)!C\u0002\u0003\b)\u00131!\u00118z\u0011!\u0011Ya\u0006CA\u0002\t5\u0011!\u00014\u0011\u000b%\u0013y!a=\n\u0007\tE!J\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\u0011)b\u0006a\u0001\u0003S\t\u0001\u0002\\8dWB\u000bG\u000f\u001b\u0005\b\u000539\u0002\u0019\u0001B\u000e\u0003\u001d!\u0018.\\3pkR\u00042!\u0013B\u000f\u0013\r\u0011yB\u0013\u0002\u0005\u0019>tw-A\u0007hKR\u001cVM\u001d<fe\"{7\u000f\u001e\u000b\u0005\u0005K\u00119\u0004E\u0003J\u0005O\u0011Y#C\u0002\u0003*)\u0013aa\u00149uS>t\u0007cB%\u0003.\u0005%\"\u0011G\u0005\u0004\u0005_Q%A\u0002+va2,'\u0007E\u0002J\u0005gI1A!\u000eK\u0005\rIe\u000e\u001e\u0005\b\u0005sA\u0002\u0019AA\u0015\u0003%q\u0017-\\3ta\u0006\u001cW-\u0001\thKR,enZ5oK\nK(+\u001a4JIR1!Q\u0005B \u0005\u0003BqA!\u000f\u001a\u0001\u0004\tI\u0003C\u0004\u0003De\u0001\r!!\u000b\u0002\u0017\u0015tw-\u001b8f%\u00164\u0017\nZ\u0001\u0014O\u0016$8+\u001a:wS\u000e,gj\u001c3fg&sgm\u001c\u000b\t\u0005\u0013\u0012)Fa\u0016\u0003^A1\u00111\u0018B&\u0005\u001fJAA!\u0014\u0002J\n\u00191+Z9\u0011\u0007=\u0013\t&C\u0002\u0003Tq\u0012qbU3sm&\u001cWMT8eK&sgm\u001c\u0005\b\u0005sQ\u0002\u0019AA\u0015\u0011%\u0011IF\u0007I\u0001\u0002\u0004\u0011Y&A\u0004tSj,w\n\u001d;\u0011\u000b%\u00139C!\r\t\u0013\t}#\u0004%AA\u0002\u0005m\u0014AB:jY\u0016tG/A\u000fhKR\u001cVM\u001d<jG\u0016tu\u000eZ3t\u0013:4w\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)G\u000b\u0003\u0003\\\u0005\u001d\u0015!H4fiN+'O^5dK:{G-Z:J]\u001a|G\u0005Z3gCVdG\u000fJ\u001a\u0002\u001fI,w-[:uKJ\u001cVM\u001d<jG\u0016$2\"\u001eB7\u0005_\u0012\tHa\u001d\u0003z!)!+\ba\u0001'\"9!\u0011H\u000fA\u0002\u0005%\u0002bBA!;\u0001\u0007\u00111\t\u0005\n\u0005kj\u0002\u0013!a\u0001\u0005o\nqA^3sg&|g\u000eE\u0003J\u0005O\tI\u0003C\u0005\u0003|u\u0001\n\u00111\u0001\u0002|\u0005AQ\r\u001f;fe:\fG.A\rsK\u001eL7\u000f^3s'\u0016\u0014h/[2fI\u0011,g-Y;mi\u0012\"TC\u0001BAU\u0011\u00119(a\"\u00023I,w-[:uKJ\u001cVM\u001d<jG\u0016$C-\u001a4bk2$H%N\u0001\u0012I\u0016\u0014XmZ5ti\u0016\u00148+\u001a:wS\u000e,\u0017!\u00069pgR$UM]3hSN$XM]*feZL7-\u001a\u000b\u0005\u0003w\u0012Y\tC\u0004\u0003:\u0005\u0002\r!!\u000b\u0002/\r\u0014X-\u0019;f\u0003:$w)\u001a;TKJ4\u0018nY3O_\u0012,G\u0003DA\u0015\u0005#\u0013\u0019J!&\u0003\u0018\ne\u0005\"\u0002*#\u0001\u0004\u0019\u0006b\u0002B\u001dE\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003K\u0011\u0003\u0019AA\u0015\u0011%\u0011)H\tI\u0001\u0002\u0004\u00119\bC\u0005\u0003|\t\u0002\n\u00111\u0001\u0002|\u0005\t3M]3bi\u0016\fe\u000eZ$fiN+'O^5dK:{G-\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005\t3M]3bi\u0016\fe\u000eZ$fiN+'O^5dK:{G-\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u0005y1\u000f^1siN+7M]3u\u001d>$W\rF\u0005v\u0005G\u00139Ka+\u00030\"9!QU\u0013A\u0002\u0005%\u0012AC2sK\u0006$X-T8eK\"9!\u0011V\u0013A\u0002\u0005%\u0012\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\t\u000f\t5V\u00051\u0001\u0002*\u0005A\u0011N\\5u\t\u0006$\u0018\rC\u0005\u00032\u0016\u0002\n\u00111\u0001\u0002|\u0005iQo]3Qe>$Xm\u0019;j_:D3!\nB[!\u0011\u00119L!3\u000e\u0005\te&\u0002\u0002B^\u0005{\u000b1\"\u00198o_R\fG/[8og*!!q\u0018Ba\u0003\u0019\u0019w.\\7p]*!!1\u0019Bc\u0003\u00199wn\\4mK*\u0011!qY\u0001\u0004G>l\u0017\u0002\u0002Bf\u0005s\u0013\u0011CV5tS\ndWMR8s)\u0016\u001cH/\u001b8h\u0003e\u0019H/\u0019:u'\u0016\u001c'/\u001a;O_\u0012,G\u0005Z3gCVdG\u000f\n\u001b\u0002\u001f\u001d,G/\u00118e\u0013:\u001c'/Z7f]R$bA!\r\u0003T\nU\u0007bBA9O\u0001\u0007\u0011\u0011\u0006\u0005\n\u0005/<\u0003\u0013!a\u0001\u0005c\tQ\u0001Z3mi\u0006\f\u0011dZ3u\u0003:$\u0017J\\2sK6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u001c\u0016\u0005\u0005c\t9)A\tbI\u0012\u001cuN\u001c4t)>\u0004VO\u00197jg\"$b!!\u000b\u0003d\n\u0015\b\"\u0002**\u0001\u0004\u0019\u0006bBA\u0013S\u0001\u0007\u0011\u0011F\u0001\u0015GJ,\u0017\r^3QKJ\u001c\u0018n\u001d;f]Rtu\u000eZ3\u0015\u001b-\u0014YO!<\u0003p\nE(1\u001fB{\u0011\u0015\u0011&\u00061\u0001T\u0011\u001d\u0011ID\u000ba\u0001\u0003SAq!!\n+\u0001\u0004\tI\u0003C\u0005\u0003v)\u0002\n\u00111\u0001\u0003x!I!1\u0010\u0016\u0011\u0002\u0003\u0007\u00111\u0010\u0005\n\u0005oT\u0003\u0013!a\u0001\u0005s\f!\"\u0019;ue&\u0014W\u000f^3t!!\tYCa?\u0002*\u0005%\u0012\u0002\u0002B\u007f\u0003{\u00111!T1q\u0003y\u0019'/Z1uKB+'o]5ti\u0016tGOT8eK\u0012\"WMZ1vYR$C'\u0001\u0010de\u0016\fG/\u001a)feNL7\u000f^3oi:{G-\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u0005q2M]3bi\u0016\u0004VM]:jgR,g\u000e\u001e(pI\u0016$C-\u001a4bk2$HEN\u000b\u0003\u0007\u000fQCA!?\u0002\b\u0006Iq/\u0019;dQ:{G-Z\u0001\u00195>|7.Z3qKJ$\u0015n]2pm\u0016\u0014\u0018p\u00117jK:$\bC\u0001/7'\u00111\u0004j!\u0005\u0011\t\rM1QC\u0007\u0002\u0001&\u00191q\u0003!\u0003\u000f1{wmZ5oOR\u00111QB\u0001\u0012G>tg.Z2uS>t7\t[3dW\u0016\u0014XCAB\u0010!\u0011\u0019\tca\u000b\u000e\u0005\r\r\"\u0002BB\u0013\u0007O\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0019I#a\u0005\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007[\u0019\u0019C\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\u0004")
public class ZookeeperDiscoveryClient
implements DiscoveryClient {
    public final KyuubiConf org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$conf;
    private final CuratorFramework zkClient;
    private volatile PersistentNode serviceNode;
    private DeRegisterWatcher watcher;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private CuratorFramework zkClient() {
        return this.zkClient;
    }

    private PersistentNode serviceNode() {
        return this.serviceNode;
    }

    private void serviceNode_$eq(PersistentNode x$1) {
        this.serviceNode = x$1;
    }

    private DeRegisterWatcher watcher() {
        return this.watcher;
    }

    private void watcher_$eq(DeRegisterWatcher x$1) {
        this.watcher = x$1;
    }

    @Override
    public void createClient() {
        this.zkClient().start();
    }

    @Override
    public void closeClient() {
        if (this.zkClient() != null) {
            this.zkClient().close();
            return;
        }
    }

    @Override
    public String create(String path, String mode, boolean createParent) {
        CreateBuilder builder = createParent ? this.zkClient().create().creatingParentsIfNeeded() : this.zkClient().create();
        return (String)((PathAndBytesable)((CreateModable)builder).withMode(CreateMode.valueOf((String)mode))).forPath(path);
    }

    @Override
    public boolean create$default$3() {
        return true;
    }

    @Override
    public byte[] getData(String path) {
        return (byte[])this.zkClient().getData().forPath(path);
    }

    @Override
    public boolean setData(String path, byte[] data) {
        return this.zkClient().setData().forPath(path, data) != null;
    }

    @Override
    public List<String> getChildren(String path) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)this.zkClient().getChildren().forPath(path)).asScala()).toList();
    }

    @Override
    public boolean pathExists(String path) {
        return this.zkClient().checkExists().forPath(path) != null;
    }

    @Override
    public boolean pathNonExists(String path) {
        return this.zkClient().checkExists().forPath(path) == null;
    }

    @Override
    public void delete(String path, boolean deleteChildren) {
        if (deleteChildren) {
            this.zkClient().delete().deletingChildrenIfNeeded().forPath(path);
            return;
        }
        this.zkClient().delete().forPath(path);
    }

    @Override
    public boolean delete$default$2() {
        return false;
    }

    @Override
    public void monitorState(ServiceDiscovery serviceDiscovery) {
        this.zkClient().getConnectionStateListenable().addListener((Object)new ConnectionStateListener(this, serviceDiscovery){
            private final AtomicBoolean org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected;
            private final /* synthetic */ ZookeeperDiscoveryClient $outer;
            public final ServiceDiscovery serviceDiscovery$1;

            public AtomicBoolean org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected() {
                return this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected;
            }

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                this.$outer.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Zookeeper client connection state changed to: ").append(newState).toString());
                ConnectionState connectionState = newState;
                if (ConnectionState.CONNECTED.equals(connectionState) ? true : ConnectionState.RECONNECTED.equals(connectionState)) {
                    this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected().set(true);
                    return;
                }
                if (ConnectionState.LOST.equals(connectionState)) {
                    this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected().set(false);
                    long delay = ZookeeperClientProvider$.MODULE$.getGracefulStopThreadDelay(this.$outer.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$conf);
                    ZookeeperDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$connectionChecker().schedule(new Runnable(this, newState, delay){
                        private final /* synthetic */ $anon$1 $outer;
                        private final ConnectionState newState$1;
                        private final long delay$1;

                        public void run() {
                            if (!this.$outer.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected().get()) {
                                this.$outer.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$$outer().error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("Zookeeper client connection state changed to: ").append($this.newState$1).append(",").append(" but failed to reconnect in ").append($this.delay$1 / 1000L).append(" seconds.").append(" Give up retry and stop gracefully . ").toString());
                                this.$outer.serviceDiscovery$1.stopGracefully(true);
                                return;
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.newState$1 = newState$1;
                            this.delay$1 = delay$1;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.kyuubi.ha.client.zookeeper.ZookeeperDiscoveryClient$$anon$1$$anon$2 )}, serializedLambda);
                        }
                    }, delay, TimeUnit.MILLISECONDS);
                    return;
                }
            }

            public /* synthetic */ ZookeeperDiscoveryClient org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.serviceDiscovery$1 = serviceDiscovery$1;
                this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected = new AtomicBoolean(false);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$stateChanged$1(org.apache.curator.framework.state.ConnectionState )}, serializedLambda);
            }
        });
    }

    @Override
    public <T> T tryWithLock(String lockPath, long timeout, Function0<T> f) {
        Object object;
        InterProcessSemaphoreMutex lock = null;
        try {
            try {
                lock = new InterProcessSemaphoreMutex(this.zkClient(), lockPath);
                boolean acquired = lock.acquire(timeout, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(111).append("Timeout to lock on path [").append(lockPath).append("] after ").append(timeout).append(" ms. There would be some problem that other session may ").append("create engine timeout.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                }
            }
            catch (KyuubiSQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(22).append("Lock failed on path [").append(lockPath).append("]").toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            object = f.apply();
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        Object object2 = object;
        try {
            if (lock != null) {
                lock.release();
            }
        }
        catch (Exception exception) {}
        return (T)object2;
    }

    @Override
    public Option<Tuple2<String, Object>> getServerHost(String namespace) {
        Seq<ServiceNodeInfo> seq = this.getServiceNodesInfo(namespace, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1)), true);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            ServiceNodeInfo sn = (ServiceNodeInfo)((SeqLike)some.get()).apply(0);
            return new Some((Object)new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port())));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Tuple2<String, Object>> getEngineByRefId(String namespace, String engineRefId) {
        String x$12 = namespace;
        boolean x$2 = true;
        Option<Object> x$3 = this.getServiceNodesInfo$default$2();
        return this.getServiceNodesInfo(x$12, x$3, x$2).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZookeeperDiscoveryClient.$anonfun$getEngineByRefId$1(engineRefId, x$1))).map((Function1 & Serializable & scala.Serializable)data -> new Tuple2((Object)data.host(), (Object)BoxesRunTime.boxToInteger((int)data.port())));
    }

    @Override
    public Seq<ServiceNodeInfo> getServiceNodesInfo(String namespace, Option<Object> sizeOpt, boolean silent) {
        Nil$ nil$;
        try {
            java.util.List hosts = (java.util.List)this.zkClient().getChildren().forPath(namespace);
            int size = BoxesRunTime.unboxToInt((Object)sizeOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> hosts.size()));
            nil$ = (Seq)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(hosts).asScala()).takeRight(size)).map((Function1 & Serializable & scala.Serializable)p -> {
                String path = ZKPaths.makePath((String)namespace, (String)p);
                String instance = new String((byte[])this.zkClient().getData().forPath(path), StandardCharsets.UTF_8);
                Tuple2<String, Object> tuple2 = DiscoveryClient$.MODULE$.parseInstanceHostPort(instance);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String host = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                String host2 = (String)tuple22._1();
                int port2 = tuple22._2$mcI$sp();
                Map attributes = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.split(";"))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.split("=", 2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ZookeeperDiscoveryClient.$anonfun$getServiceNodesInfo$4(x$5))))).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).head(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).last()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                Option version = attributes.get((Object)"version");
                Option engineRefId = attributes.get((Object)"refId");
                String engineIdStr = (String)attributes.get((Object)"kyuubi.engine.id").map((Function1 & Serializable & scala.Serializable)x$6 -> new StringBuilder(11).append(" engine id:").append((String)x$6).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Get service instance:").append(instance).append(engineIdStr).append(" and version:").append(version.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" ").append("under ").append(namespace).toString());
                return new ServiceNodeInfo(namespace, (String)p, host2, port2, (Option<String>)version, (Option<String>)engineRefId, (Map<String, String>)attributes);
            }, Buffer$.MODULE$.canBuildFrom());
        }
        catch (Exception exception) {
            if (silent) {
                nil$ = Nil$.MODULE$;
            } else {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Failed to get service node info", exception);
                nil$ = Nil$.MODULE$;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return nil$;
    }

    @Override
    public Option<Object> getServiceNodesInfo$default$2() {
        return None$.MODULE$;
    }

    @Override
    public boolean getServiceNodesInfo$default$3() {
        return false;
    }

    @Override
    public void registerService(KyuubiConf conf, String namespace, ServiceDiscovery serviceDiscovery, Option<String> version, boolean external) {
        String instance = serviceDiscovery.fe().connectionUrl();
        this.watcher_$eq(new DeRegisterWatcher(this, instance, serviceDiscovery));
        this.serviceNode_$eq(this.createPersistentNode(conf, namespace, instance, version, external, (Map<String, String>)serviceDiscovery.fe().attributes()));
        this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$watchNode();
    }

    @Override
    public Option<String> registerService$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean registerService$default$5() {
        return false;
    }

    @Override
    public void deregisterService() {
        if (this.serviceNode() != null) {
            block7: {
                try {
                    try {
                        this.serviceNode().close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof IOException ? true : throwable2 instanceof KeeperException) {
                            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Failed to close the persistent ephemeral znode").append(this.serviceNode().getActualPath()).toString(), throwable2);
                            break block7;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.serviceNode_$eq(null);
                }
            }
            return;
        }
    }

    @Override
    public boolean postDeregisterService(String namespace) {
        if (namespace != null) {
            boolean bl;
            try {
                this.delete(namespace, true);
                bl = true;
            }
            catch (KeeperException e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Failed to delete ").append(namespace).toString(), e);
                bl = false;
            }
            return bl;
        }
        return false;
    }

    @Override
    public String createAndGetServiceNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external) {
        return this.createPersistentNode(conf, namespace, instance, version, external, this.createPersistentNode$default$6()).getActualPath();
    }

    @Override
    public Option<String> createAndGetServiceNode$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean createAndGetServiceNode$default$5() {
        return false;
    }

    @Override
    @VisibleForTesting
    public void startSecretNode(String createMode, String basePath, String initData, boolean useProtection) {
        PersistentNode secretNode = new PersistentNode(this.zkClient(), CreateMode.valueOf((String)createMode), useProtection, basePath, initData.getBytes(StandardCharsets.UTF_8));
        secretNode.start();
    }

    @Override
    public boolean startSecretNode$default$4() {
        return false;
    }

    @Override
    public int getAndIncrement(String path, int delta) {
        DistributedAtomicInteger dai = new DistributedAtomicInteger(this.zkClient(), path, (RetryPolicy)new RetryForever(1000));
        AtomicValue atomicVal = null;
        while ((atomicVal = dai.add(Predef$.MODULE$.int2Integer(delta))) == null || !atomicVal.succeeded()) {
        }
        return (Integer)atomicVal.preValue();
    }

    @Override
    public int getAndIncrement$default$2() {
        return 1;
    }

    public String addConfsToPublish(KyuubiConf conf, String instance) {
        if (!instance.contains(":")) {
            return instance;
        }
        String[] hostPort = instance.split(":", 2);
        scala.collection.mutable.Map confsToPublish = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.bind.host"), (Object)hostPort[0]));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.transport.mode"), (Object)"binary"));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.port"), (Object)hostPort[1]));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.sasl.qop"), conf.get(KyuubiConf$.MODULE$.SASL_QOP())));
        String authenticationMethod = ((TraversableOnce)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).mkString(",");
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.authentication"), (Object)authenticationMethod));
        Object object = authenticationMethod.equalsIgnoreCase("KERBEROS") ? confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.authentication.kerberos.principal"), ((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_PRINCIPAL())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))) : BoxedUnit.UNIT;
        return ((TraversableOnce)confsToPublish.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(1).append(k).append("=").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).mkString(";");
    }

    private PersistentNode createPersistentNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external, Map<String, String> attributes) {
        Object object;
        String ns = ZKPaths.makePath(null, (String)namespace);
        try {
            object = ((PathAndBytesable)this.zkClient().create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(ns);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            object = BoxedUnit.UNIT;
        }
        catch (KeeperException e) {
            throw new KyuubiException(new StringBuilder(29).append("Failed to create namespace '").append(ns).append("'").toString(), (Throwable)e);
        }
        String session = (String)((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID())).map((Function1 & Serializable & scala.Serializable)refId -> new StringBuilder(7).append("refId=").append((String)refId).append(";").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String extraInfo = ((TraversableOnce)attributes.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString(";", ";", "");
        String pathPrefix = ZKPaths.makePath((String)namespace, (String)new StringBuilder(30).append("serviceUri=").append(instance).append(";version=").append(version.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.KYUUBI_VERSION())).append(new StringOps(Predef$.MODULE$.augmentString(extraInfo)).stripSuffix(";")).append(";").append(session).append("sequence=").toString());
        ObjectRef localServiceNode = ObjectRef.create(null);
        CreateMode createMode = external ? CreateMode.PERSISTENT_SEQUENTIAL : CreateMode.EPHEMERAL_SEQUENTIAL;
        String znodeData = BoxesRunTime.unboxToBoolean((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_PUBLISH_CONFIGS())) && session.isEmpty() ? this.addConfsToPublish(conf, instance) : instance;
        try {
            localServiceNode.elem = new PersistentNode(this.zkClient(), createMode, false, pathPrefix, znodeData.getBytes(StandardCharsets.UTF_8));
            ((PersistentNode)localServiceNode.elem).start();
            long znodeTimeout = BoxesRunTime.unboxToLong((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_NODE_TIMEOUT()));
            if (!((PersistentNode)localServiceNode.elem).waitForInitialCreate(znodeTimeout, TimeUnit.MILLISECONDS)) {
                throw new KyuubiException(new StringBuilder(41).append("Max znode creation wait time ").append(znodeTimeout).append(" s exhausted").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Created a ").append(((PersistentNode)localServiceNode$1.elem).getActualPath()).append(" on ZooKeeper for KyuubiServer uri:").append(" ").append(instance).toString());
        }
        catch (Exception e) {
            if ((PersistentNode)localServiceNode.elem != null) {
                ((PersistentNode)localServiceNode.elem).close();
            }
            throw new KyuubiException(new StringBuilder(51).append("Unable to create a znode for this server instance: ").append(instance).toString(), (Throwable)e);
        }
        return (PersistentNode)localServiceNode.elem;
    }

    private Option<String> createPersistentNode$default$4() {
        return None$.MODULE$;
    }

    private boolean createPersistentNode$default$5() {
        return false;
    }

    private Map<String, String> createPersistentNode$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public void org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$watchNode() {
        if (((Pathable)this.zkClient().checkExists().usingWatcher((Watcher)this.watcher())).forPath(this.serviceNode().getActualPath()) == null) {
            throw new KyuubiException(new StringBuilder(63).append("Unable to create znode for this Kyuubi ").append("instance[").append(this.watcher().instance()).append("] on ZooKeeper.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getEngineByRefId$1(String engineRefId$1, ServiceNodeInfo x$1) {
        return x$1.engineRefId().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals(engineRefId$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getServiceNodesInfo$4(String[] x$5) {
        return x$5.length == 2;
    }

    public ZookeeperDiscoveryClient(KyuubiConf conf) {
        this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$conf = conf;
        Logging.$init$((Logging)this);
        this.zkClient = ZookeeperClientProvider$.MODULE$.buildZookeeperClient(conf);
    }

    public class DeRegisterWatcher
    implements Watcher {
        private final String instance;
        private final ServiceDiscovery serviceDiscovery;
        public final /* synthetic */ ZookeeperDiscoveryClient $outer;

        public String instance() {
            return this.instance;
        }

        public void process(WatchedEvent event) {
            Watcher.Event.EventType eventType = event.getType();
            Watcher.Event.EventType eventType2 = Watcher.Event.EventType.NodeDeleted;
            if (!(eventType != null ? !eventType.equals(eventType2) : eventType2 != null)) {
                this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$DeRegisterWatcher$$$outer().warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(128).append("This Kyuubi instance ").append(this.instance()).append(" is now de-registered from").append(" ZooKeeper. The server will be shut down after the last client session completes.").toString());
                this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$DeRegisterWatcher$$$outer().deregisterService();
                this.serviceDiscovery.stopGracefully(this.serviceDiscovery.stopGracefully$default$1());
                return;
            }
            Watcher.Event.EventType eventType3 = event.getType();
            Watcher.Event.EventType eventType4 = Watcher.Event.EventType.NodeDataChanged;
            if (!(eventType3 != null ? !eventType3.equals(eventType4) : eventType4 != null)) {
                this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$DeRegisterWatcher$$$outer().warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("This Kyuubi instance ").append(this.instance()).append(" now receives the NodeDataChanged event").toString());
                this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$DeRegisterWatcher$$$outer().org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$watchNode();
                return;
            }
        }

        public /* synthetic */ ZookeeperDiscoveryClient org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$DeRegisterWatcher$$$outer() {
            return this.$outer;
        }

        public DeRegisterWatcher(ZookeeperDiscoveryClient $outer, String instance, ServiceDiscovery serviceDiscovery) {
            this.instance = instance;
            this.serviceDiscovery = serviceDiscovery;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

