/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino.session;

import io.airlift.units.Duration;
import io.trino.client.ClientSession;
import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.trino.TrinoConf$;
import org.apache.kyuubi.engine.trino.TrinoContext;
import org.apache.kyuubi.engine.trino.TrinoContext$;
import org.apache.kyuubi.engine.trino.TrinoStatement;
import org.apache.kyuubi.engine.trino.TrinoStatement$;
import org.apache.kyuubi.engine.trino.event.TrinoSessionEvent;
import org.apache.kyuubi.engine.trino.event.TrinoSessionEvent$;
import org.apache.kyuubi.events.EventBus$;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.session.AbstractSession;
import org.apache.kyuubi.session.SessionManager;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001\u0002\u000f\u001e\u0001)B\u0011\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u001f\t\u0013y\u0002!\u0011!Q\u0001\n}b\u0005\"C'\u0001\u0005\u0003\u0005\u000b\u0011B O\u0011%y\u0005A!A!\u0002\u0013y\u0004\u000bC\u0005R\u0001\t\u0005\t\u0015!\u0003S+\"Ia\u000b\u0001B\u0001B\u0003%qK\u0017\u0005\u00067\u0002!\t\u0001\u0018\u0005\nK\u0002\u0001\r\u00111A\u0005\u0002\u0019D\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011\u00017\t\u0013M\u0004\u0001\u0019!A!B\u00139\u0007\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0003v\u0011)y\b\u00011AA\u0002\u0013%\u0011\u0011\u0001\u0005\u000b\u0003\u000b\u0001\u0001\u0019!A!B\u00131\b\"CA\u0004\u0001\u0001\u0007I\u0011BA\u0005\u0011%\tY\u0001\u0001a\u0001\n\u0013\ti\u0001C\u0004\u0002\u0012\u0001\u0001\u000b\u0015B \t\u0013\u0005M\u0001\u00011A\u0005\n\u0005%\u0001\"CA\u000b\u0001\u0001\u0007I\u0011BA\f\u0011\u001d\tY\u0002\u0001Q!\n}B\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u0011\u00055\u0002\u0001)A\u0005\u0003CAq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u00024\u0001!I!!\u000e\t\u000f\u0005]\u0002\u0001\"\u0015\u0002:!9\u0011q\n\u0001\u0005B\u0005E\u0003bBA2\u0001\u0011%\u0011\u0011\u0002\u0005\b\u0003K\u0002A\u0011IA\u0019\u0005A!&/\u001b8p'\u0016\u001c8/[8o\u00136\u0004HN\u0003\u0002\u001f?\u000591/Z:tS>t'B\u0001\u0011\"\u0003\u0015!(/\u001b8p\u0015\t\u00113%\u0001\u0004f]\u001eLg.\u001a\u0006\u0003I\u0015\naa[=vk\nL'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001WA\u0011AFL\u0007\u0002[)\u0011adI\u0005\u0003_5\u0012q\"\u00112tiJ\f7\r^*fgNLwN\\\u0001\taJ|Go\\2pYB\u0011!gO\u0007\u0002g)\u0011A'N\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\u0005Y:\u0014a\u0001:qG*\u0011\u0001(O\u0001\bg\u0016\u0014h/[2f\u0015\tQT%\u0001\u0003iSZ,\u0017B\u0001\u001f4\u0005A!\u0006K]8u_\u000e|GNV3sg&|g.\u0003\u00021]\u0005!Qo]3s!\t\u0001\u0015J\u0004\u0002B\u000fB\u0011!)R\u0007\u0002\u0007*\u0011A)K\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011\u0016K!A\u0010\u0018\u0002\u0011A\f7o]<pe\u0012L!!\u0014\u0018\u0002\u0013%\u0004\u0018\t\u001a3sKN\u001c\u0018BA(/\u0003\u0011\u0019wN\u001c4\u0011\t\u0001\u001bvhP\u0005\u0003).\u00131!T1q\u0013\t\tf&\u0001\btKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u0011\u00051B\u0016BA-.\u00059\u0019Vm]:j_:l\u0015M\\1hKJL!A\u0016\u0018\u0002\rqJg.\u001b;?)\u001div\fY1cG\u0012\u0004\"A\u0018\u0001\u000e\u0003uAQ\u0001M\u0004A\u0002EBQAP\u0004A\u0002}BQ!T\u0004A\u0002}BQaT\u0004A\u0002}BQ!U\u0004A\u0002ICQAV\u0004A\u0002]\u000bA\u0002\u001e:j]>\u001cuN\u001c;fqR,\u0012a\u001a\t\u0003Q&l\u0011aH\u0005\u0003U~\u0011A\u0002\u0016:j]>\u001cuN\u001c;fqR\f\u0001\u0003\u001e:j]>\u001cuN\u001c;fqR|F%Z9\u0015\u00055\f\bC\u00018p\u001b\u0005)\u0015B\u00019F\u0005\u0011)f.\u001b;\t\u000fIL\u0011\u0011!a\u0001O\u0006\u0019\u0001\u0010J\u0019\u0002\u001bQ\u0014\u0018N\\8D_:$X\r\u001f;!\u00035\u0019G.[3oiN+7o]5p]V\ta\u000f\u0005\u0002x{6\t\u0001P\u0003\u0002zu\u000611\r\\5f]RT!\u0001I>\u000b\u0003q\f!![8\n\u0005yD(!D\"mS\u0016tGoU3tg&|g.A\tdY&,g\u000e^*fgNLwN\\0%KF$2!\\A\u0002\u0011\u001d\u0011H\"!AA\u0002Y\fab\u00197jK:$8+Z:tS>t\u0007%A\u0006dCR\fGn\\4OC6,W#A \u0002\u001f\r\fG/\u00197pO:\u000bW.Z0%KF$2!\\A\b\u0011\u001d\u0011x\"!AA\u0002}\nAbY1uC2|wMT1nK\u0002\nA\u0002Z1uC\n\f7/\u001a(b[\u0016\f\u0001\u0003Z1uC\n\f7/\u001a(b[\u0016|F%Z9\u0015\u00075\fI\u0002C\u0004s%\u0005\u0005\t\u0019A \u0002\u001b\u0011\fG/\u00192bg\u0016t\u0015-\\3!\u00031\u0019Xm]:j_:,e/\u001a8u+\t\t\t\u0003\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9cH\u0001\u0006KZ,g\u000e^\u0005\u0005\u0003W\t)CA\tUe&twnU3tg&|g.\u0012<f]R\fQb]3tg&|g.\u0012<f]R\u0004\u0013\u0001B8qK:$\u0012!\\\u0001\u0014GJ,\u0017\r^3DY&,g\u000e^*fgNLwN\u001c\u000b\u0002m\u0006a!/\u001e8Pa\u0016\u0014\u0018\r^5p]R!\u00111HA$!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!G\u0005Iq\u000e]3sCRLwN\\\u0005\u0005\u0003\u000b\nyDA\bPa\u0016\u0014\u0018\r^5p]\"\u000bg\u000e\u001a7f\u0011\u001d\t\t\u0005\u0007a\u0001\u0003\u0013\u0002B!!\u0010\u0002L%!\u0011QJA \u0005%y\u0005/\u001a:bi&|g.A\u0004hKRLeNZ8\u0015\t\u0005M\u0013\u0011\f\t\u0004e\u0005U\u0013bAA,g\tiAkR3u\u0013:4wNV1mk\u0016Dq!a\u0017\u001a\u0001\u0004\ti&\u0001\u0005j]\u001a|G+\u001f9f!\r\u0011\u0014qL\u0005\u0004\u0003C\u001a$\u0001\u0004+HKRLeNZ8UsB,\u0017!F4fiR\u0013\u0018N\\8TKJ4XM\u001d,feNLwN\\\u0001\u0006G2|7/\u001a")
public class TrinoSessionImpl
extends AbstractSession {
    private TrinoContext trinoContext;
    private ClientSession clientSession;
    private String catalogName = null;
    private String databaseName = null;
    private final TrinoSessionEvent sessionEvent = TrinoSessionEvent$.MODULE$.apply(this);

    public TrinoContext trinoContext() {
        return this.trinoContext;
    }

    public void trinoContext_$eq(TrinoContext x$1) {
        this.trinoContext = x$1;
    }

    private ClientSession clientSession() {
        return this.clientSession;
    }

    private void clientSession_$eq(ClientSession x$1) {
        this.clientSession = x$1;
    }

    private String catalogName() {
        return this.catalogName;
    }

    private void catalogName_$eq(String x$1) {
        this.catalogName = x$1;
    }

    private String databaseName() {
        return this.databaseName;
    }

    private void databaseName_$eq(String x$1) {
        this.databaseName = x$1;
    }

    private TrinoSessionEvent sessionEvent() {
        return this.sessionEvent;
    }

    public void open() {
        this.normalizedConf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TrinoSessionImpl.$anonfun$open$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        OkHttpClient httpClient = new OkHttpClient.Builder().build();
        this.clientSession_$eq(this.createClientSession());
        this.trinoContext_$eq(TrinoContext$.MODULE$.apply(httpClient, this.clientSession()));
        super.open();
        EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
    }

    private ClientSession createClientSession() {
        KyuubiConf sessionConf = super.sessionManager().getConf();
        String connectionUrl = (String)((Option)sessionConf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_URL())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw KyuubiSQLException$.MODULE$.apply("Trino server url can not be null!", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
        if (this.catalogName() == null) {
            this.catalogName_$eq((String)((Option)sessionConf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_CATALOG())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw KyuubiSQLException$.MODULE$.apply("Trino default catalog can not be null!", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }));
        }
        String user = (String)sessionConf.getOption("kyuubi.session.user").getOrElse((Function0 & Serializable & scala.Serializable)() -> Utils$.MODULE$.currentUser());
        long clientRequestTimeout = BoxesRunTime.unboxToLong((Object)sessionConf.get(TrinoConf$.MODULE$.CLIENT_REQUEST_TIMEOUT()));
        return new ClientSession(URI.create(connectionUrl), user, Optional.empty(), "kyuubi", Optional.empty(), Collections.emptySet(), null, this.catalogName(), this.databaseName(), null, ZoneId.systemDefault(), Locale.getDefault(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), null, new Duration((double)clientRequestTimeout, TimeUnit.MILLISECONDS), true);
    }

    public OperationHandle runOperation(Operation operation) {
        this.sessionEvent().totalOperations_$eq(this.sessionEvent().totalOperations() + 1);
        return super.runOperation(operation);
    }

    public TGetInfoValue getInfo(TGetInfoType infoType) {
        return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
            TGetInfoType tGetInfoType = infoType;
            if (TGetInfoType.CLI_SERVER_NAME.equals(tGetInfoType) ? true : TGetInfoType.CLI_DBMS_NAME.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)"Trino");
            }
            if (TGetInfoType.CLI_DBMS_VER.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)this.getTrinoServerVersion());
            }
            if (TGetInfoType.CLI_ODBC_KEYWORDS.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)"Unimplemented");
            }
            if (TGetInfoType.CLI_MAX_COLUMN_NAME_LEN.equals(tGetInfoType) ? true : (TGetInfoType.CLI_MAX_SCHEMA_NAME_LEN.equals(tGetInfoType) ? true : TGetInfoType.CLI_MAX_TABLE_NAME_LEN.equals(tGetInfoType))) {
                return TGetInfoValue.lenValue((long)0L);
            }
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    private String getTrinoServerVersion() {
        TrinoStatement trinoStatement = TrinoStatement$.MODULE$.apply(this.trinoContext(), super.sessionManager().getConf(), "SELECT version()", TrinoStatement$.MODULE$.apply$default$4());
        Iterator<List<Object>> resultSet = trinoStatement.execute();
        Predef$.MODULE$.assert(resultSet.hasNext());
        return ((IterableLike)resultSet.next()).head().toString();
    }

    public void close() {
        this.sessionEvent().endTime_$eq(System.currentTimeMillis());
        EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
        super.close();
    }

    public static final /* synthetic */ void $anonfun$open$1(TrinoSessionImpl $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String catalog = (String)tuple2._2();
            if ("use:catalog".equals(string)) {
                $this.catalogName_$eq(catalog);
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String database = (String)tuple2._2();
            if ("use:database".equals(string)) {
                $this.databaseName_$eq(database);
                return;
            }
        }
    }

    public TrinoSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf, SessionManager sessionManager) {
        super(protocol, user, password, ipAddress, conf, sessionManager);
    }
}

