/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ctl.cmd.delete;

import java.io.Serializable;
import org.apache.kyuubi.ctl.cmd.Command;
import org.apache.kyuubi.ctl.opt.CliConfig;
import org.apache.kyuubi.ctl.util.CtlUtils$;
import org.apache.kyuubi.ctl.util.Render$;
import org.apache.kyuubi.ctl.util.Validator$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d3AAB\u0004\u0001)!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003B\u0001\u0011\u0005!\tC\u0003D\u0001\u0011\u0005AIA\u0007EK2,G/Z\"p[6\fg\u000e\u001a\u0006\u0003\u0011%\ta\u0001Z3mKR,'B\u0001\u0006\f\u0003\r\u0019W\u000e\u001a\u0006\u0003\u00195\t1a\u0019;m\u0015\tqq\"\u0001\u0004lsV,(-\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001)\u0002c\u0001\f\u001835\t\u0011\"\u0003\u0002\u0019\u0013\t91i\\7nC:$\u0007c\u0001\u000e%O9\u00111$\t\b\u00039}i\u0011!\b\u0006\u0003=M\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t\u001a\u0013a\u00029bG.\fw-\u001a\u0006\u0002A%\u0011QE\n\u0002\u0004'\u0016\f(B\u0001\u0012$!\tAS&D\u0001*\u0015\tQ3&\u0001\u0004dY&,g\u000e\u001e\u0006\u0003Y5\t!\u0001[1\n\u00059J#aD*feZL7-\u001a(pI\u0016LeNZ8\u0002\u0013\rd\u0017nQ8oM&<\u0007CA\u00195\u001b\u0005\u0011$BA\u001a\f\u0003\ry\u0007\u000f^\u0005\u0003kI\u0012\u0011b\u00117j\u0007>tg-[4\u0002\rqJg.\u001b;?)\tA$\b\u0005\u0002:\u00015\tq\u0001C\u00030\u0005\u0001\u0007\u0001'\u0001\u0005wC2LG-\u0019;f)\u0005i\u0004C\u0001 @\u001b\u0005\u0019\u0013B\u0001!$\u0005\u0011)f.\u001b;\u0002\u000b\u0011|'+\u001e8\u0015\u0003e\taA]3oI\u0016\u0014HCA\u001fF\u0011\u00151U\u00011\u0001\u001a\u0003\u0015qw\u000eZ3t\u0001")
public class DeleteCommand
extends Command<Seq<ServiceNodeInfo>> {
    @Override
    public void validate() {
        Validator$.MODULE$.validateZkArguments(this.normalizedCliConfig());
        Validator$.MODULE$.validateHostAndPort(this.normalizedCliConfig());
        this.mergeArgsIntoKyuubiConf();
    }

    @Override
    public Seq<ServiceNodeInfo> doRun() {
        return (Seq)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(this.conf(), (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            String znodeRoot = CtlUtils$.MODULE$.getZkNamespace(this.conf(), this.normalizedCliConfig());
            Some hostPortOpt = new Some((Object)new Tuple2((Object)this.normalizedCliConfig().zkOpts().host(), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(this.normalizedCliConfig().zkOpts().port())).toInt())));
            Seq<ServiceNodeInfo> nodesToDelete = CtlUtils$.MODULE$.getServiceNodes((DiscoveryClient)discoveryClient, znodeRoot, (Option<Tuple2<String, Object>>)hostPortOpt);
            ListBuffer deletedNodes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            nodesToDelete.foreach((Function1 & Serializable & scala.Serializable)node -> {
                ListBuffer listBuffer;
                String nodePath = new StringBuilder(1).append(znodeRoot).append("/").append(node.nodeName()).toString();
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Deleting zookeeper service node:").append(nodePath).toString());
                try {
                    discoveryClient.delete(nodePath, discoveryClient.delete$default$2());
                    listBuffer = deletedNodes.$plus$eq(node);
                }
                catch (Exception e) {
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to delete zookeeper service node:").append(nodePath).toString(), e);
                    listBuffer = BoxedUnit.UNIT;
                }
                return listBuffer;
            });
            return deletedNodes;
        });
    }

    @Override
    public void render(Seq<ServiceNodeInfo> nodes) {
        String title = "Deleted zookeeper service nodes";
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> Render$.MODULE$.renderServiceNodesInfo(title, nodes));
    }

    public DeleteCommand(CliConfig cliConfig) {
        super(cliConfig);
    }
}

