/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.metadata.jdbc;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.google.common.annotations.VisibleForTesting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.server.metadata.MetadataStore;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.server.metadata.jdbc.DatabaseType$;
import org.apache.kyuubi.server.metadata.jdbc.DerbyDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.GenericDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStore$;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStoreConf$;
import org.apache.kyuubi.server.metadata.jdbc.JdbcDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.MysqlDatabaseDialect;
import org.apache.kyuubi.session.SessionType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\rmb\u0001B\u001b7\u0001\rC\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\u00067\u0002!\t\u0001\u0018\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u0019a\u0007\u0001)A\u0005E\"9Q\u000e\u0001b\u0001\n\u0013q\u0007B\u0002@\u0001A\u0003%q\u000e\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nMD\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u0013A\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u0003+A\u0011\"a\t\u0001\u0005\u0004%I!!\n\t\u0011\u0005m\u0002\u0001)A\u0005\u0003OA!\"!\u0010\u0001\u0005\u0004%\t\u0001PA \u0011!\t9\u0005\u0001Q\u0001\n\u0005\u0005\u0003\"CA0\u0001\t\u0007I\u0011BA1\u0011!\t9\b\u0001Q\u0001\n\u0005\r\u0004\"CA=\u0001\t\u0007I\u0011BA\u0001\u0011\u001d\tY\b\u0001Q\u0001\nMDq!! \u0001\t\u0013\ty\b\u0003\u0005\u0002\b\u0002!\tANAE\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!a1\u0001\t\u0003\t)\rC\u0004\u0002^\u0002!\t%a \t\u000f\u0005}\u0007\u0001\"\u0011\u0002b\"9\u0011\u0011\u001f\u0001\u0005B\u0005M\bb\u0002B\u0002\u0001\u0011\u0005#Q\u0001\u0005\b\u0005;\u0001A\u0011\tB\u0010\u0011\u001d\u0011\u0019\u0003\u0001C!\u0005KAqA!\u000b\u0001\t\u0003\u0012Y\u0003C\u0004\u00038\u0001!IA!\u000f\t\u000f\t5\u0003\u0001\"\u0003\u0003P!9!Q\u000e\u0001\u0005\n\t=\u0004b\u0002BK\u0001\u0011%!q\u0013\u0005\b\u0005W\u0003A\u0011\u0002BW\u0011\u001d\u0011Y\f\u0001C\u0005\u0005{C\u0011Ba4\u0001#\u0003%IA!5\t\u000f\t-\b\u0001\"\u0003\u0003n\"9!1\u001f\u0001\u0005\n\tU\bbBB\u0001\u0001\u0011%11A\u0004\b\u0007\u000f1\u0004\u0012AB\u0005\r\u0019)d\u0007#\u0001\u0004\f!11l\u000bC\u0001\u0007'A\u0011b!\u0006,\u0005\u0004%Iaa\u0006\t\u0011\r\u001d2\u0006)A\u0005\u00073A\u0011b!\u000b,\u0005\u0004%Iaa\u000b\t\u0011\rE2\u0006)A\u0005\u0007[A\u0011ba\r,\u0005\u0004%I!!\u0001\t\u000f\rU2\u0006)A\u0005g\"I1qG\u0016C\u0002\u0013%\u0011\u0011\u0001\u0005\b\u0007sY\u0003\u0015!\u0003t\u0005EQEIQ\"NKR\fG-\u0019;b'R|'/\u001a\u0006\u0003oa\nAA\u001b3cG*\u0011\u0011HO\u0001\t[\u0016$\u0018\rZ1uC*\u00111\bP\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005ur\u0014AB6zkV\u0014\u0017N\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0011c\u0005\u000b\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!A.\u00198h\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\r=\u0013'.Z2u!\tie*D\u00019\u0013\ty\u0005HA\u0007NKR\fG-\u0019;b'R|'/\u001a\t\u0003#Jk\u0011\u0001P\u0005\u0003'r\u0012q\u0001T8hO&tw-\u0001\u0003d_:4\u0007C\u0001,Z\u001b\u00059&B\u0001-=\u0003\u0019\u0019wN\u001c4jO&\u0011!l\u0016\u0002\u000b\u0017f,XOY5D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u0002^?B\u0011a\fA\u0007\u0002m!)AK\u0001a\u0001+\u00061AM\u0019+za\u0016,\u0012A\u0019\t\u0003G\u001at!A\u00183\n\u0005\u00154\u0014\u0001\u0004#bi\u0006\u0014\u0017m]3UsB,\u0017BA4i\u0005\u00151\u0016\r\\;f\u0013\tI'NA\u0006F]VlWM]1uS>t'\"A6\u0002\u000bM\u001c\u0017\r\\1\u0002\u000f\u0011\u0014G+\u001f9fA\u0005qAM]5wKJ\u001cE.Y:t\u001fB$X#A8\u0011\u0007A\f8/D\u0001k\u0013\t\u0011(N\u0001\u0004PaRLwN\u001c\t\u0003int!!^=\u0011\u0005YTW\"A<\u000b\u0005a\u0014\u0015A\u0002\u001fs_>$h(\u0003\u0002{U\u00061\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQ(.A\bee&4XM]\"mCN\u001cx\n\u001d;!\u0003-!'/\u001b<fe\u000ec\u0017m]:\u0016\u0003M\fA\u0002\u001a:jm\u0016\u00148\t\\1tg\u0002\nq\u0002Z1uC\n\f7/Z!eCB$xN]\u000b\u0003\u0003\u0013\u00012AXA\u0006\u0013\r\tiA\u000e\u0002\u0014\u0015\u0012\u00147\rR1uC\n\f7/\u001a#jC2,7\r^\u0001\u0011I\u0006$\u0018MY1tK\u0006#\u0017\r\u001d;pe\u0002\nA\u0003Z1uCN|WO]2f!J|\u0007/\u001a:uS\u0016\u001cXCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e\u0011\u0006!Q\u000f^5m\u0013\u0011\ty\"!\u0007\u0003\u0015A\u0013x\u000e]3si&,7/A\u000beCR\f7o\\;sG\u0016\u0004&o\u001c9feRLWm\u001d\u0011\u0002\u0019!L7.\u0019:j\u0007>tg-[4\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003oi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0007Q&\\\u0017M]5\u000b\t\u0005E\u00121G\u0001\u0007u\u0006D\b0\u001a:\u000b\u0005\u0005U\u0012aA2p[&!\u0011\u0011HA\u0016\u00051A\u0015n[1sS\u000e{gNZ5h\u00035A\u0017n[1sS\u000e{gNZ5hA\u0005\u0001\u0002.[6be&$\u0015\r^1T_V\u00148-Z\u000b\u0003\u0003\u0003\u0002B!!\u000b\u0002D%!\u0011QIA\u0016\u0005AA\u0015n[1sS\u0012\u000bG/Y*pkJ\u001cW-A\tiS.\f'/\u001b#bi\u0006\u001cv.\u001e:dK\u0002B3\u0001EA&!\u0011\ti%a\u0017\u000e\u0005\u0005=#\u0002BA)\u0003'\n1\"\u00198o_R\fG/[8og*!\u0011QKA,\u0003\u0019\u0019w.\\7p]*!\u0011\u0011LA\u001a\u0003\u00199wn\\4mK&!\u0011QLA(\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\u0007[\u0006\u0004\b/\u001a:\u0016\u0005\u0005\r\u0004\u0003BA3\u0003gj!!a\u001a\u000b\t\u0005%\u00141N\u0001\tI\u0006$\u0018MY5oI*!\u0011QNA8\u0003\u001dQ\u0017mY6t_:TA!!\u001d\u00024\u0005Ia-Y:uKJDX\u000e\\\u0005\u0005\u0003k\n9G\u0001\u0007PE*,7\r^'baB,'/A\u0004nCB\u0004XM\u001d\u0011\u0002\u001dQ,'/\\5oC2\u001cF/\u0019;fg\u0006yA/\u001a:nS:\fGn\u0015;bi\u0016\u001c\b%\u0001\u0006j]&$8k\u00195f[\u0006$\"!!!\u0011\u0007A\f\u0019)C\u0002\u0002\u0006*\u0014A!\u00168ji\u0006iq-\u001a;J]&$8k\u00195f[\u0006$2a\\AF\u0011\u0019\u0001g\u00031\u0001\u0002\u000eB!\u0011qRAU\u001d\r\t\t\n\u001a\b\u0005\u0003'\u000b9K\u0004\u0003\u0002\u0016\u0006\u0015f\u0002BAL\u0003GsA!!'\u0002\":!\u00111TAP\u001d\r1\u0018QT\u0005\u0002\u0003&\u0011q\bQ\u0005\u0003{yJ!a\u000f\u001f\n\u0005eR\u0014BA\u001c9\u0013\u0011\tY+!,\u0003\u0019\u0011\u000bG/\u00192bg\u0016$\u0016\u0010]3\u000b\u0005\u00154\u0014\u0001E4fiN\u001b\u0007.Z7b-\u0016\u00148/[8o)\u0011\t\u0019,a0\u0011\u0013A\f),!/\u0002:\u0006e\u0016bAA\\U\n1A+\u001e9mKN\u00022\u0001]A^\u0013\r\tiL\u001b\u0002\u0004\u0013:$\bBBAa/\u0001\u00071/A\u0005tG\",W.Y+sY\u0006\u0011r-\u001a;MCR,7\u000f^*dQ\u0016l\u0017-\u0016:m)\ry\u0017q\u0019\u0005\b\u0003\u0013D\u0002\u0019AAf\u0003)\u00198\r[3nCV\u0013Hn\u001d\t\u0006\u0003\u001b\f9n\u001d\b\u0005\u0003\u001f\f\u0019ND\u0002w\u0003#L\u0011a[\u0005\u0004\u0003+T\u0017a\u00029bG.\fw-Z\u0005\u0005\u00033\fYNA\u0002TKFT1!!6k\u0003\u0015\u0019Gn\\:f\u00039Ign]3si6+G/\u00193bi\u0006$B!!!\u0002d\"1\u0011H\u0007a\u0001\u0003K\u0004B!a:\u0002n6\u0011\u0011\u0011\u001e\u0006\u0004\u0003WD\u0014aA1qS&!\u0011q^Au\u0005!iU\r^1eCR\f\u0017aC4fi6+G/\u00193bi\u0006$b!!:\u0002v\u0006e\bBBA|7\u0001\u00071/\u0001\u0006jI\u0016tG/\u001b4jKJDq!a?\u001c\u0001\u0004\ti0A\u0005ti\u0006$Xm\u00148msB\u0019\u0001/a@\n\u0007\t\u0005!NA\u0004C_>dW-\u00198\u0002\u001f\u001d,G/T3uC\u0012\fG/\u0019'jgR$\"Ba\u0002\u0003\n\tM!q\u0003B\u000e!\u0019\ti-a6\u0002f\"9!1\u0002\u000fA\u0002\t5\u0011A\u00024jYR,'\u000f\u0005\u0003\u0002h\n=\u0011\u0002\u0002B\t\u0003S\u0014a\"T3uC\u0012\fG/\u0019$jYR,'\u000fC\u0004\u0003\u0016q\u0001\r!!/\u0002\t\u0019\u0014x.\u001c\u0005\b\u00053a\u0002\u0019AA]\u0003\u0011\u0019\u0018N_3\t\u000f\u0005mH\u00041\u0001\u0002~\u0006qQ\u000f\u001d3bi\u0016lU\r^1eCR\fG\u0003BAA\u0005CAa!O\u000fA\u0002\u0005\u0015\u0018aG2mK\u0006tW\u000f]'fi\u0006$\u0017\r^1Cs&#WM\u001c;jM&,'\u000f\u0006\u0003\u0002\u0002\n\u001d\u0002BBA|=\u0001\u00071/\u0001\u000bdY\u0016\fg.\u001e9NKR\fG-\u0019;b\u0005f\fu-\u001a\u000b\u0005\u0003\u0003\u0013i\u0003C\u0004\u00030}\u0001\rA!\r\u0002\r5\f\u00070Q4f!\r\u0001(1G\u0005\u0004\u0005kQ'\u0001\u0002'p]\u001e\fQBY;jY\u0012lU\r^1eCR\fGC\u0002B\u0004\u0005w\u0011Y\u0005C\u0004\u0003>\u0001\u0002\rAa\u0010\u0002\u0013I,7/\u001e7u'\u0016$\b\u0003\u0002B!\u0005\u000fj!Aa\u0011\u000b\u0007\t\u0015\u0003*A\u0002tc2LAA!\u0013\u0003D\tI!+Z:vYR\u001cV\r\u001e\u0005\b\u0003w\u0004\u0003\u0019AA\u007f\u0003\u001d)\u00070Z2vi\u0016$\u0002\"!!\u0003R\tm#Q\f\u0005\b\u0005'\n\u0003\u0019\u0001B+\u0003\u0011\u0019wN\u001c8\u0011\t\t\u0005#qK\u0005\u0005\u00053\u0012\u0019E\u0001\u0006D_:tWm\u0019;j_:DaA!\u0012\"\u0001\u0004\u0019\bb\u0002B0C\u0001\u0007!\u0011M\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u000bA\u0014\u0019Ga\u001a\n\u0007\t\u0015$N\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u00022\u0001\u001dB5\u0013\r\u0011YG\u001b\u0002\u0004\u0003:L\u0018!D<ji\"\u0014Vm];miN+G/\u0006\u0003\u0003r\teD\u0003\u0003B:\u0005\u001f\u0013\tJa%\u0015\t\tU$Q\u0011\t\u0005\u0005o\u0012I\b\u0004\u0001\u0005\u000f\tm$E1\u0001\u0003~\t\tA+\u0005\u0003\u0003\u0000\t\u001d\u0004c\u00019\u0003\u0002&\u0019!1\u00116\u0003\u000f9{G\u000f[5oO\"9!q\u0011\u0012A\u0002\t%\u0015!\u00014\u0011\u000fA\u0014YIa\u0010\u0003v%\u0019!Q\u00126\u0003\u0013\u0019+hn\u0019;j_:\f\u0004b\u0002B*E\u0001\u0007!Q\u000b\u0005\u0007\u0005\u000b\u0012\u0003\u0019A:\t\u000f\t}#\u00051\u0001\u0003b\u0005yq/\u001b;i+B$\u0017\r^3D_VtG/\u0006\u0003\u0003\u001a\n}E\u0003\u0003BN\u0005K\u00139K!+\u0015\t\tu%\u0011\u0015\t\u0005\u0005o\u0012y\nB\u0004\u0003|\r\u0012\rA! \t\u000f\t\u001d5\u00051\u0001\u0003$B9\u0001Oa#\u0002:\nu\u0005b\u0002B*G\u0001\u0007!Q\u000b\u0005\u0007\u0005\u000b\u001a\u0003\u0019A:\t\u000f\t}3\u00051\u0001\u0003b\u0005\u00112/\u001a;Ti\u0006$X-\\3oiB\u000b'/Y7t)\u0019\t\tIa,\u0003:\"9!\u0011\u0017\u0013A\u0002\tM\u0016!C:uCR,W.\u001a8u!\u0011\u0011\tE!.\n\t\t]&1\t\u0002\u0012!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\bb\u0002B0I\u0001\u0007!\u0011M\u0001\u000fo&$\bnQ8o]\u0016\u001cG/[8o+\u0011\u0011yL!2\u0015\t\t\u0005'1\u001a\u000b\u0005\u0005\u0007\u00149\r\u0005\u0003\u0003x\t\u0015Ga\u0002B>K\t\u0007!Q\u0010\u0005\b\u0005\u000f+\u0003\u0019\u0001Be!\u001d\u0001(1\u0012B+\u0005\u0007D\u0011B!4&!\u0003\u0005\r!!@\u0002\u0015\u0005,Ho\\\"p[6LG/\u0001\rxSRD7i\u001c8oK\u000e$\u0018n\u001c8%I\u00164\u0017-\u001e7uIE*BAa5\u0003jV\u0011!Q\u001b\u0016\u0005\u0003{\u00149n\u000b\u0002\u0003ZB!!1\u001cBs\u001b\t\u0011iN\u0003\u0003\u0003`\n\u0005\u0018!C;oG\",7m[3e\u0015\r\u0011\u0019O[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bt\u0005;\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u001d\u0011YH\nb\u0001\u0005{\nQB^1mk\u0016\f5o\u0015;sS:<GcA:\u0003p\"9!\u0011_\u0014A\u0002\t\u001d\u0014aA8cU\u0006Q1\u000f\u001e:j]\u001e\u0014T*\u00199\u0015\t\t](Q \t\u0006i\ne8o]\u0005\u0004\u0005wl(aA'ba\"1!q \u0015A\u0002M\f1a\u001d;s\u0003)\u0019HO]5oOJ\u001aV-\u001d\u000b\u0005\u0003\u0017\u001c)\u0001\u0003\u0004\u0003\u0000&\u0002\ra]\u0001\u0012\u0015\u0012\u00135)T3uC\u0012\fG/Y*u_J,\u0007C\u00010,'\rY3Q\u0002\t\u0004a\u000e=\u0011bAB\tU\n1\u0011I\\=SK\u001a$\"a!\u0003\u0002%M\u001b\u0005*R'B?V\u0013Fj\u0018)B)R+%KT\u000b\u0003\u00073\u0001Baa\u0007\u0004$5\u00111Q\u0004\u0006\u0005\u0007?\u0019\t#\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\r\tYB[\u0005\u0005\u0007K\u0019iBA\u0003SK\u001e,\u00070A\nT\u0007\"+U*Q0V%2{\u0006+\u0011+U\u000bJs\u0005%\u0001\bN\u000bR\u000bE)\u0011+B?R\u000b%\tT#\u0016\u0005\r5\u0002cA#\u00040%\u0011APR\u0001\u0010\u001b\u0016#\u0016\tR!U\u0003~#\u0016I\u0011'FA\u0005YR*\u0012+B\t\u0006#\u0016iX*U\u0003R+ul\u0014(M3~\u001bu\nT+N\u001dN\u000bA$T#U\u0003\u0012\u000bE+Q0T)\u0006#ViX(O\u0019f{6i\u0014'V\u001b:\u001b\u0006%\u0001\u000bN\u000bR\u000bE)\u0011+B?\u0006cEjX\"P\u0019VkejU\u0001\u0016\u001b\u0016#\u0016\tR!U\u0003~\u000bE\nT0D\u001f2+VJT*!\u0001")
public class JDBCMetadataStore
implements MetadataStore,
Logging {
    private final Enumeration.Value dbType;
    private final Option<String> driverClassOpt;
    private final String driverClass;
    private final JdbcDatabaseDialect databaseAdaptor;
    private final Properties datasourceProperties;
    private final HikariConfig hikariConfig;
    @VisibleForTesting
    private final HikariDataSource hikariDataSource;
    private final ObjectMapper mapper;
    private final String terminalStates;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private Enumeration.Value dbType() {
        return this.dbType;
    }

    private Option<String> driverClassOpt() {
        return this.driverClassOpt;
    }

    private String driverClass() {
        return this.driverClass;
    }

    private JdbcDatabaseDialect databaseAdaptor() {
        return this.databaseAdaptor;
    }

    private Properties datasourceProperties() {
        return this.datasourceProperties;
    }

    private HikariConfig hikariConfig() {
        return this.hikariConfig;
    }

    public HikariDataSource hikariDataSource() {
        return this.hikariDataSource;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private String terminalStates() {
        return this.terminalStates;
    }

    private void initSchema() {
        this.getInitSchema(this.dbType()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
            JDBCMetadataStore.$anonfun$initSchema$1(this, schema);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> getInitSchema(Enumeration.Value dbType) {
        ClassLoader classLoader = Utils$.MODULE$.getContextOrKyuubiClassLoader();
        String schemaPackage = new java.lang.StringBuilder(4).append("sql/").append(dbType.toString().toLowerCase()).toString();
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)classLoader.getResource(schemaPackage)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toURI()).flatMap((Function1 & Serializable & scala.Serializable)uri -> {
            String[] stringArray;
            String string = uri.getScheme();
            String string2 = "jar";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                try (FileSystem fs = FileSystems.newFileSystem(uri, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());){
                    stringArray = (String[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fs.getPath(schemaPackage, new String[0]), 1, new FileVisitOption[0]).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((Object)x$2.getFileName()).toString()).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getInitSchema$4(name))).toArray(ClassTag$.MODULE$.apply(String.class));
                }
            } else {
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Paths.get(uri).toFile().listFiles((x$3, name) -> JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined()))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            String[] pathNames = stringArray;
            return this.getLatestSchemaUrl((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])pathNames)).map((Function1 & Serializable & scala.Serializable)name -> new java.lang.StringBuilder(1).append(schemaPackage).append("/").append((String)name).toString()).map((Function1 & Serializable & scala.Serializable)schemaUrl -> {
                String string;
                try (InputStream inputStream = classLoader.getResourceAsStream((String)schemaUrl);){
                    string = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
                }
                return string;
            });
        })).headOption();
    }

    public Tuple3<Object, Object, Object> getSchemaVersion(String schemaUrl) {
        Option option = JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)schemaUrl);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(2))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(3))).toInt()));
        }
        throw new KyuubiException(new java.lang.StringBuilder(20).append("Invalid schema url: ").append(schemaUrl).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
    }

    public Option<String> getLatestSchemaUrl(Seq<String> schemaUrls) {
        return ((TraversableLike)schemaUrls.sortWith((Function2 & Serializable & scala.Serializable)(u1, u2) -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getLatestSchemaUrl$1(this, u1, u2)))).headOption();
    }

    @Override
    public void close() {
        this.hikariDataSource().close();
    }

    @Override
    public void insertMetadata(Metadata metadata) {
        String query = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(449).append("\n         |INSERT INTO ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("(\n         |identifier,\n         |session_type,\n         |real_user,\n         |user_name,\n         |ip_address,\n         |kyuubi_instance,\n         |state,\n         |resource,\n         |class_name,\n         |request_name,\n         |request_conf,\n         |request_args,\n         |create_time,\n         |engine_type,\n         |cluster_manager\n         |)\n         |VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n         |").toString())).stripMargin();
        this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata.identifier(), metadata.sessionType().toString(), metadata.realUser(), metadata.username(), metadata.ipAddress(), metadata.kyuubiInstance(), metadata.state(), metadata.resource(), metadata.className(), metadata.requestName(), this.valueAsString(metadata.requestConf()), this.valueAsString(metadata.requestArgs()), BoxesRunTime.boxToLong((long)metadata.createTime()), Option$.MODULE$.apply((Object)metadata.engineType()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toUpperCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms()), metadata.clusterManager().orNull(Predef$.MODULE$.$conforms())}));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Metadata getMetadata(String identifier, boolean stateOnly) {
        String query = stateOnly ? new java.lang.StringBuilder(34).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_STATE_ONLY_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString() : new java.lang.StringBuilder(34).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_ALL_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        return (Metadata)this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> (Metadata)this.withResultSet((Connection)connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}), (Function1 & Serializable & scala.Serializable)rs -> (Metadata)this.buildMetadata((ResultSet)rs, stateOnly).headOption().orNull(Predef$.MODULE$.$conforms())));
    }

    @Override
    public Seq<Metadata> getMetadataList(MetadataFilter filter, int from, int size, boolean stateOnly) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        StringBuilder stringBuilder = stateOnly ? queryBuilder.append(new java.lang.StringBuilder(13).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_STATE_ONLY_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString()) : queryBuilder.append(new java.lang.StringBuilder(13).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_ALL_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        ListBuffer whereConditions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option$.MODULE$.apply((Object)filter.sessionType()).foreach((Function1 & Serializable & scala.Serializable)sessionType -> {
            whereConditions.$plus$eq((Object)" session_type = ?");
            return params.$plus$eq((Object)sessionType.toString());
        });
        Option$.MODULE$.apply((Object)filter.engineType()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$2(x$6))).foreach((Function1 & Serializable & scala.Serializable)engineType -> {
            whereConditions.$plus$eq((Object)" UPPER(engine_type) = ? ");
            return params.$plus$eq((Object)engineType.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.username()).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$4(x$7))).foreach((Function1 & Serializable & scala.Serializable)username -> {
            whereConditions.$plus$eq((Object)" user_name = ? ");
            return params.$plus$eq(username);
        });
        Option$.MODULE$.apply((Object)filter.state()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$6(x$8))).foreach((Function1 & Serializable & scala.Serializable)state -> {
            whereConditions.$plus$eq((Object)" state = ? ");
            return params.$plus$eq((Object)state.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.kyuubiInstance()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$8(x$9))).foreach((Function1 & Serializable & scala.Serializable)kyuubiInstance -> {
            whereConditions.$plus$eq((Object)" kyuubi_instance = ? ");
            return params.$plus$eq(kyuubiInstance);
        });
        if (filter.createTime() > 0L) {
            whereConditions.$plus$eq((Object)" create_time >= ? ");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.createTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (filter.endTime() > 0L) {
            whereConditions.$plus$eq((Object)" end_time > 0 ");
            whereConditions.$plus$eq((Object)" end_time <= ? ");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.endTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (filter.peerInstanceClosed()) {
            whereConditions.$plus$eq((Object)" peer_instance_closed = ? ");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)filter.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = whereConditions.nonEmpty() ? queryBuilder.append(whereConditions.mkString(" WHERE ", " AND ", " ")) : BoxedUnit.UNIT;
        queryBuilder.append(" ORDER BY key_id ");
        String query = this.databaseAdaptor().addLimitAndOffsetToQuery(queryBuilder.toString(), size, from);
        return (Seq)this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> (Seq)this.withResultSet((Connection)connection, query, (Seq<Object>)params, (Function1 & Serializable & scala.Serializable)rs -> this.buildMetadata((ResultSet)rs, stateOnly)));
    }

    @Override
    public void updateMetadata(Metadata metadata) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append(new java.lang.StringBuilder(7).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        ListBuffer setClauses = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option$.MODULE$.apply((Object)metadata.state()).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            setClauses.$plus$eq((Object)" state = ? ");
            return params.$plus$eq((Object)metadata.state());
        });
        if (metadata.endTime() > 0L) {
            setClauses.$plus$eq((Object)" end_time = ? ");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.endTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (metadata.engineOpenTime() > 0L) {
            setClauses.$plus$eq((Object)" engine_open_time = ? ");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.engineOpenTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Option$.MODULE$.apply((Object)metadata.engineId()).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            setClauses.$plus$eq((Object)" engine_id = ? ");
            return params.$plus$eq((Object)metadata.engineId());
        });
        Option$.MODULE$.apply((Object)metadata.engineName()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            setClauses.$plus$eq((Object)" engine_name = ? ");
            return params.$plus$eq((Object)metadata.engineName());
        });
        Option$.MODULE$.apply((Object)metadata.engineUrl()).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            setClauses.$plus$eq((Object)" engine_url = ? ");
            return params.$plus$eq((Object)metadata.engineUrl());
        });
        Option$.MODULE$.apply((Object)metadata.engineState()).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            setClauses.$plus$eq((Object)" engine_state = ? ");
            return params.$plus$eq((Object)metadata.engineState());
        });
        metadata.engineError().foreach((Function1 & Serializable & scala.Serializable)error -> {
            setClauses.$plus$eq((Object)" engine_error = ? ");
            return params.$plus$eq(error);
        });
        if (metadata.peerInstanceClosed()) {
            setClauses.$plus$eq((Object)" peer_instance_closed = ? ");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)metadata.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = setClauses.nonEmpty() ? queryBuilder.append(setClauses.mkString(" SET ", " , ", " ")) : BoxedUnit.UNIT;
        queryBuilder.append(" WHERE identifier = ? ");
        params.$plus$eq((Object)metadata.identifier());
        String query = queryBuilder.toString();
        this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> {
            this.withUpdateCount(connection, query, (Seq<Object>)params, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)updateCount -> {
                if (updateCount == 0) {
                    throw new KyuubiException(new java.lang.StringBuilder(34).append("Error updating metadata for ").append(metadata$2.identifier()).append(" with ").append(query$4).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void cleanupMetadataByIdentifier(String identifier) {
        String query = new java.lang.StringBuilder(33).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void cleanupMetadataByAge(long maxAge) {
        long minEndTime = System.currentTimeMillis() - maxAge;
        String query = new java.lang.StringBuilder(47).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE state IN (").append(this.terminalStates()).append(") AND end_time < ?").toString();
        this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)minEndTime)}));
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Metadata> buildMetadata(ResultSet resultSet, boolean stateOnly) {
        void v0;
        try {
            void var3_3;
            ListBuffer metadataList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (resultSet.next()) {
                String identifier = resultSet.getString("identifier");
                Enumeration.Value sessionType = SessionType$.MODULE$.withName(resultSet.getString("session_type"));
                String realUser = resultSet.getString("real_user");
                String userName = resultSet.getString("user_name");
                String ipAddress = resultSet.getString("ip_address");
                String kyuubiInstance = resultSet.getString("kyuubi_instance");
                String state = resultSet.getString("state");
                String requestName = resultSet.getString("request_name");
                long createTime = resultSet.getLong("create_time");
                String engineType = resultSet.getString("engine_type");
                Option clusterManager = Option$.MODULE$.apply((Object)resultSet.getString("cluster_manager"));
                String engineId = resultSet.getString("engine_id");
                String engineName = resultSet.getString("engine_name");
                String engineUrl = resultSet.getString("engine_url");
                String engineState = resultSet.getString("engine_state");
                Option engineError = Option$.MODULE$.apply((Object)resultSet.getString("engine_error"));
                long endTime = resultSet.getLong("end_time");
                boolean peerInstanceClosed = resultSet.getBoolean("peer_instance_closed");
                String resource = null;
                String className = null;
                scala.collection.immutable.Map<String, String> requestConf = Predef$.MODULE$.Map().empty();
                Seq<String> requestArgs = (Seq<String>)Nil$.MODULE$;
                if (!stateOnly) {
                    resource = resultSet.getString("resource");
                    className = resultSet.getString("class_name");
                    requestConf = this.string2Map(resultSet.getString("request_conf"));
                    requestArgs = this.string2Seq(resultSet.getString("request_args"));
                }
                String x$1 = identifier;
                Enumeration.Value x$2 = sessionType;
                String x$3 = realUser;
                String x$4 = userName;
                String x$5 = ipAddress;
                String x$6 = kyuubiInstance;
                String x$7 = state;
                String x$8 = resource;
                String x$9 = className;
                String x$10 = requestName;
                scala.collection.immutable.Map<String, String> x$11 = requestConf;
                Seq<String> x$12 = requestArgs;
                long x$13 = createTime;
                String x$14 = engineType;
                Option x$15 = clusterManager;
                String x$16 = engineId;
                String x$17 = engineName;
                String x$18 = engineUrl;
                String x$19 = engineState;
                Option x$20 = engineError;
                long x$21 = endTime;
                boolean x$22 = peerInstanceClosed;
                long x$23 = Metadata$.MODULE$.apply$default$16();
                Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$23, x$16, x$17, x$18, x$19, (Option<String>)x$20, x$21, x$22);
                metadataList.$plus$eq((Object)metadata);
            }
            v0 = var3_3;
        }
        finally {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> resultSet.close());
        }
        return v0;
    }

    private void execute(Connection conn, String sql, Seq<Object> params) {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(14).append("executing sql ").append(sql).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                ((PreparedStatement)statement.elem).execute();
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(17).append("Error executing ").append(sql).append(":").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$1.elem).close());
            }
        }
    }

    private <T> T withResultSet(Connection conn, String sql, Seq<Object> params, Function1<ResultSet, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(30).append("executing sql ").append(sql).append(" with result set").toString());
        ObjectRef statement = ObjectRef.create(null);
        ObjectRef resultSet = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                resultSet.elem = ((PreparedStatement)statement.elem).executeQuery();
                object = f.apply((Object)((ResultSet)resultSet.elem));
            }
            catch (SQLException e) {
                throw new KyuubiException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if ((ResultSet)resultSet.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ResultSet)resultSet$2.elem).close());
            }
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$2.elem).close());
            }
        }
        return (T)object;
    }

    private <T> T withUpdateCount(Connection conn, String sql, Seq<Object> params, Function1<Object, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("executing sql ").append(sql).append(" with update count").toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                object = f.apply((Object)BoxesRunTime.boxToInteger((int)((PreparedStatement)statement.elem).executeUpdate()));
            }
            catch (SQLException e) {
                throw new KyuubiException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$3.elem).close());
            }
        }
        return (T)object;
    }

    private void setStatementParams(PreparedStatement statement, Seq<Object> params) {
        ((IterableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCMetadataStore.$anonfun$setStatementParams$1(statement, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private <T> T withConnection(boolean autoCommit, Function1<Connection, T> f) {
        Object object;
        ObjectRef connection = ObjectRef.create(null);
        try {
            try {
                connection.elem = this.hikariDataSource().getConnection();
                ((Connection)connection.elem).setAutoCommit(autoCommit);
                object = f.apply((Object)((Connection)connection.elem));
            }
            catch (SQLException e) {
                throw new KyuubiException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if ((Connection)connection.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Connection)connection$2.elem).close());
            }
        }
        return (T)object;
    }

    private <T> boolean withConnection$default$1() {
        return true;
    }

    private String valueAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    private scala.collection.immutable.Map<String, String> string2Map(String str) {
        if (str == null || str.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return (scala.collection.immutable.Map)this.mapper().readValue(str, scala.collection.immutable.Map.class);
    }

    private Seq<String> string2Seq(String str) {
        if (str == null || str.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)this.mapper().readValue(str, Seq.class);
    }

    public static final /* synthetic */ void $anonfun$initSchema$4(JDBCMetadataStore $this, Connection connection$1, String ddlStatement) {
        $this.execute(connection$1, ddlStatement, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(39).append("Execute init schema ddl: ").append(ddlStatement).append(" successfully.").toString());
    }

    public static final /* synthetic */ void $anonfun$initSchema$1(JDBCMetadataStore $this, String schema) {
        String[] ddlStatements = schema.trim().split(";");
        $this.withConnection($this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ddlStatements)).foreach((Function1 & Serializable & scala.Serializable)ddlStatement -> {
                JDBCMetadataStore.$anonfun$initSchema$4($this, connection, ddlStatement);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getInitSchema$4(String name) {
        return JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestSchemaUrl$1(JDBCMetadataStore $this, String u1, String u2) {
        Tuple3<Object, Object, Object> v1 = $this.getSchemaVersion(u1);
        Tuple3<Object, Object, Object> v2 = $this.getSchemaVersion(u2);
        return BoxesRunTime.unboxToInt((Object)v1._1()) > BoxesRunTime.unboxToInt((Object)v2._1()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) > BoxesRunTime.unboxToInt((Object)v2._2()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) == BoxesRunTime.unboxToInt((Object)v2._2()) && BoxesRunTime.unboxToInt((Object)v1._3()) > BoxesRunTime.unboxToInt((Object)v2._3());
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$2(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$4(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$6(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$8(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$setStatementParams$1(PreparedStatement statement$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object param = tuple2._1();
            int index = tuple2._2$mcI$sp();
            Object object = param;
            if (object == null) {
                statement$4.setObject(index + 1, null);
            } else if (object instanceof String) {
                String string = (String)object;
                statement$4.setString(index + 1, string);
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                statement$4.setInt(index + 1, n);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                statement$4.setLong(index + 1, l);
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                statement$4.setDouble(index + 1, d);
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                statement$4.setFloat(index + 1, f);
            } else if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                statement$4.setBoolean(index + 1, bl);
            } else {
                throw new KyuubiException(new java.lang.StringBuilder(23).append("Unsupported param type ").append(param.getClass().getName()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public JDBCMetadataStore(KyuubiConf conf) {
        block12: {
            JdbcDatabaseDialect jdbcDatabaseDialect;
            String string;
            Logging.$init$((Logging)this);
            this.dbType = DatabaseType$.MODULE$.withName((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_TYPE()));
            this.driverClassOpt = (Option)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DRIVER());
            Enumeration.Value value = this.dbType();
            Enumeration.Value value2 = DatabaseType$.MODULE$.DERBY();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.apache.derby.jdbc.AutoloadedDriver");
            } else {
                Enumeration.Value value4 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "com.mysql.jdbc.Driver");
                } else {
                    Enumeration.Value value6 = DatabaseType$.MODULE$.CUSTOM();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                            throw new IllegalArgumentException("No jdbc driver defined");
                        });
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
            this.driverClass = string;
            Enumeration.Value value8 = this.dbType();
            Enumeration.Value value9 = DatabaseType$.MODULE$.DERBY();
            Enumeration.Value value10 = value8;
            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                jdbcDatabaseDialect = new DerbyDatabaseDialect();
            } else {
                Enumeration.Value value11 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value12 = value8;
                if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                    jdbcDatabaseDialect = new MysqlDatabaseDialect();
                } else {
                    Enumeration.Value value13 = DatabaseType$.MODULE$.CUSTOM();
                    Enumeration.Value value14 = value8;
                    if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                        jdbcDatabaseDialect = new GenericDatabaseDialect();
                    } else {
                        throw new MatchError((Object)value8);
                    }
                }
            }
            this.databaseAdaptor = jdbcDatabaseDialect;
            this.datasourceProperties = JDBCMetadataStoreConf$.MODULE$.getMetadataStoreJDBCDataSourceProperties(conf);
            this.hikariConfig = new HikariConfig(this.datasourceProperties());
            this.hikariConfig().setDriverClassName(this.driverClass());
            this.hikariConfig().setJdbcUrl((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_URL()));
            this.hikariConfig().setUsername((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_USER()));
            this.hikariConfig().setPassword((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_PASSWORD()));
            this.hikariConfig().setPoolName("jdbc-metadata-store-pool");
            this.hikariDataSource = new HikariDataSource(this.hikariConfig());
            this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            this.terminalStates = ((TraversableOnce)OperationState$.MODULE$.terminalStates().map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(2).append("'").append(x.toString()).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            if (!BoxesRunTime.unboxToBoolean((Object)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_SCHEMA_INIT()))) break block12;
            this.initSchema();
        }
    }
}

