/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.client.api.v1.dto.ExecPoolStatistic;
import org.apache.kyuubi.client.api.v1.dto.GetColumnsRequest;
import org.apache.kyuubi.client.api.v1.dto.GetCrossReferenceRequest;
import org.apache.kyuubi.client.api.v1.dto.GetFunctionsRequest;
import org.apache.kyuubi.client.api.v1.dto.GetPrimaryKeysRequest;
import org.apache.kyuubi.client.api.v1.dto.GetSchemasRequest;
import org.apache.kyuubi.client.api.v1.dto.GetTablesRequest;
import org.apache.kyuubi.client.api.v1.dto.InfoDetail;
import org.apache.kyuubi.client.api.v1.dto.SessionData;
import org.apache.kyuubi.client.api.v1.dto.SessionHandle;
import org.apache.kyuubi.client.api.v1.dto.SessionOpenCount;
import org.apache.kyuubi.client.api.v1.dto.SessionOpenRequest;
import org.apache.kyuubi.client.api.v1.dto.StatementRequest;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.session.KyuubiSession;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@Tag(name="Session")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\rme!B\u000b\u0017\u0001Y\u0011\u0003\"B\u0019\u0001\t\u0003\u0019\u0004\"\u0002\u001c\u0001\t\u00079\u0004\"B&\u0001\t\u0013a\u0005\"\u0002)\u0001\t\u0003\t\u0006bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!a4\u0001\t\u0003\t\t\u000eC\u0004\u0002p\u0002!\t!!=\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016!9!\u0011\b\u0001\u0005\u0002\tm\u0002b\u0002B6\u0001\u0011\u0005!Q\u000e\u0005\b\u0005\u0007\u0003A\u0011\u0001BC\u0011\u001d\u0011Y\n\u0001C\u0001\u0005;CqAa/\u0001\t\u0003\u0011i\fC\u0004\u0003\\\u0002!\tA!8\t\u000f\tM\b\u0001\"\u0001\u0003v\"911\u0003\u0001\u0005\u0002\rU\u0001bBB\u001a\u0001\u0011\u00051Q\u0007\u0005\b\u0007'\u0002A\u0011AB+\u0005A\u0019Vm]:j_:\u001c(+Z:pkJ\u001cWM\u0003\u0002\u00181\u0005\u0011a/\r\u0006\u00033i\t1!\u00199j\u0015\tYB$\u0001\u0004tKJ4XM\u001d\u0006\u0003;y\taa[=vk\nL'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001cB\u0001A\u0012*[A\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0016\u000e\u0003aI!\u0001\f\r\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0002/_5\tA$\u0003\u000219\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003Q\u0002\"!\u000e\u0001\u000e\u0003Y\tq\u0002^8TKN\u001c\u0018n\u001c8IC:$G.\u001a\u000b\u0003qy\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u000f\u0002\u000fM,7o]5p]&\u0011QH\u000f\u0002\u000e'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\t\u000b}\u0012\u0001\u0019\u0001!\u0002\u0007M$(\u000f\u0005\u0002B\u0011:\u0011!I\u0012\t\u0003\u0007\u0016j\u0011\u0001\u0012\u0006\u0003\u000bJ\na\u0001\u0010:p_Rt\u0014BA$&\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d+\u0013AD:fgNLwN\\'b]\u0006<WM]\u000b\u0002\u001bB\u0011\u0011HT\u0005\u0003\u001fj\u0012abU3tg&|g.T1oC\u001e,'/\u0001\u0005tKN\u001c\u0018n\u001c8t)\u0005\u0011\u0006cA*Y7:\u0011AK\u0016\b\u0003\u0007VK\u0011AJ\u0005\u0003/\u0016\nq\u0001]1dW\u0006<W-\u0003\u0002Z5\n\u00191+Z9\u000b\u0005]+\u0003C\u0001/d\u001b\u0005i&B\u00010`\u0003\r!Go\u001c\u0006\u0003/\u0001T!!G1\u000b\u0005\td\u0012AB2mS\u0016tG/\u0003\u0002e;\nY1+Z:tS>tG)\u0019;bQ\t!a\r\u0005\u0002h]6\t\u0001N\u0003\u0002jU\u0006\u0011!o\u001d\u0006\u0003W2\f!a^:\u000b\u00035\fQA[1wCbL!a\u001c5\u0003\u0007\u001d+E\u000b\u000b\b\u0005c\u0006\r\u0011QAA\u0005\u0003\u0017\tI$a\u000f\u0011\u0005I|X\"A:\u000b\u0005Q,\u0018!\u0003:fgB|gn]3t\u0015\t1x/A\u0006b]:|G/\u0019;j_:\u001c(B\u0001=z\u0003\ry\u0017m\u001d\u0006\u0003un\f!A^\u001a\u000b\u0005ql\u0018aB:xC\u001e<WM\u001d\u0006\u0002}\u0006\u0011\u0011n\\\u0005\u0004\u0003\u0003\u0019(aC!qSJ+7\u000f]8og\u0016\fAB]3ta>t7/Z\"pI\u0016\f#!a\u0002\u0002\u0007I\u0002\u0004'A\u0004d_:$XM\u001c;-\u0005\u000551FCA\b\u00037\ti\"!\t\u0002$A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016U\fQ!\\3eS\u0006LA!!\u0007\u0002\u0014\t91i\u001c8uK:$\u0018!C7fI&\fG+\u001f9fC\t\ty\"\u0001\tbaBd\u0017nY1uS>twF[:p]\u0006)\u0011M\u001d:bs.2\u0011QEA\u0016\u0003[\u0001B!!\u0005\u0002(%!\u0011\u0011FA\n\u0005-\t%O]1z'\u000eDW-\\1\u0002\rM\u001c\u0007.Z7bW\u0019\ty#!\u000e\u00028A!\u0011\u0011CA\u0019\u0013\u0011\t\u0019$a\u0005\u0003\rM\u001b\u0007.Z7b\u00039IW\u000e\u001d7f[\u0016tG/\u0019;j_:\u001c\u0013aW\u0001\fI\u0016\u001c8M]5qi&|g.\t\u0002\u0002>\u0005\ts-\u001a;!i\",\u0007\u0005\\5ti\u0002zg\rI1mY\u0002b\u0017N^3!g\u0016\u001c8/[8og\u0006Y1/Z:tS>t\u0017J\u001c4p)\u0011\t\u0019%a\u0014\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013\u001d\u0003\u0019)g/\u001a8ug&!\u0011QJA$\u0005-Y\u00150^;cS\u00163XM\u001c;\t\r\u0005ES\u00011\u0001A\u0003A\u0019Xm]:j_:D\u0015M\u001c3mKN#(\u000f\u000b\u0005\u0002P\u0005U\u00131LA/!\r9\u0017qK\u0005\u0004\u00033B'!\u0003)bi\"\u0004\u0016M]1n\u0003\u00151\u0018\r\\;fC\t\ty&A\u0007tKN\u001c\u0018n\u001c8IC:$G.\u001a\u0015\b\u000b\u0005\r\u00141LA5!\r9\u0017QM\u0005\u0004\u0003OB'\u0001\u0002)bi\"\f#!a\u001b\u0002\u001fm\u001cXm]:j_:D\u0015M\u001c3mKvD#!\u00024)\u001d\u0015\t\u00181AA\u0003\u0003\u0013\t\t(!\u000f\u0002z1\u0012\u00111O\u0016\u000b\u0003\u001f\tY\"!\b\u0002,\u0005U4FBA\u0018\u0003k\t9h\t\u0002\u0002D\u0005\u0012\u00111P\u00012O\u0016$\b%\u0019\u0011tKN\u001c\u0018n\u001c8!KZ,g\u000e\u001e\u0011wS\u0006\u00043/Z:tS>t\u0007\u0005[1oI2,\u0007%\u001b3f]RLg-[3s\u0003\u001d9W\r^%oM>$b!!!\u0002\b\u0006-\u0005c\u0001/\u0002\u0004&\u0019\u0011QQ/\u0003\u0015%sgm\u001c#fi\u0006LG\u000e\u0003\u0004\u0002R\u0019\u0001\r\u0001\u0011\u0015\t\u0003\u000f\u000b)&a\u0017\u0002^!9\u0011Q\u0012\u0004A\u0002\u0005=\u0015\u0001C5oM>$\u0016\u0010]3\u0011\u0007\u0011\n\t*C\u0002\u0002\u0014\u0016\u00121!\u00138uQ!\tY)!\u0016\u0002\\\u0005]\u0015EAAGQ\u001d1\u00111MA.\u00037\u000b#!!(\u0002?m\u001cXm]:j_:D\u0015M\u001c3mKv|\u0013N\u001c4p_mLgNZ8UsB,W\u0010\u000b\u0002\u0007M\"ra!]A\u0002\u0003\u000b\tI!a)\u0002:\u0005-FFAASW)\ty!a\u0007\u0002\u001e\u0005-\u0012qU\u0016\u0007\u0003_\t)$!+$\u0005\u0005\u0005\u0015EAAW\u0003Y;W\r\u001e\u0011bA%tgm\u001c:nCRLwN\u001c\u0011eKR\f\u0017\u000e\u001c\u0011wS\u0006\u00043/Z:tS>t\u0007\u0005[1oI2,\u0007%\u001b3f]RLg-[3sA\u0005tG\rI1!gB,7-\u001b4jG\u0002JgNZ8s[\u0006$\u0018n\u001c8!if\u0004X-\u0001\u0007tKN\u001c\u0018n\u001c8D_VtG\u000f\u0006\u0002\u00024B\u0019A,!.\n\u0007\u0005]VL\u0001\tTKN\u001c\u0018n\u001c8Pa\u0016t7i\\;oi\":q!a\u0019\u0002\\\u0005m\u0016EAA_\u0003\u0015\u0019w.\u001e8uQ\t9a\r\u000b\b\bc\u0006\r\u0011QAA\u0005\u0003\u0007\fI$a3-\u0005\u0005\u00157FCA\b\u00037\ti\"a\u000b\u0002H.2\u0011qFA\u001b\u0003\u0013\u001c#!a-\"\u0005\u00055\u0017AI$fi\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!_B,g\u000eI:fgNLwN\u001c\u0011d_VtG/A\tfq\u0016\u001c\u0007k\\8m'R\fG/[:uS\u000e$\"!a5\u0011\u0007q\u000b).C\u0002\u0002Xv\u0013\u0011#\u0012=fGB{w\u000e\\*uCRL7\u000f^5dQ\u001dA\u00111MA.\u00037\f#!!8\u0002%\u0015DXm\u0019)p_2|3\u000f^1uSN$\u0018n\u0019\u0015\u0003\u0011\u0019Dc\u0002C9\u0002\u0004\u0005\u0015\u0011\u0011BAr\u0003s\tY\u000f\f\u0002\u0002f.R\u0011qBA\u000e\u0003;\tY#a:,\r\u0005=\u0012QGAuG\t\t\u0019.\t\u0002\u0002n\u0006Qs)\u001a;!gR\fG/[:uS\u000e\u0004\u0013N\u001c4pA=4\u0007EY1dW\u001e\u0014x.\u001e8eA\u0015DXmY;u_J\u001c\u0018aC8qK:\u001cVm]:j_:$B!a=\u0002xB\u0019A,!>\n\u0005uj\u0006bBA}\u0013\u0001\u0007\u00111`\u0001\be\u0016\fX/Z:u!\ra\u0016Q`\u0005\u0004\u0003\u007fl&AE*fgNLwN\\(qK:\u0014V-];fgRD3!\u0003B\u0002!\r9'QA\u0005\u0004\u0005\u000fA'\u0001\u0002)P'RCc\"C9\u0002\u0004\u0005\u0015\u0011\u0011\u0002B\u0006\u0003s\u0011y\u0001\f\u0002\u0003\u000e-2\u0011qBA\u000e\u0003;\t#A!\u0005\u0002-=\u0003XM\u001c\u0015de\u0016\fG/Z\u0015!C\u0002\u001aXm]:j_:\fAb\u00197pg\u0016\u001cVm]:j_:$BAa\u0006\u0003$A!!\u0011\u0004B\u0010\u001b\t\u0011YBC\u0002\u0003\u001e!\fAaY8sK&!!\u0011\u0005B\u000e\u0005!\u0011Vm\u001d9p]N,\u0007BBA)\u0015\u0001\u0007\u0001\t\u000b\u0005\u0003$\u0005U\u00131LA/Q\u001dQ\u00111MA.\u0003SB3A\u0003B\u0016!\r9'QF\u0005\u0004\u0005_A'A\u0002#F\u0019\u0016#V\t\u000b\b\u000bc\u0006\r\u0011QAA\u0005\u0005g\tID!\u000e-\u0005\t5\u0011E\u0001B\u001c\u0003=\u0019En\\:fA\u0005\u00043/Z:tS>t\u0017\u0001E3yK\u000e,H/Z*uCR,W.\u001a8u)\u0019\u0011iD!\u0013\u0003NA!!q\bB#\u001b\t\u0011\tEC\u0002\u0003Dq\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\n\t\t\u001d#\u0011\t\u0002\u0010\u001fB,'/\u0019;j_:D\u0015M\u001c3mK\"1\u0011\u0011K\u0006A\u0002\u0001C\u0003B!\u0013\u0002V\u0005m\u0013Q\f\u0005\b\u0003s\\\u0001\u0019\u0001B(!\ra&\u0011K\u0005\u0004\u0005'j&\u0001E*uCR,W.\u001a8u%\u0016\fX/Z:uQ\u001dY\u00111MA.\u0005/\n#A!\u0017\u0002Im\u001cXm]:j_:D\u0015M\u001c3mKv|s\u000e]3sCRLwN\\:0gR\fG/Z7f]RD3a\u0003B\u0002Q9Y\u0011/a\u0001\u0002\u0006\u0005%!qLA\u001d\u0005Ob#A!\u0019,\u0015\u0005=\u00111DA\u000f\u0003W\u0011\u0019g\u000b\u0004\u00020\u0005U\"QM\u0012\u0003\u0005{\t#A!\u001b\u0002_\r\u0013X-\u0019;fA\u0005t\u0007e\u001c9fe\u0006$\u0018n\u001c8!o&$\b\u000eI#Y\u000b\u000e+F+R0T)\u0006#V)T#O)\u0002\"\u0018\u0010]3\u0002\u0017\u001d,G\u000fV=qK&sgm\u001c\u000b\u0005\u0005{\u0011y\u0007\u0003\u0004\u0002R1\u0001\r\u0001\u0011\u0015\t\u0005_\n)&a\u0017\u0002^!:A\"a\u0019\u0002\\\tU\u0014E\u0001B<\u0003\rZ8/Z:tS>t\u0007*\u00198eY\u0016lxf\u001c9fe\u0006$\u0018n\u001c8t_QL\b/Z%oM>D3\u0001\u0004B\u0002Q9a\u0011/a\u0001\u0002\u0006\u0005%!QPA\u001d\u0005\u007fb#A!\u0019\"\u0005\t\u0005\u0015aK\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0U3B+u,\u0013(G\u001f\u0002\"\u0018\u0010]3\u0002\u0017\u001d,GoQ1uC2|wm\u001d\u000b\u0005\u0005{\u00119\t\u0003\u0004\u0002R5\u0001\r\u0001\u0011\u0015\t\u0005\u000f\u000b)&a\u0017\u0002^!:Q\"a\u0019\u0002\\\t5\u0015E\u0001BH\u0003\rZ8/Z:tS>t\u0007*\u00198eY\u0016lxf\u001c9fe\u0006$\u0018n\u001c8t_\r\fG/\u00197pOND3!\u0004B\u0002Q9i\u0011/a\u0001\u0002\u0006\u0005%!QSA\u001d\u0005/c#A!\u0019\"\u0005\te\u0015AK\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0D\u0003R\u000bEjT$TAQL\b/Z\u0001\u000bO\u0016$8k\u00195f[\u0006\u001cHC\u0002B\u001f\u0005?\u0013\u0019\u000b\u0003\u0004\u0002R9\u0001\r\u0001\u0011\u0015\t\u0005?\u000b)&a\u0017\u0002^!9\u0011\u0011 \bA\u0002\t\u0015\u0006c\u0001/\u0003(&\u0019!\u0011V/\u0003#\u001d+GoU2iK6\f7OU3rk\u0016\u001cH\u000fK\u0004\u000f\u0003G\nYF!,\"\u0005\t=\u0016AI>tKN\u001c\u0018n\u001c8IC:$G.Z?0_B,'/\u0019;j_:\u001cxf]2iK6\f7\u000fK\u0002\u000f\u0005\u0007AcBD9\u0002\u0004\u0005\u0015\u0011\u0011\u0002B[\u0003s\u00119\f\f\u0002\u0003b\u0005\u0012!\u0011X\u0001*\u0007J,\u0017\r^3!C:\u0004s\u000e]3sCRLwN\u001c\u0011xSRD\u0007eR#U?N\u001b\u0005*R'B'\u0002\"\u0018\u0010]3\u0002\u0013\u001d,G\u000fV1cY\u0016\u001cHC\u0002B\u001f\u0005\u007f\u0013\u0019\r\u0003\u0004\u0002R=\u0001\r\u0001\u0011\u0015\t\u0005\u007f\u000b)&a\u0017\u0002^!9\u0011\u0011`\bA\u0002\t\u0015\u0007c\u0001/\u0003H&\u0019!\u0011Z/\u0003!\u001d+G\u000fV1cY\u0016\u001c(+Z9vKN$\bfB\b\u0002d\u0005m#QZ\u0011\u0003\u0005\u001f\f\u0011e_:fgNLwN\u001c%b]\u0012dW-`\u0018pa\u0016\u0014\u0018\r^5p]N|C/\u00192mKND3a\u0004B\u0002Q9y\u0011/a\u0001\u0002\u0006\u0005%!Q[A\u001d\u0005/d#A!\u0019\"\u0005\te\u0017\u0001K\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0U\u0003\ncUi\u0015\u0011usB,\u0017!D4fiR\u000b'\r\\3UsB,7\u000f\u0006\u0003\u0003>\t}\u0007BBA)!\u0001\u0007\u0001\t\u000b\u0005\u0003`\u0006U\u00131LA/Q\u001d\u0001\u00121MA.\u0005K\f#Aa:\u0002Km\u001cXm]:j_:D\u0015M\u001c3mKv|s\u000e]3sCRLwN\\:0i\u0006\u0014G.\u001a+za\u0016\u001c\bf\u0001\t\u0003\u0004!r\u0001#]A\u0002\u0003\u000b\tIA!<\u0002:\t=HF\u0001B1C\t\u0011\t0A\u0017De\u0016\fG/\u001a\u0011b]\u0002z\u0007/\u001a:bi&|g\u000eI<ji\"\u0004s)\u0012+`)\u0006\u0013E*R0U3B+5\u000b\t;za\u0016\f!bZ3u\u0007>dW/\u001c8t)\u0019\u0011iDa>\u0003|\"1\u0011\u0011K\tA\u0002\u0001C\u0003Ba>\u0002V\u0005m\u0013Q\f\u0005\b\u0003s\f\u0002\u0019\u0001B\u007f!\ra&q`\u0005\u0004\u0007\u0003i&!E$fi\u000e{G.^7ogJ+\u0017/^3ti\":\u0011#a\u0019\u0002\\\r\u0015\u0011EAB\u0004\u0003\tZ8/Z:tS>t\u0007*\u00198eY\u0016lxf\u001c9fe\u0006$\u0018n\u001c8t_\r|G.^7og\"\u001a\u0011Ca\u0001)\u001dE\t\u00181AA\u0003\u0003\u0013\u0019i!!\u000f\u0004\u00101\u0012!\u0011M\u0011\u0003\u0007#\t\u0011f\u0011:fCR,\u0007%\u00198!_B,'/\u0019;j_:\u0004s/\u001b;iA\u001d+EkX\"P\u0019Vkej\u0015\u0011usB,\u0017\u0001D4fi\u001a+hn\u0019;j_:\u001cHC\u0002B\u001f\u0007/\u0019Y\u0002\u0003\u0004\u0002RI\u0001\r\u0001\u0011\u0015\t\u0007/\t)&a\u0017\u0002^!9\u0011\u0011 \nA\u0002\ru\u0001c\u0001/\u0004 %\u00191\u0011E/\u0003'\u001d+GOR;oGRLwN\\:SKF,Xm\u001d;)\u000fI\t\u0019'a\u0017\u0004&\u0005\u00121qE\u0001%wN,7o]5p]\"\u000bg\u000e\u001a7f{>z\u0007/\u001a:bi&|gn]\u0018gk:\u001cG/[8og\"\u001a!Ca\u0001)\u001dI\t\u00181AA\u0003\u0003\u0013\u0019i#!\u000f\u000401\u0012!\u0011M\u0011\u0003\u0007c\t1f\u0011:fCR,\u0007%\u00198!_B,'/\u0019;j_:\u0004s/\u001b;iA\u001d+Ek\u0018$V\u001d\u000e#\u0016j\u0014(TAQL\b/Z\u0001\u000fO\u0016$\bK]5nCJL8*Z=t)\u0019\u0011ida\u000e\u0004<!1\u0011\u0011K\nA\u0002\u0001C\u0003ba\u000e\u0002V\u0005m\u0013Q\f\u0005\b\u0003s\u001c\u0002\u0019AB\u001f!\ra6qH\u0005\u0004\u0007\u0003j&!F$fiB\u0013\u0018.\\1ss.+\u0017p\u001d*fcV,7\u000f\u001e\u0015\b'\u0005\r\u00141LB#C\t\u00199%\u0001\u0014|g\u0016\u001c8/[8o\u0011\u0006tG\r\\3~_=\u0004XM]1uS>t7o\f9sS6\f'/_&fsND3a\u0005B\u0002Q9\u0019\u0012/a\u0001\u0002\u0006\u0005%1QJA\u001d\u0007\u001fb#A!\u0019\"\u0005\rE\u0013!L\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0Q%&k\u0015IU-`\u0017\u0016K\u0006\u0005^=qK\u0006\tr-\u001a;De>\u001c8OU3gKJ,gnY3\u0015\r\tu2qKB.\u0011\u0019\t\t\u0006\u0006a\u0001\u0001\"B1qKA+\u00037\ni\u0006C\u0004\u0002zR\u0001\ra!\u0018\u0011\u0007q\u001by&C\u0002\u0004bu\u0013\u0001dR3u\u0007J|7o\u001d*fM\u0016\u0014XM\\2f%\u0016\fX/Z:uQ\u001d!\u00121MA.\u0007K\n#aa\u001a\u0002Sm\u001cXm]:j_:D\u0015M\u001c3mKv|s\u000e]3sCRLwN\\:0GJ|7o\u001d*fM\u0016\u0014XM\\2fQ\r!\"1\u0001\u0015\u000f)E\f\u0019!!\u0002\u0002\n\r5\u0014\u0011HB8Y\t\u0011\t'\t\u0002\u0004r\u0005\t4I]3bi\u0016\u0004\u0013M\u001c\u0011pa\u0016\u0014\u0018\r^5p]\u0002:\u0018\u000e\u001e5!\u000f\u0016#vl\u0011*P'N{&+\u0012$F%\u0016s5)\u0012\u0011usB,\u0007f\u0002\u0001\u0004v\u0005m31\u0010\t\u0004O\u000e]\u0014bAB=Q\nA1i\u001c8tk6,7\u000f\f\u0002\u0002\u001e!:\u0001aa \u0002\\\r\u0015\u0005cA4\u0004\u0002&\u001911\u00115\u0003\u0011A\u0013x\u000eZ;dKNd#!!\b)\u000f\u0001\u0019Ii!&\u0004\u0018B!11RBI\u001b\t\u0019iIC\u0002\u0004\u0010V\fA\u0001^1hg&!11SBG\u0005\r!\u0016mZ\u0001\u0005]\u0006lW-\t\u0002\u0004\u001a\u000691+Z:tS>t\u0007")
public class SessionsResource
implements ApiRequestContext,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    public org.apache.kyuubi.session.SessionHandle toSessionHandle(String str) {
        return SessionHandle$.MODULE$.fromUUID(str);
    }

    private SessionManager sessionManager() {
        return this.fe().be().sessionManager();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SessionData.class)))}, description="get the list of all live sessions")
    @GET
    public Seq<SessionData> sessions() {
        return ((TraversableOnce)this.sessionManager().allSessions().map((Function1 & Serializable & scala.Serializable)session -> new SessionData(session.handle().identifier().toString(), session.user(), session.ipAddress(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)session.conf()).asJava(), Predef$.MODULE$.long2Long(session.createTime()), Predef$.MODULE$.long2Long(session.lastAccessTime() - session.createTime()), Predef$.MODULE$.long2Long(session.getNoOperationTime())), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=KyuubiEvent.class))}, description="get a session event via session handle identifier")
    @GET
    @Path(value="{sessionHandle}")
    public KyuubiEvent sessionInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        KyuubiEvent kyuubiEvent;
        try {
            kyuubiEvent = (KyuubiEvent)((KyuubiSession)this.sessionManager().getSession(this.toSessionHandle(sessionHandleStr))).getSessionEvent().get();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Invalid ").append(sessionHandleStr).toString(), e);
                throw new NotFoundException(new StringBuilder(8).append("Invalid ").append(sessionHandleStr).toString());
            }
            throw throwable;
        }
        return kyuubiEvent;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=InfoDetail.class))}, description="get a information detail via session handle identifier and a specific information type")
    @GET
    @Path(value="{sessionHandle}/info/{infoType}")
    public InfoDetail getInfo(@PathParam(value="sessionHandle") String sessionHandleStr, @PathParam(value="infoType") int infoType) {
        InfoDetail infoDetail;
        try {
            TGetInfoType info = TGetInfoType.findByValue((int)infoType);
            TGetInfoValue infoValue = this.fe().be().getInfo(this.toSessionHandle(sessionHandleStr), info);
            infoDetail = new InfoDetail(info.toString(), infoValue.getStringValue());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), e);
                throw new NotFoundException(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString());
            }
            throw throwable;
        }
        return infoDetail;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=SessionOpenCount.class))}, description="Get the current open session count")
    @GET
    @Path(value="count")
    public SessionOpenCount sessionCount() {
        return new SessionOpenCount(this.sessionManager().getOpenSessionCount());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ExecPoolStatistic.class))}, description="Get statistic info of background executors")
    @GET
    @Path(value="execPool/statistic")
    public ExecPoolStatistic execPoolStatistic() {
        return new ExecPoolStatistic(this.sessionManager().getExecPoolSize(), this.sessionManager().getActiveCount());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Open(create) a session")
    @POST
    public SessionHandle openSession(SessionOpenRequest request) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConfigs()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        String ipAddress = this.fe().getIpAddress();
        org.apache.kyuubi.session.SessionHandle handle = this.fe().be().openSession(TProtocolVersion.findByValue((int)request.getProtocolVersion()), userName, "", ipAddress, ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConfigs()).asScala()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.client.ipAddress"), (Object)ipAddress), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.server.ipAddress"), (Object)this.fe().host()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.connection.url"), (Object)this.fe().connectionUrl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.real.user"), (Object)this.fe().getRealUser())}))).toMap(Predef$.MODULE$.$conforms()));
        return new SessionHandle(handle.identifier(), this.fe().connectionUrl());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Close a session")
    @DELETE
    @Path(value="{sessionHandle}")
    public Response closeSession(@PathParam(value="sessionHandle") String sessionHandleStr) {
        this.fe().be().closeSession(this.toSessionHandle(sessionHandleStr));
        return Response.ok().build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with EXECUTE_STATEMENT type")
    @POST
    @Path(value="{sessionHandle}/operations/statement")
    public OperationHandle executeStatement(@PathParam(value="sessionHandle") String sessionHandleStr, StatementRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().executeStatement(this.toSessionHandle(sessionHandleStr), request.getStatement(), Predef$.MODULE$.Map().empty(), request.isRunAsync(), Predef$.MODULE$.Long2long(request.getQueryTimeout()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error executing statement";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TYPE_INFO type")
    @POST
    @Path(value="{sessionHandle}/operations/typeInfo")
    public OperationHandle getTypeInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTypeInfo(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting type information";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_CATALOGS type")
    @POST
    @Path(value="{sessionHandle}/operations/catalogs")
    public OperationHandle getCatalogs(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getCatalogs(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting catalogs";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_SCHEMAS type")
    @POST
    @Path(value="{sessionHandle}/operations/schemas")
    public OperationHandle getSchemas(@PathParam(value="sessionHandle") String sessionHandleStr, GetSchemasRequest request) {
        OperationHandle operationHandle;
        try {
            OperationHandle operationHandle2;
            operationHandle = operationHandle2 = this.fe().be().getSchemas(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting schemas";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TABLES type")
    @POST
    @Path(value="{sessionHandle}/operations/tables")
    public OperationHandle getTables(@PathParam(value="sessionHandle") String sessionHandleStr, GetTablesRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTables(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName(), request.getTableTypes());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting tables";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TABLE_TYPES type")
    @POST
    @Path(value="{sessionHandle}/operations/tableTypes")
    public OperationHandle getTableTypes(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTableTypes(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting table types";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_COLUMNS type")
    @POST
    @Path(value="{sessionHandle}/operations/columns")
    public OperationHandle getColumns(@PathParam(value="sessionHandle") String sessionHandleStr, GetColumnsRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getColumns(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName(), request.getColumnName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting columns";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_FUNCTIONS type")
    @POST
    @Path(value="{sessionHandle}/operations/functions")
    public OperationHandle getFunctions(@PathParam(value="sessionHandle") String sessionHandleStr, GetFunctionsRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getFunctions(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getFunctionName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting functions";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_PRIMARY_KEY type")
    @POST
    @Path(value="{sessionHandle}/operations/primaryKeys")
    public OperationHandle getPrimaryKeys(@PathParam(value="sessionHandle") String sessionHandleStr, GetPrimaryKeysRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getPrimaryKeys(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting primary keys";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_CROSS_REFERENCE type")
    @POST
    @Path(value="{sessionHandle}/operations/crossReference")
    public OperationHandle getCrossReference(@PathParam(value="sessionHandle") String sessionHandleStr, GetCrossReferenceRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getCrossReference(this.toSessionHandle(sessionHandleStr), request.getPrimaryCatalog(), request.getPrimarySchema(), request.getPrimaryTable(), request.getForeignCatalog(), request.getForeignSchema(), request.getForeignTable());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting cross reference";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    public SessionsResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

