/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.KyuubiRestFrontendService$;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.v1.ApiRootResource$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.KyuubiHttpAuthenticationFactory;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.ui.JettyServer;
import org.apache.kyuubi.server.ui.JettyServer$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.authentication.KyuubiAuthenticationFactory$;
import org.apache.kyuubi.session.KyuubiBatchSessionImpl;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.util.ThreadUtils$;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\"\f\u0001\u0003\u0006\u0004%\tE\f\u0005\te\u0001\u0011\t\u0011)A\u0005_!)1\u0007\u0001C\u0001i!Ia\u0004\u0001a\u0001\u0002\u0004%I\u0001\u000f\u0005\n\u007f\u0001\u0001\r\u00111A\u0005\n\u0001C\u0011\"\u0013\u0001A\u0002\u0003\u0005\u000b\u0015B\u001d\t\u000f)\u0003!\u0019!C\u0005\u0017\"1\u0001\f\u0001Q\u0001\n1CQ!\u0017\u0001\u0005\niCQa\u0019\u0001\u0005\n\u0011Dqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004r\u0001\u0001\u0006I!\u001c\u0005\te\u0002A)\u0019!C\u0001g\"1q\u0010\u0001C!\u0003\u0003Aa!!\u0005\u0001\t\u0003\u001a\bbBA\n\u0001\u0011%\u0011Q\u0003\u0005\b\u0003/\u0001A\u0011BA\u000b\u0011!\tI\u0002\u0001C\u0001?\u0005U\u0001bBA\u001b\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003o\u0001A\u0011IA\u000b\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002>\u0001!\t!!\u0012\t\r\u0005E\u0003\u0001\"\u0001t\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+B\u0011\"!\u0019\u0001\u0005\u0004%\t%a\u0019\t\u0011\u0005E\u0004\u0001)A\u0005\u0003K\u0012\u0011dS=vk\nL'+Z:u\rJ|g\u000e^3oIN+'O^5dK*\u0011adH\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u0001\n\u0013AB6zkV\u0014\u0017N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0003\u0001\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!AK\u0010\u0002\u000fM,'O^5dK&\u0011A&\u000b\u0002\u0018\u0003\n\u001cHO]1di\u001a\u0013xN\u001c;f]\u0012\u001cVM\u001d<jG\u0016\f!b]3sm\u0016\u0014\u0018M\u00197f+\u0005y\u0003C\u0001\u00151\u0013\t\t\u0014F\u0001\u0006TKJ4XM]1cY\u0016\f1b]3sm\u0016\u0014\u0018M\u00197fA\u00051A(\u001b8jiz\"\"!N\u001c\u0011\u0005Y\u0002Q\"A\u000f\t\u000b5\u001a\u0001\u0019A\u0018\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001P\u000f\u0002\u0005UL\u0017B\u0001 <\u0005-QU\r\u001e;z'\u0016\u0014h/\u001a:\u0002\u0015M,'O^3s?\u0012*\u0017\u000f\u0006\u0002B\u000fB\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n!QK\\5u\u0011\u001dAU!!AA\u0002e\n1\u0001\u001f\u00132\u0003\u001d\u0019XM\u001d<fe\u0002\n\u0011\"[:Ti\u0006\u0014H/\u001a3\u0016\u00031\u0003\"!\u0014,\u000e\u00039S!a\u0014)\u0002\r\u0005$x.\\5d\u0015\t\t&+\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0015+\u0002\tU$\u0018\u000e\u001c\u0006\u0002+\u0006!!.\u0019<b\u0013\t9fJA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000bSN\u001cF/\u0019:uK\u0012\u0004\u0013A\u00035bI>|\u0007oQ8oMV\t1\f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006!1m\u001c8g\u0015\t\u0001\u0017%\u0001\u0004iC\u0012|w\u000e]\u0005\u0003Ev\u0013QbQ8oM&<WO]1uS>t\u0017AD:fgNLwN\\'b]\u0006<WM]\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001nH\u0001\bg\u0016\u001c8/[8o\u0013\tQwM\u0001\u000bLsV,(-[*fgNLwN\\'b]\u0006<WM]\u0001\rE\u0006$8\r[\"iK\u000e\\WM]\u000b\u0002[B\u0011an\\\u0007\u0002!&\u0011\u0001\u000f\u0015\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!\u00042bi\u000eD7\t[3dW\u0016\u0014\b%\u0001\u0003i_N$X#\u0001;\u0011\u0005UdhB\u0001<{!\t98)D\u0001y\u0015\tIX%\u0001\u0004=e>|GOP\u0005\u0003w\u000e\u000ba\u0001\u0015:fI\u00164\u0017BA?\u007f\u0005\u0019\u0019FO]5oO*\u00111pQ\u0001\u000bS:LG/[1mSj,GcA!\u0002\u0004!1aL\u0004a\u0001\u0003\u000b\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017y\u0012AB2p]\u001aLw-\u0003\u0003\u0002\u0010\u0005%!AC&zkV\u0014\u0017nQ8oM\u0006i1m\u001c8oK\u000e$\u0018n\u001c8Ve2\fQb\u001d;beRLe\u000e^3s]\u0006dG#A!\u0002#M$\u0018M\u001d;CCR\u001c\u0007n\u00115fG.,'/\u0001\u000bsK\u000e|g/\u001a:CCR\u001c\u0007nU3tg&|gn\u001d\u0015\u0004%\u0005u\u0001\u0003BA\u0010\u0003ci!!!\t\u000b\t\u0005\r\u0012QE\u0001\fC:tw\u000e^1uS>t7O\u0003\u0003\u0002(\u0005%\u0012AB2p[6|gN\u0003\u0003\u0002,\u00055\u0012AB4p_\u001edWM\u0003\u0002\u00020\u0005\u00191m\\7\n\t\u0005M\u0012\u0011\u0005\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0017!B:uCJ$\u0018\u0001B:u_B\f1bZ3u%\u0016\fG.V:feR\tA/\u0001\bhKR\u001cVm]:j_:,6/\u001a:\u0015\u0007Q\f\t\u0005\u0003\u0004\u0002DY\u0001\r\u0001^\u0001\rQN\u0014\u0004K]8ysV\u001bXM\u001d\u000b\u0004i\u0006\u001d\u0003bBA%/\u0001\u0007\u00111J\u0001\fg\u0016\u001c8/[8o\u0007>tg\rE\u0003v\u0003\u001b\"H/C\u0002\u0002Py\u00141!T1q\u000319W\r^%q\u0003\u0012$'/Z:t\u000319W\r\u001e)s_bLXk]3s)\u001d!\u0018qKA-\u0003;Bq!!\u0013\u001a\u0001\u0004\tY\u0005\u0003\u0004\u0002\\e\u0001\r\u0001^\u0001\nSB\fE\r\u001a:fgNDa!a\u0018\u001a\u0001\u0004!\u0018\u0001\u0003:fC2,6/\u001a:\u0002!\u0011L7oY8wKJL8+\u001a:wS\u000e,WCAA3!\u0015\u0011\u0015qMA6\u0013\r\tIg\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007!\ni'C\u0002\u0002p%\u0012qaU3sm&\u001cW-A\teSN\u001cwN^3ssN+'O^5dK\u0002\u0002")
public class KyuubiRestFrontendService
extends AbstractFrontendService {
    private String host;
    private final Serverable serverable;
    private JettyServer server;
    private final AtomicBoolean isStarted;
    private final ScheduledExecutorService batchChecker;
    private final Option<Service> discoveryService;
    private volatile boolean bitmap$0;

    public Serverable serverable() {
        return this.serverable;
    }

    private JettyServer server() {
        return this.server;
    }

    private void server_$eq(JettyServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean isStarted() {
        return this.isStarted;
    }

    private Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    public KyuubiSessionManager org$apache$kyuubi$server$KyuubiRestFrontendService$$sessionManager() {
        return (KyuubiSessionManager)this.be().sessionManager();
    }

    private ScheduledExecutorService batchChecker() {
        return this.batchChecker;
    }

    private String host$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if (!this.bitmap$0) {
                this.host = (String)((Option)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_HOST())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_CONNECTION_URL_USE_HOSTNAME()))) {
                        return Utils$.MODULE$.findLocalInetAddress().getCanonicalHostName();
                    }
                    return Utils$.MODULE$.findLocalInetAddress().getHostAddress();
                });
                this.bitmap$0 = true;
            }
        }
        return this.host;
    }

    public String host() {
        if (!this.bitmap$0) {
            return this.host$lzycompute();
        }
        return this.host;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.server_$eq(JettyServer$.MODULE$.apply(this.getName(), this.host(), BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_PORT())), BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_MAX_WORKER_THREADS()))));
        super.initialize(conf);
    }

    public String connectionUrl() {
        this.checkInitialized();
        return this.server().getServerUri();
    }

    private void startInternal() {
        ServletContextHandler contextHandler = ApiRootResource$.MODULE$.getServletHandler(this);
        FilterHolder holder = new FilterHolder((Filter)new AuthenticationFilter(this.conf()));
        contextHandler.addFilter(holder, "/v1/*", EnumSet.allOf(DispatcherType.class));
        KyuubiHttpAuthenticationFactory authenticationFactory = new KyuubiHttpAuthenticationFactory(this.conf());
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)contextHandler));
        this.server().addStaticHandler("org/apache/kyuubi/ui/static", "/static/");
        this.server().addRedirectHandler("/", "/static/");
        this.server().addRedirectHandler("/static", "/static/");
        this.server().addStaticHandler("META-INF/resources/webjars/swagger-ui/4.9.1/", "/swagger-static/");
        this.server().addStaticHandler("org/apache/kyuubi/ui/swagger", "/swagger/");
        this.server().addRedirectHandler("/docs", "/swagger/");
        this.server().addRedirectHandler("/docs/", "/swagger/");
        this.server().addRedirectHandler("/swagger", "/swagger/");
    }

    private void startBatchChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_CHECK_INTERVAL()));
        Runnable task = new Runnable(this){
            private final /* synthetic */ KyuubiRestFrontendService $outer;

            public void run() {
                try {
                    this.$outer.org$apache$kyuubi$server$KyuubiRestFrontendService$$sessionManager().getPeerInstanceClosedBatchSessions(this.$outer.connectionUrl()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        $anon$1.$anonfun$run$1(this, batch);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable e) {
                    this.$outer.error((Function0 & Serializable & scala.Serializable)() -> "Error checking batch sessions", e);
                }
            }

            public static final /* synthetic */ void $anonfun$run$3(KyuubiBatchSessionImpl x$1) {
                x$1.close();
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, Metadata batch) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    SessionHandle sessionHandle = SessionHandle$.MODULE$.fromUUID(batch.identifier());
                    Option$.MODULE$.apply((Object)((Object)$this.$outer.org$apache$kyuubi$server$KyuubiRestFrontendService$$sessionManager().getBatchSessionImpl(sessionHandle))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anon$1.$anonfun$run$3(x$1);
                        return BoxedUnit.UNIT;
                    });
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata ), $anonfun$run$4(), $anonfun$run$3$adapted(org.apache.kyuubi.session.KyuubiBatchSessionImpl ), $anonfun$run$2(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata )}, serializedLambda);
            }
        };
        this.batchChecker().scheduleWithFixedDelay(task, interval, interval, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public void recoverBatchSessions() {
        int recoveryNumThreads = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_RECOVERY_THREADS()));
        ThreadPoolExecutor batchRecoveryExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(recoveryNumThreads, "batch-recovery-executor");
        try {
            Seq<KyuubiBatchSessionImpl> batchSessionsToRecover = this.org$apache$kyuubi$server$KyuubiRestFrontendService$$sessionManager().getBatchSessionsToRecover(this.connectionUrl());
            AtomicInteger pendingRecoveryTasksCount = new AtomicInteger(0);
            Seq tasks = (Seq)batchSessionsToRecover.flatMap((Function1 & Serializable & scala.Serializable)batchSession -> {
                Iterable iterable;
                String batchId = batchSession.batchJobSubmissionOp().batchId();
                try {
                    Future<Object> task = batchRecoveryExecutor.submit(() -> {
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.org$apache$kyuubi$server$KyuubiRestFrontendService$$sessionManager().openBatchSession(batchSession));
                        return BoxedUnit.UNIT;
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(task), (Object)batchId)));
                }
                catch (Throwable e) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error while submitting batch[").append(batchId).append("] for recovery").toString(), e);
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
            pendingRecoveryTasksCount.addAndGet(tasks.size());
            tasks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KyuubiRestFrontendService.$anonfun$recoverBatchSessions$5(this, pendingRecoveryTasksCount, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)batchRecoveryExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
        }
    }

    public synchronized void start() {
        if (!this.isStarted().get()) {
            try {
                this.server().start();
                this.recoverBatchSessions();
                this.isStarted().set(true);
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append(this.getName()).append(" has started at ").append(this.server().getServerUri()).toString());
                this.startBatchChecker();
                this.startInternal();
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(13).append("Cannot start ").append(this.getName()).toString(), (Throwable)e);
            }
        }
        super.start();
    }

    public synchronized void stop() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.batchChecker(), ThreadUtils$.MODULE$.shutdown$default$2());
        if (this.isStarted().getAndSet(false)) {
            this.server().stop();
        }
        super.stop();
    }

    public String getRealUser() {
        return ServiceUtils$.MODULE$.getShortName((String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserName()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getRealUser$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous"));
    }

    public String getSessionUser(String hs2ProxyUser) {
        Map sessionConf = (Map)Option$.MODULE$.apply((Object)hs2ProxyUser).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getSessionUser$1(x$3))).map((Function1 & Serializable & scala.Serializable)proxyUser -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiAuthenticationFactory$.MODULE$.HS2_PROXY_USER()), proxyUser)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return this.getSessionUser((Map<String, String>)sessionConf);
    }

    public String getSessionUser(Map<String, String> sessionConf) {
        String string;
        String ipAddress = AuthenticationFilter$.MODULE$.getUserIpAddress();
        String realUser = this.getRealUser();
        try {
            string = this.getProxyUser(sessionConf, ipAddress, realUser);
        }
        catch (Throwable t) {
            throw new WebApplicationException(t.getMessage(), Response.Status.METHOD_NOT_ALLOWED);
        }
        return string;
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuthenticationFilter$.MODULE$.getUserIpAddress());
    }

    private String getProxyUser(Map<String, String> sessionConf, String ipAddress, String realUser) {
        if (sessionConf == null) {
            return realUser;
        }
        return (String)sessionConf.get((Object)KyuubiAuthenticationFactory$.MODULE$.HS2_PROXY_USER()).map((Function1 & Serializable & scala.Serializable)proxyUser -> {
            KyuubiAuthenticationFactory$.MODULE$.verifyProxyAccess(realUser, proxyUser, ipAddress, this.hadoopConf());
            return proxyUser;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> realUser);
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    public static final /* synthetic */ void $anonfun$recoverBatchSessions$5(KyuubiRestFrontendService $this, AtomicInteger pendingRecoveryTasksCount$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Future task = (Future)tuple2._1();
            String batchId = (String)tuple2._2();
            try {
                BoxedUnit boxedUnit;
                try {
                    boxedUnit = (BoxedUnit)task.get();
                }
                catch (Throwable e) {
                    $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error while recovering batch[").append(batchId).append("]").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                int pendingTasks = pendingRecoveryTasksCount$1.decrementAndGet();
                $this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Batch[").append(batchId).append("] recovery task terminated, current pending tasks ").append(pendingTasks).toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getRealUser$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getSessionUser$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public KyuubiRestFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiRestFrontendService");
        this.isStarted = new AtomicBoolean(false);
        this.batchChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("batch-checker", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.discoveryService = None$.MODULE$;
    }
}

