/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.operation;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationInfo$;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.spark.SparkBatchProcessBuilder;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.BatchJobSubmission$;
import org.apache.kyuubi.operation.KyuubiApplicationOperation;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.session.KyuubiBatchSessionImpl;
import org.apache.kyuubi.session.Session;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\ted\u0001\u0002\u001e<\u0001\u0011C\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001f\u0002\u0011)\u0019!C\u0001!\"Aa\f\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005`\u0001\t\u0015\r\u0011\"\u0001Q\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u0011\t\u0004!\u0011!Q\u0001\nEC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000fC\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!I\u0011\u0011\u0005\u0001C\u0002\u0013%\u00111\u0005\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002&!I\u00111\u0007\u0001C\u0002\u0013%\u0011Q\u0007\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u00028!I\u0011Q\t\u0001C\u0002\u0013\u0005Q\b\u0015\u0005\b\u0003\u000f\u0002\u0001\u0015!\u0003R\u0011%\tI\u0005\u0001a\u0001\n\u0013\tY\u0005C\u0005\u0002V\u0001\u0001\r\u0011\"\u0003\u0002X!A\u00111\r\u0001!B\u0013\ti\u0005C\u0004\u0002n\u0001!\t!a\u0013\t\u0013\u0005=\u0004\u00011A\u0005\n\u0005E\u0004\"CAH\u0001\u0001\u0007I\u0011BAI\u0011!\t)\n\u0001Q!\n\u0005M\u0004bBAL\u0001\u0011\u0005\u0011\u0011\u000f\u0005\n\u00033\u0003\u0001\u0019!C\u0005\u00037C\u0011\"a)\u0001\u0001\u0004%I!!*\t\u0011\u0005%\u0006\u0001)Q\u0005\u0003;Cq!!,\u0001\t\u0003\tY\n\u0003\u0006\u00020\u0002\u0011\r\u0011\"\u0001>\u0003cC\u0001\"!/\u0001A\u0003%\u00111\u0017\u0005\b\u0003+\u0004A\u0011KA&\u0011!\t9\u000e\u0001C\u0001{\u0005e\u0007\"CAn\u0001\t\u0007I\u0011BAN\u0011!\ti\u000e\u0001Q\u0001\n\u0005u\u0005\"CAp\u0001\t\u0007I\u0011BAN\u0011!\t\t\u000f\u0001Q\u0001\n\u0005u\u0005bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003O\u0004A\u0011IAu\u0011\u001d\ti\u000f\u0001C\u0005\u0003_DqAa\u0002\u0001\t#\n)\u000fC\u0004\u0003\n\u0001!\t&!:\t\u000f\t-\u0001\u0001\"\u0015\u0002f\"9!Q\u0002\u0001\u0005\n\u0005\u0015\bb\u0002B\b\u0001\u0011%!\u0011\u0003\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0011\u001d\u0011\u0019\u0006\u0001C!\u0003KDqA!\u0016\u0001\t\u0003\n)\u000fC\u0004\u0003X\u0001!\t%!\u0007\t\u000f\te\u0003\u0001\"\u0015\u0002\u001a!9!1\f\u0001\u0005\n\u0005\u0015xa\u0002B/w!\u0005!q\f\u0004\u0007umB\tA!\u0019\t\u000f\u0005\u0005a\u0007\"\u0001\u0003j!9!1\u000e\u001c\u0005\u0002\t5\u0004b\u0002B:m\u0011\u0005!Q\u000f\u0002\u0013\u0005\u0006$8\r\u001b&pEN+(-\\5tg&|gN\u0003\u0002={\u0005Iq\u000e]3sCRLwN\u001c\u0006\u0003}}\naa[=vk\nL'B\u0001!B\u0003\u0019\t\u0007/Y2iK*\t!)A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u000bB\u0011aiR\u0007\u0002w%\u0011\u0001j\u000f\u0002\u001b\u0017f,XOY5BaBd\u0017nY1uS>tw\n]3sCRLwN\\\u0001\bg\u0016\u001c8/[8o!\tYU*D\u0001M\u0015\tIU(\u0003\u0002O\u0019\n12*_;vE&\u0014\u0015\r^2i'\u0016\u001c8/[8o\u00136\u0004H.A\u0005cCR\u001c\u0007\u000eV=qKV\t\u0011\u000b\u0005\u0002S7:\u00111+\u0017\t\u0003)^k\u0011!\u0016\u0006\u0003-\u000e\u000ba\u0001\u0010:p_Rt$\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;\u0016A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!AW,\u0002\u0015\t\fGo\u00195UsB,\u0007%A\u0005cCR\u001c\u0007NT1nK\u0006Q!-\u0019;dQ:\u000bW.\u001a\u0011\u0002\u0011I,7o\\;sG\u0016\f\u0011b\u00197bgNt\u0015-\\3\u0002\u0013\t\fGo\u00195D_:4\u0007\u0003\u0002*f#FK!AZ/\u0003\u00075\u000b\u0007/A\u0005cCR\u001c\u0007.\u0011:hgB\u0019\u0011N\\)\u000f\u0005)dgB\u0001+l\u0013\u0005A\u0016BA7X\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001c9\u0003\u0007M+\u0017O\u0003\u0002n/\u0006\u0001\"/Z2pm\u0016\u0014\u00180T3uC\u0012\fG/\u0019\t\u0004gR4X\"A,\n\u0005U<&AB(qi&|g\u000e\u0005\u0002x}6\t\u0001P\u0003\u0002zu\u0006\u0019\u0011\r]5\u000b\u0005md\u0018\u0001C7fi\u0006$\u0017\r^1\u000b\u0005ul\u0014AB:feZ,'/\u0003\u0002\u0000q\nAQ*\u001a;bI\u0006$\u0018-\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003\u000b\t9!!\u0003\u0002\f\u00055\u0011qBA\t\u0003'\t)\u0002\u0005\u0002G\u0001!)\u0011j\u0003a\u0001\u0015\")qj\u0003a\u0001#\")ql\u0003a\u0001#\")\u0011m\u0003a\u0001#\")!m\u0003a\u0001#\")1m\u0003a\u0001I\")qm\u0003a\u0001Q\")\u0011o\u0003a\u0001e\u0006q1\u000f[8vY\u0012\u0014VO\\!ts:\u001cWCAA\u000e!\r\u0019\u0018QD\u0005\u0004\u0003?9&a\u0002\"p_2,\u0017M\\\u0001\u000e?>\u0004XM]1uS>tGj\\4\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-2(A\u0002m_\u001eLA!a\f\u0002*\taq\n]3sCRLwN\u001c'pO\u0006qql\u001c9fe\u0006$\u0018n\u001c8M_\u001e\u0004\u0013AE1qa2L7-\u0019;j_:l\u0015M\\1hKJ,\"!a\u000e\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010>\u0003\u0019)gnZ5oK&!\u0011\u0011IA\u001e\u0005aY\u00150^;cS\u0006\u0003\b\u000f\\5dCRLwN\\'b]\u0006<WM]\u0001\u0014CB\u0004H.[2bi&|g.T1oC\u001e,'\u000fI\u0001\bE\u0006$8\r[%e\u0003!\u0011\u0017\r^2i\u0013\u0012\u0004\u0013\u0001E0baBd\u0017nY1uS>t\u0017J\u001c4p+\t\ti\u0005\u0005\u0003ti\u0006=\u0003\u0003BA\u001d\u0003#JA!a\u0015\u0002<\ty\u0011\t\u001d9mS\u000e\fG/[8o\u0013:4w.\u0001\u000b`CB\u0004H.[2bi&|g.\u00138g_~#S-\u001d\u000b\u0005\u00033\ny\u0006E\u0002t\u00037J1!!\u0018X\u0005\u0011)f.\u001b;\t\u0013\u0005\u0005D#!AA\u0002\u00055\u0013a\u0001=%c\u0005\tr,\u00199qY&\u001c\u0017\r^5p]&sgm\u001c\u0011)\u0007U\t9\u0007E\u0002t\u0003SJ1!a\u001bX\u0005!1x\u000e\\1uS2,\u0017\u0001I4fi>\u0013h)\u001a;dQ\u000e+(O]3oi\u0006\u0003\b\u000f\\5dCRLwN\\%oM>\f1b[5mY6+7o]1hKV\u0011\u00111\u000f\t\u0005\u0003k\nII\u0004\u0003\u0002x\u0005\u001de\u0002BA=\u0003\u000bsA!a\u001f\u0002\u0004:!\u0011QPAA\u001d\r!\u0016qP\u0005\u0002\u0005&\u0011\u0001)Q\u0005\u0003}}J1!!\u0010>\u0013\ri\u00171H\u0005\u0005\u0003\u0017\u000biI\u0001\u0007LS2d'+Z:q_:\u001cXMC\u0002n\u0003w\tqb[5mY6+7o]1hK~#S-\u001d\u000b\u0005\u00033\n\u0019\nC\u0005\u0002ba\t\t\u00111\u0001\u0002t\u0005a1.\u001b7m\u001b\u0016\u001c8/Y4fA\u0005qq-\u001a;LS2dW*Z:tC\u001e,\u0017!D0baB\u001cF/\u0019:u)&lW-\u0006\u0002\u0002\u001eB\u00191/a(\n\u0007\u0005\u0005vK\u0001\u0003M_:<\u0017!E0baB\u001cF/\u0019:u)&lWm\u0018\u0013fcR!\u0011\u0011LAT\u0011%\t\t\u0007HA\u0001\u0002\u0004\ti*\u0001\b`CB\u00048\u000b^1siRKW.\u001a\u0011)\u0007u\t9'\u0001\u0007baB\u001cF/\u0019:u)&lW-A\u0004ck&dG-\u001a:\u0016\u0005\u0005M\u0006\u0003BA\u001d\u0003kKA!a.\u0002<\tY\u0001K]8d\u0005VLG\u000eZ3s\u0003!\u0011W/\u001b7eKJ\u0004\u0003f\u0001\u0011\u0002>B!\u0011qXAi\u001b\t\t\tM\u0003\u0003\u0002D\u0006\u0015\u0017aC1o]>$\u0018\r^5p]NTA!a2\u0002J\u000611m\\7n_:TA!a3\u0002N\u00061qm\\8hY\u0016T!!a4\u0002\u0007\r|W.\u0003\u0003\u0002T\u0006\u0005'!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\u000612-\u001e:sK:$\u0018\t\u001d9mS\u000e\fG/[8o\u0013:4w.\u0001\u000blS2d')\u0019;dQ\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0003\u0003g\n\u0001$\u00199qY&\u001c\u0017\r^5p]\u000eCWmY6J]R,'O^1m\u0003e\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u00138uKJ4\u0018\r\u001c\u0011\u00029\u0005\u0004\b\u000f\\5dCRLwN\\*uCJ4\u0018\r^5p]RKW.Z8vi\u0006i\u0012\r\u001d9mS\u000e\fG/[8o'R\f'O^1uS>tG+[7f_V$\b%A\nva\u0012\fG/\u001a\"bi\u000eDW*\u001a;bI\u0006$\u0018\r\u0006\u0002\u0002Z\u0005yq-\u001a;Pa\u0016\u0014\u0018\r^5p]2{w-\u0006\u0002\u0002lB!1\u000f^A\u0013\u0003U\u0019X\r^*uCR,\u0017J\u001a(pi\u000e\u000bgnY3mK\u0012$B!!\u0017\u0002r\"9\u00111_\u0015A\u0002\u0005U\u0018\u0001\u00038foN#\u0018\r^3\u0011\t\u0005](\u0011\u0001\b\u0005\u0003s\fiP\u0004\u0003\u0002z\u0005m\u0018B\u0001\u001f>\u0013\r\typO\u0001\u000f\u001fB,'/\u0019;j_:\u001cF/\u0019;f\u0013\u0011\u0011\u0019A!\u0002\u0003\u001d=\u0003XM]1uS>t7\u000b^1uK*\u0019\u0011q`\u001e\u0002\u0013\t,gm\u001c:f%Vt\u0017\u0001C1gi\u0016\u0014(+\u001e8\u0002\u0017I,h.\u00138uKJt\u0017\r\\\u0001\u0019gV\u0014W.\u001b;B]\u0012luN\\5u_J\u0014\u0015\r^2i\u0015>\u0014\u0017aD7p]&$xN\u001d\"bi\u000eD'j\u001c2\u0015\t\u0005e#1\u0003\u0005\u0007\u0005+q\u0003\u0019A)\u0002\u000b\u0005\u0004\b/\u00133\u0002+\u001d,Go\u00149fe\u0006$\u0018n\u001c8M_\u001e\u0014vn^*fiRA!1\u0004B\u001a\u0005\u000b\u0012y\u0005\u0005\u0003\u0003\u001e\t=RB\u0001B\u0010\u0015\u0011\u0011\tCa\t\u0002\rQD'/\u001b4u\u0015\u0011\u0011)Ca\n\u0002\u0007I\u00048M\u0003\u0003\u0003*\t-\u0012aB:feZL7-\u001a\u0006\u0004\u0005[y\u0014\u0001\u00025jm\u0016LAA!\r\u0003 \t9AKU8x'\u0016$\bb\u0002B\u001b_\u0001\u0007!qG\u0001\u0006_J$WM\u001d\t\u0005\u0005s\u0011yD\u0004\u0003\u0002z\nm\u0012b\u0001B\u001fw\u0005\u0001b)\u001a;dQ>\u0013\u0018.\u001a8uCRLwN\\\u0005\u0005\u0005\u0003\u0012\u0019E\u0001\tGKR\u001c\u0007n\u0014:jK:$\u0018\r^5p]*\u0019!QH\u001e\t\u000f\t\u001ds\u00061\u0001\u0003J\u0005!aM]8n!\r\u0019(1J\u0005\u0004\u0005\u001b:&aA%oi\"9!\u0011K\u0018A\u0002\t%\u0013\u0001B:ju\u0016\fQa\u00197pg\u0016\faaY1oG\u0016d\u0017AC5t)&lW\rZ(vi\u0006aQM^3oi\u0016s\u0017M\u00197fI\u0006y2\r\\3b]V\u0004X\u000b\u001d7pC\u0012,GMU3t_V\u00148-Z%g\u001d\u0016,G-\u001a3\u0002%\t\u000bGo\u00195K_\n\u001cVOY7jgNLwN\u001c\t\u0003\rZ\u001a2A\u000eB2!\r\u0019(QM\u0005\u0004\u0005O:&AB!osJ+g\r\u0006\u0002\u0003`\u0005\t\u0012\r\u001d9mS\u000e\fG/[8o\r\u0006LG.\u001a3\u0015\t\u0005m!q\u000e\u0005\b\u0005cB\u0004\u0019AA'\u0003E\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8Ti\u0006$Xo]\u0001\u0016CB\u0004H.[2bi&|g\u000eV3s[&t\u0017\r^3e)\u0011\tYBa\u001e\t\u000f\tE\u0014\b1\u0001\u0002N\u0001")
public class BatchJobSubmission
extends KyuubiApplicationOperation {
    private final KyuubiBatchSessionImpl session;
    private final String batchType;
    private final String batchName;
    private final String resource;
    private final Option<Metadata> recoveryMetadata;
    private final OperationLog _operationLog;
    private final KyuubiApplicationManager applicationManager;
    private final String batchId;
    private volatile Option<ApplicationInfo> _applicationInfo;
    private Tuple2<Object, String> killMessage;
    private volatile long _appStartTime;
    @VisibleForTesting
    private final ProcBuilder builder;
    private final long applicationCheckInterval;
    private final long applicationStarvationTimeout;

    public static boolean applicationTerminated(Option<ApplicationInfo> option) {
        return BatchJobSubmission$.MODULE$.applicationTerminated(option);
    }

    public static boolean applicationFailed(Option<ApplicationInfo> option) {
        return BatchJobSubmission$.MODULE$.applicationFailed(option);
    }

    public String batchType() {
        return this.batchType;
    }

    public String batchName() {
        return this.batchName;
    }

    @Override
    public boolean shouldRunAsync() {
        return true;
    }

    private OperationLog _operationLog() {
        return this._operationLog;
    }

    private KyuubiApplicationManager applicationManager() {
        return this.applicationManager;
    }

    public String batchId() {
        return this.batchId;
    }

    private Option<ApplicationInfo> _applicationInfo() {
        return this._applicationInfo;
    }

    private void _applicationInfo_$eq(Option<ApplicationInfo> x$1) {
        this._applicationInfo = x$1;
    }

    public Option<ApplicationInfo> getOrFetchCurrentApplicationInfo() {
        Option<ApplicationInfo> option = this._applicationInfo();
        if (option instanceof Some) {
            return this._applicationInfo();
        }
        if (None$.MODULE$.equals(option)) {
            return this.currentApplicationInfo();
        }
        throw new MatchError(option);
    }

    private Tuple2<Object, String> killMessage() {
        return this.killMessage;
    }

    private void killMessage_$eq(Tuple2<Object, String> x$1) {
        this.killMessage = x$1;
    }

    public Tuple2<Object, String> getKillMessage() {
        return this.killMessage();
    }

    private long _appStartTime() {
        return this._appStartTime;
    }

    private void _appStartTime_$eq(long x$1) {
        this._appStartTime = x$1;
    }

    public long appStartTime() {
        return this._appStartTime();
    }

    public ProcBuilder builder() {
        return this.builder;
    }

    @Override
    public Option<ApplicationInfo> currentApplicationInfo() {
        if (OperationState$.MODULE$.isTerminal(this.state()) && this._applicationInfo().nonEmpty()) {
            return this._applicationInfo();
        }
        Option applicationInfo = this.applicationManager().getApplicationInfo(this.builder().clusterManager(), this.batchId()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BatchJobSubmission.$anonfun$currentApplicationInfo$1(x$3)));
        applicationInfo.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            BatchJobSubmission.$anonfun$currentApplicationInfo$2(this, x$4);
            return BoxedUnit.UNIT;
        });
        return applicationInfo;
    }

    public Tuple2<Object, String> killBatchApplication() {
        return this.applicationManager().killApplication(this.builder().clusterManager(), this.batchId());
    }

    private long applicationCheckInterval() {
        return this.applicationCheckInterval;
    }

    private long applicationStarvationTimeout() {
        return this.applicationStarvationTimeout;
    }

    private void updateBatchMetadata() {
        long endTime;
        long l = endTime = this.isTerminalState(this.state()) ? this.lastAccessTime() : 0L;
        if (this.isTerminalState(this.state()) && this._applicationInfo().isEmpty()) {
            this._applicationInfo_$eq((Option<ApplicationInfo>)Option$.MODULE$.apply((Object)new ApplicationInfo(null, null, ApplicationState$.MODULE$.NOT_FOUND(), ApplicationInfo$.MODULE$.apply$default$4(), ApplicationInfo$.MODULE$.apply$default$5())));
        }
        this._applicationInfo().foreach((Function1 & Serializable & scala.Serializable)status -> {
            BatchJobSubmission.$anonfun$updateBatchMetadata$1(this, endTime, status);
            return BoxedUnit.UNIT;
        });
    }

    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this._operationLog());
    }

    private void setStateIfNotCanceled(Enumeration.Value newState) {
        Enumeration.Value value = this.state();
        synchronized (value) {
            Enumeration.Value value2 = this.state();
            Enumeration.Value value3 = OperationState$.MODULE$.CANCELED();
            if (value2 == null ? value3 != null : !value2.equals(value3)) {
                this.setState(newState);
                this._applicationInfo().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)BatchJobSubmission.$anonfun$setStateIfNotCanceled$1(x$5))).foreach((Function1 & Serializable & scala.Serializable)ai -> {
                    BatchJobSubmission.$anonfun$setStateIfNotCanceled$2(this, ai);
                    return BoxedUnit.UNIT;
                });
                Enumeration.Value value4 = newState;
                Enumeration.Value value5 = OperationState$.MODULE$.RUNNING();
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    this.session.onEngineOpened();
                }
            }
        }
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this._operationLog());
        this.setHasResultSet(true);
        this.setStateIfNotCanceled(OperationState$.MODULE$.PENDING());
    }

    @Override
    public void afterRun() {
        OperationLog$.MODULE$.removeCurrentOperationLog();
    }

    public void runInternal() {
        this.session.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block7: {
                Runnable asyncOperation = () -> {
                    block8: {
                        try {
                            try {
                                if ($this.recoveryMetadata.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.peerInstanceClosed()))) {
                                    this.setState(OperationState$.MODULE$.CANCELED());
                                } else {
                                    $this.recoveryMetadata.map((Function1 & Serializable & scala.Serializable)metadata -> {
                                        BatchJobSubmission.$anonfun$runInternal$4(this, metadata);
                                        return BoxedUnit.UNIT;
                                    }).getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.submitAndMonitorBatchJob());
                                    this.setStateIfNotCanceled(OperationState$.MODULE$.FINISHED());
                                }
                            }
                            catch (Throwable x$9) {
                                PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(this.onError$default$1());
                                if (catchExpr$1.isDefinedAt((Object)x$9)) {
                                    catchExpr$1.apply((Object)x$9);
                                    break block8;
                                }
                                throw x$9;
                            }
                        }
                        finally {
                            this.updateBatchMetadata();
                        }
                    }
                };
                try {
                    try {
                        Future opHandle = $this.session.sessionManager().submitBackgroundOperation(asyncOperation);
                        this.setBackgroundHandle(opHandle);
                    }
                    catch (Throwable x$10) {
                        PartialFunction<Throwable, BoxedUnit> catchExpr$2 = this.onError("submitting batch job submission operation in background, request rejected");
                        if (catchExpr$2.isDefinedAt((Object)x$10)) {
                            catchExpr$2.apply((Object)x$10);
                            break block7;
                        }
                        throw x$10;
                    }
                }
                finally {
                    if (this.isTerminalState(this.state())) {
                        this.updateBatchMetadata();
                    }
                }
            }
        });
    }

    private void submitAndMonitorBatchJob() {
        boolean appStatusFirstUpdated = false;
        long lastStarvationCheckTime = this.createTime();
        try {
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Submitting ").append(this.batchType()).append(" batch[").append(this.batchId()).append("] job:\n").append(this.builder()).toString());
            Process process = this.builder().start();
            this._applicationInfo_$eq(this.currentApplicationInfo());
            while (!BatchJobSubmission$.MODULE$.applicationFailed(this._applicationInfo()) && process.isAlive()) {
                if (!appStatusFirstUpdated) {
                    if (this._applicationInfo().isDefined()) {
                        this.setStateIfNotCanceled(OperationState$.MODULE$.RUNNING());
                        this.updateBatchMetadata();
                        appStatusFirstUpdated = true;
                    } else {
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - lastStarvationCheckTime > this.applicationStarvationTimeout()) {
                            lastStarvationCheckTime = currentTime;
                            this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Batch[").append(this.batchId()).append("] has not started, check the Kyuubi server to ensure").append(" that batch jobs can be submitted.").toString());
                        }
                    }
                }
                process.waitFor(this.applicationCheckInterval(), TimeUnit.MILLISECONDS);
                this._applicationInfo_$eq(this.currentApplicationInfo());
            }
            if (BatchJobSubmission$.MODULE$.applicationFailed(this._applicationInfo())) {
                process.destroyForcibly();
                throw new RuntimeException(new StringBuilder(18).append("Batch job failed: ").append(this._applicationInfo()).toString());
            }
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new KyuubiException(new StringBuilder(24).append("Process exit with value ").append(process.exitValue()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            Option$.MODULE$.apply((Object)this._applicationInfo().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.id())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BatchJobSubmission.$anonfun$submitAndMonitorBatchJob$4(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.builder().close(this.builder().close$default$1());
            this.cleanupUploadedResourceIfNeeded();
        }
    }

    private void monitorBatchJob(String appId) {
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Monitoring submitted ").append(this.batchType()).append(" batch[").append(this.batchId()).append("] job: ").append(appId).toString());
        if (this._applicationInfo().isEmpty()) {
            this._applicationInfo_$eq(this.currentApplicationInfo());
        }
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = OperationState$.MODULE$.PENDING();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.setStateIfNotCanceled(OperationState$.MODULE$.RUNNING());
        }
        if (this._applicationInfo().isEmpty()) {
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("The ").append(this.batchType()).append(" batch[").append(this.batchId()).append("] job: ").append(appId).append(" not found, assume that it has finished.").toString());
            return;
        }
        if (BatchJobSubmission$.MODULE$.applicationFailed(this._applicationInfo())) {
            throw new RuntimeException(new StringBuilder(21).append(this.batchType()).append(" batch[").append(this.batchId()).append("] job failed: ").append(this._applicationInfo()).toString());
        }
        this.updateBatchMetadata();
        while (this._applicationInfo().isDefined() && !BatchJobSubmission$.MODULE$.applicationTerminated(this._applicationInfo())) {
            Thread.sleep(this.applicationCheckInterval());
            Option<ApplicationInfo> newApplicationStatus = this.currentApplicationInfo();
            Option option = newApplicationStatus.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.state());
            Option option2 = this._applicationInfo().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.state());
            if (!(option == null ? option2 != null : !option.equals(option2))) continue;
            this._applicationInfo_$eq(newApplicationStatus);
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Batch report for ").append(this.batchId()).append(", ").append(this._applicationInfo()).toString());
        }
        if (BatchJobSubmission$.MODULE$.applicationFailed(this._applicationInfo())) {
            throw new RuntimeException(new StringBuilder(21).append(this.batchType()).append(" batch[").append(this.batchId()).append("] job failed: ").append(this._applicationInfo()).toString());
        }
    }

    public TRowSet getOperationLogRowSet(Enumeration.Value order, int from, int size) {
        Option<OperationLog> operationLog = this.getOperationLog();
        return (TRowSet)operationLog.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.read(from, size)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(44).append("Batch ID: ").append(this.batchId()).append(", failed to generate operation log").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    @Override
    public void close() {
        block17: {
            Enumeration.Value value = this.state();
            synchronized (value) {
                block15: {
                    if (!this.isClosedOrCanceled()) {
                        this.liftedTree1$1();
                        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$16 -> {
                            x$16.decCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.OPERATION_OPEN(), (String[])new String[]{this.opType()}));
                            return BoxedUnit.UNIT;
                        });
                        if (this.isTerminalState(this.state())) {
                            this.killMessage_$eq((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(46).append("batch ").append(this.batchId()).append(" is already terminal so can not kill it.").toString()));
                            this.builder().close(this.builder().close$default$1());
                            this.cleanupUploadedResourceIfNeeded();
                            break block15;
                        }
                        try {
                            this.killMessage_$eq(this.killBatchApplication());
                            this.builder().close(this.builder().close$default$1());
                            this.cleanupUploadedResourceIfNeeded();
                        }
                        finally {
                            Enumeration.Value value2 = this.state();
                            Enumeration.Value value3 = OperationState$.MODULE$.INITIALIZED();
                            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                                this.setState(OperationState$.MODULE$.CANCELED());
                                this.updateBatchMetadata();
                            } else if (this.killMessage()._1$mcZ$sp() && !this.isTerminalState(this.state())) {
                                this.setState(OperationState$.MODULE$.CANCELED());
                                this.updateBatchMetadata();
                            } else if (this.killMessage()._1$mcZ$sp()) {
                                this.killMessage_$eq((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(46).append("batch ").append(this.batchId()).append(" is already terminal so can not kill it.").toString()));
                            } else if (!this.isTerminalState(this.state())) {
                                // empty if block
                            }
                        }
                    }
                    break block17;
                }
                return;
            }
        }
    }

    @Override
    public void cancel() {
        throw new IllegalStateException("Use close instead.");
    }

    public boolean isTimedOut() {
        return false;
    }

    @Override
    public boolean eventEnabled() {
        return true;
    }

    private void cleanupUploadedResourceIfNeeded() {
        if (this.session.isResourceUploaded()) {
            try {
                Files.deleteIfExists(Paths.get(this.resource, new String[0]));
            }
            catch (Throwable e) {
                this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error deleting the uploaded resource: ").append($this.resource).toString(), e);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$currentApplicationInfo$1(ApplicationInfo x$3) {
        return x$3.id() != null;
    }

    public static final /* synthetic */ void $anonfun$currentApplicationInfo$2(BatchJobSubmission $this, ApplicationInfo x$4) {
        if ($this._appStartTime() <= 0L) {
            $this._appStartTime_$eq(System.currentTimeMillis());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateBatchMetadata$1(BatchJobSubmission $this, long endTime$1, ApplicationInfo status) {
        String x$1 = $this.batchId();
        String x$2 = $this.state().toString();
        long x$3 = $this.appStartTime();
        String x$4 = status.id();
        String x$5 = status.name();
        String x$6 = (String)status.url().orNull(Predef$.MODULE$.$conforms());
        String x$7 = status.state().toString();
        Option<String> x$8 = status.error();
        long x$9 = endTime$1;
        Enumeration.Value x$10 = Metadata$.MODULE$.apply$default$2();
        String x$11 = Metadata$.MODULE$.apply$default$3();
        String x$12 = Metadata$.MODULE$.apply$default$4();
        String x$13 = Metadata$.MODULE$.apply$default$5();
        String x$14 = Metadata$.MODULE$.apply$default$6();
        String x$15 = Metadata$.MODULE$.apply$default$8();
        String x$16 = Metadata$.MODULE$.apply$default$9();
        String x$17 = Metadata$.MODULE$.apply$default$10();
        Map<String, String> x$18 = Metadata$.MODULE$.apply$default$11();
        Seq<String> x$19 = Metadata$.MODULE$.apply$default$12();
        long x$20 = Metadata$.MODULE$.apply$default$13();
        String x$21 = Metadata$.MODULE$.apply$default$14();
        Option<String> x$22 = Metadata$.MODULE$.apply$default$15();
        boolean x$23 = Metadata$.MODULE$.apply$default$23();
        Metadata metadataToUpdate = new Metadata(x$1, x$10, x$11, x$12, x$13, x$14, x$2, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$23);
        $this.session.sessionManager().updateMetadata(metadataToUpdate);
    }

    public static final /* synthetic */ boolean $anonfun$setStateIfNotCanceled$1(ApplicationInfo x$5) {
        return x$5.id() != null;
    }

    public static final /* synthetic */ void $anonfun$setStateIfNotCanceled$2(BatchJobSubmission $this, ApplicationInfo ai) {
        $this.session.getSessionEvent().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.engineId_$eq(ai.id());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$runInternal$4(BatchJobSubmission $this, Metadata metadata) {
        String string = metadata.state();
        String string2 = OperationState$.MODULE$.PENDING().toString();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            $this._applicationInfo_$eq($this.currentApplicationInfo());
            boolean bl = false;
            Some some = null;
            Option option = $this._applicationInfo().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.id());
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                String string3 = (String)some.value();
                if (string3 == null) {
                    $this.submitAndMonitorBatchJob();
                    return;
                }
            }
            if (bl) {
                String appId = (String)some.value();
                $this.monitorBatchJob(appId);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                $this.submitAndMonitorBatchJob();
                return;
            }
            throw new MatchError((Object)option);
        }
        $this.monitorBatchJob(metadata.engineId());
    }

    public static final /* synthetic */ void $anonfun$submitAndMonitorBatchJob$4(BatchJobSubmission $this, Option x0$1) {
        Option option = x0$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            String appId = (String)some.value();
            $this.monitorBatchJob(appId);
            return;
        }
    }

    private final /* synthetic */ void liftedTree1$1() {
        try {
            this.getOperationLog().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
                x$15.close();
                return BoxedUnit.UNIT;
            });
        }
        catch (IOException e) {
            this.error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
        }
    }

    public BatchJobSubmission(KyuubiBatchSessionImpl session, String batchType, String batchName, String resource, String className, Map<String, String> batchConf, Seq<String> batchArgs, Option<Metadata> recoveryMetadata) {
        Some some;
        String string;
        Some some2;
        String string2;
        this.session = session;
        this.batchType = batchType;
        this.batchName = batchName;
        this.resource = resource;
        this.recoveryMetadata = recoveryMetadata;
        super((Session)session);
        this._operationLog = OperationLog$.MODULE$.createOperationLog((Session)session, this.getHandle());
        this.applicationManager = session.sessionManager().applicationManager();
        this.batchId = session.handle().identifier().toString();
        this._applicationInfo = None$.MODULE$;
        this.killMessage = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"UNKNOWN");
        this._appStartTime = BoxesRunTime.unboxToLong((Object)recoveryMetadata.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.engineOpenTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Option option = Option$.MODULE$.apply((Object)batchType).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toUpperCase(Locale.ROOT));
        if (!(option instanceof Some && "SPARK".equals(string2 = (String)(some2 = (Some)option).value()) ? true : option instanceof Some && "PYSPARK".equals(string = (String)(some = (Some)option).value()))) {
            throw new UnsupportedOperationException(new StringBuilder(23).append("Batch type ").append(batchType).append(" unsupported").toString());
        }
        this.builder = new SparkBatchProcessBuilder(session.user(), session.sessionConf(), this.batchId(), batchName, (Option<String>)Option$.MODULE$.apply((Object)resource), className, batchConf, batchArgs, this.getOperationLog());
        this.applicationCheckInterval = BoxesRunTime.unboxToLong((Object)session.sessionConf().get(KyuubiConf$.MODULE$.BATCH_APPLICATION_CHECK_INTERVAL()));
        this.applicationStarvationTimeout = BoxesRunTime.unboxToLong((Object)session.sessionConf().get(KyuubiConf$.MODULE$.BATCH_APPLICATION_STARVATION_TIMEOUT()));
    }
}

