/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.io.Serializable;
import java.util.List;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationInfo$;
import org.apache.kyuubi.engine.ApplicationOperation;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.JpsApplicationOperation;
import org.apache.kyuubi.engine.KubernetesApplicationOperation$;
import org.apache.kyuubi.util.KubernetesUtils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001\u0002\u000e\u001c\u0001\u0011BQa\r\u0001\u0005\u0002QB\u0011B\u000e\u0001A\u0002\u0003\u0007I\u0011B\u001c\t\u0013\u0011\u0003\u0001\u0019!a\u0001\n\u0013)\u0005\"C&\u0001\u0001\u0004\u0005\t\u0015)\u00039\u0011%\u0001\u0006\u00011AA\u0002\u0013%\u0011\u000bC\u0005V\u0001\u0001\u0007\t\u0019!C\u0005-\"I\u0001\f\u0001a\u0001\u0002\u0003\u0006KA\u0015\u0005\u00063\u0002!\tE\u0017\u0005\u0006G\u0002!\t\u0005\u001a\u0005\u0006q\u0002!\t%\u001f\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\t\u0019\u0002\u0001C\u0005\u0003+Aq!a\u000f\u0001\t\u0003\nidB\u0004\u0002@mA\t!!\u0011\u0007\riY\u0002\u0012AA\"\u0011\u0019\u0019t\u0002\"\u0001\u0002F!I\u0011qI\bC\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u00033z\u0001\u0015!\u0003\u0002L!I\u00111L\bC\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003;z\u0001\u0015!\u0003\u0002L!I\u0011qL\bC\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003Cz\u0001\u0015!\u0003\u0002L!I\u00111M\bC\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003Kz\u0001\u0015!\u0003\u0002L!9\u0011qM\b\u0005\u0002\u0005%$AH&vE\u0016\u0014h.\u001a;fg\u0006\u0003\b\u000f\\5dCRLwN\\(qKJ\fG/[8o\u0015\taR$\u0001\u0004f]\u001eLg.\u001a\u0006\u0003=}\taa[=vk\nL'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001K-z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-[5\t1$\u0003\u0002/7\t!\u0012\t\u001d9mS\u000e\fG/[8o\u001fB,'/\u0019;j_:\u0004\"\u0001M\u0019\u000e\u0003uI!AM\u000f\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\u000e\t\u0003Y\u0001\t\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0016\u0003a\u0002\"!\u000f\"\u000e\u0003iR!a\u000f\u001f\u0002\r\rd\u0017.\u001a8u\u0015\tid(\u0001\u0006lk\n,'O\\3uKNT!a\u0010!\u0002\u000f\u0019\f'M]5dq)\t\u0011)\u0001\u0002j_&\u00111I\u000f\u0002\u0011\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\fAc[;cKJtW\r^3t\u00072LWM\u001c;`I\u0015\fHC\u0001$J!\t1s)\u0003\u0002IO\t!QK\\5u\u0011\u001dQ5!!AA\u0002a\n1\u0001\u001f\u00132\u0003EYWOY3s]\u0016$Xm]\"mS\u0016tG\u000f\t\u0015\u0003\t5\u0003\"A\n(\n\u0005=;#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0019)\u00048o\u00149fe\u0006$\u0018n\u001c8\u0016\u0003I\u0003\"\u0001L*\n\u0005Q[\"a\u0006&qg\u0006\u0003\b\u000f\\5dCRLwN\\(qKJ\fG/[8o\u0003AQ\u0007o](qKJ\fG/[8o?\u0012*\u0017\u000f\u0006\u0002G/\"9!JBA\u0001\u0002\u0004\u0011\u0016!\u00046qg>\u0003XM]1uS>t\u0007%\u0001\u0006j]&$\u0018.\u00197ju\u0016$\"AR.\t\u000bqC\u0001\u0019A/\u0002\t\r|gN\u001a\t\u0003=\u0006l\u0011a\u0018\u0006\u0003Av\taaY8oM&<\u0017B\u00012`\u0005)Y\u00150^;cS\u000e{gNZ\u0001\fSN\u001cV\u000f\u001d9peR,G\r\u0006\u0002fQB\u0011aEZ\u0005\u0003O\u001e\u0012qAQ8pY\u0016\fg\u000eC\u0003j\u0013\u0001\u0007!.\u0001\bdYV\u001cH/\u001a:NC:\fw-\u001a:\u0011\u0007\u0019ZW.\u0003\u0002mO\t1q\n\u001d;j_:\u0004\"A\\;\u000f\u0005=\u001c\bC\u00019(\u001b\u0005\t(B\u0001:$\u0003\u0019a$o\\8u}%\u0011AoJ\u0001\u0007!J,G-\u001a4\n\u0005Y<(AB*ue&twM\u0003\u0002uO\u0005!2.\u001b7m\u0003B\u0004H.[2bi&|gNQ=UC\u001e$2A_A\u0002!\tYhP\u0004\u0002-y&\u0011QpG\u0001\ba\u0006\u001c7.Y4f\u0013\ry\u0018\u0011\u0001\u0002\r\u0017&dGNU3ta>t7/\u001a\u0006\u0003{nAa!!\u0002\u000b\u0001\u0004i\u0017a\u0001;bO\u00069r-\u001a;BaBd\u0017nY1uS>t\u0017J\u001c4p\u0005f$\u0016m\u001a\u000b\u0005\u0003\u0017\t\t\u0002E\u0002-\u0003\u001bI1!a\u0004\u001c\u0005=\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8J]\u001a|\u0007BBA\u0003\u0017\u0001\u0007Q.\u0001\ngS:$GI]5wKJ\u0004v\u000e\u001a\"z)\u0006<G\u0003BA\f\u0003s\u0001\u0002\"!\u0007\u0002 \u0005\r\u00121G\u0007\u0003\u00037Q1!!\b;\u0003\r!7\u000f\\\u0005\u0005\u0003C\tYB\u0001\rGS2$XM],bi\u000eDG*[:u\t\u0016dW\r^1cY\u0016\u0004B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0003n_\u0012,GNC\u0002\u0002.q\n1!\u00199j\u0013\u0011\t\t$a\n\u0003\u0007A{G\r\u0005\u0003\u0002&\u0005U\u0012\u0002BA\u001c\u0003O\u0011q\u0001U8e\u0019&\u001cH\u000f\u0003\u0004\u0002\u00061\u0001\r!\\\u0001\u0005gR|\u0007\u000fF\u0001G\u0003yYUOY3s]\u0016$Xm]!qa2L7-\u0019;j_:|\u0005/\u001a:bi&|g\u000e\u0005\u0002-\u001fM\u0019q\"J\u0018\u0015\u0005\u0005\u0005\u0013a\u0006'B\u0005\u0016culS-V+\nKu,\u0016(J#V+ulS#Z+\t\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\t1\fgn\u001a\u0006\u0003\u0003+\nAA[1wC&\u0019a/a\u0014\u000211\u000b%)\u0012'`\u0017f+VKQ%`+:K\u0015+V#`\u0017\u0016K\u0006%\u0001\nT!\u0006\u00136jX!Q!~KEi\u0018'B\u0005\u0016c\u0015aE*Q\u0003J[u,\u0011)Q?&#u\fT!C\u000b2\u0003\u0013aF&V\u0005\u0016\u0013f*\u0012+F'~\u001bVI\u0015,J\u0007\u0016{\u0006jT*U\u0003aYUKQ#S\u001d\u0016#ViU0T\u000bJ3\u0016jQ#`\u0011>\u001bF\u000bI\u0001\u0018\u0017V\u0013UI\u0015(F)\u0016\u001bvlU#S-&\u001bUi\u0018)P%R\u000b\u0001dS+C\u000bJsU\tV#T?N+%KV%D\u000b~\u0003vJ\u0015+!\u0003I!x.\u00119qY&\u001c\u0017\r^5p]N#\u0018\r^3\u0015\t\u0005-\u0014\u0011\u0012\t\u0005\u0003[\n\u0019I\u0004\u0003\u0002p\u0005}d\u0002BA9\u0003{rA!a\u001d\u0002|9!\u0011QOA=\u001d\r\u0001\u0018qO\u0005\u0002E%\u0011\u0001%I\u0005\u0003=}I!\u0001H\u000f\n\u0007\u0005\u00055$\u0001\tBaBd\u0017nY1uS>t7\u000b^1uK&!\u0011QQAD\u0005A\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ti\u0006$XMC\u0002\u0002\u0002nAa!a#\u001a\u0001\u0004i\u0017!B:uCR,\u0007")
public class KubernetesApplicationOperation
implements ApplicationOperation,
Logging {
    private volatile KubernetesClient kubernetesClient;
    private JpsApplicationOperation jpsOperation;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static Enumeration.Value toApplicationState(String string) {
        return KubernetesApplicationOperation$.MODULE$.toApplicationState(string);
    }

    public static String KUBERNETES_SERVICE_PORT() {
        return KubernetesApplicationOperation$.MODULE$.KUBERNETES_SERVICE_PORT();
    }

    public static String KUBERNETES_SERVICE_HOST() {
        return KubernetesApplicationOperation$.MODULE$.KUBERNETES_SERVICE_HOST();
    }

    public static String SPARK_APP_ID_LABEL() {
        return KubernetesApplicationOperation$.MODULE$.SPARK_APP_ID_LABEL();
    }

    public static String LABEL_KYUUBI_UNIQUE_KEY() {
        return KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private JpsApplicationOperation jpsOperation() {
        return this.jpsOperation;
    }

    private void jpsOperation_$eq(JpsApplicationOperation x$1) {
        this.jpsOperation = x$1;
    }

    @Override
    public void initialize(KyuubiConf conf) {
        KubernetesClient kubernetesClient;
        this.jpsOperation_$eq(new JpsApplicationOperation());
        this.jpsOperation().initialize(conf);
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Start initializing Kubernetes Client.");
        Option<KubernetesClient> option = KubernetesUtils$.MODULE$.buildKubernetesClient(conf);
        if (option instanceof Some) {
            Some some = (Some)option;
            KubernetesClient client = (KubernetesClient)some.value();
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Initialized Kubernetes Client connect to: ").append(client.getMasterUrl()).toString());
            kubernetesClient = client;
        } else if (None$.MODULE$.equals(option)) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Fail to init Kubernetes Client for Kubernetes Application Operation");
            kubernetesClient = null;
        } else {
            throw new MatchError(option);
        }
        this.kubernetesClient_$eq(kubernetesClient);
    }

    @Override
    public boolean isSupported(Option<String> clusterManager) {
        return this.kubernetesClient() != null && clusterManager.nonEmpty() && ((String)clusterManager.get()).toLowerCase().startsWith("k8s");
    }

    @Override
    public Tuple2<Object, String> killApplicationByTag(String tag) {
        if (this.kubernetesClient() != null) {
            Tuple2 tuple2;
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Deleting application info from Kubernetes cluster by ").append(tag).append(" tag").toString());
            try {
                FilterWatchListDeletable<Pod, PodList> operation = this.findDriverPodByTag(tag);
                List podList = ((PodList)operation.list()).getItems();
                if (podList.size() != 0) {
                    boolean bl;
                    Enumeration.Value value = KubernetesApplicationOperation$.MODULE$.toApplicationState(((Pod)podList.get(0)).getStatus().getPhase());
                    Enumeration.Value value2 = ApplicationState$.MODULE$.FAILED();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        bl = true;
                    } else {
                        Enumeration.Value value4 = ApplicationState$.MODULE$.UNKNOWN();
                        Enumeration.Value value5 = value;
                        bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
                    }
                    tuple2 = bl ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(42).append("Target Pod ").append(((Pod)podList.get(0)).getMetadata().getName()).append(" is in FAILED or UNKNOWN status").toString()) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(operation.delete())), (Object)new StringBuilder(41).append("Operation of deleted appId: ").append(((Pod)podList.get(0)).getMetadata().getName()).append(" is completed").toString());
                } else {
                    tuple2 = this.jpsOperation().killApplicationByTag(tag);
                }
            }
            catch (Exception e) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(46).append("Failed to terminate application with ").append(tag).append(", due to ").append(e.getMessage()).toString());
            }
            return tuple2;
        }
        throw new IllegalStateException("Methods initialize and isSupported must be called ahead");
    }

    @Override
    public ApplicationInfo getApplicationInfoByTag(String tag) {
        if (this.kubernetesClient() != null) {
            ApplicationInfo applicationInfo;
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Getting application info from Kubernetes cluster by ").append(tag).append(" tag").toString());
            try {
                FilterWatchListDeletable<Pod, PodList> operation = this.findDriverPodByTag(tag);
                List podList = ((PodList)operation.list()).getItems();
                if (podList.size() != 0) {
                    Pod pod = (Pod)podList.get(0);
                    String x$1 = (String)pod.getMetadata().getLabels().get(KubernetesApplicationOperation$.MODULE$.SPARK_APP_ID_LABEL());
                    String x$2 = pod.getMetadata().getName();
                    Enumeration.Value x$3 = KubernetesApplicationOperation$.MODULE$.toApplicationState(pod.getStatus().getPhase());
                    Option x$4 = Option$.MODULE$.apply((Object)pod.getStatus().getReason());
                    Option<String> x$5 = ApplicationInfo$.MODULE$.apply$default$4();
                    ApplicationInfo info = new ApplicationInfo(x$1, x$2, x$3, x$5, (Option<String>)x$4);
                    this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Successfully got application info by ").append(tag).append(": ").append(info).toString());
                    applicationInfo = info;
                } else {
                    applicationInfo = this.jpsOperation().getApplicationInfoByTag(tag);
                }
            }
            catch (Exception e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to get application with ").append(tag).append(", due to ").append(e.getMessage()).toString());
                applicationInfo = new ApplicationInfo(null, null, ApplicationState$.MODULE$.NOT_FOUND(), ApplicationInfo$.MODULE$.apply$default$4(), ApplicationInfo$.MODULE$.apply$default$5());
            }
            return applicationInfo;
        }
        throw new IllegalStateException("Methods initialize and isSupported must be called ahead");
    }

    private FilterWatchListDeletable<Pod, PodList> findDriverPodByTag(String tag) {
        FilterWatchListDeletable operation;
        block0: {
            operation = (FilterWatchListDeletable)this.kubernetesClient().pods().withLabel(KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY(), tag);
            int size = ((PodList)operation.list()).getItems().size();
            if (size == 1) break block0;
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Get Tag: ").append(tag).append(" Driver Pod In Kubernetes size: ").append(size).append(", we expect 1").toString());
        }
        return operation;
    }

    @Override
    public void stop() {
        if (this.kubernetesClient() != null) {
            try {
                this.kubernetesClient().close();
            }
            catch (Exception e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            }
            return;
        }
    }

    public KubernetesApplicationOperation() {
        Logging.$init$((Logging)this);
    }
}

