/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.EngineType$;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.flink.FlinkProcessBuilder;
import org.apache.kyuubi.engine.hive.HiveProcessBuilder;
import org.apache.kyuubi.engine.jdbc.JdbcProcessBuilder;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder;
import org.apache.kyuubi.engine.trino.TrinoProcessBuilder;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.package$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t%a!\u0002\u0016,\u00015\u001a\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t'\u0002\u0011\t\u0011)A\u0005\u000f\"AA\u000b\u0001B\u0001B\u0003%Q\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0004b\u0001\t\u0007I\u0011\u00022\t\r\r\u0004\u0001\u0015!\u0003H\u0011\u001d!\u0007A1A\u0005\n\u0015Da!\u001b\u0001!\u0002\u00131\u0007b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007w\u0002\u0001\u000b\u0011\u00027\t\u000fq\u0004!\u0019!C\u0005{\"9\u00111\u0002\u0001!\u0002\u0013q\b\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\t9\u0002\u0001Q\u0001\n\u0005E\u0001\"CA\r\u0001\t\u0007I\u0011BA\b\u0011!\tY\u0002\u0001Q\u0001\n\u0005E\u0001\u0002CA\u000f\u0001\t\u0007I\u0011\u00022\t\u000f\u0005}\u0001\u0001)A\u0005\u000f\"I\u0011\u0011\u0005\u0001C\u0002\u0013%\u00111\u0005\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002&!A\u0011Q\u0006\u0001C\u0002\u0013%!\rC\u0004\u00020\u0001\u0001\u000b\u0011B$\t\u0013\u0005E\u0002A1A\u0005\n\u0005M\u0002\u0002CA\u001e\u0001\u0001\u0006I!!\u000e\t\u0017\u0005u\u0002\u00011AA\u0002\u0013%\u0011q\b\u0005\f\u0003\u000f\u0002\u0001\u0019!a\u0001\n\u0013\tI\u0005C\u0006\u0002V\u0001\u0001\r\u0011!Q!\n\u0005\u0005\u0003\"CA,\u0001\t\u0007I\u0011A\u0017c\u0011\u001d\tI\u0006\u0001Q\u0001\n\u001dC\u0011\"a\u0017\u0001\u0005\u0004%\t!\f2\t\u000f\u0005u\u0003\u0001)A\u0005\u000f\"I\u0011\u0011\u0010\u0001C\u0002\u0013\u0005QF\u0019\u0005\b\u0003w\u0002\u0001\u0015!\u0003H\u0011)\ty\b\u0001EC\u0002\u0013\u0005QF\u0019\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003Dq!!:\u0001\t\u0003\t9\u000fC\u0005\u0002n\u0002\t\n\u0011\"\u0001\u0002p\"9!Q\u0001\u0001\u0005\u0002\t\u001d!!C#oO&tWMU3g\u0015\taS&\u0001\u0004f]\u001eLg.\u001a\u0006\u0003]=\naa[=vk\nL'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c2\u0001\u0001\u001b;!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0019\te.\u001f*fMB\u00111\bP\u0007\u0002[%\u0011Q(\f\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011\u0011\tR\u0007\u0002\u0005*\u00111)L\u0001\u0007G>tg-[4\n\u0005\u0015\u0013%AC&zkV\u0014\u0017nQ8oM\u0006!Qo]3s!\tAuJ\u0004\u0002J\u001bB\u0011!JN\u0007\u0002\u0017*\u0011AjP\u0001\u0007yI|w\u000e\u001e \n\u000593\u0014A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!A\u0014\u001c\u0002\u0019A\u0014\u0018.\\1ss\u001e\u0013x.\u001e9\u0002\u0017\u0015tw-\u001b8f%\u00164\u0017\nZ\u0001\u000eK:<\u0017N\\3NC:\fw-\u001a:\u0011\u0005Y;V\"A\u0016\n\u0005a[#\u0001G&zkV\u0014\u0017.\u00119qY&\u001c\u0017\r^5p]6\u000bg.Y4fe\u00061A(\u001b8jiz\"ba\u0017/^=~\u0003\u0007C\u0001,\u0001\u0011\u0015qd\u00011\u0001A\u0011\u00151e\u00011\u0001H\u0011\u0015\u0011f\u00011\u0001H\u0011\u0015\u0019f\u00011\u0001H\u0011\u0015!f\u00011\u0001V\u0003-\u0019XM\u001d<feN\u0003\u0018mY3\u0016\u0003\u001d\u000bAb]3sm\u0016\u00148\u000b]1dK\u0002\nq\u0001^5nK>,H/F\u0001g!\t)t-\u0003\u0002im\t!Aj\u001c8h\u0003!!\u0018.\\3pkR\u0004\u0013AC:iCJ,G*\u001a<fYV\tA\u000e\u0005\u0002nq:\u0011aN\u001e\b\u0003_Vt!\u0001\u001d;\u000f\u0005E\u001chB\u0001&s\u0013\u0005\u0011\u0014B\u0001\u00192\u0013\tqs&\u0003\u0002-[%\u0011qoK\u0001\u000b'\"\f'/\u001a'fm\u0016d\u0017BA={\u0005)\u0019\u0006.\u0019:f\u0019\u00164X\r\u001c\u0006\u0003o.\n1b\u001d5be\u0016dUM^3mA\u0005QQM\\4j]\u0016$\u0016\u0010]3\u0016\u0003y\u00042a`A\u0003\u001d\rq\u0017\u0011A\u0005\u0004\u0003\u0007Y\u0013AC#oO&tW\rV=qK&!\u0011qAA\u0005\u0005))enZ5oKRK\b/\u001a\u0006\u0004\u0003\u0007Y\u0013aC3oO&tW\rV=qK\u0002\nQ\u0002]8pYRC'/Z:i_2$WCAA\t!\r)\u00141C\u0005\u0004\u0003+1$aA%oi\u0006q\u0001o\\8m)\"\u0014Xm\u001d5pY\u0012\u0004\u0013AD2mS\u0016tG\u000fU8pYNK'0Z\u0001\u0010G2LWM\u001c;Q_>d7+\u001b>fA\u0005q1\r\\5f]R\u0004vn\u001c7OC6,\u0017aD2mS\u0016tG\u000fU8pY:\u000bW.\u001a\u0011\u00023\u0015tw-\u001b8f!>|G.S4o_J,7+\u001e2e_6\f\u0017N\\\u000b\u0003\u0003K\u00012!NA\u0014\u0013\r\tIC\u000e\u0002\b\u0005>|G.Z1o\u0003i)gnZ5oKB{w\u000e\\%h]>\u0014XmU;cI>l\u0017-\u001b8!\u0003Y)gnZ5oKB{w\u000e\\*fY\u0016\u001cG\u000fU8mS\u000eL\u0018aF3oO&tW\rU8pYN+G.Z2u!>d\u0017nY=!\u0003aaujQ&`)&kUiT+U?N\u0003\u0016IT0G\u0003\u000e#vJU\u000b\u0003\u0003k\u00012!NA\u001c\u0013\r\tID\u000e\u0002\u0007\t>,(\r\\3\u000231{5iS0U\u00136+u*\u0016+`'B\u000bej\u0018$B\u0007R{%\u000bI\u0001\bEVLG\u000eZ3s+\t\t\t\u0005E\u0002W\u0003\u0007J1!!\u0012,\u0005-\u0001&o\\2Ck&dG-\u001a:\u0002\u0017\t,\u0018\u000e\u001c3fe~#S-\u001d\u000b\u0005\u0003\u0017\n\t\u0006E\u00026\u0003\u001bJ1!a\u00147\u0005\u0011)f.\u001b;\t\u0013\u0005MC$!AA\u0002\u0005\u0005\u0013a\u0001=%c\u0005A!-^5mI\u0016\u0014\b%A\u0004baB,6/\u001a:\u0002\u0011\u0005\u0004\b/V:fe\u0002\n\u0011b];cI>l\u0017-\u001b8\u0002\u0015M,(\rZ8nC&t\u0007\u0005K\u0002\"\u0003C\u0002B!a\u0019\u0002v5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0006b]:|G/\u0019;j_:\u001c(\u0002BA6\u0003[\naaY8n[>t'\u0002BA8\u0003c\naaZ8pO2,'BAA:\u0003\r\u0019w.\\\u0005\u0005\u0003o\n)GA\tWSNL'\r\\3G_J$Vm\u001d;j]\u001e\f\u0011\u0003Z3gCVdG/\u00128hS:,g*Y7f\u0003I!WMZ1vYR,enZ5oK:\u000bW.\u001a\u0011)\u0007\r\n\t'A\u0006f]\u001eLg.Z*qC\u000e,\u0007f\u0001\u0013\u0002b\u0005YAO]=XSRDGj\\2l+\u0011\t9)a$\u0015\t\u0005%\u00151\u0016\u000b\u0005\u0003\u0017\u000b\t\u000b\u0005\u0003\u0002\u000e\u0006=E\u0002\u0001\u0003\b\u0003#+#\u0019AAJ\u0005\u0005!\u0016\u0003BAK\u00037\u00032!NAL\u0013\r\tIJ\u000e\u0002\b\u001d>$\b.\u001b8h!\r)\u0014QT\u0005\u0004\u0003?3$aA!os\"A\u00111U\u0013\u0005\u0002\u0004\t)+A\u0001g!\u0015)\u0014qUAF\u0013\r\tIK\u000e\u0002\ty\tLh.Y7f}!9\u0011QV\u0013A\u0002\u0005=\u0016a\u00043jg\u000e|g/\u001a:z\u00072LWM\u001c;\u0011\t\u0005E\u00161X\u0007\u0003\u0003gSA!!.\u00028\u000611\r\\5f]RT1!!/.\u0003\tA\u0017-\u0003\u0003\u0002>\u0006M&a\u0004#jg\u000e|g/\u001a:z\u00072LWM\u001c;\u0002\r\r\u0014X-\u0019;f)\u0019\t\u0019-!3\u0002LB1Q'!2H\u0003#I1!a27\u0005\u0019!V\u000f\u001d7fe!9\u0011Q\u0016\u0014A\u0002\u0005=\u0006bBAgM\u0001\u0007\u0011qZ\u0001\u000fKb$(/Y#oO&tW\rT8h!\u0015)\u0014\u0011[Ak\u0013\r\t\u0019N\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005]\u0017\u0011]\u0007\u0003\u00033TA!a7\u0002^\u0006\u0019An\\4\u000b\u0007\u0005}W&A\u0005pa\u0016\u0014\u0018\r^5p]&!\u00111]Am\u00051y\u0005/\u001a:bi&|g\u000eT8h\u0003-9W\r^(s\u0007J,\u0017\r^3\u0015\r\u0005\r\u0017\u0011^Av\u0011\u001d\tik\na\u0001\u0003_C\u0011\"!4(!\u0003\u0005\r!a4\u0002+\u001d,Go\u0014:De\u0016\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u001f\u0016\u0005\u0003\u001f\f\u0019p\u000b\u0002\u0002vB!\u0011q\u001fB\u0001\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018!C;oG\",7m[3e\u0015\r\tyPN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0002\u0003s\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0015\u0019Gn\\:f)\t\tY\u0005")
public class EngineRef
implements Logging {
    @VisibleForTesting
    private String engineSpace;
    private final KyuubiConf conf;
    private final String engineRefId;
    private final KyuubiApplicationManager engineManager;
    private final String serverSpace;
    private final long timeout;
    private final Enumeration.Value shareLevel;
    private final Enumeration.Value engineType;
    private final int poolThreshold;
    private final int clientPoolSize;
    private final String clientPoolName;
    private final boolean enginePoolIgnoreSubdomain;
    private final String enginePoolSelectPolicy;
    private final double LOCK_TIMEOUT_SPAN_FACTOR;
    private ProcBuilder builder;
    private final String appUser;
    @VisibleForTesting
    private final String subdomain;
    @VisibleForTesting
    private final String defaultEngineName;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private String serverSpace() {
        return this.serverSpace;
    }

    private long timeout() {
        return this.timeout;
    }

    private Enumeration.Value shareLevel() {
        return this.shareLevel;
    }

    private Enumeration.Value engineType() {
        return this.engineType;
    }

    private int poolThreshold() {
        return this.poolThreshold;
    }

    private int clientPoolSize() {
        return this.clientPoolSize;
    }

    private String clientPoolName() {
        return this.clientPoolName;
    }

    private boolean enginePoolIgnoreSubdomain() {
        return this.enginePoolIgnoreSubdomain;
    }

    private String enginePoolSelectPolicy() {
        return this.enginePoolSelectPolicy;
    }

    private double LOCK_TIMEOUT_SPAN_FACTOR() {
        return this.LOCK_TIMEOUT_SPAN_FACTOR;
    }

    private ProcBuilder builder() {
        return this.builder;
    }

    private void builder_$eq(ProcBuilder x$1) {
        this.builder = x$1;
    }

    public String appUser() {
        return this.appUser;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public String defaultEngineName() {
        return this.defaultEngineName;
    }

    private String engineSpace$lzycompute() {
        EngineRef engineRef = this;
        synchronized (engineRef) {
            if (!this.bitmap$0) {
                String commonParent = new StringBuilder(3).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).toString();
                Enumeration.Value value = this.shareLevel();
                Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
                Enumeration.Value value3 = value;
                this.engineSpace = !(value2 != null ? !value2.equals(value3) : value3 != null) ? DiscoveryPaths$.MODULE$.makePath(commonParent, this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.engineRefId})) : DiscoveryPaths$.MODULE$.makePath(commonParent, this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
                this.bitmap$0 = true;
            }
        }
        return this.engineSpace;
    }

    public String engineSpace() {
        if (!this.bitmap$0) {
            return this.engineSpace$lzycompute();
        }
        return this.engineSpace;
    }

    private <T> T tryWithLock(DiscoveryClient discoveryClient, Function0<T> f) {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (T)f.apply();
        }
        String lockPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(8).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_lock").toString(), this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
        return (T)discoveryClient.tryWithLock(lockPath, this.timeout() + (long)(this.LOCK_TIMEOUT_SPAN_FACTOR() * (double)this.timeout()), f);
    }

    private Tuple2<String, Object> create(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            tuple2 = (Tuple2)this.tryWithLock(discoveryClient, (Function0 & Serializable & scala.Serializable)() -> {
                Tuple2 tuple2;
                Logging logging;
                Option engineRef = discoveryClient.getServerHost(this.engineSpace());
                if (engineRef.nonEmpty()) {
                    throw new NonLocalReturnControl(object, engineRef.get());
                }
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_NAMESPACE(), (Object)this.engineSpace());
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID(), (Object)$this.engineRefId);
                long started = System.currentTimeMillis();
                $this.conf.set("kyuubi.engine.submit.time", String.valueOf(started));
                Enumeration.Value value = this.engineType();
                Enumeration.Value value2 = EngineType$.MODULE$.SPARK_SQL();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    $this.conf.setIfMissing("spark.app.name", this.defaultEngineName());
                    logging = new SparkProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                } else {
                    Enumeration.Value value4 = EngineType$.MODULE$.FLINK_SQL();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        $this.conf.setIfMissing("yarn.application.name", this.defaultEngineName());
                        logging = new FlinkProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                    } else {
                        Enumeration.Value value6 = EngineType$.MODULE$.TRINO();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            logging = new TrinoProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                        } else {
                            Enumeration.Value value8 = EngineType$.MODULE$.HIVE_SQL();
                            Enumeration.Value value9 = value;
                            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                logging = new HiveProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                            } else {
                                Enumeration.Value value10 = EngineType$.MODULE$.JDBC();
                                Enumeration.Value value11 = value;
                                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                    logging = new JdbcProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                                } else {
                                    throw new MatchError((Object)value);
                                }
                            }
                        }
                    }
                }
                this.builder_$eq((ProcBuilder)logging);
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.incCount(MetricsConstants$.MODULE$.ENGINE_TOTAL());
                    return BoxedUnit.UNIT;
                });
                try {
                    String redactedCmd = this.builder().toString();
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Launching engine:\n").append(redactedCmd).toString());
                    this.builder().validateConf();
                    Process process = this.builder().start();
                    None$ exitValue = None$.MODULE$;
                    while (engineRef.isEmpty()) {
                        if (exitValue.isEmpty() && process.waitFor(1L, TimeUnit.SECONDS) && BoxesRunTime.unboxToInt((Object)(exitValue = new Some((Object)BoxesRunTime.boxToInteger((int)process.exitValue()))).get()) != 0) {
                            Throwable error = this.builder().getError();
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                                EngineRef.$anonfun$create$4(this, error, ms);
                                return BoxedUnit.UNIT;
                            });
                            throw error;
                        }
                        None$ none$ = exitValue;
                        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                        if (!(none$ != null ? !none$.equals(some) : some != null)) {
                            Option$.MODULE$.apply((Object)$this.engineManager).foreach((Function1 & Serializable & scala.Serializable)engineMgr -> {
                                EngineRef.$anonfun$create$5(this, engineMgr);
                                return BoxedUnit.UNIT;
                            });
                        }
                        if (started + this.timeout() <= System.currentTimeMillis()) {
                            Tuple2<Object, String> killMessage = $this.engineManager.killApplication(this.builder().clusterManager(), $this.engineRefId);
                            process.destroyForcibly();
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$2 -> {
                                x$2.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                                return BoxedUnit.UNIT;
                            });
                            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(70).append("Timeout(").append(this.timeout()).append(" ms, you can modify ").append(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT().key()).append(" to change it) to").append(" launched ").append(this.engineType()).append(" engine with ").append(redactedCmd).append(". ").append(killMessage).toString(), this.builder().getError(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                        }
                        engineRef = discoveryClient.getEngineByRefId(this.engineSpace(), $this.engineRefId);
                    }
                    tuple2 = (Tuple2)engineRef.get();
                }
                finally {
                    ProcBuilder qual$1 = this.builder();
                    boolean x$12 = qual$1.close$default$1();
                    qual$1.close(x$12);
                }
                return tuple2;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public Tuple2<String, Object> getOrCreate(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        return (Tuple2)discoveryClient.getServerHost(this.engineSpace()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.create(discoveryClient, extraEngineLog));
    }

    public Option<OperationLog> getOrCreate$default$2() {
        return None$.MODULE$;
    }

    public void close() {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        if (!(value != null ? !value.equals(value2) : value2 != null) && this.builder() != null) {
            try {
                Option<String> clusterManager = this.builder().clusterManager();
                this.builder().close(true);
                this.engineManager.killApplication(clusterManager, this.engineRefId);
            }
            catch (Exception e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error closing engine builder, engineRefId: ").append($this.engineRefId).toString(), e);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$create$4(EngineRef $this, Throwable error$1, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{error$1.getClass().getSimpleName()}));
    }

    public static final /* synthetic */ void $anonfun$create$7(EngineRef $this, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{"ENGINE_TERMINATE"}));
    }

    public static final /* synthetic */ void $anonfun$create$6(EngineRef $this, ApplicationInfo appInfo) {
        if (ApplicationState$.MODULE$.isTerminated(appInfo.state())) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                EngineRef.$anonfun$create$7($this, ms);
                return BoxedUnit.UNIT;
            });
            throw new KyuubiSQLException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(158).append("\n                     |The engine application has been terminated. Please check the engine log.\n                     |ApplicationInfo: ").append(appInfo.toMap().mkString("(\n", ",\n", "\n)")).append("\n                     |").toString())).stripMargin(), $this.builder().getError());
        }
    }

    public static final /* synthetic */ void $anonfun$create$5(EngineRef $this, KyuubiApplicationManager engineMgr) {
        engineMgr.getApplicationInfo($this.builder().clusterManager(), $this.engineRefId).foreach((Function1 & Serializable & scala.Serializable)appInfo -> {
            EngineRef.$anonfun$create$6($this, appInfo);
            return BoxedUnit.UNIT;
        });
    }

    public EngineRef(KyuubiConf conf, String user, String primaryGroup, String engineRefId, KyuubiApplicationManager engineManager) {
        String string;
        String string2;
        this.conf = conf;
        this.engineRefId = engineRefId;
        this.engineManager = engineManager;
        Logging.$init$((Logging)this);
        this.serverSpace = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE());
        this.timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.shareLevel = ShareLevel$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
        this.engineType = EngineType$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()));
        this.poolThreshold = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE_THRESHOLD()));
        this.clientPoolSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE()));
        this.clientPoolName = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_NAME());
        this.enginePoolIgnoreSubdomain = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_IGNORE_SUBDOMAIN()));
        this.enginePoolSelectPolicy = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SELECT_POLICY());
        this.LOCK_TIMEOUT_SPAN_FACTOR = Utils$.MODULE$.isTesting() ? 0.5 : 0.1;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.SERVER();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string2 = Utils$.MODULE$.currentUser();
        } else {
            Enumeration.Value value4 = ShareLevel$.MODULE$.GROUP();
            Enumeration.Value value5 = value;
            string2 = !(value4 != null ? !value4.equals(value5) : value5 != null) ? primaryGroup : user;
        }
        this.appUser = string2;
        Option option = (Option)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN());
        if (this.clientPoolSize() > 0 && (option.isEmpty() || this.enginePoolIgnoreSubdomain())) {
            int n;
            String string3;
            int poolSize = scala.math.package$.MODULE$.min(this.clientPoolSize(), this.poolThreshold());
            if (poolSize < this.clientPoolSize()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Request engine pool size(").append(this.clientPoolSize()).append(") exceeds, fallback to ").append("system threshold ").append(this.poolThreshold()).toString());
            }
            if ("POLLING".equals(string3 = this.enginePoolSelectPolicy())) {
                String snPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(10).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_seqNum").toString(), this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.clientPoolName()}));
                n = BoxesRunTime.unboxToInt((Object)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(conf, (Function1 & Serializable & scala.Serializable)client -> BoxesRunTime.boxToInteger((int)client.getAndIncrement(snPath, client.getAndIncrement$default$2()))));
            } else if ("RANDOM".equals(string3)) {
                n = Random$.MODULE$.nextInt(poolSize);
            } else {
                throw new MatchError((Object)string3);
            }
            int seqNum = n;
            string = new StringBuilder(1).append(this.clientPoolName()).append("-").append(seqNum % poolSize).toString();
        } else if (option instanceof Some) {
            String _subdomain;
            Some some = (Some)option;
            string = _subdomain = (String)some.value();
        } else {
            string = "default";
        }
        this.subdomain = string;
        String commonNamePrefix = new StringBuilder(9).append("kyuubi_").append(this.shareLevel()).append("_").append(this.engineType()).append("_").append(this.appUser()).toString();
        Enumeration.Value value6 = this.shareLevel();
        Enumeration.Value value7 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value8 = value6;
        this.defaultEngineName = !(value7 != null ? !value7.equals(value8) : value8 != null) ? new StringBuilder(1).append(commonNamePrefix).append("_").append(engineRefId).toString() : new StringBuilder(2).append(commonNamePrefix).append("_").append(this.subdomain()).append("_").append(engineRefId).toString();
    }
}

