/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.sql;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Locale;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.codec.binary.Hex;
import org.apache.kyuubi.sql.KyuubiSQLConf$;
import org.apache.kyuubi.sql.KyuubiSparkSQLBaseVisitor;
import org.apache.kyuubi.sql.KyuubiSparkSQLParser;
import org.apache.kyuubi.sql.zorder.OptimizeZorderStatementBase;
import org.apache.kyuubi.sql.zorder.ZorderBase;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.NullOrdering;
import org.apache.spark.sql.catalyst.expressions.NullsLast$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserUtils$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.hive.HiveAnalysis$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u001de!\u0002\u000f\u001e\u0003\u00031\u0003\"B\u0019\u0001\t\u0003\u0011\u0004\"\u0002\u001b\u0001\r\u0003)\u0004\"B+\u0001\r\u00031\u0006\"B8\u0001\t#\u0001\b\"B?\u0001\t#q\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!!\u0010\u0001\t\u0003\ny\u0004C\u0004\u0002J\u0001!\t%a\u0013\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011\u001d\tI\n\u0001C!\u00037Cq!!*\u0001\t\u0003\n9\u000bC\u0004\u00022\u0002!\t%a-\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u0011\u0011\u001f\u0001\u0005B\u0005M\bbBA\u007f\u0001\u0011\u0005\u0013q \u0005\b\u0005\u0013\u0001A\u0011\tB\u0006\u0011\u001d\u0011)\u0002\u0001C!\u0005/AqA!\t\u0001\t\u0003\u0012\u0019\u0003C\u0004\u0003.\u0001!\tEa\f\t\u000f\te\u0002\u0001\"\u0003\u0003<!9!q\b\u0001\u0005\n\t\u0005\u0003b\u0002B2\u0001\u0011%!Q\r\u0002\u001d\u0017f,XOY5Ta\u0006\u00148nU)M\u0003N$()^5mI\u0016\u0014()Y:f\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\r-LX/\u001e2j\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\n\t\u0004Q%ZS\"A\u000f\n\u0005)j\"!G&zkV\u0014\u0017n\u00159be.\u001c\u0016\u000b\u0014\"bg\u00164\u0016n]5u_J\u0004\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00014!\tA\u0003!A\u0006ck&dGMW8sI\u0016\u0014HC\u0001\u001c=!\t9$(D\u00019\u0015\tIT$\u0001\u0004{_J$WM]\u0005\u0003wa\u0012!BW8sI\u0016\u0014()Y:f\u0011\u0015i$\u00011\u0001?\u0003\u0015\u0019\u0007.\u001b7e!\rytI\u0013\b\u0003\u0001\u0016s!!\u0011#\u000e\u0003\tS!aQ\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0013B\u0001$.\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001S%\u0003\u0007M+\u0017O\u0003\u0002G[A\u00111jU\u0007\u0002\u0019*\u0011QJT\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002P!\u0006A1-\u0019;bYf\u001cHO\u0003\u0002\u001f#*\u0011!+I\u0001\u0006gB\f'o[\u0005\u0003)2\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0003q\u0011W/\u001b7e\u001fB$\u0018.\\5{Kj{'\u000fZ3s'R\fG/Z7f]R$2a\u0016.f!\t9\u0004,\u0003\u0002Zq\tYr\n\u001d;j[&TXMW8sI\u0016\u00148\u000b^1uK6,g\u000e\u001e\"bg\u0016DQaW\u0002A\u0002q\u000bq\u0002^1cY\u0016LE-\u001a8uS\u001aLWM\u001d\t\u0004\u007f\u001dk\u0006C\u00010c\u001d\ty\u0006\r\u0005\u0002B[%\u0011\u0011-L\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002b[!)am\u0001a\u0001O\u0006)\u0011/^3ssB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\bY><\u0017nY1m\u0015\tag*A\u0003qY\u0006t7/\u0003\u0002oS\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0003))\u0007\u0010\u001d:fgNLwN\u001c\u000b\u0003\u0015FDQA\u001d\u0003A\u0002M\f1a\u0019;y!\t!80D\u0001v\u0015\t1x/A\u0004sk:$\u0018.\\3\u000b\u0005aL\u0018A\u0001<5\u0015\tQ8%A\u0003b]Rd'/\u0003\u0002}k\n\t\u0002+\u0019:tKJ\u0014V\u000f\\3D_:$X\r\u001f;\u0002\u00135,H\u000e^5QCJ$HC\u0001/\u0000\u0011\u0015\u0011X\u00011\u0001t\u0003Q1\u0018n]5u'&tw\r\\3Ti\u0006$X-\\3oiR\u0019q-!\u0002\t\rI4\u0001\u0019AA\u0004!\u0011\tI!a\b\u000f\t\u0005-\u00111\u0004\b\u0005\u0003\u001b\tIB\u0004\u0003\u0002\u0010\u0005]a\u0002BA\t\u0003+q1!QA\n\u0013\u0005!\u0013B\u0001\u0012$\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0019\u0011QD\u000f\u0002)-KX/\u001e2j'B\f'o[*R\u0019B\u000b'o]3s\u0013\u0011\t\t#a\t\u0003-MKgn\u001a7f'R\fG/Z7f]R\u001cuN\u001c;fqRT1!!\b\u001e\u0003M1\u0018n]5u\u001fB$\u0018.\\5{Kj{'\u000fZ3s)\r9\u0017\u0011\u0006\u0005\u0007e\u001e\u0001\r!a\u000b\u0011\t\u0005%\u0011QF\u0005\u0005\u0003_\t\u0019CA\u000bPaRLW.\u001b>f5>\u0014H-\u001a:D_:$X\r\u001f;\u0002!YL7/\u001b;QCN\u001cH\u000b\u001b:pk\u001eDGcA4\u00026!1!\u000f\u0003a\u0001\u0003o\u0001B!!\u0003\u0002:%!\u00111HA\u0012\u0005I\u0001\u0016m]:UQJ|Wo\u001a5D_:$X\r\u001f;\u0002\u0015YL7/\u001b;Rk\u0016\u0014\u0018\u0010F\u0002K\u0003\u0003BaA]\u0005A\u0002\u0005\r\u0003\u0003BA\u0005\u0003\u000bJA!a\u0012\u0002$\ta\u0011+^3ss\u000e{g\u000e^3yi\u0006\u0011b/[:ji2{w-[2bY\nKg.\u0019:z)\rQ\u0015Q\n\u0005\u0007e*\u0001\r!a\u0014\u0011\t\u0005%\u0011\u0011K\u0005\u0005\u0003'\n\u0019C\u0001\u000bM_\u001eL7-\u00197CS:\f'/_\"p]R,\u0007\u0010^\u0001\u0019m&\u001c\u0018\u000e^'vYRL\u0007/\u0019:u\u0013\u0012,g\u000e^5gS\u0016\u0014Hc\u0001/\u0002Z!1!o\u0003a\u0001\u00037\u0002B!!\u0003\u0002^%!\u0011qLA\u0012\u0005iiU\u000f\u001c;ja\u0006\u0014H/\u00133f]RLg-[3s\u0007>tG/\u001a=u\u0003E1\u0018n]5u5>\u0014H-\u001a:DY\u0006,8/\u001a\u000b\u0005\u0003K\n\u0019\b\u0005\u0003@\u000f\u0006\u001d\u0004\u0003BA5\u0003_j!!a\u001b\u000b\u0007\u00055d*\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t\t(a\u001b\u0003'Us'/Z:pYZ,G-\u0011;ue&\u0014W\u000f^3\t\rId\u0001\u0019AA;!\u0011\tI!a\u001e\n\t\u0005e\u00141\u0005\u0002\u00145>\u0014H-\u001a:DY\u0006,8/Z\"p]R,\u0007\u0010^\u0001\u0011m&\u001c\u0018\u000e\u001e(vY2d\u0015\u000e^3sC2$B!a \u0002\u0006B\u00191*!!\n\u0007\u0005\rEJA\u0004MSR,'/\u00197\t\rIl\u0001\u0019AAD!\u0011\tI!!#\n\t\u0005-\u00151\u0005\u0002\u0013\u001dVdG\u000eT5uKJ\fGnQ8oi\u0016DH/A\nwSNLGOQ8pY\u0016\fg\u000eT5uKJ\fG\u000e\u0006\u0003\u0002\u0000\u0005E\u0005B\u0002:\u000f\u0001\u0004\t\u0019\n\u0005\u0003\u0002\n\u0005U\u0015\u0002BAL\u0003G\u0011QCQ8pY\u0016\fg\u000eT5uKJ\fGnQ8oi\u0016DH/\u0001\u000bwSNLG\u000fV=qK\u000e{gn\u001d;sk\u000e$xN\u001d\u000b\u0005\u0003\u007f\ni\n\u0003\u0004s\u001f\u0001\u0007\u0011q\u0014\t\u0005\u0003\u0013\t\t+\u0003\u0003\u0002$\u0006\r\"A\u0006+za\u0016\u001cuN\\:ueV\u001cGo\u001c:D_:$X\r\u001f;\u0002%YL7/\u001b;TiJLgn\u001a'ji\u0016\u0014\u0018\r\u001c\u000b\u0005\u0003\u007f\nI\u000b\u0003\u0004s!\u0001\u0007\u00111\u0016\t\u0005\u0003\u0013\ti+\u0003\u0003\u00020\u0006\r\"\u0001F*ue&tw\rT5uKJ\fGnQ8oi\u0016DH/A\nwSNLG\u000fR3dS6\fG\u000eT5uKJ\fG\u000e\u0006\u0003\u0002\u0000\u0005U\u0006B\u0002:\u0012\u0001\u0004\t9\f\u0005\u0003\u0002\n\u0005e\u0016\u0002BA^\u0003G\u0011Q\u0003R3dS6\fG\u000eT5uKJ\fGnQ8oi\u0016DH/\u0001\bok6,'/[2MSR,'/\u00197\u0015\u0019\u0005\u0005\u00171[An\u0003?\fI/!<\u0015\t\u0005}\u00141\u0019\u0005\b\u0003\u000b\u0014\u0002\u0019AAd\u0003%\u0019wN\u001c<feR,'\u000f\u0005\u0004-\u0003\u0013l\u0016QZ\u0005\u0004\u0003\u0017l#!\u0003$v]\u000e$\u0018n\u001c82!\ra\u0013qZ\u0005\u0004\u0003#l#aA!os\"1!O\u0005a\u0001\u0003+\u0004B!!\u0003\u0002X&!\u0011\u0011\\A\u0012\u00055qU/\u001c2fe\u000e{g\u000e^3yi\"1\u0011Q\u001c\nA\u0002u\u000bAC]1x'R\u0014\u0018\u000e\u001d9fIF+\u0018\r\\5gS\u0016\u0014\bbBAq%\u0001\u0007\u00111]\u0001\t[&tg+\u00197vKB\u0019q(!:\n\u0007\u0005\u001d\u0018J\u0001\u0006CS\u001e$UmY5nC2Dq!a;\u0013\u0001\u0004\t\u0019/\u0001\u0005nCb4\u0016\r\\;f\u0011\u0019\tyO\u0005a\u0001;\u0006AA/\u001f9f\u001d\u0006lW-A\nwSNLG\u000fV5os&sG\u000fT5uKJ\fG\u000e\u0006\u0003\u0002\u0000\u0005U\bB\u0002:\u0014\u0001\u0004\t9\u0010\u0005\u0003\u0002\n\u0005e\u0018\u0002BA~\u0003G\u0011Q\u0003V5os&sG\u000fT5uKJ\fGnQ8oi\u0016DH/A\nwSNLG/\u00138uK\u001e,'\u000fT5uKJ\fG\u000e\u0006\u0003\u0002\u0000\t\u0005\u0001B\u0002:\u0015\u0001\u0004\u0011\u0019\u0001\u0005\u0003\u0002\n\t\u0015\u0011\u0002\u0002B\u0004\u0003G\u0011Q#\u00138uK\u001e,'\u000fT5uKJ\fGnQ8oi\u0016DH/\u0001\u000bwSNLGoU7bY2Le\u000e\u001e'ji\u0016\u0014\u0018\r\u001c\u000b\u0005\u0003\u007f\u0012i\u0001\u0003\u0004s+\u0001\u0007!q\u0002\t\u0005\u0003\u0013\u0011\t\"\u0003\u0003\u0003\u0014\u0005\r\"AF*nC2d\u0017J\u001c;MSR,'/\u00197D_:$X\r\u001f;\u0002%YL7/\u001b;CS\u001eLe\u000e\u001e'ji\u0016\u0014\u0018\r\u001c\u000b\u0005\u0003\u007f\u0012I\u0002\u0003\u0004s-\u0001\u0007!1\u0004\t\u0005\u0003\u0013\u0011i\"\u0003\u0003\u0003 \u0005\r\"\u0001\u0006\"jO&sG\u000fT5uKJ\fGnQ8oi\u0016DH/\u0001\nwSNLG\u000fR8vE2,G*\u001b;fe\u0006dG\u0003BA@\u0005KAaA]\fA\u0002\t\u001d\u0002\u0003BA\u0005\u0005SIAAa\u000b\u0002$\t!Bi\\;cY\u0016d\u0015\u000e^3sC2\u001cuN\u001c;fqR\faC^5tSR\u0014\u0015n\u001a#fG&l\u0017\r\u001c'ji\u0016\u0014\u0018\r\u001c\u000b\u0005\u0003\u007f\u0012\t\u0004\u0003\u0004s1\u0001\u0007!1\u0007\t\u0005\u0003\u0013\u0011)$\u0003\u0003\u00038\u0005\r\"\u0001\u0007\"jO\u0012+7-[7bY2KG/\u001a:bY\u000e{g\u000e^3yi\u0006a1M]3bi\u0016\u001cFO]5oOR\u0019QL!\u0010\t\rIL\u0002\u0019AAV\u0003)!\u0018\u0010]3e-&\u001c\u0018\u000e^\u000b\u0005\u0005\u0007\u0012I\u0005\u0006\u0003\u0003F\tU\u0003\u0003\u0002B$\u0005\u0013b\u0001\u0001B\u0004\u0003Li\u0011\rA!\u0014\u0003\u0003Q\u000bBAa\u0014\u0002NB\u0019AF!\u0015\n\u0007\tMSFA\u0004O_RD\u0017N\\4\t\rIT\u0002\u0019\u0001B,!\u0011\u0011IFa\u0018\u000e\u0005\tm#b\u0001B/k\u0006!AO]3f\u0013\u0011\u0011\tGa\u0017\u0003\u0013A\u000b'o]3Ue\u0016,\u0017\u0001D:ue&tw\rV8ECR,G\u0003\u0002B4\u0005g\u0002R\u0001\fB5\u0005[J1Aa\u001b.\u0005\u0019y\u0005\u000f^5p]B\u0019AFa\u001c\n\u0007\tETFA\u0002J]RDqA!\u001e\u001c\u0001\u0004\u00119(A\u0001t!\u0011\u0011IHa!\u000e\u0005\tm$\u0002\u0002B?\u0005\u007f\nQ\u0001^=qKNT1A!!R\u0003\u0019)hn]1gK&!!Q\u0011B>\u0005))FK\u0012\u001dTiJLgn\u001a")
public abstract class KyuubiSparkSQLAstBuilderBase
extends KyuubiSparkSQLBaseVisitor<Object> {
    public abstract ZorderBase buildZorder(Seq<Expression> var1);

    public abstract OptimizeZorderStatementBase buildOptimizeZorderStatement(Seq<String> var1, LogicalPlan var2);

    public Expression expression(ParserRuleContext ctx) {
        return (Expression)this.typedVisit((ParseTree)ctx);
    }

    public Seq<String> multiPart(ParserRuleContext ctx) {
        return (Seq)this.typedVisit((ParseTree)ctx);
    }

    @Override
    public LogicalPlan visitSingleStatement(KyuubiSparkSQLParser.SingleStatementContext ctx) {
        return (LogicalPlan)this.visit((ParseTree)ctx.statement());
    }

    @Override
    public LogicalPlan visitOptimizeZorder(KyuubiSparkSQLParser.OptimizeZorderContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            UnresolvedRelation unresolvedRelation;
            Seq<String> tableIdent = this.multiPart(ctx.multipartIdentifier());
            UnresolvedRelation table = new UnresolvedRelation(tableIdent, UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3());
            Object whereClause = ctx.whereClause() == null ? None$.MODULE$ : Option$.MODULE$.apply((Object)this.expression(ctx.whereClause().booleanExpression()));
            None$ none$ = whereClause;
            if (none$ instanceof Some) {
                Some some = (Some)none$;
                Expression expr = (Expression)some.value();
                unresolvedRelation = new Filter(expr, (LogicalPlan)table);
            } else if (None$.MODULE$.equals(none$)) {
                unresolvedRelation = table;
            } else {
                throw new MatchError((Object)none$);
            }
            UnresolvedRelation tableWithFilter = unresolvedRelation;
            Seq zorderCols = ((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx$1.zorderClause().order).asScala()).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitMultipartIdentifier((KyuubiSparkSQLParser.MultipartIdentifierContext)((Object)((Object)ctx))), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> new UnresolvedAttribute(x$1), Buffer$.MODULE$.canBuildFrom())).toSeq();
            Expression orderExpr = zorderCols.length() == 1 ? (Expression)zorderCols.head() : this.buildZorder((Seq<Expression>)zorderCols);
            SortOrder sortOrder = new SortOrder(orderExpr, (SortDirection)Ascending$.MODULE$, (NullOrdering)NullsLast$.MODULE$, (Seq)Nil$.MODULE$);
            Sort query = new Sort((Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), BoxesRunTime.unboxToBoolean((Object)HiveAnalysis$.MODULE$.conf().getConf(KyuubiSQLConf$.MODULE$.ZORDER_GLOBAL_SORT_ENABLED())), (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedStar((Option)None$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)tableWithFilter));
            return this.buildOptimizeZorderStatement(tableIdent, (LogicalPlan)query);
        });
    }

    @Override
    public LogicalPlan visitPassThrough(KyuubiSparkSQLParser.PassThroughContext ctx) {
        return null;
    }

    @Override
    public Expression visitQuery(KyuubiSparkSQLParser.QueryContext ctx) {
        return (Expression)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            UnresolvedAttribute left = new UnresolvedAttribute(this.multiPart(ctx.multipartIdentifier()));
            Expression right = this.expression(ctx.constant());
            TerminalNode operator = (TerminalNode)ctx.comparisonOperator().getChild(0);
            int n = operator.getSymbol().getType();
            if (KyuubiSparkSQLParser.EQ == n) {
                return new EqualTo((Expression)left, right);
            }
            if (KyuubiSparkSQLParser.NSEQ == n) {
                return new EqualNullSafe((Expression)left, right);
            }
            if (KyuubiSparkSQLParser.NEQ == n ? true : KyuubiSparkSQLParser.NEQJ == n) {
                return new Not((Expression)new EqualTo((Expression)left, right));
            }
            if (KyuubiSparkSQLParser.LT == n) {
                return new LessThan((Expression)left, right);
            }
            if (KyuubiSparkSQLParser.LTE == n) {
                return new LessThanOrEqual((Expression)left, right);
            }
            if (KyuubiSparkSQLParser.GT == n) {
                return new GreaterThan((Expression)left, right);
            }
            if (KyuubiSparkSQLParser.GTE == n) {
                return new GreaterThanOrEqual((Expression)left, right);
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        });
    }

    @Override
    public Expression visitLogicalBinary(KyuubiSparkSQLParser.LogicalBinaryContext ctx) {
        return (Expression)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            Function2 & Serializable & scala.Serializable intersect;
            int expressionType = ctx$3.operator.getType();
            int n = expressionType;
            if (KyuubiSparkSQLParser.AND == n) {
                intersect = (Function2 & Serializable & scala.Serializable)(left, right) -> new And(left, right);
            } else if (KyuubiSparkSQLParser.OR == n) {
                intersect = (Function2 & Serializable & scala.Serializable)(left, right) -> new Or(left, right);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            Function2 & Serializable & scala.Serializable expressionCombiner = intersect;
            ArrayBuffer contexts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KyuubiSparkSQLParser.BooleanExpressionContext[]{ctx$3.right}));
            ObjectRef current = ObjectRef.create((Object)((Object)ctx$3.left));
            while (KyuubiSparkSQLAstBuilderBase.collectContexts$1(current, expressionType, contexts)) {
            }
            ArrayBuffer expressions = (ArrayBuffer)contexts.reverseMap((Function1 & Serializable & scala.Serializable)ctx -> this.expression((ParserRuleContext)ctx), ArrayBuffer$.MODULE$.canBuildFrom());
            return KyuubiSparkSQLAstBuilderBase.reduceToExpressionTree$1(0, expressions.size() - 1, expressions, expressionCombiner);
        });
    }

    @Override
    public Seq<String> visitMultipartIdentifier(KyuubiSparkSQLParser.MultipartIdentifierContext ctx) {
        return (Seq)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx$4.parts).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getText(), Buffer$.MODULE$.canBuildFrom()));
    }

    @Override
    public Seq<UnresolvedAttribute> visitZorderClause(KyuubiSparkSQLParser.ZorderClauseContext ctx) {
        return (Seq)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            ListBuffer res = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ctx.multipartIdentifier().forEach(identifier -> res.$plus$eq((Object)new UnresolvedAttribute((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(identifier.parts).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getText(), Buffer$.MODULE$.canBuildFrom()))));
            return res;
        });
    }

    @Override
    public Literal visitNullLiteral(KyuubiSparkSQLParser.NullLiteralContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.apply(null));
    }

    @Override
    public Literal visitBooleanLiteral(KyuubiSparkSQLParser.BooleanLiteralContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            if (new StringOps(Predef$.MODULE$.augmentString(ctx.getText())).toBoolean()) {
                return Literal$.MODULE$.TrueLiteral();
            }
            return Literal$.MODULE$.FalseLiteral();
        });
    }

    @Override
    public Literal visitTypeConstructor(KyuubiSparkSQLParser.TypeConstructorContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            Literal literal;
            block8: {
                String value = ParserUtils$.MODULE$.string(ctx.STRING());
                String valueType = ctx.identifier().getText().toUpperCase(Locale.ROOT);
                try {
                    String string = valueType;
                    if ("DATE".equals(string)) {
                        literal = KyuubiSparkSQLAstBuilderBase.toLiteral$1((Function1 & Serializable & scala.Serializable)s -> this.stringToDate((UTF8String)s), (DataType)DateType$.MODULE$, value, valueType, ctx);
                        break block8;
                    }
                    if ("TIMESTAMP".equals(string)) {
                        ZoneId zoneId = DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone());
                        literal = KyuubiSparkSQLAstBuilderBase.toLiteral$1((Function1 & Serializable & scala.Serializable)x$6 -> DateTimeUtils$.MODULE$.stringToTimestamp(x$6, zoneId), (DataType)TimestampType$.MODULE$, value, valueType, ctx);
                        break block8;
                    }
                    if ("INTERVAL".equals(string)) {
                        CalendarInterval calendarInterval;
                        try {
                            calendarInterval = IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)value));
                        }
                        catch (IllegalArgumentException e) {
                            ParseException ex = new ParseException(new StringBuilder(33).append("Cannot parse the INTERVAL value: ").append(value).toString(), (ParserRuleContext)ctx);
                            ex.setStackTrace(e.getStackTrace());
                            throw ex;
                        }
                        CalendarInterval interval = calendarInterval;
                        literal = new Literal((Object)interval, (DataType)CalendarIntervalType$.MODULE$);
                        break block8;
                    }
                    if ("X".equals(string)) {
                        String padding = value.length() % 2 != 0 ? "0" : "";
                        literal = Literal$.MODULE$.apply((Object)Hex.decodeHex((String)new StringBuilder(0).append(padding).append(value).toString()));
                        break block8;
                    }
                    throw new ParseException(new StringBuilder(48).append("Literals of type '").append(string).append("' are currently not supported.").toString(), (ParserRuleContext)ctx);
                }
                catch (IllegalArgumentException e) {
                    String message = (String)Option$.MODULE$.apply((Object)e.getMessage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Exception parsing ").append(valueType).toString());
                    throw new ParseException(message, (ParserRuleContext)ctx);
                }
            }
            return literal;
        });
    }

    @Override
    public Literal visitStringLiteral(KyuubiSparkSQLParser.StringLiteralContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.apply((Object)this.createString(ctx)));
    }

    @Override
    public Literal visitDecimalLiteral(KyuubiSparkSQLParser.DecimalLiteralContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(ctx.getText()).underlying()));
    }

    private Literal numericLiteral(KyuubiSparkSQLParser.NumberContext ctx, String rawStrippedQualifier, BigDecimal minValue, BigDecimal maxValue, String typeName, Function1<String, Object> converter) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            Literal literal;
            try {
                BigDecimal rawBigDecimal = package$.MODULE$.BigDecimal().apply(rawStrippedQualifier);
                if (rawBigDecimal.$less((Object)minValue) || rawBigDecimal.$greater((Object)maxValue)) {
                    throw new ParseException(new StringBuilder(53).append("Numeric literal ").append(rawStrippedQualifier).append(" does not ").append("fit in range [").append(minValue).append(", ").append(maxValue).append("] for type ").append(typeName).toString(), (ParserRuleContext)ctx);
                }
                literal = Literal$.MODULE$.apply(converter.apply((Object)rawStrippedQualifier));
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage(), (ParserRuleContext)ctx);
            }
            return literal;
        });
    }

    @Override
    public Literal visitTinyIntLiteral(KyuubiSparkSQLParser.TinyIntLiteralContext ctx) {
        String rawStrippedQualifier = ctx.getText().substring(0, ctx.getText().length() - 1);
        return this.numericLiteral(ctx, rawStrippedQualifier, BigDecimal$.MODULE$.int2bigDecimal(-128), BigDecimal$.MODULE$.int2bigDecimal(127), ByteType$.MODULE$.simpleString(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToByte((byte)KyuubiSparkSQLAstBuilderBase.$anonfun$visitTinyIntLiteral$1(x$7)));
    }

    @Override
    public Literal visitIntegerLiteral(KyuubiSparkSQLParser.IntegerLiteralContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, ParserUtils$.MODULE$.withOrigin$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            BigDecimal bigDecimal = package$.MODULE$.BigDecimal().apply(ctx.getText());
            if (bigDecimal.isValidInt()) {
                return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)bigDecimal.intValue()));
            }
            if (bigDecimal.isValidLong()) {
                return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)bigDecimal.longValue()));
            }
            return Literal$.MODULE$.apply((Object)bigDecimal.underlying());
        });
    }

    @Override
    public Literal visitSmallIntLiteral(KyuubiSparkSQLParser.SmallIntLiteralContext ctx) {
        String rawStrippedQualifier = ctx.getText().substring(0, ctx.getText().length() - 1);
        return this.numericLiteral(ctx, rawStrippedQualifier, BigDecimal$.MODULE$.int2bigDecimal(Short.MIN_VALUE), BigDecimal$.MODULE$.int2bigDecimal(Short.MAX_VALUE), ShortType$.MODULE$.simpleString(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToShort((short)KyuubiSparkSQLAstBuilderBase.$anonfun$visitSmallIntLiteral$1(x$8)));
    }

    @Override
    public Literal visitBigIntLiteral(KyuubiSparkSQLParser.BigIntLiteralContext ctx) {
        String rawStrippedQualifier = ctx.getText().substring(0, ctx.getText().length() - 1);
        return this.numericLiteral(ctx, rawStrippedQualifier, BigDecimal$.MODULE$.long2bigDecimal(Long.MIN_VALUE), BigDecimal$.MODULE$.long2bigDecimal(Long.MAX_VALUE), LongType$.MODULE$.simpleString(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)KyuubiSparkSQLAstBuilderBase.$anonfun$visitBigIntLiteral$1(x$9)));
    }

    @Override
    public Literal visitDoubleLiteral(KyuubiSparkSQLParser.DoubleLiteralContext ctx) {
        String rawStrippedQualifier = ctx.getText().substring(0, ctx.getText().length() - 1);
        return this.numericLiteral(ctx, rawStrippedQualifier, BigDecimal$.MODULE$.double2bigDecimal(Double$.MODULE$.MinValue()), BigDecimal$.MODULE$.double2bigDecimal(Double.MAX_VALUE), DoubleType$.MODULE$.simpleString(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)KyuubiSparkSQLAstBuilderBase.$anonfun$visitDoubleLiteral$1(x$10)));
    }

    @Override
    public Literal visitBigDecimalLiteral(KyuubiSparkSQLParser.BigDecimalLiteralContext ctx) {
        Literal literal;
        String raw = ctx.getText().substring(0, ctx.getText().length() - 2);
        try {
            literal = Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(raw).underlying());
        }
        catch (AnalysisException e) {
            throw new ParseException(e.message(), (ParserRuleContext)ctx);
        }
        return literal;
    }

    private String createString(KyuubiSparkSQLParser.StringLiteralContext ctx) {
        if (HiveAnalysis$.MODULE$.conf().escapedStringLiterals()) {
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.STRING()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> ParserUtils$.MODULE$.stringWithoutUnescape(node), Buffer$.MODULE$.canBuildFrom())).mkString();
        }
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.STRING()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> ParserUtils$.MODULE$.string(node), Buffer$.MODULE$.canBuildFrom())).mkString();
    }

    private <T> T typedVisit(ParseTree ctx) {
        return (T)ctx.accept((ParseTreeVisitor)this);
    }

    private Option<Object> stringToDate(UTF8String s) {
        None$ none$;
        int j;
        if (s == null || s.trimAll().numBytes() == 0) {
            return None$.MODULE$;
        }
        int[] segments = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, 1}), ClassTag$.MODULE$.Int());
        int sign = 1;
        int i = 0;
        int currentSegmentValue = 0;
        int currentSegmentDigits = 0;
        byte[] bytes = s.trimAll().getBytes();
        if (bytes[j = 0] == 45 || bytes[j] == 43) {
            sign = bytes[j] == 45 ? -1 : 1;
            ++j;
        }
        while (j < bytes.length && i < 3 && bytes[j] != 32 && bytes[j] != 84) {
            byte b = bytes[j];
            if (i < 2 && b == 45) {
                if (!KyuubiSparkSQLAstBuilderBase.isValidDigits$1(i, currentSegmentDigits)) {
                    return None$.MODULE$;
                }
                segments[i] = currentSegmentValue;
                currentSegmentValue = 0;
                currentSegmentDigits = 0;
                ++i;
            } else {
                int parsedValue = b - (byte)48;
                if (parsedValue < 0 || parsedValue > 9) {
                    return None$.MODULE$;
                }
                currentSegmentValue = currentSegmentValue * 10 + parsedValue;
                ++currentSegmentDigits;
            }
            ++j;
        }
        if (!KyuubiSparkSQLAstBuilderBase.isValidDigits$1(i, currentSegmentDigits)) {
            return None$.MODULE$;
        }
        if (i < 2 && j < bytes.length) {
            return None$.MODULE$;
        }
        segments[i] = currentSegmentValue;
        try {
            LocalDate localDate = LocalDate.of(sign * segments[0], segments[1], segments[2]);
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.localDateToDays(localDate)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                none$ = None$.MODULE$;
            }
            throw throwable;
        }
        return none$;
    }

    private static final boolean collectContexts$1(ObjectRef current$1, int expressionType$1, ArrayBuffer contexts$1) {
        KyuubiSparkSQLParser.BooleanExpressionContext booleanExpressionContext = (KyuubiSparkSQLParser.BooleanExpressionContext)((Object)current$1.elem);
        if (booleanExpressionContext instanceof KyuubiSparkSQLParser.LogicalBinaryContext) {
            KyuubiSparkSQLParser.LogicalBinaryContext logicalBinaryContext = (KyuubiSparkSQLParser.LogicalBinaryContext)booleanExpressionContext;
            if (logicalBinaryContext.operator.getType() == expressionType$1) {
                contexts$1.$plus$eq((Object)logicalBinaryContext.right);
                current$1.elem = logicalBinaryContext.left;
                return true;
            }
        }
        contexts$1.$plus$eq((Object)((KyuubiSparkSQLParser.BooleanExpressionContext)((Object)current$1.elem)));
        return false;
    }

    private static final Expression reduceToExpressionTree$1(int low, int high, ArrayBuffer expressions$1, Function2 expressionCombiner$1) {
        int n = high - low;
        switch (n) {
            case 0: {
                return (Expression)expressions$1.apply(low);
            }
            case 1: {
                return (Expression)expressionCombiner$1.apply(expressions$1.apply(low), expressions$1.apply(high));
            }
        }
        int mid = low + n / 2;
        return (Expression)expressionCombiner$1.apply((Object)KyuubiSparkSQLAstBuilderBase.reduceToExpressionTree$1(low, mid, expressions$1, expressionCombiner$1), (Object)KyuubiSparkSQLAstBuilderBase.reduceToExpressionTree$1(mid + 1, high, expressions$1, expressionCombiner$1));
    }

    private static final Literal toLiteral$1(Function1 f, DataType t, String value$1, String valueType$1, KyuubiSparkSQLParser.TypeConstructorContext ctx$7) {
        return (Literal)((Option)f.apply((Object)UTF8String.fromString((String)value$1))).map((Function1 & Serializable & scala.Serializable)x$5 -> new Literal(x$5, t)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ParseException(new StringBuilder(25).append("Cannot parse the ").append(valueType$1).append(" value: ").append(value$1).toString(), (ParserRuleContext)ctx$7);
        });
    }

    public static final /* synthetic */ byte $anonfun$visitTinyIntLiteral$1(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toByte();
    }

    public static final /* synthetic */ short $anonfun$visitSmallIntLiteral$1(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toShort();
    }

    public static final /* synthetic */ long $anonfun$visitBigIntLiteral$1(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toLong();
    }

    public static final /* synthetic */ double $anonfun$visitDoubleLiteral$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toDouble();
    }

    private static final boolean isValidDigits$1(int segment, int digits) {
        int maxDigitsYear = 7;
        return segment == 0 && digits >= 4 && digits <= maxDigitsYear || segment != 0 && digits > 0 && digits <= 2;
    }
}

