/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino;

import com.google.common.base.Verify;
import io.trino.client.ClientSession;
import io.trino.client.Column;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import okhttp3.OkHttpClient;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.trino.TrinoConf$;
import org.apache.kyuubi.engine.trino.TrinoContext;
import org.apache.kyuubi.engine.trino.TrinoStatement$;
import org.apache.kyuubi.engine.trino.TrinoStatusPrinter$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.MapLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\f\u0019\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011!I\u0002\u0001#b\u0001\n\u0013I\u0006\u0002C2\u0001\u0011\u000b\u0007I\u0011\u00023\t\u0011!\u0004\u0001R1A\u0005\n%D\u0001\"\u001c\u0001\t\u0006\u0004%I!\u001b\u0005\b]\u0002\u0011\r\u0011b\u0001p\u0011\u00191\b\u0001)A\u0005a\")q\u000f\u0001C\u00013\")\u0001\u0010\u0001C\u0001s\")!\u0010\u0001C\u0001s\")1\u0010\u0001C\u0001y\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\u0013\u0001\u0011\u0005\u0011qE\u0004\b\u0003_A\u0002\u0012AA\u0019\r\u00199\u0002\u0004#\u0001\u00024!1!k\u0005C\u0001\u0003kAq!a\u000e\u0014\t\u0003\tI\u0004C\u0005\u0002DM\t\n\u0011\"\u0001\u0002F\tqAK]5o_N#\u0018\r^3nK:$(BA\r\u001b\u0003\u0015!(/\u001b8p\u0015\tYB$\u0001\u0004f]\u001eLg.\u001a\u0006\u0003;y\taa[=vk\nL'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016-\u001b\u0005a\u0012BA\u0017\u001d\u0005\u001daunZ4j]\u001e\fA\u0002\u001e:j]>\u001cuN\u001c;fqR\u0004\"\u0001M\u0019\u000e\u0003aI!A\r\r\u0003\u0019Q\u0013\u0018N\\8D_:$X\r\u001f;\u0002\u0015-LX/\u001e2j\u0007>tg\r\u0005\u00026q5\taG\u0003\u000289\u000511m\u001c8gS\u001eL!!\u000f\u001c\u0003\u0015-KX/\u001e2j\u0007>tg-A\u0002tc2\u0004\"\u0001P\"\u000f\u0005u\n\u0005C\u0001 '\u001b\u0005y$B\u0001!#\u0003\u0019a$o\\8u}%\u0011!IJ\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002CM\u0005aq\u000e]3sCRLwN\u001c'pOB\u0019Q\u0005\u0013&\n\u0005%3#AB(qi&|g\u000e\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006\u0019An\\4\u000b\u0005=c\u0012!C8qKJ\fG/[8o\u0013\t\tFJ\u0001\u0007Pa\u0016\u0014\u0018\r^5p]2{w-\u0001\u0004=S:LGO\u0010\u000b\u0006)V3v\u000b\u0017\t\u0003a\u0001AQAL\u0003A\u0002=BQaM\u0003A\u0002QBQAO\u0003A\u0002mBQAR\u0003A\u0002\u001d+\u0012A\u0017\t\u00037\u0006l\u0011\u0001\u0018\u0006\u0003;z\u000baa\u00197jK:$(BA\r`\u0015\u0005\u0001\u0017AA5p\u0013\t\u0011GLA\bTi\u0006$X-\\3oi\u000ec\u0017.\u001a8u\u0003Y!\u0017\r^1Qe>\u001cWm]:j]\u001e\u0004vn\u001c7TSj,W#A3\u0011\u0005\u00152\u0017BA4'\u0005\rIe\u000e^\u0001\fg\"|w\u000f\u0015:pG\u0016\u001c8/F\u0001k!\t)3.\u0003\u0002mM\t9!i\\8mK\u0006t\u0017!C:i_^$UMY;h\u0003\t)7-F\u0001q!\t\tH/D\u0001s\u0015\t\u0019h%\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u001e:\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u0005qq-\u001a;Ue&twn\u00117jK:$\u0018!E4fi\u000e+(O]3oi\u000e\u000bG/\u00197pOV\t1(\u0001\nhKR\u001cUO\u001d:f]R$\u0015\r^1cCN,\u0017AC4fi\u000e{G.^7ogV\tQ\u0010E\u0003\u007f\u0003\u000f\tiAD\u0002\u0000\u0003\u0007q1APA\u0001\u0013\u00059\u0013bAA\u0003M\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0005\u0003\u0017\u0011A\u0001T5ti*\u0019\u0011Q\u0001\u0014\u0011\u0007m\u000by!C\u0002\u0002\u0012q\u0013aaQ8mk6t\u0017aB3yK\u000e,H/\u001a\u000b\u0003\u0003/\u0001RA`A\r\u0003;IA!a\u0007\u0002\f\tA\u0011\n^3sCR|'\u000fE\u0003\u007f\u0003\u000f\ty\u0002E\u0002&\u0003CI1!a\t'\u0005\r\te._\u0001\u0013kB$\u0017\r^3Ue&twnQ8oi\u0016DH\u000f\u0006\u0002\u0002*A\u0019Q%a\u000b\n\u0007\u00055bE\u0001\u0003V]&$\u0018A\u0004+sS:|7\u000b^1uK6,g\u000e\u001e\t\u0003aM\u0019\"a\u0005\u0013\u0015\u0005\u0005E\u0012!B1qa2LH#\u0003+\u0002<\u0005u\u0012qHA!\u0011\u0015qS\u00031\u00010\u0011\u0015\u0019T\u00031\u00015\u0011\u0015QT\u00031\u0001<\u0011\u001d1U\u0003%AA\u0002\u001d\u000bq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u000fR3aRA%W\t\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAA+M\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0013q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TrinoStatement
implements Logging {
    private StatementClient trino;
    private int dataProcessingPoolSize;
    private boolean showProcess;
    private boolean showDebug;
    private final TrinoContext trinoContext;
    private final KyuubiConf kyuubiConf;
    private String sql;
    private final Option<OperationLog> operationLog;
    private final ExecutionContext ec;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<OperationLog> apply$default$4() {
        return TrinoStatement$.MODULE$.apply$default$4();
    }

    public static TrinoStatement apply(TrinoContext trinoContext, KyuubiConf kyuubiConf, String string, Option<OperationLog> option) {
        return TrinoStatement$.MODULE$.apply(trinoContext, kyuubiConf, string, option);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private StatementClient trino$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.trino = StatementClientFactory.newStatementClient((OkHttpClient)this.trinoContext.httpClient(), (ClientSession)this.trinoContext.clientSession().get(), (String)this.sql);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.sql = null;
        return this.trino;
    }

    private StatementClient trino() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.trino$lzycompute() : this.trino;
    }

    private int dataProcessingPoolSize$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dataProcessingPoolSize = BoxesRunTime.unboxToInt((Object)this.kyuubiConf.get(TrinoConf$.MODULE$.DATA_PROCESSING_POOL_SIZE()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dataProcessingPoolSize;
    }

    private int dataProcessingPoolSize() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dataProcessingPoolSize$lzycompute() : this.dataProcessingPoolSize;
    }

    private boolean showProcess$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.showProcess = BoxesRunTime.unboxToBoolean((Object)this.kyuubiConf.get(KyuubiConf$.MODULE$.ENGINE_TRINO_SHOW_PROGRESS()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.showProcess;
    }

    private boolean showProcess() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.showProcess$lzycompute() : this.showProcess;
    }

    private boolean showDebug$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.showDebug = BoxesRunTime.unboxToBoolean((Object)this.kyuubiConf.get(KyuubiConf$.MODULE$.ENGINE_TRINO_SHOW_PROGRESS_DEBUG()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.showDebug;
    }

    private boolean showDebug() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.showDebug$lzycompute() : this.showDebug;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public StatementClient getTrinoClient() {
        return this.trino();
    }

    public String getCurrentCatalog() {
        return this.trinoContext.clientSession().get().getCatalog();
    }

    public String getCurrentDatabase() {
        return this.trinoContext.clientSession().get().getSchema();
    }

    public List<Column> getColumns() {
        while (this.trino().isRunning()) {
            QueryStatusInfo results = this.trino().currentStatusInfo();
            java.util.List columns = results.getColumns();
            if (columns != null) {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Execute with Trino query id: ").append(results.getId()).toString());
                return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(columns).asScala()).toList();
            }
            this.trino().advance();
        }
        Verify.verify((boolean)this.trino().isFinished());
        QueryStatusInfo finalStatus = this.trino().finalStatusInfo();
        if (finalStatus.getError() == null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(24).append("Query has no columns (#").append(finalStatus.getId()).append(")").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(18).append("Query failed (#").append(finalStatus.getId()).append("): ").append(finalStatus.getError().getMessage()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
    }

    public Iterator<List<Object>> execute() {
        return package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> this.getData$1()).takeWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2._1$mcZ$sp())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3._2());
    }

    public void updateTrinoContext() {
        ClientSession session = this.trinoContext.clientSession().get();
        ClientSession.Builder builder = ClientSession.builder((ClientSession)session);
        if (this.trino().getSetCatalog().isPresent() || this.trino().getSetSchema().isPresent()) {
            builder = builder.withCatalog(this.trino().getSetCatalog().orElse(session.getCatalog())).withSchema(this.trino().getSetSchema().orElse(session.getSchema()));
        }
        if (this.trino().getSetPath().isPresent()) {
            builder = builder.withPath((String)this.trino().getSetPath().get());
        }
        if (!this.trino().getSetSessionProperties().isEmpty() || !this.trino().getResetSessionProperties().isEmpty()) {
            Map properties = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(session.getProperties()).asScala()).clone();
            properties.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.trino().getSetSessionProperties()).asScala());
            properties.$minus$minus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.trino().getResetSessionProperties()).asScala());
            builder = builder.withProperties((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(properties).asJava());
        }
        this.trinoContext.clientSession().set(builder.build());
    }

    private final Tuple2 getData$1() {
        Tuple2 tuple2;
        block3: {
            QueryStatusInfo finalStatus;
            while (this.trino().isRunning()) {
                Iterable data = this.trino().currentData().getData();
                this.trino().advance();
                if (data == null) continue;
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(data).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toList(), List$.MODULE$.canBuildFrom()));
                break block3;
            }
            Verify.verify((boolean)this.trino().isFinished());
            if (this.operationLog.isDefined() && this.showProcess()) {
                TrinoStatusPrinter$.MODULE$.printFinalInfo(this.trino(), (OperationLog)this.operationLog.get(), this.showDebug());
            }
            if ((finalStatus = this.trino().finalStatusInfo()).getError() != null) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(15).append("Query ").append(finalStatus.getId()).append(" failed: ").append(finalStatus.getError().getMessage()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            this.updateTrinoContext();
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Nil$.MODULE$);
        }
        return tuple2;
    }

    public TrinoStatement(TrinoContext trinoContext, KyuubiConf kyuubiConf, String sql, Option<OperationLog> operationLog) {
        this.trinoContext = trinoContext;
        this.kyuubiConf = kyuubiConf;
        this.sql = sql;
        this.operationLog = operationLog;
        Logging.$init$((Logging)this);
        this.ec = ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newFixedThreadPool(this.dataProcessingPoolSize()));
    }
}

