/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink.schema;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.types.Row;
import org.apache.kyuubi.engine.flink.result.ResultSet;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TBoolColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TBoolValue;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TByteColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TByteValue;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TColumnDesc;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TColumnValue;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TDoubleColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TDoubleValue;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI16Column;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI16Value;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI32Column;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI32Value;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI64Column;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI64Value;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TRow;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TStringColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TStringValue;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TTypeDesc;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TTypeEntry;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TTypeQualifierValue;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TTypeQualifiers;
import org.apache.kyuubi.util.RowSetUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class RowSet$ {
    public static RowSet$ MODULE$;

    static {
        new RowSet$();
    }

    public TRowSet resultSetToTRowSet(Seq<Row> rows, ResultSet resultSet, TProtocolVersion protocolVersion) {
        return protocolVersion.getValue() < TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6.getValue() ? this.toRowBaseSet(rows, resultSet) : this.toColumnBasedSet(rows, resultSet);
    }

    public TRowSet toRowBaseSet(Seq<Row> rows, ResultSet resultSet) {
        int rowSize = rows.size();
        ArrayList<TRow> tRows = new ArrayList<TRow>(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            Row row = (Row)rows.apply(i);
            TRow tRow = new TRow();
            int columnSize = row.getArity();
            for (int j = 0; j < columnSize; ++j) {
                TColumnValue columnValue = this.toTColumnValue(j, row, resultSet);
                tRow.addToColVals(columnValue);
            }
            tRows.add(tRow);
        }
        return new TRowSet(0L, tRows);
    }

    public TRowSet toColumnBasedSet(Seq<Row> rows, ResultSet resultSet) {
        int size = rows.length();
        TRowSet tRowSet = new TRowSet(0L, new ArrayList<TRow>(size));
        int columnSize = resultSet.getColumns().size();
        for (int i = 0; i < columnSize; ++i) {
            Column field = resultSet.getColumns().get(i);
            TColumn tColumn = this.toTColumn(rows, i, field.getDataType().getLogicalType());
            tRowSet.addToColumns(tColumn);
        }
        return tRowSet;
    }

    private TColumnValue toTColumnValue(int ordinal, Row row, ResultSet resultSet) {
        TColumnValue tColumnValue;
        Column column = resultSet.getColumns().get(ordinal);
        LogicalType logicalType = column.getDataType().getLogicalType();
        LogicalType logicalType2 = logicalType;
        if (logicalType2 instanceof BooleanType) {
            TBoolValue boolValue = new TBoolValue();
            if (row.getField(ordinal) != null) {
                boolValue.setValue(BoxesRunTime.unboxToBoolean((Object)row.getField(ordinal)));
            }
            tColumnValue = TColumnValue.boolVal(boolValue);
        } else if (logicalType2 instanceof TinyIntType) {
            TByteValue tByteValue = new TByteValue();
            if (row.getField(ordinal) != null) {
                tByteValue.setValue(BoxesRunTime.unboxToByte((Object)row.getField(ordinal)));
            }
            tColumnValue = TColumnValue.byteVal(tByteValue);
        } else if (logicalType2 instanceof SmallIntType) {
            TI16Value tI16Value = new TI16Value();
            if (row.getField(ordinal) != null) {
                tI16Value.setValue(BoxesRunTime.unboxToShort((Object)row.getField(ordinal)));
            }
            tColumnValue = TColumnValue.i16Val(tI16Value);
        } else if (logicalType2 instanceof IntType) {
            TI32Value tI32Value = new TI32Value();
            if (row.getField(ordinal) != null) {
                tI32Value.setValue(BoxesRunTime.unboxToInt((Object)row.getField(ordinal)));
            }
            tColumnValue = TColumnValue.i32Val(tI32Value);
        } else if (logicalType2 instanceof BigIntType) {
            TI64Value tI64Value = new TI64Value();
            if (row.getField(ordinal) != null) {
                tI64Value.setValue(BoxesRunTime.unboxToLong((Object)row.getField(ordinal)));
            }
            tColumnValue = TColumnValue.i64Val(tI64Value);
        } else if (logicalType2 instanceof FloatType) {
            TDoubleValue tDoubleValue = new TDoubleValue();
            if (row.getField(ordinal) != null) {
                Double doubleValue = Double.valueOf(Float.toString(BoxesRunTime.unboxToFloat((Object)row.getField(ordinal))));
                tDoubleValue.setValue(Predef$.MODULE$.Double2double(doubleValue));
            }
            tColumnValue = TColumnValue.doubleVal(tDoubleValue);
        } else if (logicalType2 instanceof DoubleType) {
            TDoubleValue tDoubleValue = new TDoubleValue();
            if (row.getField(ordinal) != null) {
                tDoubleValue.setValue(BoxesRunTime.unboxToDouble((Object)row.getField(ordinal)));
            }
            tColumnValue = TColumnValue.doubleVal(tDoubleValue);
        } else {
            boolean bl = logicalType2 instanceof VarCharType ? true : logicalType2 instanceof CharType;
            if (bl) {
                TStringValue tStringValue = new TStringValue();
                Object fieldValue = row.getField(ordinal);
                Object object = fieldValue;
                if (object instanceof String) {
                    String string = (String)object;
                    tStringValue.setValue(string);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof StringData) {
                    StringData stringData = (StringData)object;
                    tStringValue.setValue(stringData.toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object == null) {
                    tStringValue.setValue(null);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new IllegalArgumentException(new StringBuilder(40).append("Unsupported conversion class ").append(object.getClass()).append(" ").append("for type ").append(logicalType2.getClass()).append(".").toString());
                }
                tColumnValue = TColumnValue.stringVal(tStringValue);
            } else {
                TStringValue tStringValue = new TStringValue();
                if (row.getField(ordinal) != null) {
                    tStringValue.setValue(this.toHiveString((Tuple2<Object, LogicalType>)new Tuple2(row.getField(ordinal), (Object)logicalType2)));
                }
                tColumnValue = TColumnValue.stringVal(tStringValue);
            }
        }
        return tColumnValue;
    }

    private ByteBuffer bitSetToBuffer(BitSet bitSet) {
        return ByteBuffer.wrap(bitSet.toByteArray());
    }

    private TColumn toTColumn(Seq<Row> rows, int ordinal, LogicalType logicalType) {
        TColumn tColumn;
        BitSet nulls = new BitSet();
        Object sampleField = rows.iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getField(ordinal)).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RowSet$.$anonfun$toTColumn$2(x$2))).orNull(Predef$.MODULE$.$conforms());
        LogicalType logicalType2 = logicalType;
        if (logicalType2 instanceof BooleanType) {
            List<Boolean> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.boolean2Boolean(true));
            tColumn = TColumn.boolVal(new TBoolColumn(values, this.bitSetToBuffer(nulls)));
        } else if (logicalType2 instanceof TinyIntType) {
            List<Byte> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.byte2Byte((byte)0));
            tColumn = TColumn.byteVal(new TByteColumn(values, this.bitSetToBuffer(nulls)));
        } else if (logicalType2 instanceof SmallIntType) {
            List<Short> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.short2Short((short)0));
            tColumn = TColumn.i16Val(new TI16Column(values, this.bitSetToBuffer(nulls)));
        } else if (logicalType2 instanceof IntType) {
            List<Integer> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.int2Integer(0));
            tColumn = TColumn.i32Val(new TI32Column(values, this.bitSetToBuffer(nulls)));
        } else if (logicalType2 instanceof BigIntType) {
            List<Long> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.long2Long(0L));
            tColumn = TColumn.i64Val(new TI64Column(values, this.bitSetToBuffer(nulls)));
        } else if (logicalType2 instanceof FloatType) {
            List values = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.float2Float(0.0f))).asScala()).map((Function1 & Serializable & scala.Serializable)n -> Double.valueOf(n.toString()), Buffer$.MODULE$.canBuildFrom())).asJava();
            tColumn = TColumn.doubleVal(new TDoubleColumn(values, this.bitSetToBuffer(nulls)));
        } else if (logicalType2 instanceof DoubleType) {
            List<Double> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.double2Double(0.0));
            tColumn = TColumn.doubleVal(new TDoubleColumn(values, this.bitSetToBuffer(nulls)));
        } else {
            boolean bl = logicalType2 instanceof VarCharType ? true : logicalType2 instanceof CharType;
            if (bl) {
                Boolean bl2;
                ArrayList<String> values = new ArrayList<String>(0);
                Object object = sampleField;
                if (object instanceof String) {
                    bl2 = BoxesRunTime.boxToBoolean((boolean)values.addAll(this.getOrSetAsNull(rows, ordinal, nulls, "")));
                } else if (object instanceof StringData) {
                    List<StringData> stringDataValues = this.getOrSetAsNull(rows, ordinal, nulls, StringData.fromString((String)""));
                    stringDataValues.forEach(e -> values.add(e.toString()));
                    bl2 = BoxedUnit.UNIT;
                } else if (object == null) {
                    bl2 = BoxesRunTime.boxToBoolean((boolean)values.addAll(this.getOrSetAsNull(rows, ordinal, nulls, "")));
                } else {
                    throw new IllegalArgumentException(new StringBuilder(40).append("Unsupported conversion class ").append(object.getClass()).append(" ").append("for type ").append(logicalType2.getClass()).append(".").toString());
                }
                tColumn = TColumn.stringVal(new TStringColumn(values, this.bitSetToBuffer(nulls)));
            } else {
                int rowSize = rows.length();
                ArrayList<String> values = new ArrayList<String>(rowSize);
                for (int i = 0; i < rowSize; ++i) {
                    Row row = (Row)rows.apply(i);
                    nulls.set(i, row.getField(ordinal) == null);
                    String value = row.getField(ordinal) == null ? "" : this.toHiveString((Tuple2<Object, LogicalType>)new Tuple2(row.getField(ordinal), (Object)logicalType));
                    values.add(value);
                }
                tColumn = TColumn.stringVal(new TStringColumn(values, this.bitSetToBuffer(nulls)));
            }
        }
        return tColumn;
    }

    private <T> List<T> getOrSetAsNull(Seq<Row> rows, int ordinal, BitSet nulls, T defaultVal) {
        int size = rows.length();
        ArrayList<Object> ret = new ArrayList<Object>(size);
        for (int idx = 0; idx < size; ++idx) {
            boolean isNull;
            Row row = (Row)rows.apply(idx);
            boolean bl = isNull = row.getField(ordinal) == null;
            if (isNull) {
                nulls.set(idx, true);
                ret.add(idx, defaultVal);
                continue;
            }
            ret.add(idx, row.getFieldAs(ordinal));
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public TColumnDesc toTColumnDesc(Column field, int pos) {
        void var3_3;
        TColumnDesc tColumnDesc = new TColumnDesc();
        tColumnDesc.setColumnName(field.getName());
        tColumnDesc.setTypeDesc(this.toTTypeDesc(field.getDataType().getLogicalType()));
        tColumnDesc.setComment(field.getComment().orElse(""));
        tColumnDesc.setPosition(pos);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public TTypeDesc toTTypeDesc(LogicalType typ) {
        void var3_3;
        TPrimitiveTypeEntry typeEntry = new TPrimitiveTypeEntry(this.toTTypeId(typ));
        typeEntry.setTypeQualifiers(this.toTTypeQualifiers(typ));
        TTypeDesc tTypeDesc = new TTypeDesc();
        tTypeDesc.addToTypes(TTypeEntry.primitiveEntry(typeEntry));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public TTypeQualifiers toTTypeQualifiers(LogicalType typ) {
        void var3_2;
        java.util.Map map;
        TTypeQualifiers ret = new TTypeQualifiers();
        LogicalType logicalType = typ;
        if (logicalType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)logicalType;
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)TTypeQualifierValue.i32Value(decimalType.getPrecision())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)TTypeQualifierValue.i32Value(decimalType.getScale()))}))).asJava();
        } else if (logicalType instanceof VarCharType) {
            VarCharType varCharType = (VarCharType)logicalType;
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"characterMaximumLength"), (Object)TTypeQualifierValue.i32Value(varCharType.getLength()))}))).asJava();
        } else if (logicalType instanceof CharType) {
            CharType charType = (CharType)logicalType;
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"characterMaximumLength"), (Object)TTypeQualifierValue.i32Value(charType.getLength()))}))).asJava();
        } else {
            map = Collections.emptyMap();
        }
        java.util.Map qualifiers = map;
        ret.setQualifiers(qualifiers);
        return var3_2;
    }

    public TTypeId toTTypeId(LogicalType typ) {
        TTypeId tTypeId;
        LogicalType logicalType = typ;
        if (logicalType instanceof NullType) {
            tTypeId = TTypeId.NULL_TYPE;
        } else if (logicalType instanceof BooleanType) {
            tTypeId = TTypeId.BOOLEAN_TYPE;
        } else if (logicalType instanceof FloatType) {
            tTypeId = TTypeId.FLOAT_TYPE;
        } else if (logicalType instanceof DoubleType) {
            tTypeId = TTypeId.DOUBLE_TYPE;
        } else if (logicalType instanceof VarCharType) {
            tTypeId = TTypeId.VARCHAR_TYPE;
        } else if (logicalType instanceof CharType) {
            tTypeId = TTypeId.CHAR_TYPE;
        } else if (logicalType instanceof TinyIntType) {
            tTypeId = TTypeId.TINYINT_TYPE;
        } else if (logicalType instanceof SmallIntType) {
            tTypeId = TTypeId.SMALLINT_TYPE;
        } else if (logicalType instanceof IntType) {
            tTypeId = TTypeId.INT_TYPE;
        } else if (logicalType instanceof BigIntType) {
            tTypeId = TTypeId.BIGINT_TYPE;
        } else if (logicalType instanceof DecimalType) {
            tTypeId = TTypeId.DECIMAL_TYPE;
        } else if (logicalType instanceof DateType) {
            tTypeId = TTypeId.DATE_TYPE;
        } else if (logicalType instanceof TimestampType) {
            tTypeId = TTypeId.TIMESTAMP_TYPE;
        } else if (logicalType instanceof ArrayType) {
            tTypeId = TTypeId.ARRAY_TYPE;
        } else if (logicalType instanceof MapType) {
            tTypeId = TTypeId.MAP_TYPE;
        } else if (logicalType instanceof RowType) {
            tTypeId = TTypeId.STRUCT_TYPE;
        } else if (logicalType instanceof BinaryType) {
            tTypeId = TTypeId.BINARY_TYPE;
        } else {
            boolean bl = logicalType instanceof ZonedTimestampType ? true : (logicalType instanceof LocalZonedTimestampType ? true : (logicalType instanceof MultisetType ? true : (logicalType instanceof YearMonthIntervalType ? true : logicalType instanceof DayTimeIntervalType)));
            if (bl) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Flink data type `%s` is not supported currently")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logicalType.asSummaryString()})), null);
            }
            throw new IllegalArgumentException(new StringBuilder(24).append("Unrecognized type name: ").append(logicalType.asSummaryString()).toString());
        }
        return tTypeId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toHiveString(Tuple2<Object, LogicalType> dataWithType) {
        Object bin;
        Object s;
        Object decimal;
        Object ts;
        Object ldt;
        Object d;
        Object ld;
        Object d2;
        Object object;
        Tuple2<Object, LogicalType> tuple2 = dataWithType;
        if (tuple2 != null && (object = tuple2._1()) == null) {
            return "null";
        }
        if (tuple2 != null && (d2 = tuple2._1()) instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)d2);
            if (tuple2._2() instanceof DateType) {
                return RowSetUtils$.MODULE$.formatLocalDate(LocalDate.ofEpochDay(n));
            }
        }
        if (tuple2 != null && (ld = tuple2._1()) instanceof LocalDate) {
            LocalDate localDate = (LocalDate)ld;
            if (tuple2._2() instanceof DateType) {
                return RowSetUtils$.MODULE$.formatLocalDate(localDate);
            }
        }
        if (tuple2 != null && (d = tuple2._1()) instanceof Date) {
            Date date = (Date)d;
            if (tuple2._2() instanceof DateType) {
                return RowSetUtils$.MODULE$.formatInstant(date.toInstant(), RowSetUtils$.MODULE$.formatInstant$default$2());
            }
        }
        if (tuple2 != null && (ldt = tuple2._1()) instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)ldt;
            if (tuple2._2() instanceof TimestampType) {
                return RowSetUtils$.MODULE$.formatLocalDateTime(localDateTime);
            }
        }
        if (tuple2 != null && (ts = tuple2._1()) instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)ts;
            if (tuple2._2() instanceof TimestampType) {
                return RowSetUtils$.MODULE$.formatInstant(timestamp.toInstant(), RowSetUtils$.MODULE$.formatInstant$default$2());
            }
        }
        if (tuple2 != null && (decimal = tuple2._1()) instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)decimal;
            if (tuple2._2() instanceof DecimalType) {
                return bigDecimal.toPlainString();
            }
        }
        if (tuple2 != null) {
            Object a = tuple2._1();
            LogicalType t = (LogicalType)tuple2._2();
            if (ScalaRunTime$.MODULE$.isArray(a, 1)) {
                Object object2 = a;
                if (t instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)t;
                    return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(object2).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.toHiveString((Tuple2<Object, LogicalType>)new Tuple2(v, (Object)arrayType.getElementType())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq().mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object m = tuple2._1();
            LogicalType t = (LogicalType)tuple2._2();
            if (m instanceof scala.collection.immutable.Map) {
                scala.collection.immutable.Map map = (scala.collection.immutable.Map)m;
                if (t instanceof MapType) {
                    MapType mapType = (MapType)t;
                    return ((TraversableOnce)map.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        String string = new StringBuilder(1).append(MODULE$.toHiveString((Tuple2<Object, LogicalType>)new Tuple2(k, (Object)mapType.getKeyType()))).append(":").append(MODULE$.toHiveString((Tuple2<Object, LogicalType>)new Tuple2(v, (Object)mapType.getValueType()))).toString();
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object r = tuple2._1();
            LogicalType t = (LogicalType)tuple2._2();
            if (r instanceof Row) {
                Row row = (Row)r;
                if (t instanceof RowType) {
                    RowType rowType = (RowType)t;
                    ListBuffer lb = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.getArity()).foreach((Function1 & Serializable & scala.Serializable)i -> lb.$plus$eq((Object)new StringBuilder(1).append(rowType.getTypeAt(BoxesRunTime.unboxToInt((Object)i)).toString()).append(":").append(RowSet$.MODULE$.toHiveString((Tuple2<Object, LogicalType>)new Tuple2(row.getField(BoxesRunTime.unboxToInt((Object)i)), (Object)rowType.getTypeAt(BoxesRunTime.unboxToInt((Object)i))))).toString()));
                    return lb.toList().mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null && (s = tuple2._1()) instanceof String) {
            String string = (String)s;
            boolean bl = tuple2._2() instanceof VarCharType ? true : tuple2._2() instanceof CharType;
            if (bl) {
                return new StringBuilder(2).append("\"").append(string).append("\"").toString();
            }
        }
        if (tuple2 != null && (bin = tuple2._1()) instanceof byte[]) {
            byte[] byArray = (byte[])bin;
            if (tuple2._2() instanceof BinaryType) {
                return new String(byArray, StandardCharsets.UTF_8);
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Object other = tuple2._1();
        return other.toString();
    }

    public static final /* synthetic */ boolean $anonfun$toTColumn$2(Object x$2) {
        return x$2 != null;
    }

    private RowSet$() {
        MODULE$ = this;
    }
}

