/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.KubernetesApplicationOperation$;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KyuubiApplicationManager$ {
    public static KyuubiApplicationManager$ MODULE$;

    static {
        new KyuubiApplicationManager$();
    }

    private void setupSparkYarnTag(String tag, KyuubiConf conf) {
        String originalTag = (String)conf.getOption("spark.yarn.tags").map((Function1 & Serializable & scala.Serializable)x$4 -> new StringBuilder(1).append((String)x$4).append(",").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String newTag = new StringBuilder(6).append(originalTag).append("KYUUBI").append(new Some((Object)tag).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$6 -> new StringBuilder(1).append(",").append((String)x$6).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        conf.set("spark.yarn.tags", newTag);
    }

    private void setupSparkK8sTag(String tag, KyuubiConf conf) {
        conf.set(new StringBuilder(30).append("spark.kubernetes.driver.label.").append(KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY()).toString(), tag);
    }

    private void setupFlinkK8sTag(String tag, KyuubiConf conf) {
        String originalTag = (String)conf.getOption("yarn.tags").map((Function1 & Serializable & scala.Serializable)x$7 -> new StringBuilder(1).append((String)x$7).append(",").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String newTag = new StringBuilder(6).append(originalTag).append("KYUUBI").append(new Some((Object)tag).filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$9 -> new StringBuilder(1).append(",").append((String)x$9).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        conf.set("yarn.tags", newTag);
    }

    public void checkApplicationAccessPath(String path, KyuubiConf conf) {
        block7: {
            URI uri;
            Seq localDirAllowList;
            block8: {
                URI uRI;
                localDirAllowList = (Seq)conf.get(KyuubiConf$.MODULE$.SESSION_LOCAL_DIR_ALLOW_LIST());
                if (!localDirAllowList.nonEmpty()) break block7;
                try {
                    uRI = new URI(path);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                uri = uRI;
                if (uri.getScheme() == null) break block8;
                String string = uri.getScheme();
                String string2 = "file";
                if (string != null ? !string.equals(string2) : string2 != null) break block7;
            }
            if (!uri.getPath().startsWith(File.separator)) {
                throw new KyuubiException(new StringBuilder(56).append("Relative path ").append(uri.getPath()).append(" is not allowed, please use absolute path.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            if (!localDirAllowList.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)KyuubiApplicationManager$.$anonfun$checkApplicationAccessPath$1(uri, x$10)))) {
                throw new KyuubiException(new StringBuilder(58).append("The file ").append(uri.getPath()).append(" to access is not in the local dir allow list").append(" [").append(localDirAllowList.mkString(",")).append("].").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
        }
    }

    private void checkSparkAccessPaths(Map<String, String> appConf, KyuubiConf kyuubiConf) {
        block0: {
            if (!((TraversableOnce)kyuubiConf.get(KyuubiConf$.MODULE$.SESSION_LOCAL_DIR_ALLOW_LIST())).nonEmpty()) break block0;
            ((IterableLike)((TraversableLike)SparkProcessBuilder$.MODULE$.PATH_CONFIGS().flatMap((Function1 & Serializable & scala.Serializable)key -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])appConf.get((Object)key).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.split(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))))), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)KyuubiApplicationManager$.$anonfun$checkSparkAccessPaths$4(x$12)))).foreach((Function1 & Serializable & scala.Serializable)path -> {
                KyuubiApplicationManager$.MODULE$.checkApplicationAccessPath(path, kyuubiConf);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tagApplication(String applicationTag, String applicationType, Option<String> resourceManager, KyuubiConf conf) {
        String string;
        String string2;
        Tuple2 tuple2 = new Tuple2((Object)applicationType.toUpperCase(), (Object)resourceManager.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.toUpperCase()));
        if (tuple2 != null) {
            Some some;
            String string3;
            String string4 = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("SPARK".equals(string4) && option instanceof Some && "YARN".equals(string3 = (String)(some = (Some)option).value())) {
                this.setupSparkYarnTag(applicationTag, conf);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            Some some;
            String rm;
            String string5 = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("SPARK".equals(string5) && option instanceof Some && (rm = (String)(some = (Some)option).value()).startsWith("K8S")) {
                this.setupSparkK8sTag(applicationTag, conf);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null && "SPARK".equals(string2 = (String)tuple2._1())) {
            this.setupSparkYarnTag(applicationTag, conf);
            this.setupSparkK8sTag(applicationTag, conf);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (tuple2 != null && "FLINK".equals(string = (String)tuple2._1())) {
            this.setupFlinkK8sTag(applicationTag, conf);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void checkApplicationAccessPaths(String applicationType, Map<String, String> appConf, KyuubiConf kyuubiConf) {
        String string = applicationType.toUpperCase(Locale.ROOT);
        if (string.startsWith("SPARK")) {
            this.checkSparkAccessPaths(appConf, kyuubiConf);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (string.startsWith("FLINK")) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkApplicationAccessPath$1(URI uri$1, String x$10) {
        return uri$1.getPath().startsWith(x$10);
    }

    public static final /* synthetic */ boolean $anonfun$checkSparkAccessPaths$4(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).nonEmpty();
    }

    private KyuubiApplicationManager$() {
        MODULE$ = this;
    }
}

